/*
 * Decompiled with CFR 0.152.
 */
package org.trix.cuery;

import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.trix.cuery.filter.Filter;
import org.trix.cuery.filter.ProcessingFilter;
import org.trix.cuery.parser.CueryParser;
import org.trix.cuery.util.CSSUtil;
import org.trix.cuery.util.DOMUtil;
import org.w3c.css.sac.Selector;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CSSQuery {
    private static final CueryParser PARSER = new CueryParser();
    private final Document document;

    public CSSQuery(String path) throws IOException {
        this(new File(path));
    }

    public CSSQuery(File file) throws IOException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            this.document = builder.parse(file);
        }
        catch (ParserConfigurationException e) {
            throw new IOException(e.getMessage());
        }
        catch (SAXException e) {
            throw new IOException(e.getMessage());
        }
    }

    public CSSQuery(Document document) {
        this.document = document;
    }

    public Set<Element> select(String expression) {
        return this.query(this.document, PARSER.parseSelector(expression));
    }

    public Set<Element> select(Selector selector) {
        return this.query(this.document, selector);
    }

    private Set<Element> query(Node source, Selector selector) {
        Filter filter = CSSUtil.converte(selector);
        if (filter instanceof ProcessingFilter) {
            ProcessingFilter processing = (ProcessingFilter)selector;
            Set<Element> results = this.query(source, processing.getSelector());
            if (results.size() == 0) {
                return DOMUtil.EMPTY_SET;
            }
            HashSet<Element> container = new HashSet<Element>();
            for (Element result : results) {
                processing.process(container, result);
            }
            return container;
        }
        return DOMUtil.retrieveElements(source, filter, true);
    }
}

