/*
	FUJITSU FM16beta Emulator 'eFM16beta'

	Author : Takeda.Toshiya
	Date   : 2018.01.01 -

	[ keyboard ]
*/

#include "keyboard.h"
#include "mainbus.h"
#include "../../fifo.h"


void KEYBOARD::initialize()
{
	key_buf = new FIFO(64);
	register_frame_event(this);
}

void KEYBOARD::release()
{
	key_buf->release();
	delete key_buf;
}

void KEYBOARD::reset()
{
	memset(table, 0, sizeof(table));
	key_buf->clear();
	kbstat = kbdata = 0;
}

uint32_t KEYBOARD::read_io8(uint32_t addr)
{
	if(addr & 1) {
		d_main->write_signal(SIG_MAIN_IRQ1, 0, 0);
		kbstat &= ~1;
		return kbdata & 0xff;
	} else {
		return kbdata >> 8;
	}
}

void KEYBOARD::event_frame()
{
	if(!(kbstat & 1) && !key_buf->empty()) {
		d_main->write_signal(SIG_MAIN_IRQ1, 1, 1);
		kbstat |= 1;
		kbdata = key_buf->read();
	}
}

void KEYBOARD::key_down(int code)
{
//	if(!table[code]) {
		table[code] = 1;
		if(code = key_table[code]) {
//code=0x20;
			key_buf->write(code);
		}
//	}
}

void KEYBOARD::key_up(int code)
{
//	if(table[code]) {
		table[code] = 0;
		if(code = key_table[code]) {
//code=0x20;
			key_buf->write(code| 0x80);
		}
//	}
}

#define STATE_VERSION	1

#include "../../statesub.h"

void KEYBOARD::decl_state()
{
	enter_decl_state(STATE_VERSION);
	
	DECL_STATE_ENTRY_FIFO(key_buf);
	DECL_STATE_ENTRY_INT32(kbstat);
	DECL_STATE_ENTRY_INT32(kbdata);
	DECL_STATE_ENTRY_1D_ARRAY(table, sizeof(table));

	leave_decl_state();
}
void KEYBOARD::save_state(FILEIO* state_fio)
{
	if(state_entry != NULL) {
		state_entry->save_state(state_fio);
	}

//	state_fio->FputUint32(STATE_VERSION);
//	state_fio->FputInt32(this_device_id);
	
//	key_buf->save_state((void *)state_fio);
//	state_fio->FputInt32(kbstat);
//	state_fio->FputInt32(kbdata);
//	state_fio->Fwrite(table, sizeof(table), 1);
}

bool KEYBOARD::load_state(FILEIO* state_fio)
{
	bool mb = false;
	if(state_entry != NULL) {
		mb = state_entry->load_state(state_fio);
	}
	if(!mb) {
		return false;
	}

//	if(state_fio->FgetUint32() != STATE_VERSION) {
//		return false;
//	}
//	if(state_fio->FgetInt32() != this_device_id) {
//		return false;
//	}
//	if(!key_buf->load_state((void *)state_fio)) {
//		return false;
//	}
//	kbstat = state_fio->FgetInt32();
//	kbdata = state_fio->FgetInt32();
//	state_fio->Fread(table, sizeof(table), 1);
	return true;
}

static const int key_code[] = {
-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	0x008,	0x009,	-1,	-1,	-1,	0x00D,	-1,	-1,
-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	0x10B,	-1,	0x01B,	0x10D,	0x10E,	-1,	-1,
0x020,	0x112,	0x113,	0x111,	0x115,	0x118,	0x116,	0x119,	0x117,	-1,	-1,	-1,	-1,	0x110,	0x114,	-1,
0x030,	0x031,	0x032,	0x033,	0x034,	0x035,	0x036,	0x037,	0x038,	0x039,	-1,	-1,	-1,	-1,	-1,	-1,
-1,	0x061,	0x062,	0x063,	0x064,	0x065,	0x066,	0x067,	0x068,	0x069,	0x06A,	0x06B,	0x06C,	0x06D,	0x06E,	0x06F,
0x070,	0x071,	0x072,	0x073,	0x074,	0x075,	0x076,	0x077,	0x078,	0x079,	0x07A,	-1,	-1,	-1,	-1,	-1,
0x030,	0x031,	0x032,	0x033,	0x034,	0x035,	0x036,	0x037,	0x038,	0x039,	0x02A,	0x02B,	0x02C,	0x02D,	0x02E,	0x02F,
0x101,	0x102,	0x103,	0x104,	0x105,	0x106,	0x107,	0x108,	0x109,	0x10A,	0x10B,	0x10C,	-1,	-1,	-1,	-1,
-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,
-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,
-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,
-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	0x03A,	0x03B,	0x02C,	0x02D,	0x02E,	0x02F,
0x040,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,
-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	0x05B,	0x05C,	0x05D,	0x05E,	-1,
-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,
-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,
};
static const int key_code_shift[] = {
-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	0x008,	0x009,	-1,	-1,	-1,	0x00D,	-1,	-1,
-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	0x12B,	-1,	0x01B,	0x12D,	0x12E,	-1,	-1,
0x020,	0x132,	0x133,	0x131,	0x135,	0x138,	0x136,	0x139,	0x137,	-1,	-1,	-1,	-1,	0x130,	0x134,	-1,
-1,	0x021,	0x022,	0x023,	0x024,	0x025,	0x026,	0x027,	0x028,	0x029,	-1,	-1,	-1,	-1,	-1,	-1,
-1,	0x041,	0x042,	0x043,	0x044,	0x045,	0x046,	0x047,	0x048,	0x049,	0x04A,	0x04B,	0x04C,	0x04D,	0x04E,	0x04F,
0x050,	0x051,	0x052,	0x053,	0x054,	0x055,	0x056,	0x057,	0x058,	0x059,	0x05A,	-1,	-1,	-1,	-1,	-1,
-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,
0x121,	0x122,	0x123,	0x124,	0x125,	0x126,	0x127,	0x128,	0x129,	0x12A,	0x12B,	0x12C,	-1,	-1,	-1,	-1,
-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,
-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,
-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,
-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	0x02B,	0x02A,	0x03C,	0x03D,	0x03E,	0x03F,
0x060,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,
-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	0x07B,	0x07C,	0x07D,	0x07E,	-1,
-1,	-1,	0x05F,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,
-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,
};
static const int key_code_kana[] = {
-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	0x008,	0x009,	-1,	-1,	-1,	0x00D,	-1,	-1,
-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	0x10B,	-1,	0x01B,	0x10D,	0x10E,	-1,	-1,
0x020,	0x112,	0x113,	0x111,	0x115,	0x118,	0x116,	0x119,	0x117,	-1,	-1,	-1,	-1,	0x110,	0x114,	-1,
0x0DC,	0x0C7,	0x0CC,	0x0B1,	0x0B3,	0x0B4,	0x0B5,	0x0D4,	0x0D5,	0x0D6,	-1,	-1,	-1,	-1,	-1,	-1,
-1,	0x0C1,	0x0BA,	0x0BF,	0x0BC,	0x0B2,	0x0CA,	0x0B7,	0x0B8,	0x0C6,	0x0C9,	0x0C9,	0x0D8,	0x0D3,	0x0D0,	0x0D7,
0x0BE,	0x0C0,	0x0BD,	0x0C4,	0x0B6,	0x0C5,	0x0CB,	0x0C3,	0x0BB,	0x0DD,	0x0C2,	-1,	-1,	-1,	-1,	-1,
0x030,	0x031,	0x032,	0x033,	0x034,	0x035,	0x036,	0x037,	0x038,	0x039,	0x02A,	0x02B,	0x02C,	0x02D,	0x02E,	0x02F,
0x101,	0x102,	0x103,	0x104,	0x105,	0x106,	0x107,	0x108,	0x109,	0x10A,	0x10B,	0x10C,	-1,	-1,	-1,	-1,
-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,
-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,
-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,
-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	0x0B9,	0x0DA,	0x0C8,	0x0CE,	0x0D9,	0x0D2,
0x0DE,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,
-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	0x0DF,	0x0B0,	0x0D1,	0x0CD,	-1,
-1,	-1,	0x0DB,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,
-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,
};
static const int key_code_kana_shift[] = {
-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	0x008,	0x009,	-1,	-1,	-1,	0x00D,	-1,	-1,
-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	0x12B,	-1,	0x01B,	0x12D,	0x12E,	-1,	-1,
0x020,	0x132,	0x133,	0x131,	0x135,	0x138,	0x136,	0x139,	0x137,	-1,	-1,	-1,	-1,	0x130,	0x134,	-1,
0x0A6,	-1,	-1,	0x0A7,	0x0A9,	0x0AA,	0x0AB,	0x0AC,	0x0AD,	0x0AE,	-1,	-1,	-1,	-1,	-1,	-1,
-1,	-1,	-1,	-1,	-1,	0x0A8,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,
-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	0x0AF,	-1,	-1,	-1,	-1,	-1,
-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,
0x121,	0x122,	0x123,	0x124,	0x125,	0x126,	0x127,	0x128,	0x129,	0x12A,	0x12B,	0x12C,	-1,	-1,	-1,	-1,
-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,
-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,
-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,
-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	0x0A4,	-1,	0x0A1,	0x0A5,
-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,
-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	0x0A2,	-1,	0x0A3,	-1,	-1,
-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,
-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,
};
static const int key_code_graph[] = {
-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	0x008,	0x009,	-1,	-1,	-1,	0x00D,	-1,	-1,
-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	0x10B,	-1,	0x01B,	0x10D,	0x10E,	-1,	-1,
0x020,	0x112,	0x113,	0x111,	0x115,	0x118,	0x116,	0x119,	0x117,	-1,	-1,	-1,	-1,	0x110,	0x114,	-1,
0x0F7,	0x0F9,	0x0FA,	0x0FB,	0x0FC,	0x0F2,	0x0F3,	0x0F4,	0x0F5,	0x0F6,	-1,	-1,	-1,	-1,	-1,	-1,
-1,	0x095,	0x084,	0x082,	0x0E6,	0x0E4,	0x0E7,	0x09E,	0x09F,	0x0E8,	0x0EA,	0x0EB,	0x08E,	0x086,	0x085,	0x0E9,
0x08D,	0x0FD,	0x0E5,	0x096,	0x09C,	0x0F0,	0x083,	0x0F8,	0x081,	0x09D,	0x080,	-1,	-1,	-1,	-1,	-1,
-1,	0x09A,	0x090,	0x09B,	0x093,	0x080,	0x092,	0x0E1,	0x0E2,	0x0E3,	0x098,	0x099,	-1,	0x0EE,	-1,	0x091,
0x101,	0x102,	0x103,	0x104,	0x105,	0x106,	0x107,	0x108,	0x109,	0x10A,	0x10B,	0x10C,	-1,	-1,	-1,	-1,
-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,
-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,
-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,
-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	0x094,	0x089,	0x087,	0x08C,	0x088,	0x097,
0x08A,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,
-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	0x0ED,	0x0F1,	0x0EC,	0x08B,	-1,
-1,	-1,	0x0E0,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,
-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,
};
static const int key_code_graph_shift[] = {
-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	0x008,	0x009,	-1,	-1,	-1,	0x00D,	-1,	-1,
-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	0x12B,	-1,	0x01B,	0x12D,	0x12E,	-1,	-1,
0x020,	0x132,	0x133,	0x131,	0x135,	0x138,	0x136,	0x139,	0x137,	-1,	-1,	-1,	-1,	0x130,	0x134,	-1,
0x0F7,	0x0F9,	0x0FA,	0x0FB,	0x0FC,	0x0F2,	0x0F3,	0x0F4,	0x0F5,	0x0F6,	-1,	-1,	-1,	-1,	-1,	-1,
-1,	0x095,	0x084,	0x082,	0x0E6,	0x0E4,	0x0E7,	0x09E,	0x09F,	0x0E8,	0x0EA,	0x0EB,	0x08E,	0x086,	0x085,	0x0E9,
0x08D,	0x0FD,	0x0E5,	0x096,	0x09C,	0x0F0,	0x083,	0x0F8,	0x081,	0x09D,	0x080,	-1,	-1,	-1,	-1,	-1,
-1,	0x09A,	0x090,	0x09B,	0x093,	0x080,	0x092,	0x0E1,	0x0E2,	0x0E3,	0x098,	0x099,	-1,	0x0EE,	-1,	0x091,
0x101,	0x102,	0x103,	0x104,	0x105,	0x106,	0x107,	0x108,	0x109,	0x10A,	0x10B,	0x10C,	-1,	-1,	-1,	-1,
-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,
-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,
-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,
-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	0x094,	0x089,	0x087,	0x08C,	0x088,	0x097,
0x08A,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,
-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	0x0ED,	0x0F1,	0x0EC,	0x08B,	-1,
-1,	-1,	0x0E0,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,
-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,
};
static const int key_code_ctrl[] = {
-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,
-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	0x14B,	-1,	-1,	0x14D,	0x14E,	-1,	-1,
-1,	0x152,	0x153,	0x151,	0x155,	0x158,	0x156,	0x159,	0x157,	-1,	-1,	-1,	-1,	0x150,	0x154,	-1,
-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,
-1,	0x001,	0x002,	0x003,	0x004,	0x005,	0x006,	0x007,	0x008,	0x009,	0x00A,	0x00B,	0x00C,	0x00D,	0x00E,	0x00F,
0x010,	0x011,	0x012,	0x013,	0x014,	0x015,	0x016,	0x017,	0x018,	0x109,	0x01A,	-1,	-1,	-1,	-1,	-1,
-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,
0x141,	0x142,	0x143,	0x144,	0x145,	0x146,	0x147,	0x148,	0x149,	0x14A,	0x14B,	0x14C,	-1,	-1,	-1,	-1,
-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,
-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,
-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,
-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,
0x000,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,
-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	0x01B,	0x01C,	0x01D,	0x01E,	-1,
-1,	-1,	0x01F,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,
-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,
};
static const int scan_code[] = {
-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	0x0F,	0x10,	-1,	-1,	-1,	0x1D,	-1,	-1,
0x53,	0x52,	0x56,	-1,	0x55,	0x5A,	-1,	-1,	-1,	0x59,	-1,	0x01,	0x58,	0x57,	-1,	-1,
0x35,	0x49,	0x4C,	0x4A,	0x4E,	0x4F,	0x4D,	0x51,	0x50,	-1,	-1,	-1,	-1,	0x48,	0x4B,	-1,
0x0B,	0x02,	0x03,	0x04,	0x05,	0x06,	0x07,	0x08,	0x09,	0x0A,	-1,	-1,	-1,	-1,	-1,	-1,
-1,	0x1E,	0x2E,	0x2C,	0x20,	0x13,	0x21,	0x22,	0x23,	0x18,	0x24,	0x25,	0x26,	0x30,	0x2F,	0x19,
0x1A,	0x11,	0x14,	0x1F,	0x15,	0x17,	0x2D,	0x12,	0x2B,	0x16,	0x2A,	-1,	-1,	-1,	-1,	-1,
0x46,	0x42,	0x43,	0x44,	0x3E,	0x3F,	0x40,	0x3A,	0x3B,	0x3C,	0x36,	0x38,	0x41,	0x39,	0x47,	0x37,
0x5D,	0x5E,	0x5F,	0x60,	0x61,	0x62,	0x63,	0x64,	0x65,	0x66,	0x59,	0x5B,	-1,	-1,	-1,	-1,
-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,
-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,
-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,
-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	0x28,	0x27,	0x31,	0x0C,	0x32,	0x33,
0x1B,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,
-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	0x1C,	0x0E,	0x29,	0x0D,	-1,
-1,	-1,	0x34,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,
-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,
};
