/*
AuthForm.cs : It is Form that sets the user name and the password.
 
Copyright (c) 2005 CSamura
All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions
are met:
1. Redistributions of source code must retain the above copyright
   notice, this list of conditions and the following disclaimer.
2. Redistributions in binary form must reproduce the above copyright
   notice, this list of conditions and the following disclaimer in the
   documentation and/or other materials provided with the distribution.
3. The name of the author may not be used to endorse or promote products
   derived from this software without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

using System;
using System.Drawing;
using System.Collections;
using System.ComponentModel;
using System.Windows.Forms;
using CSamura.NNTP;

namespace CSamura.Forms
{
	/// <summary>
	/// AuthForm ̊Tv̐łB
	/// </summary>
	public class AuthForm : System.Windows.Forms.Form
	{
		private System.Windows.Forms.Label label1;
		private System.Windows.Forms.Label label2;
		private System.Windows.Forms.CheckBox chkAuth;
		private System.Windows.Forms.TextBox txtUser;
		private System.Windows.Forms.TextBox txtPass;
		private System.Windows.Forms.Button btnOK;
		private System.Windows.Forms.Button btnCancel;
		/// <summary>
		/// KvȃfUCiϐłB
		/// </summary>
		private System.ComponentModel.Container components = null;

		private CSamura.NNTP.NewsAuthentication auth;

		public AuthForm()
		{
			//
			// Windows tH[ fUCi T|[gɕKvłB
			//
			InitializeComponent();

			//
			// TODO: InitializeComponent ĂяǒɁARXgN^ R[hǉĂB
			//
		}

		/// <summary>
		/// gpĂ郊\[XɌ㏈s܂B
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if(components != null)
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		#region Windows tH[ fUCiŐꂽR[h 
		/// <summary>
		/// fUCi T|[gɕKvȃ\bhłB̃\bh̓e
		/// R[h GfB^ŕύXȂłB
		/// </summary>
		private void InitializeComponent()
		{
			this.chkAuth = new System.Windows.Forms.CheckBox();
			this.label1 = new System.Windows.Forms.Label();
			this.txtUser = new System.Windows.Forms.TextBox();
			this.label2 = new System.Windows.Forms.Label();
			this.txtPass = new System.Windows.Forms.TextBox();
			this.btnOK = new System.Windows.Forms.Button();
			this.btnCancel = new System.Windows.Forms.Button();
			this.SuspendLayout();
			// 
			// chkAuth
			// 
			this.chkAuth.Location = new System.Drawing.Point(24, 16);
			this.chkAuth.Name = "chkAuth";
			this.chkAuth.Size = new System.Drawing.Size(216, 24);
			this.chkAuth.TabIndex = 0;
			this.chkAuth.Text = " NNTP T[oɂ͔F؂Kv(&A)";
			this.chkAuth.CheckedChanged += new System.EventHandler(this.chkAuth_CheckedChange);
			// 
			// label1
			// 
			this.label1.Location = new System.Drawing.Point(56, 48);
			this.label1.Name = "label1";
			this.label1.Size = new System.Drawing.Size(72, 23);
			this.label1.TabIndex = 1;
			this.label1.Text = "[U(&I)";
			// 
			// txtUser
			// 
			this.txtUser.Location = new System.Drawing.Point(152, 48);
			this.txtUser.Name = "txtUser";
			this.txtUser.Size = new System.Drawing.Size(200, 19);
			this.txtUser.TabIndex = 2;
			this.txtUser.Text = "";
			// 
			// label2
			// 
			this.label2.Location = new System.Drawing.Point(56, 88);
			this.label2.Name = "label2";
			this.label2.Size = new System.Drawing.Size(72, 23);
			this.label2.TabIndex = 3;
			this.label2.Text = "pX[h(&P)";
			// 
			// txtPass
			// 
			this.txtPass.Location = new System.Drawing.Point(152, 88);
			this.txtPass.Name = "txtPass";
			this.txtPass.PasswordChar = '*';
			this.txtPass.Size = new System.Drawing.Size(200, 19);
			this.txtPass.TabIndex = 4;
			this.txtPass.Text = "";
			// 
			// btnOK
			// 
			this.btnOK.DialogResult = System.Windows.Forms.DialogResult.OK;
			this.btnOK.Location = new System.Drawing.Point(96, 128);
			this.btnOK.Name = "btnOK";
			this.btnOK.Size = new System.Drawing.Size(112, 24);
			this.btnOK.TabIndex = 5;
			this.btnOK.Text = "OK";
			this.btnOK.Click += new System.EventHandler(this.btnOK_Click);
			// 
			// btnCancel
			// 
			this.btnCancel.DialogResult = System.Windows.Forms.DialogResult.Cancel;
			this.btnCancel.Location = new System.Drawing.Point(248, 128);
			this.btnCancel.Name = "btnCancel";
			this.btnCancel.Size = new System.Drawing.Size(104, 24);
			this.btnCancel.TabIndex = 6;
			this.btnCancel.Text = "LZ";
			// 
			// AuthForm
			// 
			this.AutoScaleBaseSize = new System.Drawing.Size(5, 12);
			this.ClientSize = new System.Drawing.Size(384, 174);
			this.Controls.Add(this.btnCancel);
			this.Controls.Add(this.btnOK);
			this.Controls.Add(this.txtPass);
			this.Controls.Add(this.label2);
			this.Controls.Add(this.txtUser);
			this.Controls.Add(this.label1);
			this.Controls.Add(this.chkAuth);
			this.Name = "AuthForm";
			this.Text = "[UƃpX[h̐ݒ";
			this.Load += new System.EventHandler(this.AuthForm_Load);
			this.ResumeLayout(false);

		}
		#endregion

		private void AuthForm_Load(object sender, System.EventArgs e)
		{
			if(chkAuth.Checked)
			{
				txtUser.Enabled = true;
				txtPass.Enabled = true;
			}
			else
			{
				txtUser.Enabled = false;
				txtPass.Enabled = false;
			}
		}

		private void chkAuth_CheckedChange(object sender, System.EventArgs e)
		{
			if(chkAuth.Checked)
			{
				txtUser.Enabled = true;
				txtPass.Enabled = true;
			}
			else
			{
				txtUser.Enabled = false;
				txtPass.Enabled = false;
			}
		}

		private void btnOK_Click(object sender, System.EventArgs e)
		{
			if(chkAuth.Checked)
			{
				auth = new NewsAuthentication(txtUser.Text.Trim(), txtPass.Text.Trim(), AuthenticationType.Plain);
			}
			else
			{
				auth = new NewsAuthentication();
			}
		}

		public NewsAuthentication Authentication
		{
			get
			{
				return auth;
			}
		}
	}
}
