/*
NewsArticleNode.cs : The class is the subclass of TreeNode class.
 It handles the news articles as the node of the tree.

Copyright (c) 2005 CSamura
All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions
are met:
1. Redistributions of source code must retain the above copyright
   notice, this list of conditions and the following disclaimer.
2. Redistributions in binary form must reproduce the above copyright
   notice, this list of conditions and the following disclaimer in the
   documentation and/or other materials provided with the distribution.
3. The name of the author may not be used to endorse or promote products
   derived from this software without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/


using System;
using System.Collections;
using System.Text.RegularExpressions;
using System.Windows.Forms;
using CSamura.NNTP;

namespace CSamura.Forms
{
	/// <summary>
	/// j[XL̃c[̃m[hNX
	/// </summary>
	public class NewsArticleNode : System.Windows.Forms.TreeNode
	{
		// j[XL Message-ID
		public string ID;

		// j[XL References
		public string[] References;

		// References ݂邩ǂ
		public bool isReferences;

		// j[XL̃^Cg
		private string Subject;

		// ̃m[h̃j[XL
		private NewsArticle Article;

		/// <summary>
		/// ArticleNode ̃RXgN^B
		/// x[XNXɂ̓TuWFNgn
		/// </summary>
		/// <param name="article">Mj[XL</param>
		public NewsArticleNode(NewsArticle article) : base(article.GetSubject()) 
		{
			InitializeComponent(article);
		}

		/// <summary>
		/// NewsArticleNode NX̏̃\bh
		/// </summary>
		/// <param name="article">Mj[XL</param>
		private void InitializeComponent(NewsArticle article)
		{
			Article = article; 
			ID = article.GetHeaderValue("Message-ID");
			Subject = article.GetSubject();
			isReferences = this.GetReferences(article.GetHeaderValue("References"));
		}

		/// <summary>
		/// j[XL References wb_擾郁\bh
		/// </summary>
		/// <param name="src">j[XL Reference wb_̕</param>
		/// <returns>Reference wb_݂邩ǂԂ</returns>
		private bool GetReferences(string src)
		{
			Regex r;
			Match m;
			ArrayList a;
			try
			{
				r = new Regex("(?<references>[<][^>]+[>])");
				m = r.Match(src);
			}
			catch(ArgumentNullException)
			{
				return false;
			}

			if(!m.Success) return false;
			else a = new ArrayList();

			while(m.Success)
			{
				a.Add(m.Groups["references"].Value.ToString());
				m = m.NextMatch();
			}

			References = new string[a.Count];
			IEnumerator ie = a.GetEnumerator();
			int index = 0;

			while(ie.MoveNext())
			{
				string res = ie.Current.ToString();
				References[index] = res;
				index++;
			}
			return true;
		}

		/// <summary>
		/// ̃m[h̃j[XL擾
		/// </summary>
		/// <returns>̃m[h̃j[XL</returns>
		public NewsArticle GetNewsArticle()
		{
			return Article;
		}
	}
}
