/*
NewsArticleDictionary.cs : The class has the Hashtable to store 
 the NewsArticleNode class.

Copyright (c) 2005 CSamura
All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions
are met:
1. Redistributions of source code must retain the above copyright
   notice, this list of conditions and the following disclaimer.
2. Redistributions in binary form must reproduce the above copyright
   notice, this list of conditions and the following disclaimer in the
   documentation and/or other materials provided with the distribution.
3. The name of the author may not be used to endorse or promote products
   derived from this software without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

using System;
using System.Collections;
using CSamura.Forms;

namespace CSamura.NNTP
{
	/// <summary>
	/// j[XL̃m[hۑnbVe[u
	/// </summary>
	public class NewsArticleDictionary
	{

		// NewsArticleNode IuWFNgێnbVe[u
		private Hashtable articleNodeDictionary;

		/// <summary>
		/// NewsArticleDictionary NX̃RXgN^
		/// </summary>
		public NewsArticleDictionary()
		{
			articleNodeDictionary = new Hashtable();
		}

		/// <summary>
		///  Message-ID ̃j[XLm[hɑ݂邩ǂ
		/// ׂ邽߂̃\bh
		/// </summary>
		/// <param name="id">m[h̃j[XL Message-ID</param>
		/// <returns>j[XLm[hɑ݂邩ǂԂ</returns>
		public bool ContainsNode(string id)
		{
			return articleNodeDictionary.ContainsKey(id);
		}

		/// <summary>
		/// NewsArticleNode IuWFNgǉ
		/// </summary>
		/// <param name="id">ǉm[h̋L Message-ID</param>
		/// <param name="articleNode">ǉNewsArticleNode IuWFNg</param>
		public void AddNewsArticleNode(string id, NewsArticleNode articleNode)
		{
			if(this.ContainsNode(id))
			{
				articleNodeDictionary[id] = articleNode;
			}
			else
			{
				articleNodeDictionary.Add(id, articleNode);
			}
		}

		/// <summary>
		/// ꂽ NewsArticleNode IuWFNgԂ
		/// </summary>
		/// <param name="id">m[h̃j[XL Message-ID</param>
		/// <returns>NewsArticleNode IuWFNgԂBȂ null Ԃ</returns>
		public NewsArticleNode GetNewsArticleNode(string id)
		{
			if(this.ContainsNode(id))
			{
				return (NewsArticleNode)articleNodeDictionary[id];
			}
			else return null;
		}
	}
}
