/*
NNTPClient.cs : To connect/disconnect to the NNTP server and
 receiving the news articles. 
 
Copyright (c) 2005 CSamura
All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions
are met:
1. Redistributions of source code must retain the above copyright
   notice, this list of conditions and the following disclaimer.
2. Redistributions in binary form must reproduce the above copyright
   notice, this list of conditions and the following disclaimer in the
   documentation and/or other materials provided with the distribution.
3. The name of the author may not be used to endorse or promote products
   derived from this software without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

using System;
using System.Collections;
using System.Net;
using System.Web;
using System.Net.Sockets;
using System.Threading;
using System.IO;
using System.Text;
using System.Text.RegularExpressions;
using System.Globalization;
using System.Windows.Forms;
using CSamura.Forms;

namespace CSamura.NNTP
{
	/// <summary>
	/// NNTP NCAg̃NXB
	/// </summary>
	public class NNTPClient
	{
		/// <summary>
		/// XML ̃f[^x[XIuWFNgB
		/// Ƀj[X̃wb_ƃ{fBi[B
		/// </summary>
		//private NewsReader0001.NNTPNews nntpNews1;

		private Socket netNewsSocket = null;
		private NetworkStream netNewsStream = null;
		//private TraceContext trace = null;
		//private HttpContext context = null;
		public string from = "";
		public string address = "";
		public string subject = "";
		public string group = "";
		public string body = "";
		public const string xreader = "CSNewsClient 0.0.2.78 (test version)";

		//private NewsReader0001.NNTPNews newsData = null;

		/// <summary>
		/// NNTPConnection ̃RXgN^ (Ȃ)
		/// </summary>
		public NNTPClient()
		{}

		/// <summary>
		/// NNTP T[oɐڑ
		/// </summary>
		/// <param name="serverName">NNTP T[o</param>
		/// <param name="port">|[gԍi119j</param>
		public string NewsConnect(string serverName, int port)
		{
			netNewsSocket = new Socket(AddressFamily.InterNetwork, SocketType.Stream, ProtocolType.Tcp);
			string message = "";
			try
			{
				// w肵 NNTP T[o IP AhX擾
				IPAddress address = Dns.GetHostByName(serverName).AddressList[0];

				// IPEndPoint擾
				IPEndPoint endpoint = new IPEndPoint(address, port);
				
				// ڑ
				netNewsSocket.Connect(endpoint);

				// Mp̃Xg[𐶐
				netNewsStream = new NetworkStream(netNewsSocket);

				// s̃bZ[WM
				message = getMessage();


			}
			catch(Exception e)
			{
			    message = e.Message;
				NewsDisconnect();
			}
			return message;
		}

		/// <summary>
		/// T[oƂ̃RlNVB
		/// </summary>
		public string NewsDisconnect()
		{
			// QUIT R}h𑗐M
			sendMessage("QUIT");

			// BYE bZ[WM
			string bye = getMessage();

			netNewsStream.Close();
			netNewsStream = null;
			netNewsSocket.Close();
			netNewsSocket = null;

			return bye;
		}

		/// <summary>
		/// R}h𑗐M
		/// </summary>
		/// <param name="input">MR}h</param>
		private string sendMessage(string input)
		{
			// MR}h "\r\n" tB
			string msg = input + "\r\n";

			// MR}h̕ byte zɕϊ
			byte[] bb = Encoding.ASCII.GetBytes(msg);

			// f[^Xg[ɏ
			netNewsStream.Write(bb, 0, bb.Length);

			// f[^𑗐M
			netNewsStream.Flush();

			return msg;
		}

		/// <summary>
		/// POST R}hs
		/// </summary>
		/// <param name="post">Mj[XL</param>
		/// 

		/// <summary>
		/// POST R}hs
		/// </summary>
		/// <param name="post">Mj[XL</param>
		/// <returns>Mf[^</returns>
		public string Post(string post)
		{
			string session = "";
			session += sendMessage("POST");
			session += getMessage();

			session += sendNewsArticle(post);
			session += getMessage();
			return session;
		}

		/// <summary>
		/// News L𑗐MB
		/// </summary>
		/// <param name="post">Mj[XL</param>
		/// <returns>Mj[XLԂlɂ</returns>
		private string sendNewsArticle(string post)
		{
			byte[] bb = Encoding.ASCII.GetBytes(post);
			netNewsStream.Write(bb, 0, bb.Length);
			netNewsStream.Flush();
			//trace.Write("article", article);
			return post;
		}

		/// <summary>
		/// s̃f[^M
		/// </summary>
		/// <returns>Mf[^</returns>
		private string getMessage()
		{			
			StreamReader sr = new StreamReader(netNewsStream, Encoding.UTF8);
			string temp = "";
			string msg = "";
			
			// Mf[^܂őҋ@
			while(!netNewsStream.DataAvailable) Thread.Sleep(0);
			try
			{
				temp = sr.ReadLine();
				msg = temp + "\r\n";
			}
			catch(Exception e)
			{
				msg += e.Message + "\r\n";
			}
			return msg;
		}

		/// <summary>
		/// s̃bZ[WMB
		/// </summary>
		private string getMultiMessage()
		{
			StreamReader sr = new StreamReader(netNewsStream, Encoding.UTF8);

			string temp = "";
			string msg = "";

			// Mf[^܂őҋ@
			while(!netNewsStream.DataAvailable) Thread.Sleep(0);
			try
			{
				temp = sr.ReadLine();
				msg = temp + "\r\n";

				int num = int.Parse(msg.Substring(0,3));
				int chk = num / 100;

				// bZ[W̔ԍ 400 ԑ 500 ԑȂ΃G[Ȃ̂ŁA
				// ȊÔƂɃbZ[Wǂݍ
				if(chk != 4 && chk != 5)
				{
					msg = "";
					temp = sr.ReadLine();
					while(temp != ".")
					{
						msg += temp + "\r\n";
						temp = sr.ReadLine();
					}
					msg += temp + "\r\n";
				}
				else msg = "";
			}
			catch(Exception e)
			{
				msg += e.Message + "\r\n";
			}
				return msg;
		}

		/// <summary>
		/// "=?...?B?...?=" Ƃ`̕fR[hB
		/// </summary>
		/// <param name="ptext">"=?...?B?...?=" Ƃ`̕</param>
		/// <returns>fR[h</returns>
		private string DecodeBcode(string ptext)
		{
			string[] s = ptext.Split('?');
			if(s[2] == "Q") return ptext;
			byte[] b = Convert.FromBase64String(s[3]);
			string code = Encoding.GetEncoding(s[1]).GetString(b);

			if(s[0] == "Re: =") return "Re: " + code;
			else return code;
		}

		private string getCharValue(string content)
		{
			string charset = "";
			int x = content.IndexOf(";", 0);
			if(x >= 0) charset = content.Substring(0, x);
			else charset = content;
			int y = charset.IndexOf("\"", 0);
			int z = charset.IndexOf("\"", y + 1);
			if(z >= 0) charset = charset.Substring(y+1, z-y-1);
			else
			{
				int w = charset.IndexOf("=", 0);
				charset = charset.Substring(w+1);
			}
			return charset;
		}

		/// <summary>
		/// j[XL擾B
		/// </summary>
		/// <returns>j[Xwb_i[Ălq𕶎ŕԂ</returns>
		public string getNews()
		{
			string group = "microsoft.public.jp.excel";
			string message = "";

			// GROUP R}h𑗐M
			message	+= sendMessage("GROUP " + group);
			string msg = getMessage();

			// GROUP R}hɑ΂ԐMA
			// ŐV̋L̔ԍ擾
			message += msg;
			int number = int.Parse(msg.Split(' ')[3]);

			// ARTICLE R}h𑗐M
			// قǂ̏œꂽL̔ԍɎ
			//message += sendMessage("ARTICLE "+ number.ToString());
			//message += getMultiMessage();
			
			string id = "<exFQfNHiFHA.2916@TK2MSFTNGP14.phx.gbl>";
			// HEAD R}h𑗐M
			// قǂ̏œꂽL̔ԍɎ
			//message += sendMessage("HEAD "+ number.ToString());
			message += sendMessage("HEAD "+ id);
			
			string head = getMultiMessage();
			message += head;
			
			// BODY R}h𓯗lɂđM
			//message += sendMessage("BODY " + number.ToString());
			message += sendMessage("BODY " + id);
			
			string body = getMultiMessage();


			// ̂Ƃ̏ƃ^CAEgɂȂ̂ŁA
			// NNTP T[oƂ̐ڑŐ؂Ă
			// message += this.NewsDisconnect();

			NewsArticle article = new NewsArticle(head, body);

			// Subject wb_i[Ă邩eXg
			message += article.GetHeaderValue("Subject") + "\r\n";

			// wb_Si[Ă邩eXg
			message += article.GetHeaders();

			// {fBƃfR[hĂ邩eXg
			message += article.GetDecodedBody();

			// j[XL̓t擾ł邩eXg
			message += article.GetDate() + "\r\n";


			//string src = "=?iso-2022-jp?Q?=1B$B\"(L$>5Bz$H>5B=\r\nz9-=\r\n9p\"#=1B(B?=";


			return message;
		}

		/// <summary>
		/// j[XL̃wb_Ac[\ɂāA
		/// TreeView Rg[Ɋi[
		/// </summary>
		/// <param name="articleTreeView">tH[ treeView Rg[</param>
		/// <param name="articleDictionary">j[XLi[NX</param>
		/// <returns>R}h𑗐Mlq𕶎ŕԂ</returns>
		public string GetHeaders(ref TreeView articleTreeView, ref NewsArticleDictionary articleDictionary)
		{
			string group = "microsoft.public.jp.dotnet.languages.csharp";
			string msg = "";
			string resp = "";

			msg += sendMessage("GROUP " + group);
			resp += getMessage();

			// GROUP R}hŕԂĂMʂAL̔ԍ擾
			string[] numbers = resp.Split(' ');
			int number1 = int.Parse(numbers[2]);
			int number2 = int.Parse(numbers[3]);

			// j[XO[ṽm[hc[̍Ƃ
			TreeNode groupNode = new TreeNode(group);

			NewsArticle article;
			NewsArticleNode articleNode;
			for(int i=number1; i<=number2; i++)
			{
				msg += sendMessage("HEAD " + i.ToString());
				string head = getMultiMessage();

				// Mf[^wb_̌`Ă΁A
				//m[hɋL̃wb_i[
				if(Regex.IsMatch(head, "[-\\w\\d]: [^\r]+\r\n"))
				{
					article = new NewsArticle(head);
					string id = article.GetHeaderValue("Message-ID");
					articleNode = new NewsArticleNode(article);
					articleDictionary.AddNewsArticleNode(id, articleNode);

					if(articleNode.isReferences)
					{
						try
						{
							// References ̂AɈԋ߂ Message-ID 擾B
							string parent = articleNode.References[articleNode.References.Length -1];

							// ̍ɂm[hǍm[h̗tɎB
							NewsArticleNode pnode = articleDictionary.GetNewsArticleNode(parent);
							pnode.Nodes.Add(articleNode);
						}
						catch(NullReferenceException)
						{
							// ̍ɓm[h݂ȂꍇA
							// j[XO[ṽm[h̗tɂB
							groupNode.Nodes.Add(articleNode);
						}
					}
					else
					{
						// ̍ɓm[h݂ȂꍇA
						// ԍ̃j[XO[ṽm[h̗tɂB
						groupNode.Nodes.Add(articleNode);
					}
				}
			}
			// łc[ TreeView Rg[ɉB
			articleTreeView.Nodes.Add(groupNode);
		
			return msg;
		}
	}
}
