/*
NewsArticle.cs : The class of the news article. That has fields of
 the NewsHeader class and the NewsBody class.
 
Copyright (c) 2005 CSamura
All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions
are met:
1. Redistributions of source code must retain the above copyright
   notice, this list of conditions and the following disclaimer.
2. Redistributions in binary form must reproduce the above copyright
   notice, this list of conditions and the following disclaimer in the
   documentation and/or other materials provided with the distribution.
3. The name of the author may not be used to endorse or promote products
   derived from this software without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

using System;
using System.Globalization;

namespace TestWeb
{
	/// <summary>
	/// j[XL̃NX
	/// </summary>
	public class NewsArticle
	{
		/// <summary>
		/// j[XL̃wb_
		/// </summary>
		private NewsHeader header;

		/// <summary>
		/// j[XL̃{fB
		/// </summary>
		private NewsBody body;
		
		/// <summary>
		/// NewsArticle ̃ftHgRXgN^
		/// </summary>
		public NewsArticle()
		{
			header = new NewsHeader();
			body = new NewsBody();
		}

		/// <summary>
		/// NewsArticle ̃RXgN^B
		/// Mwb_ɂƂB
		/// </summary>
		/// <param name="h">Mwb_̕</param>
		/// <param name="b">M{fB̕</param>
		public NewsArticle(string h, string b)
		{
			header = new NewsHeader(h);

			// Content-Type wb_̒l擾
			string ct = header.GetHeaderValue("Content-Type");

			body = new NewsBody(b, ct);
		}

		/// <summary>
		/// L[ɑΉwb_̒lo\bhB
		/// ł NewsHeader NX GetHeaderValue \bhĂяoĂB
		/// </summary>
		/// <param name="key">wb_̃L[̒l</param>
		/// <returns>Ήwb_̒l</returns>
		public string GetHeaderValue(string key)
		{
			return header.GetHeaderValue(key);
		}

		/// <summary>
		/// j[XL̃wb_̃L[ƒlׂĎo\bhB
		/// ł NewsHeader NX GetHeaders \bhĂяoĂB
		/// </summary>
		/// <returns>j[XLׂ̂Ẵwb_</returns>
		public string GetHeaders()
		{
			return header.GetHeaders();
		}

		/// <summary>
		/// j[XL̃{fB̕Ԃ\bh
		/// </summary>
		/// <returns>{fB̕</returns>
		public string GetBody()
		{
			return body.GetBody();
		}

		/// <summary>
		/// j[XL̓t擾
		/// </summary>
		/// <returns>header tB[h Date tB[h̒l𕶎ŕԂ</returns>
		public string GetDate()
		{
			return header.GetDate();
		}
		
		/// <summary>
		/// From wb_쐬
		/// </summary>
		/// <param name="name">M҂̖O</param>
		/// <param name="address">M҂̃[AhX</param>
		/// <returns>From wb_̒l</returns>
		public string EncodeFrom(string name, string address)
		{
			string name2 = "\"" + name + "\"";
			if(!TextCheck.Is2ByteString(name))
			{
				name2 = header.GetSubjectEncode(name2);
			}
			string res = name2 + " <" + address + ">";
			return res;
		}

		/// <summary>
		/// Subject wb_쐬
		/// </summary>
		/// <param name="subject">^Cg̕</param>
		/// <returns> Subject wb_̒l</returns>
		public string EncodeSubject(string subject)
		{
			string res;
			
			if(TextCheck.Is2ByteString(subject)) res = subject;
			else res = header.GetSubjectEncode(subject);

			return res;
		}

		/// <summary>
		/// j[XL̖{GR[h
		/// </summary>
		/// <param name="b">GR[hO̖{̕</param>
		/// <returns>GR[h{fB</returns>
		public string EncodeBody(string b)
		{
			return body.EncodeBody(b);
		}

		/// <summary>
		/// POST 邽߂ɁAj[XL쐬B
		/// </summary>
		/// <param name="name">M҂̖O</param>
		/// <param name="address">M҂̃[AhX</param>
		/// <param name="group">POST j[XO[v</param>
		/// <param name="subject">j[XL̃^Cg</param>
		/// <param name="b">j[XL̖{</param>
		/// <returns>j[XL𕶎ŕԂ</returns>
		public string BeforePost(string name, string address,
			string group, string subject, string b)
		{
			string post = "";
			string from = this.EncodeFrom(name, address);
			string subject2 = this.EncodeSubject(subject);
			string b2 = this.EncodeBody(b);

			// ݎ擾ADate wb_̒ľ`ɕϊ
			DateTime n = DateTime.Now;
			string date = n.ToString("ddd, dd MMM yyyy HH':'mm':'ss zzz", DateTimeFormatInfo.InvariantInfo);
			date = date.Substring(0, date.Length-3) + date.Substring(date.Length-2, 2);

			// j[XL̃wb_쐬
			post += "From: " + from + "\r\n";
			post += "Subject: " + subject2 + "\r\n";
			post += "Content-Type: text/plain; charset=\"iso-2022-jp\"\r\n";
			post += "Content-Transfer-Encoding: 7bit\r\n";
			post += "Date: " + date + "\r\n";
			post += "Newsgroups: " + group + "\r\n";
			post += "X-Newsreader: " + NNTPClient.xreader + "\r\n";
			post += "\r\n";

			// j[XL̃{fB쐬
			post += b2 + "\r\n.\r\n";

			return post;
		}
 
	}
}
