/*
NNTPClient.cs : To connect/disconnect to the NNTP server and
 receiving the news articles. 
 
Copyright (c) 2005 CSamura
All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions
are met:
1. Redistributions of source code must retain the above copyright
   notice, this list of conditions and the following disclaimer.
2. Redistributions in binary form must reproduce the above copyright
   notice, this list of conditions and the following disclaimer in the
   documentation and/or other materials provided with the distribution.
3. The name of the author may not be used to endorse or promote products
   derived from this software without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

using System;
using System.Net;
using System.Web;
using System.Net.Sockets;
using System.Threading;
using System.IO;
using System.Text;
using System.Globalization;

namespace TestWeb
{
	/// <summary>
	/// NNTP NCAg̃NXB
	/// </summary>
	public class NNTPClient
	{
		/// <summary>
		/// XML ̃f[^x[XIuWFNgB
		/// Ƀj[X̃wb_ƃ{fBi[B
		/// </summary>
		//private NewsReader0001.NNTPNews nntpNews1;

		private Socket netNewsSocket = null;
		private NetworkStream netNewsStream = null;
		//private TraceContext trace = null;
		//private HttpContext context = null;
		static private string Message;
		private string article = "";
		public string from = "";
		public string address = "";
		public string subject = "";
		public string group = "";
		public string body = "";
		private const string xreader = "NNTP Web Poster 0.1 beta";

		//private NewsReader0001.NNTPNews newsData = null;

		/// <summary>
		/// NNTPConnection ̃RXgN^ (Ȃ)
		/// </summary>
		public NNTPClient()
		{
			Message = "";
		}

		public void MakeArticle()
		{
			DateTime dt = DateTime.Now;
			article += "From: ";
			byte[] bb = Encoding.GetEncoding("iso-2022-jp").GetBytes(from);
			string bf = Convert.ToBase64String(bb);
			bf = "=?iso-2022-jp?B?" + bf + "?=";
			article += bf + " <" + address + ">\r\n";

			article += "Subject: ";
			byte[] b2 = Encoding.GetEncoding("iso-2022-jp").GetBytes(subject);
			string bs = Convert.ToBase64String(b2);
			bs = "=?iso-2022-jp?B?" + bs + "?=";
			article += bs + "\r\n";

			article += "Content-Type: text/plain; charset=\"iso-2022-jp\"\r\n";
			article += "Content-Transfer-Encoding: 7bit\r\n";

			string date = dt.ToString("ddd, dd MMM yyyy HH':'mm':'ss zzz", DateTimeFormatInfo.InvariantInfo);
			string t = date.Substring(date.Length-2);
			date = date.Substring(0, date.Length-3);
			article += "Date: " + date + t + "\r\n";

			article += "Newsgroups: " + group + "\r\n";
			article += "X-Newsreader: " + xreader + "\r\n";
			article += "\r\n";
			byte[] bbs = Encoding.GetEncoding("iso-2022-jp").GetBytes(body);
			string body2 = Encoding.ASCII.GetString(bbs);
			article += body2 + "\r\n.\r\n";
			
			Message = article;

		}


		/// <summary>
		/// NNTP T[oɐڑ
		/// </summary>
		/// <param name="serverName">NNTP T[o</param>
		/// <param name="port">|[gԍi119j</param>
		public string NewsConnect(string serverName, int port)
		{
			netNewsSocket = new Socket(AddressFamily.InterNetwork, SocketType.Stream, ProtocolType.Tcp);
			string message = "";
			try
			{
				// w肵 NNTP T[o IP AhX擾
				IPAddress address = Dns.GetHostByName(serverName).AddressList[0];

				// IPEndPoint擾
				IPEndPoint endpoint = new IPEndPoint(address, port);
				
				// ڑ
				netNewsSocket.Connect(endpoint);

				// Mp̃Xg[𐶐
				netNewsStream = new NetworkStream(netNewsSocket);

				// s̃bZ[WM
				message = getMessage();


			}
			catch(Exception e)
			{
			    message = e.Message;
				NewsDisconnect();
			}
			return message;
		}

		/// <summary>
		/// T[oƂ̃RlNVB
		/// </summary>
		public string NewsDisconnect()
		{
			// QUIT R}h𑗐M
			sendMessage("QUIT");

			// BYE bZ[WM
			string bye = getMessage();

			netNewsStream.Close();
			netNewsStream = null;
			netNewsSocket.Close();
			netNewsSocket = null;

			return bye;
		}

		/// <summary>
		/// R}h𑗐M
		/// </summary>
		/// <param name="input">MR}h</param>
		private string sendMessage(string input)
		{
			// MR}h "\r\n" tB
			string msg = input + "\r\n";

			// MR}h̕ byte zɕϊ
			byte[] bb = Encoding.ASCII.GetBytes(msg);

			// f[^Xg[ɏ
			netNewsStream.Write(bb, 0, bb.Length);

			// f[^𑗐M
			netNewsStream.Flush();

			return msg;
		}

		public void Post()
		{
			sendMessage("POST");
			getMessage();

			sendNewsArticle();
			getMessage();
		}

		/// <summary>
		/// News L𑗐MB
		/// </summary>
		private void sendNewsArticle()
		{
			Thread.Sleep(800);
			byte[] bb = Encoding.ASCII.GetBytes(article);
			netNewsStream.Write(bb, 0, bb.Length);
			netNewsStream.Flush();
			//trace.Write("article", article);
			Thread.Sleep(800);
		}

		/// <summary>
		/// s̃f[^M
		/// </summary>
		/// <returns>Mf[^</returns>
		private string getMessage()
		{			
			StreamReader sr = new StreamReader(netNewsStream, Encoding.UTF8);
			string temp = "";
			string msg = "";
			
			// Mf[^܂őҋ@
			while(!netNewsStream.DataAvailable) Thread.Sleep(0);
			try
			{
				temp = sr.ReadLine();
				msg = temp + "\r\n";
			}
			catch(Exception e)
			{
				msg += e.Message + "\r\n";
			}
			return msg;
		}

		/// <summary>
		/// s̃bZ[WMB
		/// </summary>
		private string getMultiMessage()
		{
			StreamReader sr = new StreamReader(netNewsStream, Encoding.UTF8);

			string temp = "";
			string msg = "";

			// Mf[^܂őҋ@
			while(!netNewsStream.DataAvailable) Thread.Sleep(0);
			try
			{
				temp = sr.ReadLine();
				msg = temp + "\r\n";

				int num = int.Parse(msg.Substring(0,3));
				int chk = num / 100;

				// bZ[W̔ԍ 400 ԑ 500 ԑȂ΃G[Ȃ̂ŁA
				// ȊÔƂɃbZ[Wǂݍ
				if(chk != 4 && chk != 5)
				{
					msg = "";
					temp = sr.ReadLine();
					while(temp != ".")
					{
						msg += temp + "\r\n";
						temp = sr.ReadLine();
					}
					msg += temp + "\r\n";
				}
				else msg = "";
			}
			catch(Exception e)
			{
				msg += e.Message + "\r\n";
			}
				return msg;
		}

		/// <summary>
		/// "=?...?B?...?=" Ƃ`̕fR[hB
		/// </summary>
		/// <param name="ptext">"=?...?B?...?=" Ƃ`̕</param>
		/// <returns>fR[h</returns>
		private string DecodeBcode(string ptext)
		{
			string[] s = ptext.Split('?');
			if(s[2] == "Q") return ptext;
			byte[] b = Convert.FromBase64String(s[3]);
			string code = Encoding.GetEncoding(s[1]).GetString(b);

			if(s[0] == "Re: =") return "Re: " + code;
			else return code;
		}

		private string getCharValue(string content)
		{
			string charset = "";
			int x = content.IndexOf(";", 0);
			if(x >= 0) charset = content.Substring(0, x);
			else charset = content;
			int y = charset.IndexOf("\"", 0);
			int z = charset.IndexOf("\"", y + 1);
			if(z >= 0) charset = charset.Substring(y+1, z-y-1);
			else
			{
				int w = charset.IndexOf("=", 0);
				charset = charset.Substring(w+1);
			}
			return charset;
		}

		/// <summary>
		/// j[XL擾B
		/// </summary>
		/// <returns>j[Xwb_i[Ălq𕶎ŕԂ</returns>
		public string getNews()
		{
			string group = "microsoft.public.jp.excel";
			string message = "";

			// GROUP R}h𑗐M
			message	+= sendMessage("GROUP " + group);
			string msg = getMessage();

			// GROUP R}hɑ΂ԐMA
			// ŐV̋L̔ԍ擾
			message += msg;
			int number = int.Parse(msg.Split(' ')[3]);

			// ARTICLE R}h𑗐M
			// قǂ̏œꂽL̔ԍɎ
			//message += sendMessage("ARTICLE "+ number.ToString());
			//message += getMultiMessage();
			
			// HEAD R}h𑗐M
			// قǂ̏œꂽL̔ԍɎ
			message += sendMessage("HEAD "+ number.ToString());
			string head = getMultiMessage();
			message += head;
			
			// BODY R}h𓯗lɂđM
			message += sendMessage("BODY " + number.ToString());
			string body = getMultiMessage();


			// ̂Ƃ̏ƃ^CAEgɂȂ̂ŁA
			// NNTP T[oƂ̐ڑŐ؂Ă
			message += this.NewsDisconnect();

			NewsArticle a = new NewsArticle(head, body);

			// Subject wb_i[Ă邩eXg
			message += a.GetHeaderValue("Subject") + "\r\n";

			// wb_Si[Ă邩eXg
			message += a.GetHeaders();

			// {fBƃfR[hĂ邩eXg
			message += a.GetBody();


			//string src = "=?iso-2022-jp?Q?=1B$B\"(L$>5Bz$H>5B=\r\nz9-=\r\n9p\"#=1B(B?=";


			return message;
		}
	}
}
