/*
NewsHeader.cs : The class of the "header part" in the news article.
 The header information is stored in the "Hashtable".
 
Copyright (c) 2005 CSamura
All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions
are met:
1. Redistributions of source code must retain the above copyright
   notice, this list of conditions and the following disclaimer.
2. Redistributions in binary form must reproduce the above copyright
   notice, this list of conditions and the following disclaimer in the
   documentation and/or other materials provided with the distribution.
3. The name of the author may not be used to endorse or promote products
   derived from this software without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

using System;
using System.Collections;
using System.Text;
using System.Text.RegularExpressions;

namespace TestWeb
{
	/// <summary>
	/// j[XL̃wb_̃NX
	/// </summary>
	public class NewsHeader
	{
		/// <summary>
		/// wb_i[nbVe[u
		/// </summary>
		private Hashtable headers;

		/// <summary>
		/// NewsHeader ̃ftHgRXgN^
		/// </summary>
		public NewsHeader()
		{
			headers = new Hashtable();
		}

		/// <summary>
		/// NewsHeader ̃RXgN^B
		/// ɎMwb_̕
		/// </summary>
		/// <param name="h">Mwb_̕</param>
		public NewsHeader(string h)
		{
			headers = new Hashtable();

			// wb_̒lsɂ킽ꍇ̏
			string h2 = Regex.Replace(h, "\r\n[\\s]+", "");

			// wb_̃L[ƒlo߂̐K\
			Regex r = new Regex("(?<key>[-\\w]+): (?<value>[^\r]+)\r\n");
			
			Match m = r.Match(h2);
			while(m.Success)
			{
				string hkey = m.Groups["key"].Value.ToString();
				string hvalue = m.Groups["value"].Value.ToString();
				headers.Add(hkey, hvalue);
				m = m.NextMatch();
			}
			if(this.ContainsKey("Subject"))
			{
				headers["Subject"] = this.GetSubjectCode(headers["Subject"].ToString());
			}
			if(this.ContainsKey("From"))
			{
				headers["From"] = this.GetSubjectCode(headers["From"].ToString());
			}
		}

		/// <summary>
		/// L[ɑΉlo\bh
		/// </summary>
		/// <param name="key">L[̕</param>
		/// <returns>L[ɑΉl̕</returns>
		public string GetHeaderValue(string key)
		{
			if(this.ContainsKey(key))
			{
				return headers[key].ToString();
			}
			else
			{
				return "̃L[͊܂܂Ă܂B";
			}
		}

		/// <summary>
		/// wb_̃L[ƒlׂĎo\bh
		/// </summary>
		/// <returns>L̃wb_ׂ̂ẴL[ƒl</returns>
		public string GetHeaders()
		{
			IDictionaryEnumerator ide = headers.GetEnumerator();
			string res ="";
			while(ide.MoveNext())
			{
				res += ide.Key.ToString() + " : " + ide.Value.ToString() + "\r\n";
			}
			return res;
		}

		/// <summary>
		/// ̖Õwb_ZbgĂ邩𒲂ׂ郁\bh
		/// </summary>
		/// <param name="key">wb_̃L[</param>
		/// <returns>܂܂Ă true, łȂ false</returns>
		public bool ContainsKey(string key)
		{
			return headers.ContainsKey(key);
		}

		/// <summary>
		/// Subject wb_ =?iso-2022-jp?B?...?= ƂfR[h
		/// </summary>
		/// <param name="src">fR[h镶</param>
		/// <returns>fR[h</returns>
		public string GetSubjectCode(string src)
		{
			Regex subRegex;
			Match m;

			// ̕ (Ƃ "=?iso-2022-jp?B?...?=" ) 3̕ɕ鐳K\
			subRegex = new Regex(@"=[?](?<enc>[-\w\d^?]+)[?](?<form>[BQ])[?](?<src>[^?]+)[?]=");
			string res = "";
			m = subRegex.Match(src);

			// ̏̕ǂ܂Ői񂾂 index ̒lŎ
			int index = 0;
			while(m.Success)
			{
				// fR[hȂXLbv
				res += src.Substring(index, m.Index - index);

				// "iso-2022-jp" 
				string encd = m.Groups["enc"].ToString();
				// "B" ܂ "Q"
				string formd = m.Groups["form"].ToString();
				// fR[h镶񕔕
				string srcd = m.Groups["src"].ToString();

				// "B" ܂ "Q" GR[fBOŃfR[h
				if(formd == "B")
				{
					byte[] b = Convert.FromBase64String(srcd);
					res += Encoding.GetEncoding(encd).GetString(b);
				}
				else if(formd == "Q")
				{
					byte[] b = TestWeb.QuotedPrintable.GetBytes(srcd);
					res += Encoding.GetEncoding(encd).GetString(b);
				}
				index = m.Index + m.Length;
				m = m.NextMatch();
			}
			// fR[hc̕
			if(index < src.Length)
			{
				res += src.Substring(index, src.Length - index);
			}
			return res;
		}
	}
}
