#!/usr/bin/perl
@POW2 = (1, 2, 4, 8, 16, 32, 64, 128, 256, 512, 1024, 2048, 4096, 8192, 16384, 32768, 65536, 131072, 262144, 524288, 1048576, 
 2097152, 4194304, 8388608, 16777216, 33554432, 67108864, 134217728, 268435456, 536870912, 1073741824, 2147483648, 4294967296);
@ALLNETS = ();
@ORGNETS = ();
sub num2pow2 {
   local($n) = shift;
   for($i = 0; $i < @POW2; $i ++){
      if($n <= $POW2[$i]){ return $i; }
   }
   return 33;
}
sub num2mask {
  local($ip) = shift;
  local($num) = shift;
}


#####
sub n2bit32 {
  local($i) = shift;
  local($r) = "";
  while($i > 0){
     $r = ($i%2).$r;
     $i = int($i/2);
  }
  return sprintf("%032d", $r);
}
sub n2bit {
  local($i) = shift;
  local($r) = "";
  while($i > 0){
     $r = ($i%2).$r;
     $i = int($i/2);
  }
  return sprintf("%08d", $r);
}
sub a2bit {
  local($a) = shift;
  local($r);
  while($a =~ /([0-9]+)(.*)/){
#    print STDERR "$a\n";
    $a = $2;
    $r = $r.&n2bit($1);
  }
  return $r;
}
sub net2bit {
  local($a) = shift;
  if($a =~ /([0-9\.]+)\/(.*)/){
     local($x) = $1; local($y) = $2;
     return substr(&a2bit($x), 0, $y)
  }

}
sub merge {
  local($n1) = shift; 
  local($n2) = shift; 
#print ":$n1\n";
#print ":$n2\n";
  if(substr($n1, 0, length($n2)) eq substr($n2, 0, length($n1))){
    return substr($n1, 0, length($n2));
  }
  local($nl) = length($n1);
  if($nl == length($n2)){
     $nl --;
     if(&isMatch($n1, $n2, $nl)){
       return substr($n1, 0, $nl);
     }
  } 
  return ;
}
sub isMatch {
  local($b1) = shift;
  local($b2) = shift;
  local($m) = shift;
 # print substr($b1,0,$m)." eq \n".substr($b2,0,$m) ;  print "::\n";
#  print (substr($b1,0,$m) eq substr($b2,0,$m) ); print "::\n";
  return (substr($b1,0,$m) eq substr($b2,0,$m) );
}

sub bit2net {
  local($n) = shift;
  local($m) = length($n);
  $n = $n.("0"x (32 - $m));
#  print "*$n\n";
  local($r, $c, $t);
  while($n =~ /([0-1])(.*)/){
#  		print ":$n\t$t\t$r\t$c\n";
       $n = $2;
       $t = $t*2+$1;
       if($c%8 == 7){
         $r .= $t;
         if($n){ $r .=".";}
         $t = 0;
       }
       $c ++;
  }
  return $r."/".$m;
}
sub nextNet {
  local($ipb) = shift;
  local($m) = 32 - shift;
  local($mb) = ("0"x (length($ipb) - $m-1))."1".("0" x ($m));
  local($f) = 0;
  local($r) = ""; local($it, $mt);
#  print "$ipb\n$mb\n";
  while(length($ipb) > 0){
    if($ipb =~ /(.*)([0-1])/){
       $ipb = $1; $it = $2;
    }
    if($mb =~ /(.*)([0-1])/){
       $mb = $1; $mt = $2;
    }
    $f = $f+$it+$mt;
    if($f == 0){
      $r = "0".$r; $f = 0;
    } elsif($f == 1){
      $r = "1".$r; $f = 0;
    } elsif($f == 2){
      $r = "0".$r; $f = 1;
    } elsif($f == 3){
      $r = "1".$r; $f = 1;
    } 
  }
#  print "$r\n";
  return $r;
}
###
$mask = shift;
$org_total = 0;
while(<>){
  if(/ipv4\|([0-9]+\.[0-9]+\.[0-9]+\.[0-9]+)\|([0-9]+)/){
#    print;
	local($ip) = $1;
  	local($n) = $2;
    $org_total += $n;
  	$n = 32-&num2pow2($n);
  	local($ipb) = &a2bit("$ip");
#  	print STDERR "$n\t".substr($ipb, $n, length($ipb) -$n);
#  	print STDERR "\n";
  	if(substr($ipb, $n, length($ipb) -$n) =~ /1/){
  	   local($c) = 1;
  	   while(substr($ipb, $n, length($ipb) -$n) =~ /1/){
  		 $c *= 2;
  		 $n ++;
  	   }
  	   for($ci = 0; $ci < $c; $ci ++){
  	      $ip = &bit2net(substr($ipb, 0, $n));
#  	      print "#//$ipb, $ci, $ip\n";
		  push(@ALLNETS, substr(&net2bit("$ip"), 0, $mask));
  	  	  push(@ORGNETS, &net2bit("$ip"));
  	  	  $ipb = &nextNet($ipb, $n);
  	   }
  	} else {
  	  print STDERR "PUSH:$ip/$n -> ".&net2bit("$ip/$n")."\n";
  	  push(@ALLNETS, substr(&net2bit("$ip/$n"), 0, $mask));
  	  push(@ORGNETS, &net2bit("$ip/$n"));
  	}
  } elsif(/([0-9]+\.[0-9]+\.[0-9]+\.[0-9\.]+)\/([0-9]+)/){
	local($ip) = $1;
  	local($n) = $2;   
  	$org_total += $POW2[(32-$n)];
  	print STDERR "PUSH:$ip/$n -> ".&net2bit("$ip/$n")."\n";
  	push(@ALLNETS, substr(&net2bit("$ip/$n"), 0, $mask));
  	push(@ORGNETS, &net2bit("$ip/$n"));
  }
}
@ORGNETS = sort(@ORGNETS);
$mflag = true;
while($mflag){
  $mflag = 0;
  @ALLNETS = sort(@ALLNETS);

#  for $f (@ALLNETS){
#    print $f;
#    print "\n";
#  }
#  print "------------$mflag\n";

  local($l) = @ALLNETS -1;
  local(@tmp) = ();
#   print STDERR "l:$l\n";
   local($i);
  for($i = 0; $i < $l; $i ++){
#     print STDERR "$i\n";
     if($m = &merge($ALLNETS[$i], $ALLNETS[$i+1])){
        push(@tmp, $m);
        $i ++;
		$mflag = 1;
     } else {
        push(@tmp, $ALLNETS[$i]);
     } 
  }
  if($i == $l){ push(@tmp, $ALLNETS[$i]);
}
  @ALLNETS = @tmp;
}
@res = ();
$orgi = 0;
for $f (sort(@ALLNETS)){
  @tmp = ();
  while(&isMatch($ORGNETS[$orgi], $f, length($f))){
    push(@tmp, $ORGNETS[$orgi]);
    $orgi ++;
  }
  if(@tmp == 0){ #Ȃ͂
     print STDERR "NO match org\n";
     push(@res, $f);
  } elsif(@tmp == 1){
     print STDERR "Only one org".$tmp[0]."\t".$f."\t:".(length($tmp[0]) < length($f))."\n";
     push(@res, pop(@tmp));
  } else {
     print STDERR "Two more orgs:".$f."\n";
     local($can) = $tmp[0];
     local($m) = length($can);
     local($f) = 1;
     while($f){
       $f = 0; local($tt);
       for $tt (@tmp){
#         print STDERR "test can:$can test:$tt $m ".&isMatch($can, $tt, $m)."\n";
         if(!&isMatch($can, $tt, $m)){
           $f = 1;
         }
       }
       if($f) { $m --;}
     }
     local($tt);
     for $tt (@tmp){       print STDERR $tt."\n";     }
     print STDERR "-->\n".substr($can,0,$m)."\n\n";
     push(@res, substr($can,0,$m));
  }
}
@ALLNETS = @res;
#print " result------------\n";
$total = 0;
for $f (sort(@ALLNETS)){
#  print $f;
#  print "\t:";
  $t = &bit2net($f);
  if($t =~ /\/([0-9]+)/){
    $total += $POW2[(32-$1)];
  }
  print $t;  print "\n";
}
print "#$total / $org_total =".($total / $org_total)." \n";
print "#".@ALLNETS." \n";
print STDERR "#$total / $org_total =".($total / $org_total)." \n";
print STDERR "#".@ALLNETS." \n";
