#!/usr/bin/python
# -*- coding: utf-8 -*-
import sys
sys.path.append('../../code/')

import os
import os.path
from cti import *

# セッションの開始
with get_session('ctip://localhost:8099/',{
    'user'  :'user',
    'password'  :'kappa'
}) as session:
    # ファイル出力
    dir = 'out';
    if not os.path.exists(dir):
        os.mkdir(dir)
    session.set_output_as_file('out/continuous.pdf')

    # リソースの送信
    with session.resource('test.css') as out:
        with open('data/test.css') as file:
            out.write(file.read())
   
    session.set_continuous(True)

    # 文書の送信
    with session.transcode() as out:
        with open('data/test.html') as file:
            out.write(file.read())

    #リソースのアクセス許可
    session.property('input.include', 'http://copper-pdf.com/**')
      
    #文書の変換
    session.transcode_server('http://copper-pdf.com/')
    
    # 結合
    session.join()
