/*
 * Decompiled with CFR 0.152.
 */
package jp.cssj.resolver.cache;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import jp.cssj.resolver.MetaSource;
import jp.cssj.resolver.Source;
import jp.cssj.resolver.SourceResolver;
import jp.cssj.resolver.cache.CachedSource;
import org.apache.commons.io.IOUtils;

public class CachedSourceResolver
implements SourceResolver {
    private final Map<String, CachedSourceInfo> uriToSource = new HashMap<String, CachedSourceInfo>();
    private final File tmpDir;

    public CachedSourceResolver(File tmpDir) {
        this.tmpDir = tmpDir;
    }

    public CachedSourceResolver() {
        this(null);
    }

    private static char convertHexDigit(char b) {
        if (b >= '0' && b <= '9') {
            return (char)(b - 48);
        }
        if (b >= 'a' && b <= 'f') {
            return (char)(b - 97 + 10);
        }
        if (b >= 'A' && b <= 'F') {
            return (char)(b - 65 + 10);
        }
        return '\u0000';
    }

    public static String toKey(URI uri) {
        String key = uri.toString();
        String scheme = uri.getScheme();
        if (scheme == null) {
            return key;
        }
        if (scheme.equals("http") || scheme.equals("https")) {
            String exclude = "?#";
            char[] ch = key.toCharArray();
            int len = ch.length;
            int ix = 0;
            int ox = 0;
            while (ix < len) {
                int b;
                if ((b = ch[ix++]) == 63) {
                    exclude = "&=#";
                } else if (b == 43) {
                    b = 32;
                } else if (b == 37) {
                    char c = (char)((CachedSourceResolver.convertHexDigit(ch[ix]) << 4) + CachedSourceResolver.convertHexDigit(ch[ix + 1]));
                    if (exclude.indexOf(c) == -1) {
                        b = c;
                        ix += 2;
                    } else {
                        ch[ix] = Character.toUpperCase(ch[ix]);
                        ch[ix + 1] = Character.toUpperCase(ch[ix + 1]);
                    }
                }
                ch[ox++] = b;
            }
            key = new String(ch, 0, ox);
        }
        return key;
    }

    public File putFile(MetaSource metaSource) throws IOException {
        URI uri = metaSource.getURI().normalize();
        String key = CachedSourceResolver.toKey(uri);
        CachedSourceInfo info = this.uriToSource.get(key);
        if (info != null) {
            info.file.delete();
        }
        String mimeType = metaSource.getMimeType();
        String encoding = metaSource.getEncoding();
        File file = File.createTempFile("cssj-cache-", ".dat", this.tmpDir);
        file.deleteOnExit();
        info = new CachedSourceInfo(uri, mimeType, encoding, file);
        this.uriToSource.put(key, info);
        return file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putSource(Source source) throws IOException {
        File file = this.putFile(source);
        InputStream in = source.getInputStream();
        try {
            FileOutputStream out = new FileOutputStream(file);
            try {
                IOUtils.copy((InputStream)in, (OutputStream)out);
            }
            finally {
                ((OutputStream)out).close();
            }
        }
        finally {
            in.close();
        }
    }

    public Source resolve(URI uri) throws IOException, SecurityException {
        String key = CachedSourceResolver.toKey(uri = uri.normalize());
        CachedSourceInfo info = this.uriToSource.get(key);
        if (info != null) {
            CachedSource source = new CachedSource(info.uri, info.mimeType, info.encoding, info.file);
            return source;
        }
        throw new FileNotFoundException(uri.toString());
    }

    public void release(Source source) {
        ((CachedSource)source).close();
    }

    public void reset() {
        for (CachedSourceInfo info : this.uriToSource.values()) {
            info.file.delete();
        }
        this.uriToSource.clear();
    }

    public void dispose() {
        this.reset();
    }

    protected void finalize() throws Throwable {
        this.dispose();
        super.finalize();
    }

    protected static class CachedSourceInfo {
        public final URI uri;
        public final String mimeType;
        public final String encoding;
        public final File file;

        public CachedSourceInfo(URI uri, String mimeType, String encoding, File file) {
            this.uri = uri;
            this.mimeType = mimeType;
            this.encoding = encoding;
            this.file = file;
        }
    }
}

