/*
 * Decompiled with CFR 0.152.
 */
package jp.cssj.driver.ctip.v2;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.ByteBuffer;
import java.nio.channels.ByteChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.SocketChannel;
import java.nio.channels.spi.SelectorProvider;
import java.util.ArrayList;
import java.util.List;
import jp.cssj.driver.ctip.common.TcpUtils;
import jp.cssj.driver.ctip.v2.V2RequestConsumer;
import jp.cssj.resolver.helpers.URIHelper;

public class V2ContentProducer {
    protected final String charset;
    protected final URI serverURI;
    protected ReadableByteChannel channel;
    private byte type;
    private byte mode;
    private int blockId;
    private int anchorId;
    private long length;
    private short code;
    private URI uri;
    private String mimeType;
    private String message;
    private String encoding;
    private List args = new ArrayList();
    private ByteBuffer data;
    private ByteBuffer destLong = ByteBuffer.allocate(8);
    private ByteBuffer destInt = ByteBuffer.allocate(4);
    private ByteBuffer destShort = ByteBuffer.allocate(2);
    private ByteBuffer destByte = ByteBuffer.allocate(1);

    public V2ContentProducer(URI uri, String encoding) throws IOException {
        this.charset = encoding;
        this.serverURI = uri;
    }

    public V2RequestConsumer connect() throws IOException {
        String host = this.serverURI.getHost();
        int port = this.serverURI.getPort();
        if (port == -1) {
            port = 8099;
        }
        InetSocketAddress address = new InetSocketAddress(host, port);
        ByteChannel channel = this.createChannel(address);
        this.channel = channel;
        byte[] header = ("CTIP/2.0 " + this.charset + "\n").getBytes("ISO-8859-1");
        TcpUtils.writeAll(channel, ByteBuffer.wrap(header));
        return new V2RequestConsumer(channel, this.charset);
    }

    protected ByteChannel createChannel(InetSocketAddress address) throws IOException {
        SocketChannel socketChannel = SelectorProvider.provider().openSocketChannel();
        socketChannel.connect(address);
        socketChannel.configureBlocking(true);
        return socketChannel;
    }

    protected void close() throws IOException {
        if (this.channel != null) {
            this.channel.close();
            this.channel = null;
        }
    }

    public void next() throws IOException {
        int payload = TcpUtils.readInt(this.channel, this.destInt);
        this.type = TcpUtils.readByte(this.channel, this.destByte);
        switch (this.type) {
            case 1: {
                try {
                    this.uri = URIHelper.create(this.charset, TcpUtils.readString(this.channel, this.destShort, this.charset));
                }
                catch (URISyntaxException e) {
                    throw new IOException(e.getMessage());
                }
                this.mimeType = TcpUtils.readString(this.channel, this.destShort, this.charset);
                this.encoding = TcpUtils.readString(this.channel, this.destShort, this.charset);
                this.length = TcpUtils.readLong(this.channel, this.destLong);
                break;
            }
            case 17: {
                this.blockId = TcpUtils.readInt(this.channel, this.destInt);
                this.data = ByteBuffer.allocate(payload -= 5);
                TcpUtils.readAll(this.channel, this.data);
                this.data.position(0);
                break;
            }
            case 18: {
                break;
            }
            case 19: 
            case 24: {
                this.anchorId = TcpUtils.readInt(this.channel, this.destInt);
                break;
            }
            case 20: {
                this.code = TcpUtils.readShort(this.channel, this.destShort);
                payload -= 3;
                short len = TcpUtils.readShort(this.channel, this.destShort);
                byte[] buff = new byte[len];
                ByteBuffer dest = ByteBuffer.wrap(buff);
                TcpUtils.readAll(this.channel, dest);
                this.message = new String(buff, this.charset);
                payload -= 2 + len;
                this.args.clear();
                while (payload > 0) {
                    len = TcpUtils.readShort(this.channel, this.destShort);
                    buff = new byte[len];
                    dest = ByteBuffer.wrap(buff);
                    TcpUtils.readAll(this.channel, dest);
                    String arg = new String(buff, this.charset);
                    this.args.add(arg);
                    payload -= 2 + len;
                }
                break;
            }
            case 50: {
                this.mode = TcpUtils.readByte(this.channel, this.destByte);
                this.code = TcpUtils.readShort(this.channel, this.destShort);
                payload -= 4;
                short len = TcpUtils.readShort(this.channel, this.destShort);
                byte[] buff = new byte[len];
                ByteBuffer dest = ByteBuffer.wrap(buff);
                TcpUtils.readAll(this.channel, dest);
                this.message = new String(buff, this.charset);
                payload -= 2 + len;
                while (payload > 0) {
                    len = TcpUtils.readShort(this.channel, this.destShort);
                    buff = new byte[len];
                    dest = ByteBuffer.wrap(buff);
                    TcpUtils.readAll(this.channel, dest);
                    String arg = new String(buff, this.charset);
                    this.args.add(arg);
                    payload -= 2 + len;
                }
                break;
            }
            case 21: 
            case 22: {
                this.length = TcpUtils.readLong(this.channel, this.destLong);
                break;
            }
            case 23: {
                this.data = ByteBuffer.allocate(--payload);
                TcpUtils.readAll(this.channel, this.data);
                this.data.position(0);
                break;
            }
            case 33: {
                try {
                    this.uri = URIHelper.create(this.charset, TcpUtils.readString(this.channel, this.destShort, this.charset));
                    break;
                }
                catch (URISyntaxException e) {
                    throw new IOException(e.getMessage());
                }
            }
            case 49: 
            case 51: {
                break;
            }
            default: {
                throw new IOException("Bad response: type " + Integer.toHexString(this.type));
            }
        }
    }

    public int getBlockId() throws IOException {
        return this.blockId;
    }

    public int getAnchorId() throws IOException {
        return this.anchorId;
    }

    public byte getType() throws IOException {
        return this.type;
    }

    public long getLength() throws IOException {
        return this.length;
    }

    public String getMessage() throws IOException {
        return this.message;
    }

    public String[] getArgs() throws IOException {
        return this.args.toArray(new String[this.args.size()]);
    }

    public URI getURI() throws IOException {
        return this.uri;
    }

    public String getMimeType() throws IOException {
        return this.mimeType;
    }

    public String getEncoding() throws IOException {
        return this.encoding;
    }

    public short getCode() throws IOException {
        return this.code;
    }

    public byte getMode() throws IOException {
        return this.mode;
    }

    public int read(byte[] b, int off, int len) throws IOException {
        if (this.data.remaining() <= 0) {
            return -1;
        }
        len = Math.min(len, this.data.remaining());
        this.data.get(b, off, len);
        return len;
    }
}

