/*
 * Decompiled with CFR 0.152.
 */
package jp.cssj.driver.rest;

import java.io.File;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import jp.cssj.cti2.CTISession;
import jp.cssj.cti2.TranscoderException;
import jp.cssj.cti2.helpers.AbstractCTISession;
import jp.cssj.cti2.helpers.DefaultMetaSource;
import jp.cssj.cti2.message.MessageHandler;
import jp.cssj.cti2.progress.ProgressListener;
import jp.cssj.cti2.results.Results;
import jp.cssj.driver.rest.SourcePart;
import jp.cssj.resolver.MetaSource;
import jp.cssj.resolver.Source;
import jp.cssj.resolver.SourceResolver;
import jp.cssj.resolver.file.FileSource;
import jp.cssj.rsr.RandomBuilder;
import jp.cssj.rsr.SerialSupport;
import jp.cssj.rsr.helpers.RandomBuilderOutputStream;
import jp.cssj.rsr.helpers.SerialSupportOutputStream;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethodBase;
import org.apache.commons.httpclient.NameValuePair;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.multipart.MultipartRequestEntity;
import org.apache.commons.httpclient.methods.multipart.Part;
import org.apache.commons.httpclient.methods.multipart.StringPart;
import org.apache.commons.httpclient.params.HttpClientParams;
import org.apache.commons.io.IOUtils;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class RestSession
extends AbstractCTISession
implements CTISession {
    protected static final String CHARSET = "UTF-8";
    protected final String uri;
    protected final String user;
    protected final String password;
    protected Results results = null;
    protected SourceResolver resolver = null;
    protected MessageHandler messageHandler = null;
    protected ProgressListener progressListener = null;
    protected List props = new ArrayList();
    protected int state = 1;
    protected RandomBuilder builder = null;
    protected final HttpClient client;
    protected final DocumentBuilder docBuilder;
    protected final String sessionId;
    protected long srcRead = 0L;
    protected long srcLength = 0L;
    protected Collection resultSet = new HashSet();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RestSession(URI uri, String user, String password) throws IOException {
        this.uri = uri.toString();
        this.user = user;
        this.password = password;
        this.client = new HttpClient();
        HttpClientParams params = this.client.getParams();
        params.setParameter("http.protocol.content-charset", CHARSET);
        params.setParameter("http.protocol.uri-charset", CHARSET);
        params.setParameter("http.protocol.element-charset", CHARSET);
        try {
            this.docBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            throw new RuntimeException(e);
        }
        GetMethod method = new GetMethod(this.uri + "open");
        try {
            ArrayList<NameValuePair> list = new ArrayList<NameValuePair>();
            if (this.user != null) {
                list.add(new NameValuePair("rest.user", this.user));
            }
            if (this.password != null) {
                list.add(new NameValuePair("rest.password", this.password));
            }
            method.setQueryString(RestSession.toParams(list));
            Element message = this.getMessage(method);
            String code = message.getAttribute("code");
            if (!"1012".equals(code)) {
                throw new SecurityException(message.getFirstChild().getNodeValue());
            }
            this.sessionId = message.getFirstChild().getNodeValue();
        }
        finally {
            method.releaseConnection();
        }
    }

    private static IOException IOException(Throwable cause) throws IOException {
        IOException e = new IOException();
        e.initCause(cause);
        return e;
    }

    private static NameValuePair[] toParams(List list) {
        return list.toArray(new NameValuePair[list.size()]);
    }

    private Reader getReader(HttpMethodBase method) throws IOException {
        this.client.executeMethod(method);
        return new InputStreamReader(method.getResponseBodyAsStream(), CHARSET);
    }

    private InputStream getInputStream(HttpMethodBase method) throws IOException {
        this.client.executeMethod(method);
        return method.getResponseBodyAsStream();
    }

    private Document parseResponse(HttpMethodBase method) throws IOException {
        Reader reader = this.getReader(method);
        InputSource source = new InputSource(reader);
        source.setSystemId(method.getURI().toString());
        try {
            return this.docBuilder.parse(source);
        }
        catch (SAXException e) {
            throw RestSession.IOException(e);
        }
    }

    private Element getMessage(HttpMethodBase method) throws IOException {
        Document doc = this.parseResponse(method);
        NodeList nl = doc.getElementsByTagName("message");
        if (nl == null || nl.getLength() == 0) {
            throw new IOException();
        }
        return (Element)nl.item(0);
    }

    public InputStream getServerInfo(URI uri) throws IOException {
        if (this.state >= 2) {
            throw new IllegalStateException("\u65e2\u306b\u672c\u4f53\u304c\u5909\u63db\u3055\u308c\u3066\u3044\u307e\u3059\u3002");
        }
        final GetMethod method = new GetMethod(this.uri + "info");
        ArrayList<NameValuePair> list = new ArrayList<NameValuePair>();
        list.add(new NameValuePair("rest.id", this.sessionId));
        list.add(new NameValuePair("rest.uri", uri.toString()));
        method.setQueryString(RestSession.toParams(list));
        return new FilterInputStream(this.getInputStream(method)){

            public void close() throws IOException {
                super.close();
                method.releaseConnection();
            }
        };
    }

    public void setResults(Results results) throws IOException {
        this.results = results;
    }

    public void setMessageHandler(MessageHandler eh) {
        if (this.state >= 2) {
            throw new IllegalStateException("\u65e2\u306b\u672c\u4f53\u304c\u5909\u63db\u3055\u308c\u3066\u3044\u307e\u3059\u3002");
        }
        this.messageHandler = eh;
    }

    public void setProgressListener(ProgressListener l) {
        if (this.state >= 2) {
            throw new IllegalStateException("\u65e2\u306b\u672c\u4f53\u304c\u5909\u63db\u3055\u308c\u3066\u3044\u307e\u3059\u3002");
        }
        this.progressListener = l;
    }

    public void property(String key, String value) throws IOException {
        if (this.state >= 2) {
            throw new IllegalStateException("\u65e2\u306b\u672c\u4f53\u304c\u5909\u63db\u3055\u308c\u3066\u3044\u307e\u3059\u3002");
        }
        this.props.add(new NameValuePair(key, value));
    }

    public void setSourceResolver(SourceResolver resolver) throws IOException {
        this.resolver = resolver;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resourceNotFound(URI uri) throws IOException {
        GetMethod method = new GetMethod(this.uri + "resources");
        try {
            ArrayList<NameValuePair> list = new ArrayList<NameValuePair>();
            list.add(new NameValuePair("rest.id", this.sessionId));
            list.add(new NameValuePair("rest.uri", uri.toString()));
            list.add(new NameValuePair("rest.notFound", "yes"));
            method.setQueryString(RestSession.toParams(list));
            Element message = this.getMessage(method);
            String code = message.getAttribute("code");
            if (!"1011".equals(code)) {
                throw new IOException(message.getFirstChild().getNodeValue());
            }
        }
        finally {
            method.releaseConnection();
        }
    }

    public OutputStream resource(final MetaSource metaSource) throws IOException {
        final File file = File.createTempFile("copper-rest-rsrc-", ".dat");
        file.deleteOnExit();
        return new FilterOutputStream(new FileOutputStream(file)){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void close() throws IOException {
                try {
                    super.close();
                    FileSource source = new FileSource(file, metaSource.getURI(), metaSource.getMimeType(), metaSource.getEncoding());
                    try {
                        RestSession.this.resource(source);
                    }
                    finally {
                        source.close();
                    }
                }
                finally {
                    file.delete();
                }
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resource(Source source) throws IOException {
        PostMethod method = new PostMethod(this.uri + "resources");
        try {
            ArrayList<NameValuePair> list = new ArrayList<NameValuePair>();
            list.add(new NameValuePair("rest.id", this.sessionId));
            list.add(new NameValuePair("rest.uri", source.getURI().toString()));
            if (source.getMimeType() != null) {
                list.add(new NameValuePair("rest.mimeType", source.getMimeType()));
            }
            if (source.getEncoding() != null) {
                list.add(new NameValuePair("rest.encoding", source.getEncoding()));
            }
            method.setQueryString(RestSession.toParams(list));
            Part[] parts = new Part[]{new SourcePart("rest.resource", source)};
            method.setRequestEntity(new MultipartRequestEntity(parts, method.getParams()));
            Element message = this.getMessage(method);
            String code = message.getAttribute("code");
            if (!"1011".equals(code)) {
                throw new IOException(message.getFirstChild().getNodeValue());
            }
        }
        finally {
            method.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitResults() throws IOException, TranscoderException {
        while (true) {
            PostMethod method = new PostMethod(this.uri + "messages");
            try {
                NodeList progressList;
                URI uri;
                ArrayList<NameValuePair> list = new ArrayList<NameValuePair>();
                list.add(new NameValuePair("rest.id", this.sessionId));
                list.add(new NameValuePair("rest.wait", "5000"));
                method.setQueryString(RestSession.toParams(list));
                Document doc = this.parseResponse(method);
                NodeList messages = doc.getElementsByTagName("message");
                Element message = (Element)messages.item(0);
                if (this.messageHandler != null) {
                    for (int i = 1; i < messages.getLength(); ++i) {
                        Attr arg;
                        Element m = (Element)messages.item(i);
                        short code = (short)Integer.parseInt(m.getAttribute("code"), 16);
                        Text text = (Text)m.getFirstChild();
                        ArrayList<String> args = new ArrayList<String>();
                        int j = 0;
                        while ((arg = m.getAttributeNode("arg" + j)) != null) {
                            args.add(arg.getValue());
                            ++j;
                        }
                        this.messageHandler.message(code, args.toArray(new String[args.size()]), text == null ? null : text.getNodeValue());
                    }
                }
                if (this.resolver != null) {
                    NodeList resources = doc.getElementsByTagName("resource");
                    for (int i = 0; i < resources.getLength(); ++i) {
                        Source source;
                        Element resource = (Element)resources.item(i);
                        uri = URI.create(resource.getAttribute("uri"));
                        try {
                            source = this.resolver.resolve(uri);
                        }
                        catch (IOException e) {
                            this.resourceNotFound(uri);
                            source = null;
                        }
                        if (source == null) continue;
                        try {
                            if (source.exists()) {
                                this.resource(source);
                                continue;
                            }
                            this.resourceNotFound(uri);
                            continue;
                        }
                        finally {
                            this.resolver.release(source);
                        }
                    }
                }
                if (this.progressListener != null && (progressList = doc.getElementsByTagName("progressList")).getLength() > 0) {
                    long srcRead;
                    Attr read;
                    long srcLength;
                    Element progress = (Element)progressList.item(0);
                    Attr length = progress.getAttributeNode("length");
                    if (length != null && this.srcLength != (srcLength = Long.parseLong(length.getValue()))) {
                        this.srcLength = srcLength;
                        this.progressListener.sourceLength(this.srcLength);
                    }
                    if ((read = progress.getAttributeNode("read")) != null && this.srcRead != (srcRead = Long.parseLong(read.getValue()))) {
                        this.srcRead = srcRead;
                        this.progressListener.progress(this.srcLength);
                    }
                }
                NodeList results = doc.getElementsByTagName("result");
                for (int i = 0; i < results.getLength(); ++i) {
                    Element result = (Element)results.item(i);
                    uri = URI.create(result.getAttribute("uri"));
                    if (this.resultSet.contains(uri)) continue;
                    this.resultSet.add(uri);
                    Attr mimeType = result.getAttributeNode("mimeType");
                    Attr encoding = result.getAttributeNode("encoding");
                    Attr length = result.getAttributeNode("length");
                    DefaultMetaSource metaSource = new DefaultMetaSource(uri, mimeType == null ? null : mimeType.getValue(), encoding == null ? null : encoding.getValue(), length == null ? -1L : Long.parseLong(length.getValue()));
                    RandomBuilder builder = this.results.nextBuilder(metaSource);
                    this.result(builder, uri);
                }
                NodeList interruptedList = doc.getElementsByTagName("interrupted");
                if (interruptedList.getLength() > 0) {
                    Attr arg;
                    Element m = (Element)interruptedList.item(0);
                    short code = (short)Integer.parseInt(m.getAttribute("code"), 16);
                    Text text = (Text)m.getFirstChild();
                    ArrayList<String> args = new ArrayList<String>();
                    int j = 0;
                    while ((arg = m.getAttributeNode("arg" + j)) != null) {
                        args.add(arg.getValue());
                        ++j;
                    }
                    throw new TranscoderException(results.getLength() > 0 ? (byte)1 : 2, code, args.toArray(new String[args.size()]), text == null ? null : text.getNodeValue());
                }
                if (!"1013".equals(message.getAttribute("code"))) break;
                continue;
            }
            finally {
                method.releaseConnection();
                continue;
            }
            break;
        }
        this.resultSet.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void result(RandomBuilder builder, URI uri) throws IOException {
        OutputStream out = builder instanceof SerialSupport ? new SerialSupportOutputStream((SerialSupport)builder) : new RandomBuilderOutputStream(builder, 0);
        try {
            GetMethod method = new GetMethod(this.uri + "result");
            try {
                ArrayList<NameValuePair> list = new ArrayList<NameValuePair>();
                list.add(new NameValuePair("rest.id", this.sessionId));
                list.add(new NameValuePair("rest.uri", uri.toString()));
                method.setQueryString(RestSession.toParams(list));
                this.client.executeMethod(method);
                InputStream in = method.getResponseBodyAsStream();
                try {
                    IOUtils.copy(in, out);
                }
                finally {
                    in.close();
                }
            }
            finally {
                method.releaseConnection();
            }
        }
        finally {
            out.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void transcode(URI uri) throws IOException, TranscoderException {
        if (this.results == null) {
            throw new IllegalStateException("Results\u304c\u8a2d\u5b9a\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002");
        }
        if (this.state >= 2) {
            throw new IllegalStateException("\u65e2\u306b\u672c\u4f53\u304c\u5909\u63db\u3055\u308c\u3066\u3044\u307e\u3059\u3002");
        }
        this.state = 2;
        try {
            PostMethod method = new PostMethod(this.uri + "transcode");
            try {
                ArrayList<NameValuePair> list = new ArrayList<NameValuePair>();
                list.add(new NameValuePair("rest.id", this.sessionId));
                list.add(new NameValuePair("rest.async", "true"));
                if (this.resolver != null) {
                    list.add(new NameValuePair("rest.requestResource", "true"));
                }
                method.setQueryString(RestSession.toParams(list));
                method.addParameters(RestSession.toParams(this.props));
                this.props.clear();
                method.addParameter(new NameValuePair("rest.mainURI", uri.toString()));
                Element message = this.getMessage(method);
                String code = message.getAttribute("code");
                if (!"1011".equals(code)) {
                    throw new IOException(message.getFirstChild().getNodeValue());
                }
            }
            finally {
                method.releaseConnection();
            }
            this.waitResults();
        }
        finally {
            this.state = 1;
        }
    }

    public OutputStream transcode(final MetaSource metaSource) throws IOException, TranscoderException {
        final File file = File.createTempFile("copper-rest-main-", ".dat");
        file.deleteOnExit();
        return new FilterOutputStream(new FileOutputStream(file)){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void close() throws IOException {
                try {
                    super.close();
                    FileSource source = new FileSource(file, metaSource.getURI(), metaSource.getMimeType(), metaSource.getEncoding());
                    try {
                        RestSession.this.transcode(source);
                    }
                    finally {
                        source.close();
                    }
                }
                finally {
                    file.delete();
                }
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void transcode(Source source) throws IOException, TranscoderException {
        if (this.results == null) {
            throw new IllegalStateException("Results\u304c\u8a2d\u5b9a\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002");
        }
        if (this.state >= 2) {
            throw new IllegalStateException("\u65e2\u306b\u672c\u4f53\u304c\u5909\u63db\u3055\u308c\u3066\u3044\u307e\u3059\u3002");
        }
        this.state = 2;
        try {
            PostMethod method = new PostMethod(this.uri + "transcode");
            try {
                ArrayList<Object> list = new ArrayList<Object>();
                list.add(new NameValuePair("rest.id", this.sessionId));
                list.add(new NameValuePair("rest.async", "true"));
                if (this.resolver != null) {
                    list.add(new NameValuePair("rest.requestResource", "true"));
                }
                method.setQueryString(RestSession.toParams(list));
                list.clear();
                for (int i = 0; i < this.props.size(); ++i) {
                    NameValuePair param = (NameValuePair)this.props.get(i);
                    list.add(new StringPart(param.getName(), param.getValue(), CHARSET));
                }
                this.props.clear();
                list.add(new StringPart("rest.uri", source.getURI().toString(), CHARSET));
                if (source.getMimeType() != null) {
                    list.add(new StringPart("rest.mimeType", source.getMimeType(), CHARSET));
                }
                if (source.getEncoding() != null) {
                    list.add(new StringPart("rest.encoding", source.getEncoding(), CHARSET));
                }
                list.add(new SourcePart("rest.main", source));
                Part[] parts = list.toArray(new Part[list.size()]);
                method.setRequestEntity(new MultipartRequestEntity(parts, method.getParams()));
                Element message = this.getMessage(method);
                String code = message.getAttribute("code");
                if (!"1011".equals(code)) {
                    throw new IOException(message.getFirstChild().getNodeValue());
                }
            }
            finally {
                method.releaseConnection();
            }
            this.waitResults();
        }
        finally {
            this.state = 1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void abort(byte mode) throws IOException {
        GetMethod method = new GetMethod(this.uri + "abort");
        try {
            ArrayList<NameValuePair> list = new ArrayList<NameValuePair>();
            list.add(new NameValuePair("rest.id", this.sessionId));
            list.add(new NameValuePair("rest.mode", String.valueOf(mode)));
            method.setQueryString(RestSession.toParams(list));
            Element message = this.getMessage(method);
            String code = message.getAttribute("code");
            if (!"1011".equals(code)) {
                throw new IOException(message.getFirstChild().getNodeValue());
            }
        }
        finally {
            method.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() throws IOException {
        GetMethod method = new GetMethod(this.uri + "reset");
        try {
            ArrayList<NameValuePair> list = new ArrayList<NameValuePair>();
            list.add(new NameValuePair("rest.id", this.sessionId));
            method.setQueryString(RestSession.toParams(list));
            Element message = this.getMessage(method);
            String code = message.getAttribute("code");
            if (!"1011".equals(code)) {
                throw new IOException(message.getFirstChild().getNodeValue());
            }
        }
        finally {
            method.releaseConnection();
        }
        this.resolver = null;
        this.results = null;
        this.state = 1;
        this.builder = null;
        this.props.clear();
        this.resultSet.clear();
        this.srcRead = 0L;
        this.srcLength = 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        if (this.state >= 3) {
            return;
        }
        GetMethod method = new GetMethod(this.uri + "close");
        try {
            ArrayList<NameValuePair> list = new ArrayList<NameValuePair>();
            list.add(new NameValuePair("rest.id", this.sessionId));
            method.setQueryString(RestSession.toParams(list));
            Element message = this.getMessage(method);
            String code = message.getAttribute("code");
            if (!"1011".equals(code)) {
                throw new IOException(message.getFirstChild().getNodeValue());
            }
        }
        finally {
            method.releaseConnection();
        }
        this.state = 3;
    }
}

