/*
 * Decompiled with CFR 0.152.
 */
package jp.cssj.driver.ctip.v2;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import jp.cssj.cti2.CTISession;
import jp.cssj.cti2.TranscoderException;
import jp.cssj.cti2.helpers.AbstractCTISession;
import jp.cssj.cti2.helpers.DefaultMetaSource;
import jp.cssj.cti2.message.MessageHandler;
import jp.cssj.cti2.progress.ProgressListener;
import jp.cssj.cti2.results.Results;
import jp.cssj.driver.ctip.v2.V2ContentProducer;
import jp.cssj.driver.ctip.v2.V2RequestConsumer;
import jp.cssj.driver.ctip.v2.V2RequestConsumerOutputStream;
import jp.cssj.resolver.MetaSource;
import jp.cssj.resolver.Source;
import jp.cssj.resolver.SourceResolver;
import jp.cssj.rsr.RandomBuilder;
import jp.cssj.rsr.SerialSupport;

public class V2Session
extends AbstractCTISession
implements CTISession {
    public static final int BUFFER_SIZE = 8192;
    private final byte[] writeBuff = new byte[8192];
    private final byte[] readBuff = new byte[8192];
    protected final String host;
    protected final String encoding;
    protected final int port;
    protected final String user;
    protected final String password;
    protected V2ContentProducer producer = null;
    protected V2RequestConsumer request = null;
    protected Results results = null;
    protected SourceResolver resolver = null;
    protected MessageHandler messageHandler = null;
    protected ProgressListener progressListener = null;
    protected int state = 1;
    protected RandomBuilder builder = null;
    static final /* synthetic */ boolean $assertionsDisabled;

    public V2Session(String host, int port, String encoding, String user, String password) throws IOException {
        this.host = host;
        this.port = port;
        this.encoding = encoding;
        this.user = user == null ? "" : user;
        this.password = password == null ? "" : password;
    }

    protected void init() throws IOException {
        if (this.producer == null) {
            V2ContentProducer producer = new V2ContentProducer(this.host, this.port, this.encoding);
            V2RequestConsumer request = producer.connect();
            request.setCTIPSession(this);
            request.connect(this.user, this.password);
            this.producer = producer;
            this.request = request;
        }
    }

    public InputStream getServerInfo(URI uri) throws IOException {
        if (this.state >= 2) {
            throw new IllegalStateException("\u65e2\u306b\u672c\u4f53\u304c\u5909\u63db\u3055\u308c\u3066\u3044\u307e\u3059\u3002");
        }
        this.init();
        this.request.serverInfo(uri);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        block0: while (true) {
            this.producer.next();
            byte type = this.producer.getType();
            if (type == 49) break;
            if (type != 23) {
                throw new IOException("\u4e0d\u6b63\u306a\u30d1\u30b1\u30c3\u30c8\u30bf\u30a4\u30d7\u3067\u3059: " + type);
            }
            int len = this.producer.read(this.readBuff, 0, this.readBuff.length);
            while (true) {
                if (len == -1) continue block0;
                out.write(this.readBuff, 0, len);
                len = this.producer.read(this.readBuff, 0, this.readBuff.length);
            }
            break;
        }
        return new ByteArrayInputStream(out.toByteArray());
    }

    public void setResults(Results results) throws IOException {
        this.results = results;
    }

    public void setMessageHandler(MessageHandler eh) {
        if (this.state >= 2) {
            throw new IllegalStateException("\u65e2\u306b\u672c\u4f53\u304c\u5909\u63db\u3055\u308c\u3066\u3044\u307e\u3059\u3002");
        }
        this.messageHandler = eh;
    }

    public void setProgressListener(ProgressListener l) {
        if (this.state >= 2) {
            throw new IllegalStateException("\u65e2\u306b\u672c\u4f53\u304c\u5909\u63db\u3055\u308c\u3066\u3044\u307e\u3059\u3002");
        }
        this.progressListener = l;
    }

    public void property(String key, String value) throws IOException {
        if (this.state >= 2) {
            throw new IllegalStateException("\u65e2\u306b\u672c\u4f53\u304c\u5909\u63db\u3055\u308c\u3066\u3044\u307e\u3059\u3002");
        }
        this.init();
        this.request.property(key, value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void transcode(URI uri) throws IOException, TranscoderException {
        if (this.results == null) {
            throw new IllegalStateException("Results\u304c\u8a2d\u5b9a\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002");
        }
        this.request.serverMain(uri);
        this.state = 2;
        try {
            while (this.buildNext()) {
            }
            if (!$assertionsDisabled && this.builder != null) {
                throw new AssertionError();
            }
        }
        finally {
            this.state = 1;
        }
    }

    public OutputStream resource(MetaSource metaSource) throws IOException {
        if (this.state >= 2) {
            throw new IllegalStateException("\u65e2\u306b\u672c\u4f53\u304c\u5909\u63db\u3055\u308c\u3066\u3044\u307e\u3059\u3002");
        }
        this.init();
        this.request.startResource(metaSource.getURI(), metaSource.getMimeType(), metaSource.getEncoding(), metaSource.getLength());
        return new V2RequestConsumerOutputStream(this.request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resource(Source source) throws IOException {
        if (this.state >= 2) {
            throw new IllegalStateException("\u65e2\u306b\u672c\u4f53\u304c\u5909\u63db\u3055\u308c\u3066\u3044\u307e\u3059\u3002");
        }
        this.init();
        this.request.startResource(source.getURI(), source.getMimeType(), source.getEncoding(), source.getLength());
        try {
            InputStream in = source.getInputStream();
            try {
                int len = in.read(this.writeBuff, 0, this.writeBuff.length);
                while (len != -1) {
                    this.request.data(this.writeBuff, 0, len);
                    len = in.read(this.writeBuff, 0, this.writeBuff.length);
                }
            }
            finally {
                in.close();
            }
        }
        finally {
            this.request.eof();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean buildNext() throws IOException, TranscoderException {
        if (this.state <= 1) {
            return false;
        }
        this.producer.next();
        boolean serial = false;
        switch (this.producer.getType()) {
            case 1: {
                if (this.builder != null) {
                    this.builder.finish();
                    this.builder.dispose();
                    this.builder = null;
                }
                URI uri = this.producer.getURI();
                String mimeType = this.producer.getMimeType();
                String encoding = this.producer.getEncoding();
                long length = this.producer.getLength();
                DefaultMetaSource metaSource = new DefaultMetaSource(uri, mimeType, encoding, length);
                this.builder = this.results.nextBuilder(metaSource);
                break;
            }
            case 17: {
                if (!$assertionsDisabled && this.builder == null) {
                    throw new AssertionError();
                }
                if (!$assertionsDisabled && serial) {
                    throw new AssertionError();
                }
                int blockId = this.producer.getBlockId();
                int len = this.producer.read(this.readBuff, 0, this.readBuff.length);
                while (len != -1) {
                    this.builder.write(blockId, this.readBuff, 0, len);
                    len = this.producer.read(this.readBuff, 0, this.readBuff.length);
                }
                break;
            }
            case 18: {
                if (!$assertionsDisabled && this.builder == null) {
                    throw new AssertionError();
                }
                if (!$assertionsDisabled && serial) {
                    throw new AssertionError();
                }
                this.builder.addBlock();
                break;
            }
            case 19: {
                if (!$assertionsDisabled && this.builder == null) {
                    throw new AssertionError();
                }
                if (!$assertionsDisabled && serial) {
                    throw new AssertionError();
                }
                int anchorId = this.producer.getAnchorId();
                this.builder.insertBlockBefore(anchorId);
                break;
            }
            case 24: {
                if (!$assertionsDisabled && this.builder == null) {
                    throw new AssertionError();
                }
                if (!$assertionsDisabled && serial) {
                    throw new AssertionError();
                }
                int anchorId = this.producer.getAnchorId();
                this.builder.closeBlock(anchorId);
                break;
            }
            case 20: {
                if (this.messageHandler == null) break;
                short code = this.producer.getCode();
                String mes = this.producer.getMessage();
                String[] args = this.producer.getArgs();
                this.messageHandler.message(code, args, mes);
                break;
            }
            case 21: {
                if (this.progressListener == null) break;
                long sourceLength = this.producer.getLength();
                this.progressListener.sourceLength(sourceLength);
                break;
            }
            case 22: {
                if (this.progressListener == null) break;
                long serverRead = this.producer.getLength();
                this.progressListener.progress(serverRead);
                break;
            }
            case 23: {
                if (!$assertionsDisabled && this.builder == null) {
                    throw new AssertionError();
                }
                if (this.builder instanceof SerialSupport) {
                    SerialSupport builder = (SerialSupport)this.builder;
                    int len = this.producer.read(this.readBuff, 0, this.readBuff.length);
                    while (len != -1) {
                        builder.write(this.readBuff, 0, len);
                        len = this.producer.read(this.readBuff, 0, this.readBuff.length);
                    }
                } else {
                    if (!serial) {
                        this.builder.addBlock();
                    }
                    int len = this.producer.read(this.readBuff, 0, this.readBuff.length);
                    while (len != -1) {
                        this.builder.write(0, this.readBuff, 0, len);
                        len = this.producer.read(this.readBuff, 0, this.readBuff.length);
                    }
                }
                if (serial) break;
                serial = true;
                break;
            }
            case 33: {
                URI uri = this.producer.getURI();
                if (this.resolver != null) {
                    Source source;
                    try {
                        source = this.resolver.resolve(uri);
                    }
                    catch (IOException e) {
                        this.request.missingResource(uri);
                        source = null;
                    }
                    if (source == null) break;
                    try {
                        if (source.exists()) {
                            this.request.startResource(source.getURI(), source.getMimeType(), source.getEncoding(), source.getLength());
                            InputStream in = source.getInputStream();
                            try {
                                V2RequestConsumerOutputStream out = new V2RequestConsumerOutputStream(this.request);
                                try {
                                    int len = in.read(this.writeBuff);
                                    while (len != -1) {
                                        ((OutputStream)out).write(this.writeBuff, 0, len);
                                        len = in.read(this.writeBuff);
                                    }
                                    break;
                                }
                                finally {
                                    ((OutputStream)out).close();
                                }
                            }
                            finally {
                                in.close();
                            }
                        }
                        this.request.missingResource(uri);
                        break;
                    }
                    finally {
                        this.resolver.release(source);
                    }
                }
                this.request.missingResource(uri);
                break;
            }
            case 49: {
                if (this.builder != null) {
                    this.builder.finish();
                    this.builder.dispose();
                    this.builder = null;
                }
                this.state = 1;
                return false;
            }
            case 50: {
                byte state;
                if (this.producer.getMode() == 0) {
                    this.builder.finish();
                    state = 1;
                } else {
                    state = 2;
                }
                if (this.builder != null) {
                    this.builder.dispose();
                    this.builder = null;
                }
                this.state = 1;
                throw new TranscoderException(state, this.producer.getCode(), this.producer.getArgs(), this.producer.getMessage());
            }
            default: {
                throw new IOException("\u4e0d\u6b63\u306a\u30ec\u30b9\u30dd\u30f3\u30b9\u3067\u3059: " + Integer.toHexString(this.producer.getType()));
            }
        }
        return true;
    }

    public OutputStream transcode(MetaSource metaSource) throws IOException, TranscoderException {
        if (this.results == null) {
            throw new IllegalStateException("Results\u304c\u8a2d\u5b9a\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002");
        }
        if (this.state >= 2) {
            throw new IllegalStateException("\u65e2\u306b\u672c\u4f53\u304c\u5909\u63db\u3055\u308c\u3066\u3044\u307e\u3059\u3002");
        }
        this.init();
        this.request.startMain(metaSource.getURI(), metaSource.getMimeType(), metaSource.getEncoding(), metaSource.getLength());
        this.state = 2;
        return new V2RequestConsumerOutputStream(this.request){
            static final /* synthetic */ boolean $assertionsDisabled;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void close() throws IOException {
                block4: {
                    try {
                        super.close();
                        while (V2Session.this.buildNext()) {
                        }
                        Object var2_1 = null;
                        if ($assertionsDisabled || V2Session.this.builder == null) break block4;
                        throw new AssertionError();
                    }
                    catch (Throwable throwable) {
                        Object var2_2 = null;
                        if (!$assertionsDisabled && V2Session.this.builder != null) {
                            throw new AssertionError();
                        }
                        V2Session.this.state = 1;
                        throw throwable;
                    }
                }
                V2Session.this.state = 1;
            }

            static {
                $assertionsDisabled = !(class$jp$cssj$driver$ctip$v2$V2Session == null ? (class$jp$cssj$driver$ctip$v2$V2Session = V2Session.class$("jp.cssj.driver.ctip.v2.V2Session")) : class$jp$cssj$driver$ctip$v2$V2Session).desiredAssertionStatus();
            }
        };
    }

    public void setSourceResolver(SourceResolver resolver) throws IOException {
        this.resolver = resolver;
        this.init();
        this.request.clientResource(resolver != null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendResource(Source source) throws IOException {
        this.init();
        OutputStream out = this.resource(new DefaultMetaSource(source));
        try {
            InputStream in = source.getInputStream();
            try {
                int len = in.read(this.writeBuff);
                while (len != -1) {
                    out.write(this.writeBuff, 0, len);
                    len = in.read(this.writeBuff);
                }
            }
            finally {
                in.close();
            }
        }
        finally {
            out.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void transcode(Source source) throws IOException, TranscoderException {
        if (this.results == null) {
            throw new IllegalStateException("Results\u304c\u8a2d\u5b9a\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002");
        }
        this.init();
        OutputStream out = this.transcode(new DefaultMetaSource(source));
        try {
            InputStream in = source.getInputStream();
            try {
                int len = in.read(this.writeBuff);
                while (len != -1) {
                    out.write(this.writeBuff, 0, len);
                    len = in.read(this.writeBuff);
                }
            }
            finally {
                in.close();
            }
        }
        finally {
            out.close();
        }
    }

    public void abort(byte mode) throws IOException {
        this.request.abort((byte)(mode - 1));
    }

    public void reset() throws IOException {
        if (this.request != null) {
            this.request.reset();
        }
        this.resolver = null;
        this.results = null;
        this.state = 1;
        this.builder = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        if (this.state >= 3) {
            return;
        }
        if (this.producer != null) {
            try {
                this.request.close();
            }
            finally {
                this.producer.close();
            }
        }
        this.state = 3;
    }

    static {
        $assertionsDisabled = !V2Session.class.desiredAssertionStatus();
    }
}

