/*
 * Decompiled with CFR 0.152.
 */
package jp.cssj.driver.ctip;

import java.io.IOException;
import java.net.URI;
import java.util.Map;
import jp.cssj.cti2.CTIDriver;
import jp.cssj.cti2.CTISession;
import jp.cssj.driver.ctip.v1.V1Session;
import jp.cssj.driver.ctip.v2.V2Session;

public class CTIPDriver
implements CTIDriver {
    public static final String ENCODING = "UTF-8";

    public boolean match(Object key) {
        URI uri = (URI)key;
        if (uri == null) {
            return false;
        }
        return !uri.isOpaque() && "ctip".equals(uri.getScheme());
    }

    public CTISession getSession(URI uri, Map props) throws IOException {
        String host = uri.getHost();
        int port = uri.getPort();
        if (port == -1) {
            port = 8099;
        }
        String query = uri.getQuery();
        String user = null;
        String password = null;
        if (props != null) {
            user = (String)props.get("user");
            password = (String)props.get("password");
        }
        if (query != null && query.indexOf("version=1") != -1) {
            return new V1Session(host, port, ENCODING, user, password);
        }
        return new V2Session(host, port, ENCODING, user, password);
    }
}

