/*
 * Decompiled with CFR 0.152.
 */
package jp.cssj.driver.cli;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.util.Properties;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import jp.cssj.cti2.CTIDriverManager;
import jp.cssj.cti2.CTISession;
import jp.cssj.cti2.helpers.CTIMessageHelper;
import jp.cssj.cti2.helpers.CTISessionHelper;
import jp.cssj.cti2.results.SingleResult;
import jp.cssj.resolver.composite.CompositeSourceResolver;
import jp.cssj.resolver.file.FileSource;
import jp.cssj.resolver.helpers.AbstractSource;
import jp.cssj.resolver.stream.StreamSource;
import org.apache.commons.cli.BasicParser;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionGroup;
import org.apache.commons.cli.Options;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public final class Main {
    private static final Options OPTIONS = new Options();

    private Main() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        block30: {
            OutputStream out;
            AbstractSource source;
            CommandLine line;
            BasicParser parser = new BasicParser();
            try {
                line = parser.parse(OPTIONS, args);
            }
            catch (Exception e) {
                System.err.println(e.getMessage());
                System.exit(0);
                return;
            }
            if (line.hasOption("h")) {
                HelpFormatter formatter = new HelpFormatter();
                formatter.printHelp("copper", OPTIONS, true);
                System.exit(0);
                return;
            }
            if (line.hasOption("v")) {
                System.out.println("Copper PDF CLI 2.0.2");
                System.exit(0);
                return;
            }
            String inputType = line.hasOption("if") ? line.getOptionValue("if") : "text/html";
            String encoding = line.hasOption("ie") ? line.getOptionValue("ie") : null;
            URI uri = new File(".").toURI();
            if (line.hasOption("in")) {
                File file = new File(line.getOptionValue("in"));
                uri = line.hasOption("uri") ? uri.resolve(line.getOptionValue("uri")) : file.toURI();
                source = new FileSource(file, uri, inputType, encoding);
            } else if (line.hasOption("uri")) {
                uri = uri.resolve(line.getOptionValue("uri"));
                source = null;
            } else {
                if (line.hasOption("uri")) {
                    uri = uri.resolve(line.getOptionValue("uri"));
                }
                source = new StreamSource(uri, System.in, inputType, encoding);
            }
            if (line.hasOption("out")) {
                File file = new File(line.getOptionValue("out"));
                out = new FileOutputStream(file);
            } else {
                out = System.out;
            }
            Properties props = new Properties();
            if (line.hasOption("pf")) {
                File file = new File(line.getOptionValue("pf"));
                FileInputStream pin = new FileInputStream(file);
                try {
                    props.load(pin);
                }
                finally {
                    ((InputStream)pin).close();
                }
            }
            if (line.hasOption("p")) {
                String[] values = line.getOptionValues("p");
                for (int i = 0; i < values.length; i += 2) {
                    props.setProperty(values[i], values[i + 1]);
                }
            }
            String server = "copper:direct:";
            if (line.hasOption("s")) {
                server = line.getOptionValue("s");
            }
            URI serverURI = URI.create(server);
            String user = null;
            String password = null;
            if (line.hasOption("u")) {
                user = line.getOptionValue("u");
            }
            if (line.hasOption("pw")) {
                password = line.getOptionValue("pw");
            }
            boolean sv = line.hasOption("sv");
            CompositeSourceResolver resolver = CompositeSourceResolver.createGenericCompositeSourceResolver();
            CTISession session = CTIDriverManager.getSession(serverURI, user, password);
            try {
                if (sv) {
                    InputStream in = session.getServerInfo(URI.create("http://www.cssj.jp/ns/ctip/version"));
                    try {
                        DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
                        Document doc = builder.parse(in);
                        Element e = (Element)doc.getElementsByTagName("long-version").item(0);
                        System.out.println(e.getFirstChild().getNodeValue());
                        e = (Element)doc.getElementsByTagName("copyrights").item(0);
                        System.out.println(e.getFirstChild().getNodeValue());
                        e = (Element)doc.getElementsByTagName("credits").item(0);
                        System.out.println(e.getFirstChild().getNodeValue());
                        break block30;
                    }
                    finally {
                        in.close();
                    }
                }
                session.setResults(new SingleResult(out));
                session.setMessageHandler(CTIMessageHelper.createStreamMessageHandler(System.err));
                session.setSourceResolver(resolver);
                CTISessionHelper.properties(session, props);
                if (source != null) {
                    session.transcode(source);
                } else {
                    session.transcode(uri);
                }
            }
            finally {
                session.close();
            }
        }
    }

    static {
        OptionGroup optGroup = new OptionGroup();
        Option opt = new Option("h", "help", false, "\u30d8\u30eb\u30d7\u30e1\u30c3\u30bb\u30fc\u30b8\u3092\u8868\u793a\u3059\u308b\u3002");
        optGroup.addOption(opt);
        opt = new Option("v", "version", false, "\u30d0\u30fc\u30b8\u30e7\u30f3\u60c5\u5831\u3092\u8868\u793a\u3059\u308b\u3002");
        optGroup.addOption(opt);
        opt = new Option("in", "input-file", true, "\u5165\u529b\u30d5\u30a1\u30a4\u30eb\u3092\u6307\u5b9a\u3059\u308b\u3002");
        opt.setArgs(1);
        opt.setArgName("\u5165\u529b\u30d5\u30a1\u30a4\u30eb");
        optGroup.addOption(opt);
        opt = new Option("uri", "input-uri", true, "\u5165\u529bURI\u3092\u6307\u5b9a\u3059\u308b\u3002");
        opt.setArgs(1);
        opt.setArgName("\u5165\u529bURI");
        optGroup.addOption(opt);
        OPTIONS.addOptionGroup(optGroup);
        Option opt2 = new Option("if", "input-format", true, "\u5165\u529b\u5f62\u5f0f\u3092\u6307\u5b9a\u3059\u308b(\u7701\u7565\u6642\u306ftext/html)\u3002");
        opt2.setArgs(1);
        opt2.setArgName("\u5165\u529b\u5f62\u5f0f");
        OPTIONS.addOption(opt2);
        opt2 = new Option("ie", "input-encoding", true, "\u5165\u529b\u30a8\u30f3\u30b3\u30fc\u30c7\u30a3\u30f3\u30b0\u3092\u6307\u5b9a\u3059\u308b\u3002");
        opt2.setArgs(1);
        opt2.setArgName("\u5165\u529b\u30a8\u30f3\u30b3\u30fc\u30c7\u30a3\u30f3\u30b0");
        OPTIONS.addOption(opt2);
        opt2 = new Option("out", "output-file", true, "\u51fa\u529b\u30d5\u30a1\u30a4\u30eb\u3092\u6307\u5b9a\u3059\u308b\u3002");
        opt2.setArgs(1);
        opt2.setArgName("\u51fa\u529b\u30d5\u30a1\u30a4\u30eb");
        OPTIONS.addOption(opt2);
        opt2 = new Option("p", true, "\u30d7\u30ed\u30d1\u30c6\u30a3\u3092\u6307\u5b9a\u3059\u308b\u3002");
        opt2.setArgs(Integer.MAX_VALUE);
        opt2.setArgName("\u30d7\u30ed\u30d1\u30c6\u30a3\u540d=\u5024");
        opt2.setValueSeparator('=');
        OPTIONS.addOption(opt2);
        opt2 = new Option("pf", "properties-file", true, "\u30d7\u30ed\u30d1\u30c6\u30a3\u30d5\u30a1\u30a4\u30eb\u3092\u6307\u5b9a\u3059\u308b\u3002");
        opt2.setArgs(1);
        opt2.setArgName("\u30d7\u30ed\u30d1\u30c6\u30a3\u30d5\u30a1\u30a4\u30eb");
        OPTIONS.addOption(opt2);
        opt2 = new Option("s", "server", true, "\u30b5\u30fc\u30d0\u30fcURI\u3092\u6307\u5b9a\u3059\u308b\u3002");
        opt2.setArgs(1);
        opt2.setArgName("\u30b5\u30fc\u30d0\u30fcURI");
        OPTIONS.addOption(opt2);
        opt2 = new Option("u", "user", true, "\u63a5\u7d9a\u30e6\u30fc\u30b6\u30fc\u3002");
        opt2.setArgs(1);
        opt2.setArgName("\u30e6\u30fc\u30b6\u30fc");
        OPTIONS.addOption(opt2);
        opt2 = new Option("pw", "pw", true, "\u63a5\u7d9a\u30d1\u30b9\u30ef\u30fc\u30c9\u3002");
        opt2.setArgs(1);
        opt2.setArgName("\u30d1\u30b9\u30ef\u30fc\u30c9");
        OPTIONS.addOption(opt2);
        opt2 = new Option("sv", "server-version", false, "\u30c9\u30ad\u30e5\u30e1\u30f3\u30c8\u5909\u63db\u30b5\u30fc\u30d0\u30fc\u306e\u30d0\u30fc\u30b8\u30e7\u30f3\u60c5\u5831\u3002");
        OPTIONS.addOption(opt2);
    }
}

