/*
 * Decompiled with CFR 0.152.
 */
package jp.cssj.sakae.opentype;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jp.cssj.sakae.opentype.OpenTypeFont;

public class FontFile {
    private static Map fileToRaf = new HashMap();
    private static Map fileToFontFile = new HashMap();
    private final List fonts;
    private final OpenTypeFont font;

    public static synchronized FontFile getFontFile(File file) throws IOException {
        FontFile ttFile;
        RandomAccessFile raf = (RandomAccessFile)fileToRaf.get(file = file.getCanonicalFile());
        if (raf == null) {
            raf = new RandomAccessFile(file, "r");
            fileToRaf.put(file, raf);
        }
        if ((ttFile = (FontFile)fileToFontFile.get(file)) == null) {
            ttFile = new FontFile(raf);
            fileToFontFile.put(file, ttFile);
        }
        return ttFile;
    }

    private FontFile(RandomAccessFile raf) throws IOException {
        byte[] tagBytes = new byte[4];
        raf.read(tagBytes);
        String tag = new String(tagBytes, "ISO-8859-1");
        if ("ttcf".equals(tag)) {
            int i;
            ArrayList<OpenTypeFont> fonts = new ArrayList<OpenTypeFont>();
            raf.skipBytes(4);
            int numFonts = raf.readInt();
            long[] dirOffsets = new long[numFonts];
            for (i = 0; i < numFonts; ++i) {
                dirOffsets[i] = raf.readInt();
            }
            for (i = 0; i < numFonts; ++i) {
                raf.seek(dirOffsets[i]);
                fonts.add(new OpenTypeFont(raf));
            }
            this.fonts = Collections.unmodifiableList(fonts);
            this.font = null;
        } else {
            raf.seek(0L);
            this.fonts = null;
            this.font = new OpenTypeFont(raf);
        }
    }

    public boolean isFontCollection() {
        return this.fonts != null;
    }

    public int getNumFonts() {
        if (this.fonts == null) {
            return 1;
        }
        return this.fonts.size();
    }

    public OpenTypeFont getFont(int i) {
        if (this.fonts == null) {
            if (i != 0) {
                throw new ArrayIndexOutOfBoundsException(i);
            }
            return this.font;
        }
        return (OpenTypeFont)this.fonts.get(i);
    }

    public OpenTypeFont getFont() {
        if (this.fonts != null) {
            return this.getFont(0);
        }
        return this.font;
    }
}

