/*
 * Decompiled with CFR 0.152.
 */
package jp.cssj.sakae.opentype.truetype;

import java.io.IOException;
import java.io.RandomAccessFile;
import jp.cssj.sakae.opentype.table.GlyfTable;
import jp.cssj.sakae.opentype.table.Program;
import jp.cssj.sakae.opentype.truetype.GlyphDescription;

public abstract class GlyfDescript
extends Program
implements GlyphDescription {
    public static final byte onCurve = 1;
    public static final byte xShortVector = 2;
    public static final byte yShortVector = 4;
    public static final byte repeat = 8;
    public static final byte xDual = 16;
    public static final byte yDual = 32;
    protected GlyfTable parentTable;
    private int numberOfContours;
    private short xMin;
    private short yMin;
    private short xMax;
    private short yMax;

    protected GlyfDescript(GlyfTable parentTable, int numberOfContours, RandomAccessFile raf) throws IOException {
        this.parentTable = parentTable;
        this.numberOfContours = numberOfContours;
        this.xMin = (short)(raf.read() << 8 | raf.read());
        this.yMin = (short)(raf.read() << 8 | raf.read());
        this.xMax = (short)(raf.read() << 8 | raf.read());
        this.yMax = (short)(raf.read() << 8 | raf.read());
    }

    public int getNumberOfContours() {
        return this.numberOfContours;
    }

    public short getXMaximum() {
        return this.xMax;
    }

    public short getXMinimum() {
        return this.xMin;
    }

    public short getYMaximum() {
        return this.yMax;
    }

    public short getYMinimum() {
        return this.yMin;
    }
}

