/*
 * Decompiled with CFR 0.152.
 */
package jp.cssj.sakae.opentype.table;

import java.io.IOException;
import java.io.RandomAccessFile;
import jp.cssj.sakae.opentype.table.DirectoryEntry;
import jp.cssj.sakae.opentype.table.Table;

public abstract class XmtxTable
implements Table {
    private DirectoryEntry de;
    private RandomAccessFile raf;
    private int numberOfHMetrics;
    private int lsbCount;
    private int[] xMetrics = null;
    private short[] leftSideBearing = null;

    protected XmtxTable(DirectoryEntry de, RandomAccessFile raf) throws IOException {
        this.de = de;
        this.raf = raf;
    }

    public void init(int numberOfHMetrics, int lsbCount) throws IOException {
        this.numberOfHMetrics = numberOfHMetrics;
        this.lsbCount = lsbCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void load() {
        if (this.raf == null) {
            return;
        }
        RandomAccessFile randomAccessFile = this.raf;
        synchronized (randomAccessFile) {
            try {
                int i;
                this.xMetrics = new int[this.numberOfHMetrics];
                this.raf.seek(this.de.getOffset());
                for (i = 0; i < this.numberOfHMetrics; ++i) {
                    this.xMetrics[i] = this.raf.read() << 24 | this.raf.read() << 16 | this.raf.read() << 8 | this.raf.read();
                }
                if (this.lsbCount > 0) {
                    this.leftSideBearing = new short[this.lsbCount];
                    for (i = 0; i < this.lsbCount; ++i) {
                        this.leftSideBearing[i] = (short)(this.raf.read() << 8 | this.raf.read());
                    }
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            this.raf = null;
        }
    }

    public synchronized int getAdvanceWidth(int i) {
        this.load();
        if (i < this.xMetrics.length) {
            return this.xMetrics[i] >> 16;
        }
        return this.xMetrics[this.xMetrics.length - 1] >> 16;
    }

    public synchronized short getLeftSideBearing(int i) {
        this.load();
        if (i < this.xMetrics.length) {
            return (short)(this.xMetrics[i] & 0xFFFF);
        }
        return this.leftSideBearing[i -= this.xMetrics.length];
    }
}

