/*
 * Decompiled with CFR 0.152.
 */
package jp.cssj.sakae.opentype.cff;

import java.io.IOException;
import java.io.RandomAccessFile;
import jp.cssj.sakae.opentype.Glyph;
import jp.cssj.sakae.opentype.cff.CffStack;
import jp.cssj.sakae.opentype.cff.Type2CharString;
import jp.cssj.sakae.opentype.table.DirectoryEntry;
import jp.cssj.sakae.opentype.table.HmtxTable;
import jp.cssj.sakae.opentype.table.Table;

public class CffTable
implements Table {
    public static final int VERSION = 0;
    public static final int NOTICE = 1;
    public static final int FULL_NAME = 2;
    public static final int FAMILY_NAME = 3;
    public static final int WEIGHT = 4;
    public static final int FONT_BBOX = 5;
    public static final int BLUE_VALUES = 6;
    public static final int OTHER_BLUES = 7;
    public static final int FAMILY_BLUES = 8;
    public static final int FAMILY_OTHER_BLUES = 9;
    public static final int STD_HW = 10;
    public static final int STD_VW = 11;
    public static final int UNIQUE_ID = 13;
    public static final int XUID = 14;
    public static final int CHARSETS = 15;
    public static final int ENCODING = 16;
    public static final int CHAR_STRINGS = 17;
    public static final int PRIVATE = 18;
    public static final int SUBRS = 19;
    public static final int DEFAULT_WIDTHX = 20;
    public static final int NOMINAL_WIDTHX = 21;
    public static final int COPYRIGHT = 3072;
    public static final int IS_FIXED_PITCH = 3073;
    public static final int ITALIC_ANGLE = 3074;
    public static final int UNDERLINE_POSITION = 3075;
    public static final int UNDERLINE_THICKNESS = 3076;
    public static final int PAINT_TYPE = 3077;
    public static final int CHARSTRING_TYPE = 3078;
    public static final int FONT_MATRIX = 1804;
    public static final int STROKE_WIDTH = 3080;
    public static final int BLUE_SCALE = 3081;
    public static final int BLUE_SHIFT = 3082;
    public static final int BLUE_FUZZ = 3083;
    public static final int STEM_SNAP_H = 3084;
    public static final int STEM_SNAP_V = 3085;
    public static final int FORCE_BOLD = 3086;
    public static final int LANGUAGE_GROUP = 3089;
    public static final int EXPANSION_FACTOR = 4620;
    public static final int INITIAL_RANDOM_SEED = 4876;
    public static final int SYNTHETIC_BASE = 5132;
    public static final int POST_SCRIPT = 5388;
    public static final int BASE_FONT_NAME = 5644;
    public static final int BASE_FONT_BLEND = 5900;
    public static final int ROS = 7692;
    public static final int CID_FONT_VERSION = 7948;
    public static final int CID_FONT_REVISION = 3104;
    public static final int CID_FONT_TYPE = 3105;
    public static final int CID_COUNT = 3106;
    public static final int UID_BASE = 3107;
    public static final int FD_ARRAY = 3108;
    public static final int FD_SELECT = 3109;
    public static final int FONT_NAME = 3110;
    public static final byte TYPE_OPERATOR = 1;
    public static final byte TYPE_INTEGER = 2;
    public static final byte TYPE_REAL = 3;
    private static final boolean DEBUG = false;
    private final RandomAccessFile raf;
    private final CffStack stack = new CffStack();
    private int[] charStringOffsets;
    private int[] globalSubrOffsets;
    private int[][] localSubrOffsets;
    private int b0 = -1;
    private final StringBuffer buff = new StringBuffer();
    private Type2CharString charString;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CffTable(DirectoryEntry de, RandomAccessFile raf) throws IOException {
        RandomAccessFile randomAccessFile = this.raf = raf;
        synchronized (randomAccessFile) {
            int i;
            int i2;
            int offSize;
            this.raf.seek(de.getOffset());
            byte[] header = this.readHeader();
            byte skip = header[2];
            this.raf.skipBytes(skip - 4);
            int count = this.readCard16();
            if (count != 1) {
                throw new IOException("Name INDEX\u304c1\u3064\u3067\u306f\u3042\u308a\u307e\u305b\u3093\u3002:" + count);
            }
            int offSize2 = this.readOffSize();
            this.raf.skipBytes(offSize2);
            int offset = this.readOffset(offSize2);
            this.raf.skipBytes(offset - 1);
            int count2 = this.readCard16();
            if (count2 != 1) {
                throw new IOException("Top DICT INDEX\u304c1\u3064\u3067\u306f\u3042\u308a\u307e\u305b\u3093\u3002:" + count2);
            }
            int offSize3 = this.readOffSize();
            this.raf.skipBytes(offSize3);
            int offset2 = this.readOffset(offSize3);
            int dictEnd = offset2 - 1;
            dictEnd = (int)((long)dictEnd + this.raf.getFilePointer());
            int charStringsOffset = -1;
            int privateOffset = -1;
            int privateEnd = 0;
            int fontDictIndexOffset = -1;
            int fdSelectOffset = -1;
            while (this.raf.getFilePointer() < (long)dictEnd) {
                int op = this.scanOperator();
                switch (op) {
                    case 17: {
                        charStringsOffset = (int)this.stack.get(0);
                        break;
                    }
                    case 18: {
                        privateEnd = (int)this.stack.get(0);
                        privateOffset = (int)this.stack.get(1);
                        break;
                    }
                    case 3108: {
                        fontDictIndexOffset = (int)this.stack.get(0);
                        break;
                    }
                    case 3109: {
                        fdSelectOffset = (int)this.stack.get(0);
                    }
                }
                this.stack.clear();
            }
            if (charStringsOffset == -1) {
                throw new IOException("DICT\u306bCharStrings\u304c\u3042\u308a\u307e\u305b\u3093\u3002");
            }
            int count3 = this.readCard16();
            if (count3 > 0) {
                offSize = this.readOffSize();
                int skip2 = count3 * offSize;
                this.raf.skipBytes(skip2);
                int offset3 = this.readOffset(offSize);
                this.raf.skipBytes(offset3 - 1);
            }
            count3 = this.readCard16();
            offSize = this.readOffSize();
            this.globalSubrOffsets = new int[++count3];
            for (i2 = 0; i2 < count3; ++i2) {
                this.globalSubrOffsets[i2] = this.readOffset(offSize);
            }
            int globalSubrsIndexOffset = (int)this.raf.getFilePointer() - 1;
            int i3 = 0;
            while (i3 < count3) {
                int n = i3++;
                this.globalSubrOffsets[n] = this.globalSubrOffsets[n] + globalSubrsIndexOffset;
            }
            this.raf.seek(de.getOffset() + charStringsOffset);
            int charCount = this.readCard16();
            offSize = this.readOffSize();
            this.charStringOffsets = new int[charCount];
            for (i2 = 0; i2 < charCount; ++i2) {
                this.charStringOffsets[i2] = this.readOffset(offSize);
            }
            int charStringsIndexOffset = (int)this.raf.getFilePointer() + offSize - 1;
            i3 = 0;
            while (i3 < charCount) {
                int n = i3++;
                this.charStringOffsets[n] = this.charStringOffsets[n] + charStringsIndexOffset;
            }
            if (privateEnd != 0) {
                this.raf.seek(de.getOffset() + privateOffset);
                privateEnd = (int)((long)privateEnd + this.raf.getFilePointer());
                int localSubrsOffset = -1;
                while (this.raf.getFilePointer() < (long)privateEnd) {
                    int op = this.scanOperator();
                    switch (op) {
                        case 19: {
                            localSubrsOffset = (int)this.stack.get(0) + privateOffset;
                        }
                    }
                    this.stack.clear();
                }
                if (localSubrsOffset != -1) {
                    this.raf.seek(de.getOffset() + localSubrsOffset);
                    int count4 = this.readCard16();
                    int offSize4 = this.readOffSize();
                    int[] localSubrOffsets = new int[++count4];
                    for (int i4 = 0; i4 < count4; ++i4) {
                        localSubrOffsets[i4] = this.readOffset(offSize4);
                    }
                    int localSubrsIndexOffset = (int)this.raf.getFilePointer() - 1;
                    i = 0;
                    while (i < count4) {
                        int n = i++;
                        localSubrOffsets[n] = localSubrOffsets[n] + localSubrsIndexOffset;
                    }
                    this.localSubrOffsets = new int[charCount][];
                    for (i = 0; i < charCount; ++i) {
                        this.localSubrOffsets[i] = localSubrOffsets;
                    }
                }
            }
            if (fontDictIndexOffset != -1) {
                this.raf.seek(de.getOffset() + fontDictIndexOffset);
                int count5 = this.readCard16();
                int offSize5 = this.readOffSize();
                int[] offsets = new int[++count5];
                for (int i5 = 0; i5 < count5; ++i5) {
                    offsets[i5] = this.readOffset(offSize5);
                }
                int[] privateOffsets = new int[count5 - 1];
                int[] privateLengths = new int[count5 - 1];
                for (i = 0; i < count5 - 1; ++i) {
                    int end = (int)this.raf.getFilePointer() + offsets[i + 1] - offsets[i];
                    while (this.raf.getFilePointer() < (long)end) {
                        int op = this.scanOperator();
                        switch (op) {
                            case 18: {
                                privateLengths[i] = (int)this.stack.get(0);
                                privateOffsets[i] = (int)this.stack.get(1);
                            }
                        }
                        this.stack.clear();
                    }
                }
                int[] subrsOffsets = new int[count5 - 1];
                for (int i6 = 0; i6 < count5 - 1; ++i6) {
                    int end = privateLengths[i6];
                    if (end <= 0) continue;
                    int fdPrivateOffset = privateOffsets[i6];
                    this.raf.seek(de.getOffset() + fdPrivateOffset);
                    end = (int)((long)end + this.raf.getFilePointer());
                    while (this.raf.getFilePointer() < (long)end) {
                        int op = this.scanOperator();
                        switch (op) {
                            case 19: {
                                subrsOffsets[i6] = (int)this.stack.get(0) + fdPrivateOffset;
                            }
                        }
                        this.stack.clear();
                    }
                }
                int[][] fdLocalSubrOffsets = new int[count5 - 1][];
                for (int i7 = 0; i7 < count5 - 1; ++i7) {
                    if (subrsOffsets[i7] == 0) continue;
                    this.raf.seek(de.getOffset() + subrsOffsets[i7]);
                    int subrCount = this.readCard16();
                    int subrOffSize = this.readOffSize();
                    int[] subrOffsets = new int[++subrCount];
                    for (int j = 0; j < subrCount; ++j) {
                        subrOffsets[j] = this.readOffset(subrOffSize);
                    }
                    int fdLocalSubrsIndexOffset = (int)this.raf.getFilePointer() - 1;
                    int j = 0;
                    while (j < subrCount) {
                        int n = j++;
                        subrOffsets[n] = subrOffsets[n] + fdLocalSubrsIndexOffset;
                    }
                    fdLocalSubrOffsets[i7] = subrOffsets;
                }
                this.localSubrOffsets = new int[charCount][];
                this.raf.seek(de.getOffset() + fdSelectOffset);
                int format = this.readCard8();
                switch (format) {
                    case 0: {
                        for (int i8 = 0; i8 < charCount; ++i8) {
                            int fdIx = this.readCard8();
                            this.localSubrOffsets[i8] = fdLocalSubrOffsets[fdIx];
                        }
                        break;
                    }
                    case 3: {
                        int nRanges = this.readCard16();
                        int first = this.readCard16();
                        for (int i9 = 0; i9 < nRanges; ++i9) {
                            int fdIx = this.readCard8();
                            int last = this.readCard16();
                            for (int j = first; j < last; ++j) {
                                this.localSubrOffsets[j] = fdLocalSubrOffsets[fdIx];
                            }
                            first = last;
                        }
                        break;
                    }
                    default: {
                        throw new IOException("Unsupported FD Select format: " + format);
                    }
                }
            }
        }
    }

    public int getType() {
        return 1128678944;
    }

    public void init(HmtxTable hmtx) {
        this.charString = new Type2CharString(this.raf, hmtx);
    }

    public Glyph getGlyph(int ix, short upm) {
        int[] localSubrOffsets = this.localSubrOffsets == null ? null : this.localSubrOffsets[ix];
        return this.charString.getGlyph(ix, this.charStringOffsets[ix], upm, this.globalSubrOffsets, localSubrOffsets);
    }

    private byte[] readHeader() throws IOException {
        byte[] header = new byte[4];
        for (int i = 0; i < 4; ++i) {
            header[i] = this.raf.readByte();
        }
        return header;
    }

    private int readCard8() throws IOException {
        return this.raf.read();
    }

    private int readCard16() throws IOException {
        return this.raf.readShort() & 0xFFFF;
    }

    private int readOffSize() throws IOException {
        byte offSize = this.raf.readByte();
        if (offSize < 1 || offSize > 4) {
            throw new IOException("OffSize\u306f1\u304b\u30894\u307e\u3067\u3067\u3059\u3002:" + offSize);
        }
        return offSize;
    }

    private int readOffset(int size) throws IOException {
        int offset = 0;
        for (int i = 0; i < size; ++i) {
            offset <<= 8;
            offset |= this.raf.read();
        }
        return offset;
    }

    /*
     * WARNING - void declaration
     */
    private int scanOperator() throws IOException {
        while (true) {
            void var2_2;
            byte type = this.nextType();
            switch (type) {
                case 1: {
                    return this.readOperator();
                }
                case 2: {
                    float number = this.readInteger();
                    break;
                }
                case 3: {
                    String real = this.readReal();
                    float number = Float.parseFloat(real);
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
            this.stack.push((float)var2_2);
        }
    }

    private byte nextType() throws IOException {
        this.b0 = this.raf.read();
        if (this.b0 <= 21) {
            return 1;
        }
        if (this.b0 == 30) {
            return 3;
        }
        if (this.b0 >= 28 && this.b0 != 31 && this.b0 != 255) {
            return 2;
        }
        throw new IOException("\u672a\u77e5\u306e\u30aa\u30da\u30e9\u30f3\u30c9\u3067\u3059\u3002");
    }

    private int readOperator() throws IOException {
        if (this.b0 == -1 && this.nextType() != 1) {
            throw new IOException("Operator\u3067\u306f\u3042\u308a\u307e\u305b\u3093\u3002");
        }
        int b = this.b0;
        this.b0 = -1;
        if (b == 12) {
            b <<= 8;
            b |= this.raf.read();
        }
        return b;
    }

    private int readInteger() throws IOException {
        if (this.b0 == -1 && this.nextType() != 2) {
            throw new IOException("Integer\u3067\u306f\u3042\u308a\u307e\u305b\u3093\u3002");
        }
        int b0 = this.b0;
        this.b0 = -1;
        if (b0 >= 32 && b0 <= 246) {
            return b0 - 139;
        }
        if (b0 >= 247 && b0 <= 250) {
            int b1 = this.raf.read();
            return (b0 - 247) * 256 + b1 + 108;
        }
        if (b0 >= 251 && b0 <= 254) {
            int b1 = this.raf.read();
            return -(b0 - 251) * 256 - b1 - 108;
        }
        if (b0 == 28) {
            int b1 = this.raf.read();
            int b2 = this.raf.read();
            return b1 << 8 | b2;
        }
        if (b0 == 29) {
            int b1 = this.raf.read();
            int b2 = this.raf.read();
            int b3 = this.raf.read();
            int b4 = this.raf.read();
            return b1 << 24 | b2 << 16 | b3 << 8 | b4;
        }
        throw new IOException("\u4e0d\u6b63\u306aInteger\u3067\u3059\u3002:" + b0);
    }

    private String readReal() throws IOException {
        if (this.b0 == -1 && this.nextType() != 3) {
            throw new IOException("Real\u3067\u306f\u3042\u308a\u307e\u305b\u3093\u3002");
        }
        this.buff.setLength(0);
        this.b0 = -1;
        block8: while (true) {
            int b = this.raf.read();
            int i = 0;
            while (true) {
                if (i >= 2) continue block8;
                int c = b >> 4 & 0xF;
                switch (c) {
                    case 10: {
                        this.buff.append('.');
                        break;
                    }
                    case 11: {
                        this.buff.append('E');
                        break;
                    }
                    case 12: {
                        this.buff.append("E-");
                        break;
                    }
                    case 13: {
                        break;
                    }
                    case 14: {
                        this.buff.append('-');
                        break;
                    }
                    case 15: {
                        break block8;
                    }
                    default: {
                        this.buff.append(String.valueOf(c));
                    }
                }
                b <<= 4;
                ++i;
            }
            break;
        }
        return this.buff.toString();
    }
}

