/*
 * Decompiled with CFR 0.152.
 */
package jp.cssj.sakae.opentype;

import java.io.IOException;
import java.io.RandomAccessFile;
import jp.cssj.sakae.opentype.Glyph;
import jp.cssj.sakae.opentype.GlyphList;
import jp.cssj.sakae.opentype.cff.CffGlyphList;
import jp.cssj.sakae.opentype.cff.CffTable;
import jp.cssj.sakae.opentype.table.CmapTable;
import jp.cssj.sakae.opentype.table.GlyfTable;
import jp.cssj.sakae.opentype.table.HeadTable;
import jp.cssj.sakae.opentype.table.HheaTable;
import jp.cssj.sakae.opentype.table.HmtxTable;
import jp.cssj.sakae.opentype.table.LocaTable;
import jp.cssj.sakae.opentype.table.MaxpTable;
import jp.cssj.sakae.opentype.table.NameTable;
import jp.cssj.sakae.opentype.table.Os2Table;
import jp.cssj.sakae.opentype.table.PostTable;
import jp.cssj.sakae.opentype.table.Table;
import jp.cssj.sakae.opentype.table.TableDirectory;
import jp.cssj.sakae.opentype.table.TableFactory;
import jp.cssj.sakae.opentype.table.VheaTable;
import jp.cssj.sakae.opentype.table.VmtxTable;
import jp.cssj.sakae.opentype.truetype.TrueTypeGlyphList;

public class OpenTypeFont {
    private TableDirectory tableDirectory = null;
    private Table[] tables;
    private Os2Table os2;
    private CmapTable cmap;
    private HeadTable head;
    private HheaTable hhea;
    private HmtxTable hmtx;
    private VheaTable vhea;
    private VmtxTable vmtx;
    private MaxpTable maxp;
    private NameTable name;
    private PostTable post;
    private GlyphList glyphList;

    public OpenTypeFont(RandomAccessFile raf) throws IOException {
        GlyfTable glyf;
        this.tableDirectory = new TableDirectory(raf);
        this.tables = new Table[this.tableDirectory.getNumTables()];
        for (int i = 0; i < this.tableDirectory.getNumTables(); ++i) {
            this.tables[i] = TableFactory.create(this.tableDirectory.getEntry(i), raf);
        }
        this.os2 = (Os2Table)this.getTable(1330851634);
        this.cmap = (CmapTable)this.getTable(1668112752);
        this.head = (HeadTable)this.getTable(1751474532);
        this.hhea = (HheaTable)this.getTable(1751672161);
        this.hmtx = (HmtxTable)this.getTable(1752003704);
        this.vhea = (VheaTable)this.getTable(1986553185);
        this.vmtx = (VmtxTable)this.getTable(1986884728);
        this.maxp = (MaxpTable)this.getTable(1835104368);
        this.name = (NameTable)this.getTable(1851878757);
        this.post = (PostTable)this.getTable(1886352244);
        this.hmtx.init(this.hhea.getNumberOfHMetrics(), this.maxp.getNumGlyphs() - this.hhea.getNumberOfHMetrics());
        if (this.vmtx != null) {
            this.vmtx.init(this.vhea.getNumberOfHMetrics(), this.maxp.getNumGlyphs() - this.vhea.getNumberOfHMetrics());
        }
        if ((glyf = (GlyfTable)this.getTable(1735162214)) != null) {
            LocaTable loca = (LocaTable)this.getTable(1819239265);
            glyf.init(loca);
            loca.init(this.maxp.getNumGlyphs(), this.head.getIndexToLocFormat() == 0);
            this.glyphList = new TrueTypeGlyphList(glyf, this.head, this.hmtx, this.maxp);
        } else {
            CffTable cff = (CffTable)this.getTable(1128678944);
            if (cff != null) {
                cff.init(this.hmtx);
                this.glyphList = new CffGlyphList(cff, this.head, this.maxp);
            } else {
                throw new IOException("Unsupported font file format.");
            }
        }
    }

    public Table getTable(int tableType) {
        for (int i = 0; i < this.tables.length; ++i) {
            if (this.tables[i] == null || this.tables[i].getType() != tableType) continue;
            return this.tables[i];
        }
        return null;
    }

    public Os2Table getOS2Table() {
        return this.os2;
    }

    public CmapTable getCmapTable() {
        return this.cmap;
    }

    public HeadTable getHeadTable() {
        return this.head;
    }

    public HheaTable getHheaTable() {
        return this.hhea;
    }

    public HmtxTable getHmtxTable() {
        return this.hmtx;
    }

    public VheaTable getVheaTable() {
        return this.vhea;
    }

    public VmtxTable getVmtxTable() {
        return this.vmtx;
    }

    public MaxpTable getMaxpTable() {
        return this.maxp;
    }

    public NameTable getNameTable() {
        return this.name;
    }

    public PostTable getPostTable() {
        return this.post;
    }

    public int getAscent() {
        return this.hhea.getAscender();
    }

    public int getDescent() {
        return this.hhea.getDescender();
    }

    public int getNumGlyphs() {
        return this.maxp.getNumGlyphs();
    }

    public Glyph getGlyph(int i) {
        return this.glyphList.getGlyph(i);
    }

    public TableDirectory getTableDirectory() {
        return this.tableDirectory;
    }
}

