package jp.cssj.cti.servlet;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Map.Entry;

import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import jp.cssj.cti.CTIDriver;
import jp.cssj.cti.CTIDriverManager;
import jp.cssj.cti.CTISession;

/**
 * <p>
 * JSP/Servlet̏o͂PDFɕϊ邽߂̃T[ubgłB Servlet 2.3ȍ~łCSSJFilter֗̕łB
 * <p>
 * ȉ̃ReLXgEp[^g܂B
 * <dl>
 * <dt>cssj.host</dt>
 * <dd>CSSJT[o[̃zXg</dd>
 * 
 * <dt>cssj.port</dt>
 * <dd>CSSJT[o[̃|[gԍ</dd>
 * 
 * <dt>cssj.password</dt>
 * <dd>CSSJT[o[̃pX[h</dd>
 * <dl>
 * 
 * <p>
 * T[ubgEp[^͈ȉ̒ʂłB
 * <dl>
 * <dt>resources</dt>
 * <dd>\[X̃pX̃Xg(J}؂)</dd>
 * 
 * <dt>main</dt>
 * <dd>{̂̃pX</dd>
 * 
 * <dt>prop.*</dt>
 * <dd>CSSJɓnvpeBłB*vpeBɒuĂB</dd>
 * <dl>
 * 
 * <p>
 * pXjavax.servlet.ServletRequest#getRequestDispatcherɓn̂Ɠ`łB
 * </p>
 * <p>
 * ݒwebapp/WEB-INF/web.xmlQƂĂB
 * </p>
 * 
 * <p>
 * ȂÃT[ubg͓Iɕϊ郊\[X؂ւ@\͂܂B
 * _ȏKvȏꍇ́AAbstractCSSJServletpăvO~OĂB
 * </p>
 * 
 * @author <a href="mailto:miyabe at gnn.co.jp">MIYABE Tatsuhiko </a>
 * @version $Id: CSSJServlet.java,v 1.5 2005/08/18 04:51:26 harumanx Exp $
 */
public class CSSJServlet extends AbstractCSSJServlet {
	private static final long serialVersionUID = 0L;

	private String host, password;

	private int port;

	private String[] resources = null;

	private Map properties = null;

	public void init(ServletConfig config) throws ServletException {
		super.init(config);
		this.host = config.getServletContext().getInitParameter("cssj.host");
		this.port = Integer.parseInt(config.getServletContext()
				.getInitParameter("cssj.port"));
		this.password = config.getServletContext().getInitParameter(
				"cssj.password");
		String resources = config.getInitParameter("resources");
		if (resources != null) {
			ArrayList list = new ArrayList();
			for (StringTokenizer i = new StringTokenizer(resources, ","); i
					.hasMoreTokens();) {
				list.add(i.nextToken());
			}
			this.resources = (String[]) list.toArray(new String[list.size()]);
		}

		this.properties = new HashMap();
		for (Enumeration i = config.getInitParameterNames(); i
				.hasMoreElements();) {
			String name = (String) i.nextElement();
			if (name.startsWith("prop.")) {
				String value = config.getInitParameter(name);
				this.properties.put(name.substring(5), value);
			}
		}
		this.properties = Collections.unmodifiableMap(this.properties);
	}

	protected CTISession createSession(HttpServletRequest request,
			HttpServletResponse response) throws ServletException, IOException {
		// hCo擾
		CTIDriver driver = CTIDriverManager.createDriverFor(this.host,
				this.port);
		// ڑ([U["user"ŌŒ)
		return driver.createSession("user", this.password);
	}

	protected void process(CTISession session, HttpServletRequest request,
			HttpServletResponse response) throws ServletException, IOException {
		// vpeBݒ
		for (Iterator i = this.properties.entrySet().iterator(); i.hasNext();) {
			Entry entry = (Entry) i.next();
			session.setProperty((String) entry.getKey(), (String) entry
					.getValue());
		}

		// \[X𑗐M
		String resources = this.getInitParameter("resources");
		if (resources != null) {
			for (StringTokenizer i = new StringTokenizer(resources, ","); i
					.hasMoreTokens();) {
				String uri = i.nextToken();
				this.sendResource(session, request, response, uri, null);
			}
		}

		// {̂ϊ
		String main = this.getInitParameter("main");
		if (main == null) {
			throw new ServletException("{̂w肳Ă܂");
		}
		this.sendMain(session, request, response, main, null);
	}
}