package jp.cssj.cti.servlet;

import java.io.IOException;
import java.io.OutputStream;

import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import jp.cssj.cti.CTISession;
import jp.cssj.cti.helpers.ProgressAdapter;

/**
 * <p>
 * ANZXy[W̏o͌ʂϊ邽߂̃tB^łB
 * <p>
 * sendResource\bh́AEFuAvP[V̎w肵pXfof[^Lv`CSSJT[o[ɑ܂B
 * eLXg̓GR[fBOServlet/JSPŎw肳GR[fBOɊւ炸UTF-8g邽߁A
 * ̃\bh̓GR[fBOw肷Kv܂B
 * </p>
 * 
 * @author <a href="mailto:miyabe at gnn.co.jp">MIYABE Tatsuhiko </a>
 * @version $Id: AbstractCSSJFilter.java,v 1.4 2005/08/18 04:51:26 harumanx Exp $
 */
public abstract class AbstractCSSJFilter implements Filter {
	/**
	 * CSSJT[ubg̃NGXgł邱ƂNGXg̃L[łB
	 */
	public static final String FROM_CSSJ = "jp.cssj.cti.servlet.FROM_CSSJ";

	private static final String CONTENT_TYPE = "application/pdf";

	public void doFilter(ServletRequest request,
			final ServletResponse response, FilterChain chain)
			throws ServletException, IOException {
		// ڑ
		CTISession session = this.createSession((HttpServletRequest) request,
				(HttpServletResponse) response);
		try {
			// Content-Typewb_o͂
			response.setContentType(CONTENT_TYPE);

			// NCAgɌʂo͂
			session.setOutput(response.getOutputStream(), CONTENT_TYPE);

			// Content-Lengthwb_o͂(dv!)
			session.setProgressListener(new ProgressAdapter(true) {
				public void contentLength(long contentLength) {
					response.setContentLength((int) contentLength);
				}
			});

			this.prepare(session, (HttpServletRequest) request,
					(HttpServletResponse) response);

			String path = ((HttpServletRequest) request).getServletPath();

			OutputStream out = session.sendMain("resource:" + path, null,
					"UTF-8");
			CSSJHttpServletResponseWrapper responseWrapper = new CSSJHttpServletResponseWrapper(
					(HttpServletResponse) response, out, "UTF-8");
			try {
				request.setAttribute(FROM_CSSJ, Boolean.TRUE);
				chain.doFilter(request, responseWrapper);
				request.removeAttribute(FROM_CSSJ);
			} finally {
				responseWrapper.close();
			}
		} finally {
			// ZbV(Y₷̂Œ!)
			session.close();
		}
	}

	/**
	 * \[X𑗐M܂B
	 * <p>
	 * 
	 * @param session
	 *            ZbV
	 * @param request
	 *            T[ubgNGXg
	 * @param response
	 *            T[ubgX|X
	 * @param path
	 *            Servlet/JSP̃pX
	 * @param mimeType
	 *            MIME^(ȗꍇnull)
	 * 
	 * @throws ServletException
	 * @throws IOException
	 */
	protected void sendResource(CTISession session, HttpServletRequest request,
			HttpServletResponse response, String path, String mimeType)
			throws ServletException, IOException {
		OutputStream out = session.sendResource("resource:" + path, mimeType,
				"UTF-8");
		CSSJHttpServletResponseWrapper responseWrapper = new CSSJHttpServletResponseWrapper(
				response, out, "UTF-8");
		try {
			RequestDispatcher dispatcher = request.getRequestDispatcher(path);
			request.setAttribute(FROM_CSSJ, Boolean.TRUE);
			dispatcher.include(request, responseWrapper);
			request.removeAttribute(FROM_CSSJ);
		} finally {
			responseWrapper.close();
		}
	}

	/**
	 * ZbV쐬邽߂ɁÃ\bhĂB
	 * 
	 * @param request
	 * @param response
	 * @return
	 * @throws ServletException
	 * @throws IOException
	 */
	protected abstract CTISession createSession(HttpServletRequest request,
			HttpServletResponse response) throws ServletException, IOException;

	/**
	 * vpeB̐ݒA\[X̑M̂߂ɁÃ\bhĂB
	 * 
	 * @param request
	 * @param response
	 * @return
	 * @throws ServletException
	 * @throws IOException
	 */
	protected abstract void prepare(CTISession session,
			HttpServletRequest request, HttpServletResponse response)
			throws ServletException, IOException;
}