package jp.cssj.cti;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;

/**
 * NCAg̃t@CAURLAXg[𑗂邽߂̃[eBeBłB
 * 
 * @author <a href="mailto:miyabe at gnn.co.jp">MIYABE Tatsuhiko </a>
 * @version $Id: CTIUtils.java,v 1.2 2005/08/18 04:51:26 harumanx Exp $
 */
public final class CTIUtils {
	private CTIUtils() {
		// unused
	}

	/** f[^̈ړɎgobt@̃TCYłB */
	private static final int BUFFER_SIZE = 1024;

	/**
	 * \[XƂăt@C𑗐M܂B
	 * 
	 * @param session
	 *            ZbV
	 * @param file
	 *            t@C
	 * @param mimeType
	 *            MIME^(ȗꍇnull)
	 * @param encoding
	 *            GR[fBO(ȗꍇnull)
	 * @throws IOException
	 */
	public static void sendResourceFile(CTISession session, File file,
			String mimeType, String encoding) throws IOException {
		InputStream in = new FileInputStream(file);
		try {
			sendResourceStream(session, in, file.toURI().toASCIIString(),
					mimeType, encoding);
		} finally {
			in.close();
		}
	}

	/**
	 * \[XƂURL𑗐M܂B
	 * 
	 * @param session
	 *            ZbV
	 * @param url
	 *            URL
	 * @param mimeType
	 *            MIME^(ȗꍇnull)
	 * @param encoding
	 *            GR[fBO(ȗꍇnull)
	 * @throws IOException
	 */
	public static void sendResourceURL(CTISession session, URL url,
			String mimeType, String encoding) throws IOException {
		InputStream in = url.openStream();
		try {
			sendResourceStream(session, in, url.toString(), mimeType, encoding);
		} finally {
			in.close();
		}
	}

	/**
	 * \[XƂăXg[of[^𑗐M܂B
	 * 
	 * @param session
	 *            ZbV
	 * @param in
	 *            ̓Xg[
	 * @param mimeType
	 *            MIME^(ȗꍇnull)
	 * @param encoding
	 *            GR[fBO(ȗꍇnull)
	 * @throws IOException
	 */
	public static void sendResourceStream(CTISession session, InputStream in,
			String uri, String mimeType, String encoding) throws IOException {
		OutputStream out = session.sendResource(uri, mimeType, encoding);
		try {
			byte[] buff = new byte[BUFFER_SIZE];
			for (int len = in.read(buff); len != -1; len = in.read(buff)) {
				out.write(buff, 0, len);
			}
		} finally {
			out.close();
		}
	}

	/**
	 * \[XƂāAfBNg̃t@CSđM܂B ̃\bh͎qfBNgċAIɏ܂B
	 * 
	 * @param session
	 *            ZbV
	 * @param dir
	 *            fBNg
	 * @param mimeType
	 *            MIME^(ȗꍇnull)
	 * @param encoding
	 *            GR[fBO(ȗꍇnull)
	 * @throws IOException
	 */
	public static void sendResourceDir(CTISession session, File dir,
			String mimeType, String encoding) throws IOException {
		if (dir.isDirectory()) {
			File[] files = dir.listFiles();
			if (files != null) {
				for (int i = 0; i < files.length; ++i) {
					sendResourceDir(session, files[i], mimeType, encoding);
				}
			}
		} else {
			sendResourceFile(session, dir, mimeType, encoding);
		}
	}

	/**
	 * {̂Ƃăt@C𑗐M܂B
	 * 
	 * @param session
	 *            ZbV
	 * @param file
	 *            t@C
	 * @param mimeType
	 *            MIME^(ȗꍇnull)
	 * @param encoding
	 *            GR[fBO(ȗꍇnull)
	 * @throws IOException
	 */
	public static void sendMainFile(CTISession session, File file,
			String mimeType, String encoding) throws IOException {
		InputStream in = new FileInputStream(file);
		try {
			sendMainStream(session, in, file.toURI().toASCIIString(), mimeType,
					encoding);
		} finally {
			in.close();
		}
	}

	/**
	 * {̂ƂURL𑗐M܂B
	 * 
	 * @param session
	 *            ZbV
	 * @param url
	 *            URL
	 * @param mimeType
	 *            MIME^(ȗꍇnull)
	 * @param encoding
	 *            GR[fBO(ȗꍇnull)
	 * @throws IOException
	 */
	public static void sendMainURL(CTISession session, URL url,
			String mimeType, String encoding) throws IOException {
		InputStream in = url.openStream();
		try {
			sendMainStream(session, in, url.toString(), mimeType, encoding);
		} finally {
			in.close();
		}
	}

	/**
	 * {̂ƂăXg[of[^𑗐M܂B
	 * 
	 * @param session
	 *            ZbV
	 * @param in
	 *            ̓Xg[
	 * @param mimeType
	 *            MIME^(ȗꍇnull)
	 * @param encoding
	 *            GR[fBO(ȗꍇnull)
	 * @throws IOException
	 */
	public static void sendMainStream(CTISession session, InputStream in,
			String uri, String mimeType, String encoding) throws IOException {
		OutputStream out = session.sendMain(uri, mimeType, encoding);
		try {
			byte[] buff = new byte[BUFFER_SIZE];
			for (int len = in.read(buff); len != -1; len = in.read(buff)) {
				out.write(buff, 0, len);
			}
		} finally {
			out.close();
		}
	}
}