package jp.cssj.cti.transcoder;

import java.util.Properties;

import jp.cssj.cti.helpers.AbortException;
import jp.cssj.cti.helpers.ContentBuilder;
import jp.cssj.cti.helpers.ErrorHandler;
import jp.cssj.cti.resolver.Source;
import jp.cssj.cti.resolver.SourceResolver;

/**
 * gXR[_́Ajp.cssj.cti.resolver.Sourceɂ͂Ajava.cssj.cti.helpers.ContentBuilderւƏo͂APIłB
 * <p>
 * jp.cssj.cti.CTISessionƂ̈Ⴂ́A[U[jp.cssj.cti.resolver.SourceResolverɃ\[Xv邽߁A
 * 炩ߕKvȃ\[X[U[Kv܂B
 * </p>
 * <p>
 * ContentBuilder,Source,SourceResolver̓T^ȎFileContentBuilder,URISource,URISourceResolverƂėpӂĂ܂B
 * قƂǂ̏ꍇA̎pΏ\łB ȉhttp://www.cssj.jp/gXR[_ŕϊłB
 * </p>
 * 
 * <pre>
 * Transcoder trans = TranscoderFactory.newTranscoderFactory().newTranscoder();
 * FileContentBuilder builder = new FileContentBuilder(out);
 * trans.transcode(builder, new URISource(&quot;http://www.cssj.jp/&quot;),
 * 		new URISourceResolver(), null, null);
 * builder.finish();
 * </pre>
 * 
 * <p>
 * <em>݁AgXR[_JavaŃCuNꍇ̂݃T|[gĂ܂B</em>
 * </p>
 * 
 * @see TranscoderFactory
 * 
 * @author <a href="mailto:miyabe at gnn.co.jp">MIYABE Tatsuhiko </a>
 * @version $Id: Transcoder.java,v 1.5 2005/08/18 04:51:26 harumanx Exp $
 */
public interface Transcoder {
	/**
	 * f[^̕ϊs܂B
	 * 
	 * @param builder
	 *            o͐B
	 * @param source
	 *            ̓f[^B
	 * @param resolver
	 *            \[X̗vB
	 * @param props
	 *            ϊvpeBBȗꍇnullB
	 * @param errorHandler
	 *            G[nhBȗꍇnullB
	 * @throws TranscoderException
	 */
	public void transcode(ContentBuilder builder, Source source,
			SourceResolver resolver, Properties props, ErrorHandler errorHandler)
			throws TranscoderException, AbortException;
}
