package jp.cssj.cti.helpers;

import java.util.HashMap;
import java.util.Map;

/**
 * @author <a href="mailto:miyabe at gnn.co.jp">MIYABE Tatsuhiko </a>
 * @version $Id: ClientErrorHandler.java,v 1.1 2005/09/06 22:13:47 harumanx Exp $
 */
public class ClientErrorHandler extends ErrorHandler {
	protected Map info = new HashMap();

	public void error(String message) {
		// nothing to do
	}

	public void fatal(String message) {
		// nothing to do
	}

	public void info(String category, String message) {
		this.info.put(category, message);
	}

	public void warn(String message) {
		// nothing to do
	}

	public void message(byte level, String message) {
		switch (level) {
		case WARN:
			this.warn(message);
			break;

		case ERROR:
			this.error(message);
			break;

		case FATAL:
			this.fatal(message);
			break;

		case INFO:
			int colon = message.indexOf(':');
			String category;
			if (colon != -1) {
				category = message.substring(0, colon);
				message = message.substring(colon + 1);
			} else {
				category = null;
			}
			this.info(category, message);
			break;
		}
	}
	
	public String getInfo(String category) {
		return (String)this.info.get(category);
	}
}