/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.icu.util;

import com.ibm.icu.impl.ICUResourceBundle;
import com.ibm.icu.impl.LocaleUtility;
import com.ibm.icu.impl.SimpleCache;
import com.ibm.icu.util.ULocale;
import com.ibm.icu.util.UResourceBundle;
import java.io.Serializable;
import java.lang.ref.SoftReference;
import java.text.ParseException;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.TreeMap;

public final class ULocale
implements Serializable {
    private static final long serialVersionUID = 3715177670352309217L;
    public static final ULocale ENGLISH = new ULocale("en", Locale.ENGLISH);
    public static final ULocale FRENCH = new ULocale("fr", Locale.FRENCH);
    public static final ULocale GERMAN = new ULocale("de", Locale.GERMAN);
    public static final ULocale ITALIAN = new ULocale("it", Locale.ITALIAN);
    public static final ULocale JAPANESE = new ULocale("ja", Locale.JAPANESE);
    public static final ULocale KOREAN = new ULocale("ko", Locale.KOREAN);
    public static final ULocale CHINESE = new ULocale("zh", Locale.CHINESE);
    public static final ULocale SIMPLIFIED_CHINESE = new ULocale("zh_Hans", Locale.CHINESE);
    public static final ULocale TRADITIONAL_CHINESE = new ULocale("zh_Hant", Locale.CHINESE);
    public static final ULocale FRANCE = new ULocale("fr_FR", Locale.FRANCE);
    public static final ULocale GERMANY = new ULocale("de_DE", Locale.GERMANY);
    public static final ULocale ITALY = new ULocale("it_IT", Locale.ITALY);
    public static final ULocale JAPAN = new ULocale("ja_JP", Locale.JAPAN);
    public static final ULocale KOREA = new ULocale("ko_KR", Locale.KOREA);
    public static final ULocale CHINA;
    public static final ULocale PRC;
    public static final ULocale TAIWAN;
    public static final ULocale UK;
    public static final ULocale US;
    public static final ULocale CANADA;
    public static final ULocale CANADA_FRENCH;
    private static final String EMPTY_STRING = "";
    private static final char UNDERSCORE = '_';
    private static final Locale EMPTY_LOCALE;
    public static final ULocale ROOT;
    private static final SimpleCache CACHE;
    private transient Locale locale;
    private String localeID;
    private static String[] _languages;
    private static String[] _replacementLanguages;
    private static String[] _obsoleteLanguages;
    private static String[] _languages3;
    private static String[] _obsoleteLanguages3;
    private static String[] _countries;
    private static String[] _deprecatedCountries;
    private static String[] _replacementCountries;
    private static String[] _obsoleteCountries;
    private static String[] _countries3;
    private static String[] _obsoleteCountries3;
    private static String[][] _variantsToKeywords;
    private static final String[][] _javaLocaleMap;
    private static SoftReference nameCacheRef;
    private static Locale defaultLocale;
    private static ULocale defaultULocale;
    public static Type ACTUAL_LOCALE;
    public static Type VALID_LOCALE;
    private static HashMap _likelySubtagMaximizeMap;
    private static final String UNDEFINED_LANGUAGE = "und";
    private static final String UNDEFINED_SCRIPT = "Zzzz";
    private static final String UNDEFINED_REGION = "ZZ";
    static /* synthetic */ Class class$0;

    static {
        PRC = CHINA = new ULocale("zh_Hans_CN", Locale.CHINA);
        TAIWAN = new ULocale("zh_Hant_TW", Locale.TAIWAN);
        UK = new ULocale("en_GB", Locale.UK);
        US = new ULocale("en_US", Locale.US);
        CANADA = new ULocale("en_CA", Locale.CANADA);
        CANADA_FRENCH = new ULocale("fr_CA", Locale.CANADA_FRENCH);
        EMPTY_LOCALE = new Locale(EMPTY_STRING, EMPTY_STRING);
        ROOT = new ULocale("root", EMPTY_LOCALE);
        CACHE = new SimpleCache();
        String[][] stringArrayArray = new String[2][];
        stringArrayArray[0] = new String[]{"ja_JP_JP", "ja_JP", "calendar", "japanese", "ja"};
        String[] stringArray = new String[5];
        stringArray[0] = "no_NO_NY";
        stringArray[1] = "nn_NO";
        stringArray[4] = "nn";
        stringArrayArray[1] = stringArray;
        _javaLocaleMap = stringArrayArray;
        nameCacheRef = new SoftReference(Collections.synchronizedMap(new HashMap()));
        defaultLocale = Locale.getDefault();
        defaultULocale = new ULocale(defaultLocale);
        ACTUAL_LOCALE = new Type(0);
        VALID_LOCALE = new Type(1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void initLanguageTables() {
        if (_languages != null) return;
        String[] tempLanguages = new String[]{"aa", "ab", "ace", "ach", "ada", "ady", "ae", "af", "afa", "afh", "ak", "akk", "ale", "alg", "am", "an", "ang", "apa", "ar", "arc", "arn", "arp", "art", "arw", "as", "ast", "ath", "aus", "av", "awa", "ay", "az", "ba", "bad", "bai", "bal", "ban", "bas", "bat", "be", "bej", "bem", "ber", "bg", "bh", "bho", "bi", "bik", "bin", "bla", "bm", "bn", "bnt", "bo", "br", "bra", "bs", "btk", "bua", "bug", "byn", "ca", "cad", "cai", "car", "cau", "ce", "ceb", "cel", "ch", "chb", "chg", "chk", "chm", "chn", "cho", "chp", "chr", "chy", "cmc", "co", "cop", "cpe", "cpf", "cpp", "cr", "crh", "crp", "cs", "csb", "cu", "cus", "cv", "cy", "da", "dak", "dar", "day", "de", "del", "den", "dgr", "din", "doi", "dra", "dsb", "dua", "dum", "dv", "dyu", "dz", "ee", "efi", "egy", "eka", "el", "elx", "en", "enm", "eo", "es", "et", "eu", "ewo", "fa", "fan", "fat", "ff", "fi", "fiu", "fj", "fo", "fon", "fr", "frm", "fro", "fur", "fy", "ga", "gaa", "gay", "gba", "gd", "gem", "gez", "gil", "gl", "gmh", "gn", "goh", "gon", "gor", "got", "grb", "grc", "gu", "gv", "gwi", "ha", "hai", "haw", "he", "hi", "hil", "him", "hit", "hmn", "ho", "hr", "hsb", "ht", "hu", "hup", "hy", "hz", "ia", "iba", "id", "ie", "ig", "ii", "ijo", "ik", "ilo", "inc", "ine", "inh", "io", "ira", "iro", "is", "it", "iu", "ja", "jbo", "jpr", "jrb", "jv", "ka", "kaa", "kab", "kac", "kam", "kar", "kaw", "kbd", "kg", "kha", "khi", "kho", "ki", "kj", "kk", "kl", "km", "kmb", "kn", "ko", "kok", "kos", "kpe", "kr", "krc", "kro", "kru", "ks", "ku", "kum", "kut", "kv", "kw", "ky", "la", "lad", "lah", "lam", "lb", "lez", "lg", "li", "ln", "lo", "lol", "loz", "lt", "lu", "lua", "lui", "lun", "luo", "lus", "lv", "mad", "mag", "mai", "mak", "man", "map", "mas", "mdf", "mdr", "men", "mg", "mga", "mh", "mi", "mic", "min", "mis", "mk", "mkh", "ml", "mn", "mnc", "mni", "mno", "mo", "moh", "mos", "mr", "ms", "mt", "mul", "mun", "mus", "mwr", "my", "myn", "myv", "na", "nah", "nai", "nap", "nb", "nd", "nds", "ne", "new", "ng", "nia", "nic", "niu", "nl", "nn", "no", "nog", "non", "nr", "nso", "nub", "nv", "nwc", "ny", "nym", "nyn", "nyo", "nzi", "oc", "oj", "om", "or", "os", "osa", "ota", "oto", "pa", "paa", "pag", "pal", "pam", "pap", "pau", "peo", "phi", "phn", "pi", "pl", "pon", "pra", "pro", "ps", "pt", "qu", "raj", "rap", "rar", "rm", "rn", "ro", "roa", "rom", "ru", "rup", "rw", "sa", "sad", "sah", "sai", "sal", "sam", "sas", "sat", "sc", "sco", "sd", "se", "sel", "sem", "sg", "sga", "sgn", "shn", "si", "sid", "sio", "sit", "sk", "sl", "sla", "sm", "sma", "smi", "smj", "smn", "sms", "sn", "snk", "so", "sog", "son", "sq", "sr", "srr", "ss", "ssa", "st", "su", "suk", "sus", "sux", "sv", "sw", "syr", "ta", "tai", "te", "tem", "ter", "tet", "tg", "th", "ti", "tig", "tiv", "tk", "tkl", "tl", "tlh", "tli", "tmh", "tn", "to", "tog", "tpi", "tr", "ts", "tsi", "tt", "tum", "tup", "tut", "tvl", "tw", "ty", "tyv", "udm", "ug", "uga", "uk", "umb", UNDEFINED_LANGUAGE, "ur", "uz", "vai", "ve", "vi", "vo", "vot", "wa", "wak", "wal", "war", "was", "wen", "wo", "xal", "xh", "yao", "yap", "yi", "yo", "ypk", "za", "zap", "zen", "zh", "znd", "zu", "zun"};
        String[] tempReplacementLanguages = new String[]{"id", "he", "yi", "jv", "sr", "nb"};
        String[] tempObsoleteLanguages = new String[]{"in", "iw", "ji", "jw", "sh", "no"};
        String[] tempLanguages3 = new String[]{"aar", "abk", "ace", "ach", "ada", "ady", "ave", "afr", "afa", "afh", "aka", "akk", "ale", "alg", "amh", "arg", "ang", "apa", "ara", "arc", "arn", "arp", "art", "arw", "asm", "ast", "ath", "aus", "ava", "awa", "aym", "aze", "bak", "bad", "bai", "bal", "ban", "bas", "bat", "bel", "bej", "bem", "ber", "bul", "bih", "bho", "bis", "bik", "bin", "bla", "bam", "ben", "bnt", "bod", "bre", "bra", "bos", "btk", "bua", "bug", "byn", "cat", "cad", "cai", "car", "cau", "che", "ceb", "cel", "cha", "chb", "chg", "chk", "chm", "chn", "cho", "chp", "chr", "chy", "cmc", "cos", "cop", "cpe", "cpf", "cpp", "cre", "crh", "crp", "ces", "csb", "chu", "cus", "chv", "cym", "dan", "dak", "dar", "day", "deu", "del", "den", "dgr", "din", "doi", "dra", "dsb", "dua", "dum", "div", "dyu", "dzo", "ewe", "efi", "egy", "eka", "ell", "elx", "eng", "enm", "epo", "spa", "est", "eus", "ewo", "fas", "fan", "fat", "ful", "fin", "fiu", "fij", "fao", "fon", "fra", "frm", "fro", "fur", "fry", "gle", "gaa", "gay", "gba", "gla", "gem", "gez", "gil", "glg", "gmh", "grn", "goh", "gon", "gor", "got", "grb", "grc", "guj", "glv", "gwi", "hau", "hai", "haw", "heb", "hin", "hil", "him", "hit", "hmn", "hmo", "hrv", "hsb", "hat", "hun", "hup", "hye", "her", "ina", "iba", "ind", "ile", "ibo", "iii", "ijo", "ipk", "ilo", "inc", "ine", "inh", "ido", "ira", "iro", "isl", "ita", "iku", "jpn", "jbo", "jpr", "jrb", "jaw", "kat", "kaa", "kab", "kac", "kam", "kar", "kaw", "kbd", "kon", "kha", "khi", "kho", "kik", "kua", "kaz", "kal", "khm", "kmb", "kan", "kor", "kok", "kos", "kpe", "kau", "krc", "kro", "kru", "kas", "kur", "kum", "kut", "kom", "cor", "kir", "lat", "lad", "lah", "lam", "ltz", "lez", "lug", "lim", "lin", "lao", "lol", "loz", "lit", "lub", "lua", "lui", "lun", "luo", "lus", "lav", "mad", "mag", "mai", "mak", "man", "map", "mas", "mdf", "mdr", "men", "mlg", "mga", "mah", "mri", "mic", "min", "mis", "mkd", "mkh", "mal", "mon", "mnc", "mni", "mno", "mol", "moh", "mos", "mar", "msa", "mlt", "mul", "mun", "mus", "mwr", "mya", "myn", "myv", "nau", "nah", "nai", "nap", "nob", "nde", "nds", "nep", "new", "ndo", "nia", "nic", "niu", "nld", "nno", "nor", "nog", "non", "nbl", "nso", "nub", "nav", "nwc", "nya", "nym", "nyn", "nyo", "nzi", "oci", "oji", "orm", "ori", "oss", "osa", "ota", "oto", "pan", "paa", "pag", "pal", "pam", "pap", "pau", "peo", "phi", "phn", "pli", "pol", "pon", "pra", "pro", "pus", "por", "que", "raj", "rap", "rar", "roh", "run", "ron", "roa", "rom", "rus", "rup", "kin", "san", "sad", "sah", "sai", "sal", "sam", "sas", "sat", "srd", "sco", "snd", "sme", "sel", "sem", "sag", "sga", "sgn", "shn", "sin", "sid", "sio", "sit", "slk", "slv", "sla", "smo", "sma", "smi", "smj", "smn", "sms", "sna", "snk", "som", "sog", "son", "sqi", "srp", "srr", "ssw", "ssa", "sot", "sun", "suk", "sus", "sux", "swe", "swa", "syr", "tam", "tai", "tel", "tem", "ter", "tet", "tgk", "tha", "tir", "tig", "tiv", "tuk", "tkl", "tgl", "tlh", "tli", "tmh", "tsn", "ton", "tog", "tpi", "tur", "tso", "tsi", "tat", "tum", "tup", "tut", "tvl", "twi", "tah", "tyv", "udm", "uig", "uga", "ukr", "umb", UNDEFINED_LANGUAGE, "urd", "uzb", "vai", "ven", "vie", "vol", "vot", "wln", "wak", "wal", "war", "was", "wen", "wol", "xal", "xho", "yao", "yap", "yid", "yor", "ypk", "zha", "zap", "zen", "zho", "znd", "zul", "zun"};
        String[] tempObsoleteLanguages3 = new String[]{"ind", "heb", "yid", "jaw", "srp"};
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.ibm.icu.util.ULocale");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Class<?> clazz2 = clazz;
        synchronized (clazz) {
            if (_languages != null) return;
            _languages = tempLanguages;
            _replacementLanguages = tempReplacementLanguages;
            _obsoleteLanguages = tempObsoleteLanguages;
            _languages3 = tempLanguages3;
            _obsoleteLanguages3 = tempObsoleteLanguages3;
            // ** MonitorExit[var5_5] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void initCountryTables() {
        if (_countries != null) return;
        String[] tempCountries = new String[]{"AD", "AE", "AF", "AG", "AI", "AL", "AM", "AN", "AO", "AQ", "AR", "AS", "AT", "AU", "AW", "AX", "AZ", "BA", "BB", "BD", "BE", "BF", "BG", "BH", "BI", "BJ", "BL", "BM", "BN", "BO", "BR", "BS", "BT", "BV", "BW", "BY", "BZ", "CA", "CC", "CD", "CF", "CG", "CH", "CI", "CK", "CL", "CM", "CN", "CO", "CR", "CU", "CV", "CX", "CY", "CZ", "DE", "DJ", "DK", "DM", "DO", "DZ", "EC", "EE", "EG", "EH", "ER", "ES", "ET", "FI", "FJ", "FK", "FM", "FO", "FR", "GA", "GB", "GD", "GE", "GF", "GG", "GH", "GI", "GL", "GM", "GN", "GP", "GQ", "GR", "GS", "GT", "GU", "GW", "GY", "HK", "HM", "HN", "HR", "HT", "HU", "ID", "IE", "IL", "IM", "IN", "IO", "IQ", "IR", "IS", "IT", "JE", "JM", "JO", "JP", "KE", "KG", "KH", "KI", "KM", "KN", "KP", "KR", "KW", "KY", "KZ", "LA", "LB", "LC", "LI", "LK", "LR", "LS", "LT", "LU", "LV", "LY", "MA", "MC", "MD", "ME", "MF", "MG", "MH", "MK", "ML", "MM", "MN", "MO", "MP", "MQ", "MR", "MS", "MT", "MU", "MV", "MW", "MX", "MY", "MZ", "NA", "NC", "NE", "NF", "NG", "NI", "NL", "NO", "NP", "NR", "NU", "NZ", "OM", "PA", "PE", "PF", "PG", "PH", "PK", "PL", "PM", "PN", "PR", "PS", "PT", "PW", "PY", "QA", "RE", "RO", "RS", "RU", "RW", "SA", "SB", "SC", "SD", "SE", "SG", "SH", "SI", "SJ", "SK", "SL", "SM", "SN", "SO", "SR", "ST", "SV", "SY", "SZ", "TC", "TD", "TF", "TG", "TH", "TJ", "TK", "TL", "TM", "TN", "TO", "TR", "TT", "TV", "TW", "TZ", "UA", "UG", "UM", "US", "UY", "UZ", "VA", "VC", "VE", "VG", "VI", "VN", "VU", "WF", "WS", "YE", "YT", "ZA", "ZM", "ZW"};
        String[] tempObsoleteCountries = new String[]{"FX", "CS", "RO", "TP", "YU", "ZR"};
        String[] tempDeprecatedCountries = new String[]{"BU", "CS", "DY", "FX", "HV", "NH", "RH", "TP", "YU", "ZR"};
        String[] tempReplacementCountries = new String[]{"MM", "RS", "BJ", "FR", "BF", "VU", "ZW", "TL", "RS", "CD"};
        String[] tempCountries3 = new String[]{"AND", "ARE", "AFG", "ATG", "AIA", "ALB", "ARM", "ANT", "AGO", "ATA", "ARG", "ASM", "AUT", "AUS", "ABW", "ALA", "AZE", "BIH", "BRB", "BGD", "BEL", "BFA", "BGR", "BHR", "BDI", "BEN", "BLM", "BMU", "BRN", "BOL", "BRA", "BHS", "BTN", "BVT", "BWA", "BLR", "BLZ", "CAN", "CCK", "COD", "CAF", "COG", "CHE", "CIV", "COK", "CHL", "CMR", "CHN", "COL", "CRI", "CUB", "CPV", "CXR", "CYP", "CZE", "DEU", "DJI", "DNK", "DMA", "DOM", "DZA", "ECU", "EST", "EGY", "ESH", "ERI", "ESP", "ETH", "FIN", "FJI", "FLK", "FSM", "FRO", "FRA", "GAB", "GBR", "GRD", "GEO", "GUF", "GGY", "GHA", "GIB", "GRL", "GMB", "GIN", "GLP", "GNQ", "GRC", "SGS", "GTM", "GUM", "GNB", "GUY", "HKG", "HMD", "HND", "HRV", "HTI", "HUN", "IDN", "IRL", "ISR", "IMN", "IND", "IOT", "IRQ", "IRN", "ISL", "ITA", "JEY", "JAM", "JOR", "JPN", "KEN", "KGZ", "KHM", "KIR", "COM", "KNA", "PRK", "KOR", "KWT", "CYM", "KAZ", "LAO", "LBN", "LCA", "LIE", "LKA", "LBR", "LSO", "LTU", "LUX", "LVA", "LBY", "MAR", "MCO", "MDA", "MNE", "MAF", "MDG", "MHL", "MKD", "MLI", "MMR", "MNG", "MAC", "MNP", "MTQ", "MRT", "MSR", "MLT", "MUS", "MDV", "MWI", "MEX", "MYS", "MOZ", "NAM", "NCL", "NER", "NFK", "NGA", "NIC", "NLD", "NOR", "NPL", "NRU", "NIU", "NZL", "OMN", "PAN", "PER", "PYF", "PNG", "PHL", "PAK", "POL", "SPM", "PCN", "PRI", "PSE", "PRT", "PLW", "PRY", "QAT", "REU", "ROU", "SRB", "RUS", "RWA", "SAU", "SLB", "SYC", "SDN", "SWE", "SGP", "SHN", "SVN", "SJM", "SVK", "SLE", "SMR", "SEN", "SOM", "SUR", "STP", "SLV", "SYR", "SWZ", "TCA", "TCD", "ATF", "TGO", "THA", "TJK", "TKL", "TLS", "TKM", "TUN", "TON", "TUR", "TTO", "TUV", "TWN", "TZA", "UKR", "UGA", "UMI", "USA", "URY", "UZB", "VAT", "VCT", "VEN", "VGB", "VIR", "VNM", "VUT", "WLF", "WSM", "YEM", "MYT", "ZAF", "ZMB", "ZWE"};
        String[] tempObsoleteCountries3 = new String[]{"FXX", "SCG", "ROM", "TMP", "YUG", "ZAR"};
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.ibm.icu.util.ULocale");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Class<?> clazz2 = clazz;
        synchronized (clazz) {
            if (_countries != null) return;
            _countries = tempCountries;
            _deprecatedCountries = tempDeprecatedCountries;
            _replacementCountries = tempReplacementCountries;
            _obsoleteCountries = tempObsoleteCountries;
            _countries3 = tempCountries3;
            _obsoleteCountries3 = tempObsoleteCountries3;
            // ** MonitorExit[var6_6] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void initVariantsTable() {
        if (_variantsToKeywords != null) return;
        String[][] stringArrayArray = new String[53][];
        String[] stringArray = new String[4];
        stringArray[0] = "C";
        stringArray[1] = "en_US_POSIX";
        stringArrayArray[0] = stringArray;
        String[] stringArray2 = new String[4];
        stringArray2[0] = "art_LOJBAN";
        stringArray2[1] = "jbo";
        stringArrayArray[1] = stringArray2;
        String[] stringArray3 = new String[4];
        stringArray3[0] = "az_AZ_CYRL";
        stringArray3[1] = "az_Cyrl_AZ";
        stringArrayArray[2] = stringArray3;
        String[] stringArray4 = new String[4];
        stringArray4[0] = "az_AZ_LATN";
        stringArray4[1] = "az_Latn_AZ";
        stringArrayArray[3] = stringArray4;
        stringArrayArray[4] = new String[]{"ca_ES_PREEURO", "ca_ES", "currency", "ESP"};
        String[] stringArray5 = new String[4];
        stringArray5[0] = "cel_GAULISH";
        stringArray5[1] = "cel__GAULISH";
        stringArrayArray[5] = stringArray5;
        String[] stringArray6 = new String[4];
        stringArray6[0] = "de_1901";
        stringArray6[1] = "de__1901";
        stringArrayArray[6] = stringArray6;
        String[] stringArray7 = new String[4];
        stringArray7[0] = "de_1906";
        stringArray7[1] = "de__1906";
        stringArrayArray[7] = stringArray7;
        stringArrayArray[8] = new String[]{"de__PHONEBOOK", "de", "collation", "phonebook"};
        stringArrayArray[9] = new String[]{"de_AT_PREEURO", "de_AT", "currency", "ATS"};
        stringArrayArray[10] = new String[]{"de_DE_PREEURO", "de_DE", "currency", "DEM"};
        stringArrayArray[11] = new String[]{"de_LU_PREEURO", "de_LU", "currency", "EUR"};
        stringArrayArray[12] = new String[]{"el_GR_PREEURO", "el_GR", "currency", "GRD"};
        String[] stringArray8 = new String[4];
        stringArray8[0] = "en_BOONT";
        stringArray8[1] = "en__BOONT";
        stringArrayArray[13] = stringArray8;
        String[] stringArray9 = new String[4];
        stringArray9[0] = "en_SCOUSE";
        stringArray9[1] = "en__SCOUSE";
        stringArrayArray[14] = stringArray9;
        stringArrayArray[15] = new String[]{"en_BE_PREEURO", "en_BE", "currency", "BEF"};
        stringArrayArray[16] = new String[]{"en_IE_PREEURO", "en_IE", "currency", "IEP"};
        stringArrayArray[17] = new String[]{"es__TRADITIONAL", "es", "collation", "traditional"};
        stringArrayArray[18] = new String[]{"es_ES_PREEURO", "es_ES", "currency", "ESP"};
        stringArrayArray[19] = new String[]{"eu_ES_PREEURO", "eu_ES", "currency", "ESP"};
        stringArrayArray[20] = new String[]{"fi_FI_PREEURO", "fi_FI", "currency", "FIM"};
        stringArrayArray[21] = new String[]{"fr_BE_PREEURO", "fr_BE", "currency", "BEF"};
        stringArrayArray[22] = new String[]{"fr_FR_PREEURO", "fr_FR", "currency", "FRF"};
        stringArrayArray[23] = new String[]{"fr_LU_PREEURO", "fr_LU", "currency", "LUF"};
        stringArrayArray[24] = new String[]{"ga_IE_PREEURO", "ga_IE", "currency", "IEP"};
        stringArrayArray[25] = new String[]{"gl_ES_PREEURO", "gl_ES", "currency", "ESP"};
        stringArrayArray[26] = new String[]{"hi__DIRECT", "hi", "collation", "direct"};
        stringArrayArray[27] = new String[]{"it_IT_PREEURO", "it_IT", "currency", "ITL"};
        stringArrayArray[28] = new String[]{"ja_JP_TRADITIONAL", "ja_JP", "calendar", "japanese"};
        stringArrayArray[29] = new String[]{"nl_BE_PREEURO", "nl_BE", "currency", "BEF"};
        stringArrayArray[30] = new String[]{"nl_NL_PREEURO", "nl_NL", "currency", "NLG"};
        stringArrayArray[31] = new String[]{"pt_PT_PREEURO", "pt_PT", "currency", "PTE"};
        String[] stringArray10 = new String[4];
        stringArray10[0] = "sl_ROZAJ";
        stringArray10[1] = "sl__ROZAJ";
        stringArrayArray[32] = stringArray10;
        String[] stringArray11 = new String[4];
        stringArray11[0] = "sr_SP_CYRL";
        stringArray11[1] = "sr_Cyrl_CS";
        stringArrayArray[33] = stringArray11;
        String[] stringArray12 = new String[4];
        stringArray12[0] = "sr_SP_LATN";
        stringArray12[1] = "sr_Latn_CS";
        stringArrayArray[34] = stringArray12;
        String[] stringArray13 = new String[4];
        stringArray13[0] = "sr_YU_CYRILLIC";
        stringArray13[1] = "sr_Cyrl_CS";
        stringArrayArray[35] = stringArray13;
        String[] stringArray14 = new String[4];
        stringArray14[0] = "uz_UZ_CYRILLIC";
        stringArray14[1] = "uz_Cyrl_UZ";
        stringArrayArray[36] = stringArray14;
        String[] stringArray15 = new String[4];
        stringArray15[0] = "uz_UZ_CYRL";
        stringArray15[1] = "uz_Cyrl_UZ";
        stringArrayArray[37] = stringArray15;
        String[] stringArray16 = new String[4];
        stringArray16[0] = "uz_UZ_LATN";
        stringArray16[1] = "uz_Latn_UZ";
        stringArrayArray[38] = stringArray16;
        String[] stringArray17 = new String[4];
        stringArray17[0] = "zh_CHS";
        stringArray17[1] = "zh_Hans";
        stringArrayArray[39] = stringArray17;
        String[] stringArray18 = new String[4];
        stringArray18[0] = "zh_CHT";
        stringArray18[1] = "zh_Hant";
        stringArrayArray[40] = stringArray18;
        String[] stringArray19 = new String[4];
        stringArray19[0] = "zh_GAN";
        stringArray19[1] = "zh__GAN";
        stringArrayArray[41] = stringArray19;
        String[] stringArray20 = new String[4];
        stringArray20[0] = "zh_GUOYU";
        stringArray20[1] = "zh";
        stringArrayArray[42] = stringArray20;
        String[] stringArray21 = new String[4];
        stringArray21[0] = "zh_HAKKA";
        stringArray21[1] = "zh__HAKKA";
        stringArrayArray[43] = stringArray21;
        String[] stringArray22 = new String[4];
        stringArray22[0] = "zh_MIN";
        stringArray22[1] = "zh__MIN";
        stringArrayArray[44] = stringArray22;
        String[] stringArray23 = new String[4];
        stringArray23[0] = "zh_MIN_NAN";
        stringArray23[1] = "zh__MINNAN";
        stringArrayArray[45] = stringArray23;
        String[] stringArray24 = new String[4];
        stringArray24[0] = "zh_WUU";
        stringArray24[1] = "zh__WUU";
        stringArrayArray[46] = stringArray24;
        String[] stringArray25 = new String[4];
        stringArray25[0] = "zh_XIANG";
        stringArray25[1] = "zh__XIANG";
        stringArrayArray[47] = stringArray25;
        String[] stringArray26 = new String[4];
        stringArray26[0] = "zh_YUE";
        stringArray26[1] = "zh__YUE";
        stringArrayArray[48] = stringArray26;
        stringArrayArray[49] = new String[]{"th_TH_TRADITIONAL", "th_TH", "calendar", "buddhist"};
        stringArrayArray[50] = new String[]{"hi_IN_TRADITIONAL", "hi_IN", "calendar", "indian"};
        stringArrayArray[51] = new String[]{"zh_TW_STROKE", "zh_TW", "collation", "stroke"};
        stringArrayArray[52] = new String[]{"zh__PINYIN", "zh", "collation", "pinyin"};
        String[][] tempVariantsToKeywords = stringArrayArray;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.ibm.icu.util.ULocale");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Class<?> clazz2 = clazz;
        synchronized (clazz) {
            if (_variantsToKeywords != null) return;
            _variantsToKeywords = tempVariantsToKeywords;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    private ULocale(String localeID, Locale locale) {
        this.localeID = localeID;
        this.locale = locale;
    }

    private ULocale(Locale loc) {
        this.localeID = ULocale.getName(ULocale.forLocale(loc).toString());
        this.locale = loc;
    }

    public static ULocale forLocale(Locale loc) {
        if (loc == null) {
            return null;
        }
        ULocale result = (ULocale)CACHE.get(loc);
        if (result == null) {
            if (defaultULocale != null && loc == ULocale.defaultULocale.locale) {
                result = defaultULocale;
            } else {
                String locStr = loc.toString();
                if (locStr.length() == 0) {
                    result = ROOT;
                } else {
                    int i = 0;
                    while (i < _javaLocaleMap.length) {
                        if (_javaLocaleMap[i][0].equals(locStr)) {
                            IDParser p = new IDParser(_javaLocaleMap[i][1]);
                            p.setKeywordValue(_javaLocaleMap[i][2], _javaLocaleMap[i][3]);
                            locStr = p.getName();
                            break;
                        }
                        ++i;
                    }
                    result = new ULocale(locStr, loc);
                }
            }
            CACHE.put(loc, result);
        }
        return result;
    }

    public ULocale(String localeID) {
        this.localeID = ULocale.getName(localeID);
    }

    public ULocale(String a, String b) {
        this(a, b, null);
    }

    public ULocale(String a, String b, String c) {
        this.localeID = ULocale.getName(ULocale.lscvToID(a, b, c, EMPTY_STRING));
    }

    public static ULocale createCanonical(String nonCanonicalID) {
        return new ULocale(ULocale.canonicalize(nonCanonicalID), null);
    }

    private static String lscvToID(String lang, String script, String country, String variant) {
        StringBuffer buf = new StringBuffer();
        if (lang != null && lang.length() > 0) {
            buf.append(lang);
        }
        if (script != null && script.length() > 0) {
            buf.append('_');
            buf.append(script);
        }
        if (country != null && country.length() > 0) {
            buf.append('_');
            buf.append(country);
        }
        if (variant != null && variant.length() > 0) {
            if (country == null || country.length() == 0) {
                buf.append('_');
            }
            buf.append('_');
            buf.append(variant);
        }
        return buf.toString();
    }

    public Locale toLocale() {
        if (this.locale == null) {
            IDParser p = new IDParser(this.localeID);
            String base = p.getBaseName();
            int i = 0;
            while (i < _javaLocaleMap.length) {
                if (base.equals(_javaLocaleMap[i][1]) || base.equals(_javaLocaleMap[i][4])) {
                    if (_javaLocaleMap[i][2] != null) {
                        String val = p.getKeywordValue(_javaLocaleMap[i][2]);
                        if (val != null && val.equals(_javaLocaleMap[i][3])) {
                            p = new IDParser(_javaLocaleMap[i][0]);
                            break;
                        }
                    } else {
                        p = new IDParser(_javaLocaleMap[i][0]);
                        break;
                    }
                }
                ++i;
            }
            String[] names = p.getLanguageScriptCountryVariant();
            this.locale = new Locale(names[0], names[2], names[3]);
        }
        return this.locale;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ULocale getDefault() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.ibm.icu.util.ULocale");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Class<?> clazz2 = clazz;
        synchronized (clazz) {
            Locale currentDefault = Locale.getDefault();
            if (defaultLocale != currentDefault) {
                defaultLocale = currentDefault;
                defaultULocale = new ULocale(defaultLocale);
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return defaultULocale;
        }
    }

    public static synchronized void setDefault(ULocale newLocale) {
        Locale.setDefault(newLocale.toLocale());
        defaultULocale = newLocale;
    }

    public Object clone() {
        return this;
    }

    public int hashCode() {
        return this.localeID.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof String) {
            return this.localeID.equals((String)obj);
        }
        if (obj instanceof ULocale) {
            return this.localeID.equals(((ULocale)obj).localeID);
        }
        return false;
    }

    public static ULocale[] getAvailableLocales() {
        return ICUResourceBundle.getAvailableULocales();
    }

    public static String[] getISOCountries() {
        ULocale.initCountryTables();
        return (String[])_countries.clone();
    }

    public static String[] getISOLanguages() {
        ULocale.initLanguageTables();
        return (String[])_languages.clone();
    }

    public String getLanguage() {
        return ULocale.getLanguage(this.localeID);
    }

    public static String getLanguage(String localeID) {
        return new IDParser(localeID).getLanguage();
    }

    public String getScript() {
        return ULocale.getScript(this.localeID);
    }

    public static String getScript(String localeID) {
        return new IDParser(localeID).getScript();
    }

    public String getCountry() {
        return ULocale.getCountry(this.localeID);
    }

    public static String getCountry(String localeID) {
        return new IDParser(localeID).getCountry();
    }

    public String getVariant() {
        return ULocale.getVariant(this.localeID);
    }

    public static String getVariant(String localeID) {
        return new IDParser(localeID).getVariant();
    }

    public static String getFallback(String localeID) {
        return ULocale.getFallbackString(ULocale.getName(localeID));
    }

    public ULocale getFallback() {
        if (this.localeID.length() == 0 || this.localeID.charAt(0) == '@') {
            return null;
        }
        return new ULocale(ULocale.getFallbackString(this.localeID), null);
    }

    private static String getFallbackString(String fallback) {
        int start;
        int limit = fallback.indexOf(64);
        if (limit == -1) {
            limit = fallback.length();
        }
        if ((start = fallback.lastIndexOf(95, limit)) == -1) {
            start = 0;
        }
        return String.valueOf(fallback.substring(0, start)) + fallback.substring(limit);
    }

    public String getBaseName() {
        return ULocale.getBaseName(this.localeID);
    }

    public static String getBaseName(String localeID) {
        if (localeID.indexOf(64) == -1) {
            return localeID;
        }
        return new IDParser(localeID).getBaseName();
    }

    public String getName() {
        return this.localeID;
    }

    public static String getName(String localeID) {
        String name;
        Map<String, String> cache = (Map<String, String>)nameCacheRef.get();
        if (cache == null) {
            cache = Collections.synchronizedMap(new HashMap());
            nameCacheRef = new SoftReference(cache);
        }
        if ((name = (String)cache.get(localeID)) == null) {
            name = new IDParser(localeID).getName();
            cache.put(localeID, name);
        }
        return name;
    }

    public String toString() {
        return this.localeID;
    }

    public Iterator getKeywords() {
        return ULocale.getKeywords(this.localeID);
    }

    public static Iterator getKeywords(String localeID) {
        return new IDParser(localeID).getKeywords();
    }

    public String getKeywordValue(String keywordName) {
        return ULocale.getKeywordValue(this.localeID, keywordName);
    }

    public static String getKeywordValue(String localeID, String keywordName) {
        return new IDParser(localeID).getKeywordValue(keywordName);
    }

    private static int findIndex(String[] array, String target) {
        int i = 0;
        while (i < array.length) {
            if (target.equals(array[i])) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static String canonicalize(String localeID) {
        int idx;
        IDParser parser = new IDParser(localeID, true);
        String baseName = parser.getBaseName();
        boolean foundVariant = false;
        if (localeID.equals(EMPTY_STRING)) {
            return EMPTY_STRING;
        }
        ULocale.initVariantsTable();
        int i = 0;
        while (i < _variantsToKeywords.length) {
            if (_variantsToKeywords[i][0].equals(baseName)) {
                foundVariant = true;
                String[] vals = _variantsToKeywords[i];
                parser.setBaseName(vals[1]);
                if (vals[2] == null) break;
                parser.defaultKeywordValue(vals[2], vals[3]);
                break;
            }
            ++i;
        }
        if (!foundVariant && (idx = baseName.indexOf("_EURO")) > -1) {
            parser.setBaseName(baseName.substring(0, idx));
            parser.defaultKeywordValue("currency", "EUR");
        }
        if (!foundVariant && parser.getLanguage().equals("nb") && parser.getVariant().equals("NY")) {
            parser.setBaseName(ULocale.lscvToID("nn", parser.getScript(), parser.getCountry(), null));
        }
        return parser.getName();
    }

    public ULocale setKeywordValue(String keyword, String value) {
        return new ULocale(ULocale.setKeywordValue(this.localeID, keyword, value), null);
    }

    public static String setKeywordValue(String localeID, String keyword, String value) {
        IDParser parser = new IDParser(localeID);
        parser.setKeywordValue(keyword, value);
        return parser.getName();
    }

    public String getISO3Language() {
        return ULocale.getISO3Language(this.localeID);
    }

    public static String getISO3Language(String localeID) {
        ULocale.initLanguageTables();
        String language = ULocale.getLanguage(localeID);
        int offset = ULocale.findIndex(_languages, language);
        if (offset >= 0) {
            return _languages3[offset];
        }
        offset = ULocale.findIndex(_obsoleteLanguages, language);
        if (offset >= 0) {
            return _obsoleteLanguages3[offset];
        }
        return EMPTY_STRING;
    }

    public String getISO3Country() {
        return ULocale.getISO3Country(this.localeID);
    }

    public static String getISO3Country(String localeID) {
        ULocale.initCountryTables();
        String country = ULocale.getCountry(localeID);
        int offset = ULocale.findIndex(_countries, country);
        if (offset >= 0) {
            return _countries3[offset];
        }
        offset = ULocale.findIndex(_obsoleteCountries, country);
        if (offset >= 0) {
            return _obsoleteCountries3[offset];
        }
        return EMPTY_STRING;
    }

    private static String getTableString(String tableName, String subtableName, String item, String displayLocaleID) {
        if (item.length() > 0) {
            try {
                ICUResourceBundle bundle = (ICUResourceBundle)UResourceBundle.getBundleInstance("com/ibm/icu/impl/data/icudt38b", displayLocaleID);
                return ULocale.getTableString(tableName, subtableName, item, bundle);
            }
            catch (Exception exception) {}
        }
        return item;
    }

    private static String getTableString(String tableName, String subtableName, String item, ICUResourceBundle bundle) {
        try {
            while (true) {
                ICUResourceBundle table;
                if ("currency".equals(subtableName)) {
                    table = bundle.getWithFallback("Currencies");
                    table = table.getWithFallback(item);
                    return table.getString(1);
                }
                table = bundle.getWithFallback(tableName);
                try {
                    if (subtableName != null) {
                        table = table.getWithFallback(subtableName);
                    }
                    return table.getStringWithFallback(item);
                }
                catch (MissingResourceException missingResourceException) {
                    String fallbackLocale;
                    if (subtableName == null) {
                        try {
                            String currentName = null;
                            if (tableName.equals("Countries")) {
                                currentName = ULocale.getCurrentCountryID(item);
                            } else if (tableName.equals("Languages")) {
                                currentName = ULocale.getCurrentLanguageID(item);
                            }
                            return table.getStringWithFallback(currentName);
                        }
                        catch (MissingResourceException missingResourceException2) {}
                    }
                    if ((fallbackLocale = table.getWithFallback("Fallback").getString()).length() == 0) {
                        fallbackLocale = "root";
                    }
                    if (fallbackLocale.equals(table.getULocale().localeID)) {
                        return item;
                    }
                    bundle = (ICUResourceBundle)UResourceBundle.getBundleInstance("com/ibm/icu/impl/data/icudt38b", fallbackLocale);
                    continue;
                }
                break;
            }
        }
        catch (Exception exception) {
            return item;
        }
    }

    public String getDisplayLanguage() {
        return ULocale.getDisplayLanguageInternal(this.localeID, ULocale.getDefault().localeID);
    }

    public String getDisplayLanguage(ULocale displayLocale) {
        return ULocale.getDisplayLanguageInternal(this.localeID, displayLocale.localeID);
    }

    public static String getDisplayLanguage(String localeID, String displayLocaleID) {
        return ULocale.getDisplayLanguageInternal(localeID, ULocale.getName(displayLocaleID));
    }

    public static String getDisplayLanguage(String localeID, ULocale displayLocale) {
        return ULocale.getDisplayLanguageInternal(localeID, displayLocale.localeID);
    }

    static String getCurrentCountryID(String oldID) {
        ULocale.initCountryTables();
        int offset = ULocale.findIndex(_deprecatedCountries, oldID);
        if (offset >= 0) {
            return _replacementCountries[offset];
        }
        return oldID;
    }

    static String getCurrentLanguageID(String oldID) {
        ULocale.initLanguageTables();
        int offset = ULocale.findIndex(_obsoleteLanguages, oldID);
        if (offset >= 0) {
            return _replacementLanguages[offset];
        }
        return oldID;
    }

    private static String getDisplayLanguageInternal(String localeID, String displayLocaleID) {
        return ULocale.getTableString("Languages", null, new IDParser(localeID).getLanguage(), displayLocaleID);
    }

    public String getDisplayScript() {
        return ULocale.getDisplayScriptInternal(this.localeID, ULocale.getDefault().localeID);
    }

    public String getDisplayScript(ULocale displayLocale) {
        return ULocale.getDisplayScriptInternal(this.localeID, displayLocale.localeID);
    }

    public static String getDisplayScript(String localeID, String displayLocaleID) {
        return ULocale.getDisplayScriptInternal(localeID, ULocale.getName(displayLocaleID));
    }

    public static String getDisplayScript(String localeID, ULocale displayLocale) {
        return ULocale.getDisplayScriptInternal(localeID, displayLocale.localeID);
    }

    private static String getDisplayScriptInternal(String localeID, String displayLocaleID) {
        return ULocale.getTableString("Scripts", null, new IDParser(localeID).getScript(), displayLocaleID);
    }

    public String getDisplayCountry() {
        return ULocale.getDisplayCountryInternal(this.localeID, ULocale.getDefault().localeID);
    }

    public String getDisplayCountry(ULocale displayLocale) {
        return ULocale.getDisplayCountryInternal(this.localeID, displayLocale.localeID);
    }

    public static String getDisplayCountry(String localeID, String displayLocaleID) {
        return ULocale.getDisplayCountryInternal(localeID, ULocale.getName(displayLocaleID));
    }

    public static String getDisplayCountry(String localeID, ULocale displayLocale) {
        return ULocale.getDisplayCountryInternal(localeID, displayLocale.localeID);
    }

    private static String getDisplayCountryInternal(String localeID, String displayLocaleID) {
        return ULocale.getTableString("Countries", null, new IDParser(localeID).getCountry(), displayLocaleID);
    }

    public String getDisplayVariant() {
        return ULocale.getDisplayVariantInternal(this.localeID, ULocale.getDefault().localeID);
    }

    public String getDisplayVariant(ULocale displayLocale) {
        return ULocale.getDisplayVariantInternal(this.localeID, displayLocale.localeID);
    }

    public static String getDisplayVariant(String localeID, String displayLocaleID) {
        return ULocale.getDisplayVariantInternal(localeID, ULocale.getName(displayLocaleID));
    }

    public static String getDisplayVariant(String localeID, ULocale displayLocale) {
        return ULocale.getDisplayVariantInternal(localeID, displayLocale.localeID);
    }

    private static String getDisplayVariantInternal(String localeID, String displayLocaleID) {
        return ULocale.getTableString("Variants", null, new IDParser(localeID).getVariant(), displayLocaleID);
    }

    public static String getDisplayKeyword(String keyword) {
        return ULocale.getDisplayKeywordInternal(keyword, ULocale.getDefault().localeID);
    }

    public static String getDisplayKeyword(String keyword, String displayLocaleID) {
        return ULocale.getDisplayKeywordInternal(keyword, ULocale.getName(displayLocaleID));
    }

    public static String getDisplayKeyword(String keyword, ULocale displayLocale) {
        return ULocale.getDisplayKeywordInternal(keyword, displayLocale.localeID);
    }

    private static String getDisplayKeywordInternal(String keyword, String displayLocaleID) {
        return ULocale.getTableString("Keys", null, keyword.trim().toLowerCase(), displayLocaleID);
    }

    public String getDisplayKeywordValue(String keyword) {
        return ULocale.getDisplayKeywordValueInternal(this.localeID, keyword, ULocale.getDefault().localeID);
    }

    public String getDisplayKeywordValue(String keyword, ULocale displayLocale) {
        return ULocale.getDisplayKeywordValueInternal(this.localeID, keyword, displayLocale.localeID);
    }

    public static String getDisplayKeywordValue(String localeID, String keyword, String displayLocaleID) {
        return ULocale.getDisplayKeywordValueInternal(localeID, keyword, ULocale.getName(displayLocaleID));
    }

    public static String getDisplayKeywordValue(String localeID, String keyword, ULocale displayLocale) {
        return ULocale.getDisplayKeywordValueInternal(localeID, keyword, displayLocale.localeID);
    }

    private static String getDisplayKeywordValueInternal(String localeID, String keyword, String displayLocaleID) {
        keyword = keyword.trim().toLowerCase();
        String value = new IDParser(localeID).getKeywordValue(keyword);
        return ULocale.getTableString("Types", keyword, value, displayLocaleID);
    }

    public String getDisplayName() {
        return ULocale.getDisplayNameInternal(this.localeID, ULocale.getDefault().localeID);
    }

    public String getDisplayName(ULocale displayLocale) {
        return ULocale.getDisplayNameInternal(this.localeID, displayLocale.localeID);
    }

    public static String getDisplayName(String localeID, String displayLocaleID) {
        return ULocale.getDisplayNameInternal(localeID, ULocale.getName(displayLocaleID));
    }

    public static String getDisplayName(String localeID, ULocale displayLocale) {
        return ULocale.getDisplayNameInternal(localeID, displayLocale.localeID);
    }

    private static String getDisplayNameInternal(String localeID, String displayLocaleID) {
        String[] tableNames = new String[]{"Languages", "Scripts", "Countries", "Variants"};
        ICUResourceBundle bundle = (ICUResourceBundle)UResourceBundle.getBundleInstance("com/ibm/icu/impl/data/icudt38b", displayLocaleID);
        StringBuffer buf = new StringBuffer();
        IDParser parser = new IDParser(localeID);
        String[] names = parser.getLanguageScriptCountryVariant();
        boolean haveLanguage = names[0].length() > 0;
        boolean openParen = false;
        int i = 0;
        while (i < names.length) {
            String name = names[i];
            if (name.length() > 0) {
                name = ULocale.getTableString(tableNames[i], null, name, bundle);
                if (buf.length() > 0) {
                    if (haveLanguage & !openParen) {
                        buf.append(" (");
                        openParen = true;
                    } else {
                        buf.append(", ");
                    }
                }
                buf.append(name);
            }
            ++i;
        }
        Map m = parser.getKeywordMap();
        if (!m.isEmpty()) {
            Iterator keys = m.entrySet().iterator();
            while (keys.hasNext()) {
                if (buf.length() > 0) {
                    if (haveLanguage & !openParen) {
                        buf.append(" (");
                        openParen = true;
                    } else {
                        buf.append(", ");
                    }
                }
                Map.Entry e = keys.next();
                String key = (String)e.getKey();
                String val = (String)e.getValue();
                buf.append(ULocale.getTableString("Keys", null, key, bundle));
                buf.append("=");
                buf.append(ULocale.getTableString("Types", key, val, bundle));
            }
        }
        if (openParen) {
            buf.append(")");
        }
        return buf.toString();
    }

    public static ULocale acceptLanguage(String acceptLanguageList, ULocale[] availableLocales, boolean[] fallback) {
        if (acceptLanguageList == null) {
            throw new NullPointerException();
        }
        ULocale[] acceptList = null;
        try {
            acceptList = ULocale.parseAcceptLanguage(acceptLanguageList, true);
        }
        catch (ParseException parseException) {
            acceptList = null;
        }
        if (acceptList == null) {
            return null;
        }
        return ULocale.acceptLanguage(acceptList, availableLocales, fallback);
    }

    public static ULocale acceptLanguage(ULocale[] acceptLanguageList, ULocale[] availableLocales, boolean[] fallback) {
        if (fallback != null) {
            fallback[0] = true;
        }
        int i = 0;
        while (i < acceptLanguageList.length) {
            ULocale aLocale = acceptLanguageList[i];
            boolean[] setFallback = fallback;
            do {
                int j = 0;
                while (j < availableLocales.length) {
                    if (availableLocales[j].equals(aLocale)) {
                        if (setFallback != null) {
                            setFallback[0] = false;
                        }
                        return availableLocales[j];
                    }
                    ++j;
                }
                Locale loc = aLocale.toLocale();
                Locale parent = LocaleUtility.fallback(loc);
                aLocale = parent != null ? new ULocale(parent) : null;
                setFallback = null;
            } while (aLocale != null);
            ++i;
        }
        return null;
    }

    public static ULocale acceptLanguage(String acceptLanguageList, boolean[] fallback) {
        return ULocale.acceptLanguage(acceptLanguageList, ULocale.getAvailableLocales(), fallback);
    }

    public static ULocale acceptLanguage(ULocale[] acceptLanguageList, boolean[] fallback) {
        return ULocale.acceptLanguage(acceptLanguageList, ULocale.getAvailableLocales(), fallback);
    }

    static ULocale[] parseAcceptLanguage(String acceptLanguage, boolean isLenient) throws ParseException {
        class ULocaleAcceptLanguageQ
        implements Comparable {
            private double q;
            private double serial;

            public ULocaleAcceptLanguageQ(double theq, int theserial) {
                this.q = theq;
                this.serial = theserial;
            }

            public int compareTo(Object o) {
                ULocaleAcceptLanguageQ other = (ULocaleAcceptLanguageQ)o;
                if (this.q > other.q) {
                    return -1;
                }
                if (this.q < other.q) {
                    return 1;
                }
                if (this.serial < other.serial) {
                    return -1;
                }
                if (this.serial > other.serial) {
                    return 1;
                }
                return 0;
            }
        }
        TreeMap<ULocaleAcceptLanguageQ, ULocale> map = new TreeMap<ULocaleAcceptLanguageQ, ULocale>();
        StringBuffer languageRangeBuf = new StringBuffer();
        StringBuffer qvalBuf = new StringBuffer();
        int state = 0;
        acceptLanguage = String.valueOf(acceptLanguage) + ",";
        boolean subTag = false;
        boolean q1 = false;
        int n = 0;
        while (n < acceptLanguage.length()) {
            boolean gotLanguageQ = false;
            char c = acceptLanguage.charAt(n);
            switch (state) {
                case 0: {
                    if ('A' <= c && c <= 'Z' || 'a' <= c && c <= 'z') {
                        languageRangeBuf.append(c);
                        state = 1;
                        subTag = false;
                        break;
                    }
                    if (c == '*') {
                        languageRangeBuf.append(c);
                        state = 2;
                        break;
                    }
                    if (c == ' ' || c == '\t') break;
                    state = -1;
                    break;
                }
                case 1: {
                    if ('A' <= c && c <= 'Z' || 'a' <= c && c <= 'z') {
                        languageRangeBuf.append(c);
                        break;
                    }
                    if (c == '-') {
                        subTag = true;
                        languageRangeBuf.append(c);
                        break;
                    }
                    if (c == '_') {
                        if (isLenient) {
                            subTag = true;
                            languageRangeBuf.append(c);
                            break;
                        }
                        state = -1;
                        break;
                    }
                    if ('0' <= c && c <= '9') {
                        if (subTag) {
                            languageRangeBuf.append(c);
                            break;
                        }
                        state = -1;
                        break;
                    }
                    if (c == ',') {
                        gotLanguageQ = true;
                        break;
                    }
                    if (c == ' ' || c == '\t') {
                        state = 3;
                        break;
                    }
                    if (c == ';') {
                        state = 4;
                        break;
                    }
                    state = -1;
                    break;
                }
                case 2: {
                    if (c == ',') {
                        gotLanguageQ = true;
                        break;
                    }
                    if (c == ' ' || c == '\t') {
                        state = 3;
                        break;
                    }
                    if (c == ';') {
                        state = 4;
                        break;
                    }
                    state = -1;
                    break;
                }
                case 3: {
                    if (c == ',') {
                        gotLanguageQ = true;
                        break;
                    }
                    if (c == ';') {
                        state = 4;
                        break;
                    }
                    if (c == ' ' || c == '\t') break;
                    state = -1;
                    break;
                }
                case 4: {
                    if (c == 'q') {
                        state = 5;
                        break;
                    }
                    if (c == ' ' || c == '\t') break;
                    state = -1;
                    break;
                }
                case 5: {
                    if (c == '=') {
                        state = 6;
                        break;
                    }
                    if (c == ' ' || c == '\t') break;
                    state = -1;
                    break;
                }
                case 6: {
                    if (c == '0') {
                        q1 = false;
                        qvalBuf.append(c);
                        state = 7;
                        break;
                    }
                    if (c == '1') {
                        qvalBuf.append(c);
                        state = 7;
                        break;
                    }
                    if (c == '.') {
                        if (isLenient) {
                            qvalBuf.append(c);
                            state = 8;
                            break;
                        }
                        state = -1;
                        break;
                    }
                    if (c == ' ' || c == '\t') break;
                    state = -1;
                    break;
                }
                case 7: {
                    if (c == '.') {
                        qvalBuf.append(c);
                        state = 8;
                        break;
                    }
                    if (c == ',') {
                        gotLanguageQ = true;
                        break;
                    }
                    if (c == ' ' || c == '\t') {
                        state = 10;
                        break;
                    }
                    state = -1;
                    break;
                }
                case 8: {
                    if ('0' <= c || c <= '9') {
                        if (q1 && c != '0' && !isLenient) {
                            state = -1;
                            break;
                        }
                        qvalBuf.append(c);
                        state = 9;
                        break;
                    }
                    state = -1;
                    break;
                }
                case 9: {
                    if ('0' <= c && c <= '9') {
                        if (q1 && c != '0') {
                            state = -1;
                            break;
                        }
                        qvalBuf.append(c);
                        break;
                    }
                    if (c == ',') {
                        gotLanguageQ = true;
                        break;
                    }
                    if (c == ' ' || c == '\t') {
                        state = 10;
                        break;
                    }
                    state = -1;
                    break;
                }
                case 10: {
                    if (c == ',') {
                        gotLanguageQ = true;
                        break;
                    }
                    if (c == ' ' || c == '\t') break;
                    state = -1;
                }
            }
            if (state == -1) {
                throw new ParseException("Invalid Accept-Language", n);
            }
            if (gotLanguageQ) {
                double q = 1.0;
                if (qvalBuf.length() != 0) {
                    try {
                        q = Double.parseDouble(qvalBuf.toString());
                    }
                    catch (NumberFormatException numberFormatException) {
                        q = 1.0;
                    }
                    if (q > 1.0) {
                        q = 1.0;
                    }
                }
                if (languageRangeBuf.charAt(0) != '*') {
                    int serial = map.size();
                    ULocaleAcceptLanguageQ entry = new ULocaleAcceptLanguageQ(q, serial);
                    map.put(entry, new ULocale(ULocale.canonicalize(languageRangeBuf.toString())));
                }
                languageRangeBuf.setLength(0);
                qvalBuf.setLength(0);
                state = 0;
            }
            ++n;
        }
        if (state != 0) {
            throw new ParseException("Invalid AcceptlLanguage", n);
        }
        ULocale[] acceptList = map.values().toArray(new ULocale[map.size()]);
        return acceptList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void initLikelySubtagMaximizeMap() {
        if (_likelySubtagMaximizeMap != null) {
            return;
        }
        String[][] likelySubtagTable = new String[][]{{"aa", "aa_Latn_ET"}, {"af", "af_Latn_ZA"}, {"ak", "ak_Latn_GH"}, {"am", "am_Ethi_ET"}, {"ar", "ar_Arab_EG"}, {"as", "as_Beng_IN"}, {"az", "az_Latn_AZ"}, {"be", "be_Cyrl_BY"}, {"bg", "bg_Cyrl_BG"}, {"bn", "bn_Beng_BD"}, {"bo", "bo_Tibt_CN"}, {"bs", "bs_Latn_BA"}, {"byn", "byn_Ethi_ER"}, {"ca", "ca_Latn_ES"}, {"cch", "cch_Latn_NG"}, {"ch", "ch_Latn_GU"}, {"chk", "chk_Latn_FM"}, {"cop", "cop_Arab_EG"}, {"cs", "cs_Latn_CZ"}, {"cy", "cy_Latn_GB"}, {"da", "da_Latn_DK"}, {"de", "de_Latn_DE"}, {"dv", "dv_Thaa_MV"}, {"dz", "dz_Tibt_BT"}, {"ee", "ee_Latn_GH"}, {"el", "el_Grek_GR"}, {"en", "en_Latn_US"}, {"es", "es_Latn_ES"}, {"et", "et_Latn_EE"}, {"eu", "eu_Latn_ES"}, {"fa", "fa_Arab_IR"}, {"fi", "fi_Latn_FI"}, {"fil", "fil_Latn_PH"}, {"fj", "fj_Latn_FJ"}, {"fo", "fo_Latn_FO"}, {"fr", "fr_Latn_FR"}, {"fur", "fur_Latn_IT"}, {"ga", "ga_Latn_IE"}, {"gaa", "gaa_Latn_GH"}, {"gez", "gez_Ethi_ER"}, {"gl", "gl_Latn_ES"}, {"gn", "gn_Latn_PY"}, {"gu", "gu_Gujr_IN"}, {"gv", "gv_Latn_GB"}, {"ha", "ha_Latn_NG"}, {"haw", "haw_Latn_US"}, {"he", "he_Hebr_IL"}, {"hi", "hi_Deva_IN"}, {"hr", "hr_Latn_HR"}, {"ht", "ht_Latn_HT"}, {"hu", "hu_Latn_HU"}, {"hy", "hy_Armn_AM"}, {"id", "id_Latn_ID"}, {"ig", "ig_Latn_NG"}, {"ii", "ii_Yiii_CN"}, {"is", "is_Latn_IS"}, {"it", "it_Latn_IT"}, {"iu", "iu_Cans_CA"}, {"ja", "ja_Jpan_JP"}, {"ka", "ka_Geor_GE"}, {"kaj", "kaj_Latn_NG"}, {"kam", "kam_Latn_KE"}, {"kcg", "kcg_Latn_NG"}, {"kfo", "kfo_Latn_NG"}, {"kk", "kk_Cyrl_KZ"}, {"kl", "kl_Latn_GL"}, {"km", "km_Khmr_KH"}, {"kn", "kn_Knda_IN"}, {"ko", "ko_Kore_KR"}, {"kok", "kok_Deva_IN"}, {"kpe", "kpe_Latn_LR"}, {"ku", "ku_Latn_TR"}, {"kw", "kw_Latn_GB"}, {"ky", "ky_Cyrl_KG"}, {"la", "la_Latn_VA"}, {"ln", "ln_Latn_CD"}, {"lo", "lo_Laoo_LA"}, {"lt", "lt_Latn_LT"}, {"lv", "lv_Latn_LV"}, {"mg", "mg_Latn_MG"}, {"mh", "mh_Latn_MH"}, {"mk", "mk_Cyrl_MK"}, {"ml", "ml_Mlym_IN"}, {"mn", "mn_Cyrl_MN"}, {"mr", "mr_Deva_IN"}, {"ms", "ms_Latn_MY"}, {"mt", "mt_Latn_MT"}, {"my", "my_Mymr_MM"}, {"na", "na_Latn_NR"}, {"nb", "nb_Latn_NO"}, {"ne", "ne_Deva_NP"}, {"niu", "niu_Latn_NU"}, {"nl", "nl_Latn_NL"}, {"nn", "nn_Latn_NO"}, {"nr", "nr_Latn_ZA"}, {"nso", "nso_Latn_ZA"}, {"ny", "ny_Latn_MW"}, {"om", "om_Latn_ET"}, {"or", "or_Orya_IN"}, {"pa", "pa_Guru_IN"}, {"pa_Arab", "pa_Arab_PK"}, {"pa_PK", "pa_Arab_PK"}, {"pap", "pap_Latn_AN"}, {"pau", "pau_Latn_PW"}, {"pl", "pl_Latn_PL"}, {"ps", "ps_Arab_AF"}, {"pt", "pt_Latn_BR"}, {"rn", "rn_Latn_BI"}, {"ro", "ro_Latn_RO"}, {"ru", "ru_Cyrl_RU"}, {"rw", "rw_Latn_RW"}, {"sa", "sa_Deva_IN"}, {"se", "se_Latn_NO"}, {"sg", "sg_Latn_CF"}, {"sh", "sr_Latn_RS"}, {"si", "si_Sinh_LK"}, {"sid", "sid_Latn_ET"}, {"sk", "sk_Latn_SK"}, {"sl", "sl_Latn_SI"}, {"sm", "sm_Latn_AS"}, {"so", "so_Latn_SO"}, {"sq", "sq_Latn_AL"}, {"sr", "sr_Cyrl_RS"}, {"ss", "ss_Latn_ZA"}, {"st", "st_Latn_ZA"}, {"sv", "sv_Latn_SE"}, {"sw", "sw_Latn_TZ"}, {"syr", "syr_Syrc_SY"}, {"ta", "ta_Taml_IN"}, {"te", "te_Telu_IN"}, {"tet", "tet_Latn_TL"}, {"tg", "tg_Cyrl_TJ"}, {"th", "th_Thai_TH"}, {"ti", "ti_Ethi_ET"}, {"tig", "tig_Ethi_ER"}, {"tk", "tk_Latn_TM"}, {"tkl", "tkl_Latn_TK"}, {"tn", "tn_Latn_ZA"}, {"to", "to_Latn_TO"}, {"tpi", "tpi_Latn_PG"}, {"tr", "tr_Latn_TR"}, {"ts", "ts_Latn_ZA"}, {"tt", "tt_Cyrl_RU"}, {"tvl", "tvl_Latn_TV"}, {"ty", "ty_Latn_PF"}, {"uk", "uk_Cyrl_UA"}, {"ur", "ur_Arab_IN"}, {"uz", "uz_Cyrl_UZ"}, {"uz_AF", "uz_Arab_AF"}, {"uz_Arab", "uz_Arab_AF"}, {"ve", "ve_Latn_ZA"}, {"vi", "vi_Latn_VN"}, {"wal", "wal_Ethi_ET"}, {"wo", "wo_Arab_SN"}, {"wo_SN", "wo_Latn_SN"}, {"xh", "xh_Latn_ZA"}, {"yo", "yo_Latn_NG"}, {"zh", "zh_Hans_CN"}, {"zh_Hani", "zh_Hans_CN"}, {"zh_Hant", "zh_Hant_TW"}, {"zh_HK", "zh_Hant_HK"}, {"zh_MO", "zh_Hant_MO"}, {"zh_TW", "zh_Hant_TW"}, {"zu", "zu_Latn_ZA"}, {UNDEFINED_LANGUAGE, "en_Latn_US"}, {"und_AD", "ca_Latn_AD"}, {"und_AE", "ar_Arab_AE"}, {"und_AF", "fa_Arab_AF"}, {"und_AL", "sq_Latn_AL"}, {"und_AM", "hy_Armn_AM"}, {"und_AN", "pap_Latn_AN"}, {"und_AO", "pt_Latn_AO"}, {"und_AR", "es_Latn_AR"}, {"und_Arab", "ar_Arab_EG"}, {"und_Arab_IN", "ur_Arab_IN"}, {"und_Arab_PK", "pa_Arab_PK"}, {"und_Arab_SN", "wo_Arab_SN"}, {"und_Armn", "hy_Armn_AM"}, {"und_AS", "sm_Latn_AS"}, {"und_AT", "de_Latn_AT"}, {"und_AW", "nl_Latn_AW"}, {"und_AX", "sv_Latn_AX"}, {"und_AZ", "az_Latn_AZ"}, {"und_BA", "bs_Latn_BA"}, {"und_BD", "bn_Beng_BD"}, {"und_BE", "nl_Latn_BE"}, {"und_Beng", "bn_Beng_BD"}, {"und_Beng_IN", "as_Beng_IN"}, {"und_BF", "fr_Latn_BF"}, {"und_BG", "bg_Cyrl_BG"}, {"und_BH", "ar_Arab_BH"}, {"und_BI", "rn_Latn_BI"}, {"und_BJ", "fr_Latn_BJ"}, {"und_BN", "ms_Latn_BN"}, {"und_BO", "es_Latn_BO"}, {"und_BR", "pt_Latn_BR"}, {"und_BT", "dz_Tibt_BT"}, {"und_BY", "be_Cyrl_BY"}, {"und_Cans", "iu_Cans_CA"}, {"und_CD", "fr_Latn_CD"}, {"und_CF", "sg_Latn_CF"}, {"und_CG", "ln_Latn_CG"}, {"und_CH", "de_Latn_CH"}, {"und_CI", "fr_Latn_CI"}, {"und_CL", "es_Latn_CL"}, {"und_CM", "fr_Latn_CM"}, {"und_CN", "zh_Hans_CN"}, {"und_CO", "es_Latn_CO"}, {"und_CR", "es_Latn_CR"}, {"und_CU", "es_Latn_CU"}, {"und_CV", "pt_Latn_CV"}, {"und_CY", "el_Grek_CY"}, {"und_Cyrl", "ru_Cyrl_RU"}, {"und_Cyrl_KZ", "kk_Cyrl_KZ"}, {"und_CZ", "cs_Latn_CZ"}, {"und_DE", "de_Latn_DE"}, {"und_Deva", "hi_Deva_IN"}, {"und_DJ", "ar_Arab_DJ"}, {"und_DK", "da_Latn_DK"}, {"und_DO", "es_Latn_DO"}, {"und_DZ", "ar_Arab_DZ"}, {"und_EC", "es_Latn_EC"}, {"und_EE", "et_Latn_EE"}, {"und_EG", "ar_Arab_EG"}, {"und_EH", "ar_Arab_EH"}, {"und_ER", "ti_Ethi_ER"}, {"und_ES", "es_Latn_ES"}, {"und_ET", "am_Ethi_ET"}, {"und_Ethi", "am_Ethi_ET"}, {"und_Ethi_ER", "byn_Ethi_ER"}, {"und_FI", "fi_Latn_FI"}, {"und_FJ", "fj_Latn_FJ"}, {"und_FM", "chk_Latn_FM"}, {"und_FO", "fo_Latn_FO"}, {"und_FR", "fr_Latn_FR"}, {"und_GA", "fr_Latn_GA"}, {"und_GE", "ka_Geor_GE"}, {"und_Geor", "ka_Geor_GE"}, {"und_GF", "fr_Latn_GF"}, {"und_GL", "kl_Latn_GL"}, {"und_GN", "fr_Latn_GN"}, {"und_GP", "fr_Latn_GP"}, {"und_GQ", "fr_Latn_GQ"}, {"und_GR", "el_Grek_GR"}, {"und_Grek", "el_Grek_GR"}, {"und_GT", "es_Latn_GT"}, {"und_GU", "ch_Latn_GU"}, {"und_Gujr", "gu_Gujr_IN"}, {"und_Guru", "pa_Guru_IN"}, {"und_GW", "pt_Latn_GW"}, {"und_Hani", "zh_Hans_CN"}, {"und_Hans", "zh_Hans_CN"}, {"und_Hant", "zh_Hant_HK"}, {"und_Hebr", "he_Hebr_IL"}, {"und_HK", "zh_Hant_HK"}, {"und_HN", "es_Latn_HN"}, {"und_HR", "hr_Latn_HR"}, {"und_HT", "ht_Latn_HT"}, {"und_HU", "hu_Latn_HU"}, {"und_ID", "id_Latn_ID"}, {"und_IL", "he_Hebr_IL"}, {"und_IN", "hi_Deva_IN"}, {"und_IQ", "ar_Arab_IQ"}, {"und_IR", "fa_Arab_IR"}, {"und_IS", "is_Latn_IS"}, {"und_IT", "it_Latn_IT"}, {"und_JO", "ar_Arab_JO"}, {"und_JP", "ja_Jpan_JP"}, {"und_Jpan", "ja_Jpan_JP"}, {"und_KG", "ky_Cyrl_KG"}, {"und_KH", "km_Khmr_KH"}, {"und_Khmr", "km_Khmr_KH"}, {"und_KM", "ar_Arab_KM"}, {"und_Knda", "kn_Knda_IN"}, {"und_Kore", "ko_Kore_KR"}, {"und_KP", "ko_Kore_KP"}, {"und_KR", "ko_Kore_KR"}, {"und_KW", "ar_Arab_KW"}, {"und_KZ", "ru_Cyrl_KZ"}, {"und_LA", "lo_Laoo_LA"}, {"und_Laoo", "lo_Laoo_LA"}, {"und_Latn_ES", "ca_Latn_ES"}, {"und_Latn_ET", "aa_Latn_ET"}, {"und_Latn_GB", "cy_Latn_GB"}, {"und_Latn_GH", "ak_Latn_GH"}, {"und_Latn_IT", "fur_Latn_IT"}, {"und_Latn_NG", "cch_Latn_NG"}, {"und_Latn_TR", "ku_Latn_TR"}, {"und_Latn_ZA", "af_Latn_ZA"}, {"und_LB", "ar_Arab_LB"}, {"und_LI", "de_Latn_LI"}, {"und_LK", "si_Sinh_LK"}, {"und_LS", "st_Latn_LS"}, {"und_LT", "lt_Latn_LT"}, {"und_LU", "fr_Latn_LU"}, {"und_LV", "lv_Latn_LV"}, {"und_LY", "ar_Arab_LY"}, {"und_MA", "ar_Arab_MA"}, {"und_MC", "fr_Latn_MC"}, {"und_MD", "ro_Latn_MD"}, {"und_ME", "sr_Cyrl_ME"}, {"und_MG", "mg_Latn_MG"}, {"und_MH", "mh_Latn_MH"}, {"und_MK", "mk_Cyrl_MK"}, {"und_ML", "fr_Latn_ML"}, {"und_Mlym", "ml_Mlym_IN"}, {"und_MM", "my_Mymr_MM"}, {"und_MN", "mn_Cyrl_MN"}, {"und_MO", "zh_Hant_MO"}, {"und_MQ", "fr_Latn_MQ"}, {"und_MR", "ar_Arab_MR"}, {"und_MT", "mt_Latn_MT"}, {"und_MV", "dv_Thaa_MV"}, {"und_MW", "ny_Latn_MW"}, {"und_MX", "es_Latn_MX"}, {"und_MY", "ms_Latn_MY"}, {"und_Mymr", "my_Mymr_MM"}, {"und_MZ", "pt_Latn_MZ"}, {"und_NC", "fr_Latn_NC"}, {"und_NE", "fr_Latn_NE"}, {"und_NG", "ha_Latn_NG"}, {"und_NI", "es_Latn_NI"}, {"und_NL", "nl_Latn_NL"}, {"und_NO", "nb_Latn_NO"}, {"und_NP", "ne_Deva_NP"}, {"und_NR", "na_Latn_NR"}, {"und_NU", "niu_Latn_NU"}, {"und_OM", "ar_Arab_OM"}, {"und_Orya", "or_Orya_IN"}, {"und_PA", "es_Latn_PA"}, {"und_PE", "es_Latn_PE"}, {"und_PF", "ty_Latn_PF"}, {"und_PG", "tpi_Latn_PG"}, {"und_PH", "fil_Latn_PH"}, {"und_PL", "pl_Latn_PL"}, {"und_PM", "fr_Latn_PM"}, {"und_PR", "es_Latn_PR"}, {"und_PS", "ar_Arab_PS"}, {"und_PT", "pt_Latn_PT"}, {"und_PW", "pau_Latn_PW"}, {"und_PY", "gn_Latn_PY"}, {"und_QA", "ar_Arab_QA"}, {"und_RE", "fr_Latn_RE"}, {"und_RO", "ro_Latn_RO"}, {"und_RS", "sr_Cyrl_RS"}, {"und_RU", "ru_Cyrl_RU"}, {"und_RW", "rw_Latn_RW"}, {"und_SA", "ar_Arab_SA"}, {"und_SD", "ar_Arab_SD"}, {"und_SE", "sv_Latn_SE"}, {"und_SG", "zh_Hans_SG"}, {"und_SI", "sl_Latn_SI"}, {"und_Sinh", "si_Sinh_LK"}, {"und_SJ", "nb_Latn_SJ"}, {"und_SK", "sk_Latn_SK"}, {"und_SM", "it_Latn_SM"}, {"und_SN", "fr_Latn_SN"}, {"und_SO", "so_Latn_SO"}, {"und_SR", "nl_Latn_SR"}, {"und_ST", "pt_Latn_ST"}, {"und_SV", "es_Latn_SV"}, {"und_SY", "ar_Arab_SY"}, {"und_Syrc", "syr_Syrc_SY"}, {"und_Taml", "ta_Taml_IN"}, {"und_TD", "ar_Arab_TD"}, {"und_Telu", "te_Telu_IN"}, {"und_TG", "fr_Latn_TG"}, {"und_TH", "th_Thai_TH"}, {"und_Thaa", "dv_Thaa_MV"}, {"und_Thai", "th_Thai_TH"}, {"und_Tibt", "bo_Tibt_CN"}, {"und_TJ", "tg_Cyrl_TJ"}, {"und_TK", "tkl_Latn_TK"}, {"und_TL", "tet_Latn_TL"}, {"und_TM", "tk_Latn_TM"}, {"und_TN", "ar_Arab_TN"}, {"und_TO", "to_Latn_TO"}, {"und_TR", "tr_Latn_TR"}, {"und_TV", "tvl_Latn_TV"}, {"und_TW", "zh_Hant_TW"}, {"und_UA", "uk_Cyrl_UA"}, {"und_UY", "es_Latn_UY"}, {"und_UZ", "uz_Cyrl_UZ"}, {"und_VA", "la_Latn_VA"}, {"und_VE", "es_Latn_VE"}, {"und_VN", "vi_Latn_VN"}, {"und_VU", "fr_Latn_VU"}, {"und_WF", "fr_Latn_WF"}, {"und_WS", "sm_Latn_WS"}, {"und_YE", "ar_Arab_YE"}, {"und_Yiii", "ii_Yiii_CN"}, {"und_YT", "fr_Latn_YT"}};
        HashMap<String, ULocale> tmpMap = new HashMap<String, ULocale>();
        int i = 0;
        while (i < likelySubtagTable.length) {
            ULocale loc = new ULocale(likelySubtagTable[i][1]);
            tmpMap.put(likelySubtagTable[i][0], loc);
            ++i;
        }
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.ibm.icu.util.ULocale");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Class<?> clazz2 = clazz;
        synchronized (clazz) {
            if (_likelySubtagMaximizeMap == null) {
                _likelySubtagMaximizeMap = tmpMap;
            }
            // ** MonitorExit[var2_3] (shouldn't be in output)
            return;
        }
    }

    public static ULocale addLikelySubtag(ULocale loc) {
        ULocale match;
        ULocale.initLikelySubtagMaximizeMap();
        String language = loc.getLanguage();
        String script = loc.getScript();
        String region = loc.getCountry();
        if (language.length() == 0) {
            language = UNDEFINED_LANGUAGE;
        }
        if (script.equals(UNDEFINED_SCRIPT)) {
            script = EMPTY_STRING;
        }
        if (region.equals(UNDEFINED_REGION)) {
            region = EMPTY_STRING;
        }
        boolean hasScript = script.length() != 0;
        boolean hasRegion = region.length() != 0;
        boolean bDone = false;
        if (hasScript && hasRegion && (match = (ULocale)_likelySubtagMaximizeMap.get(String.valueOf(language) + "_" + script + "_" + region)) != null) {
            language = match.getLanguage();
            script = match.getScript();
            region = match.getCountry();
            bDone = true;
        }
        if (!bDone && hasScript && (match = (ULocale)_likelySubtagMaximizeMap.get(String.valueOf(language) + "_" + script)) != null) {
            language = match.getLanguage();
            script = match.getScript();
            if (!hasRegion) {
                region = match.getCountry();
            }
            bDone = true;
        }
        if (!bDone && hasRegion && (match = (ULocale)_likelySubtagMaximizeMap.get(String.valueOf(language) + "_" + region)) != null) {
            language = match.getLanguage();
            region = match.getCountry();
            if (!hasScript) {
                script = match.getScript();
            }
            bDone = true;
        }
        if (!bDone && (match = (ULocale)_likelySubtagMaximizeMap.get(language)) != null) {
            language = match.getLanguage();
            if (!hasScript) {
                script = match.getScript();
            }
            if (!hasRegion) {
                region = match.getCountry();
            }
            bDone = true;
        }
        ULocale result = null;
        if (bDone) {
            if (language.equals(loc.getLanguage()) && script.equals(loc.getScript()) && region.equals(loc.getCountry())) {
                result = loc;
            } else {
                int keywordsIdx;
                String variant;
                StringBuffer buf = new StringBuffer();
                buf.append(language);
                if (script.length() != 0) {
                    buf.append('_');
                    buf.append(script);
                }
                if (region.length() != 0) {
                    buf.append('_');
                    buf.append(region);
                }
                if ((variant = loc.getVariant()).length() != 0) {
                    buf.append('_');
                    buf.append(variant);
                }
                if ((keywordsIdx = loc.localeID.indexOf(64)) >= 0) {
                    buf.append(loc.localeID.substring(keywordsIdx));
                }
                result = new ULocale(buf.toString());
            }
        } else {
            result = hasScript && hasRegion && language != UNDEFINED_LANGUAGE ? loc : loc;
        }
        return result;
    }

    private static final class IDParser {
        private char[] id;
        private int index;
        private char[] buffer;
        private int blen;
        private boolean canonicalize;
        private boolean hadCountry;
        Map keywords;
        String baseName;
        private static final char KEYWORD_SEPARATOR = '@';
        private static final char HYPHEN = '-';
        private static final char KEYWORD_ASSIGN = '=';
        private static final char COMMA = ',';
        private static final char ITEM_SEPARATOR = ';';
        private static final char DOT = '.';
        private static final char DONE = '\uffff';

        private IDParser(String localeID) {
            this(localeID, false);
        }

        private IDParser(String localeID, boolean canonicalize) {
            this.id = localeID.toCharArray();
            this.index = 0;
            this.buffer = new char[this.id.length + 5];
            this.blen = 0;
            this.canonicalize = canonicalize;
        }

        private void reset() {
            this.blen = 0;
            this.index = 0;
        }

        private void append(char c) {
            try {
                this.buffer[this.blen] = c;
            }
            catch (IndexOutOfBoundsException e) {
                if (this.buffer.length > 512) {
                    throw e;
                }
                char[] nbuffer = new char[this.buffer.length * 2];
                System.arraycopy(this.buffer, 0, nbuffer, 0, this.buffer.length);
                nbuffer[this.blen] = c;
                this.buffer = nbuffer;
            }
            ++this.blen;
        }

        private void addSeparator() {
            this.append('_');
        }

        private String getString(int start) {
            if (start == this.blen) {
                return ULocale.EMPTY_STRING;
            }
            return new String(this.buffer, start, this.blen - start);
        }

        private void set(int pos, String s) {
            this.blen = pos;
            this.append(s);
        }

        private void append(String s) {
            int i = 0;
            while (i < s.length()) {
                this.append(s.charAt(i));
                ++i;
            }
        }

        private char next() {
            if (this.index == this.id.length) {
                ++this.index;
                return '\uffff';
            }
            return this.id[this.index++];
        }

        private void skipUntilTerminatorOrIDSeparator() {
            while (!this.isTerminatorOrIDSeparator(this.next())) {
            }
            --this.index;
        }

        private boolean atTerminator() {
            return this.index >= this.id.length || this.isTerminator(this.id[this.index]);
        }

        private boolean isTerminator(char c) {
            return c == '@' || c == '\uffff' || c == '.';
        }

        private boolean isTerminatorOrIDSeparator(char c) {
            return c == '@' || c == '_' || c == '-' || c == '\uffff' || c == '.';
        }

        private boolean haveExperimentalLanguagePrefix() {
            char c;
            if (this.id.length > 2 && ((c = this.id[1]) == '-' || c == '_')) {
                c = this.id[0];
                return c == 'x' || c == 'X' || c == 'i' || c == 'I';
            }
            return false;
        }

        private boolean haveKeywordAssign() {
            int i = this.index;
            while (i < this.id.length) {
                if (this.id[i] == '=') {
                    return true;
                }
                ++i;
            }
            return false;
        }

        private int parseLanguage() {
            char c;
            if (this.haveExperimentalLanguagePrefix()) {
                this.append(Character.toLowerCase(this.id[0]));
                this.append('-');
                this.index = 2;
            }
            while (!this.isTerminatorOrIDSeparator(c = this.next())) {
                this.append(Character.toLowerCase(c));
            }
            --this.index;
            if (this.blen == 3) {
                ULocale.initLanguageTables();
                String lang = this.getString(0);
                int offset = ULocale.findIndex(_languages3, lang);
                if (offset >= 0) {
                    this.set(0, _languages[offset]);
                } else {
                    offset = ULocale.findIndex(_obsoleteLanguages3, lang);
                    if (offset >= 0) {
                        this.set(0, _obsoleteLanguages[offset]);
                    }
                }
            }
            return 0;
        }

        private void skipLanguage() {
            if (this.haveExperimentalLanguagePrefix()) {
                this.index = 2;
            }
            this.skipUntilTerminatorOrIDSeparator();
        }

        private int parseScript() {
            if (!this.atTerminator()) {
                char c;
                int oldIndex = this.index++;
                int oldBlen = this.blen;
                while (!this.isTerminatorOrIDSeparator(c = this.next())) {
                    if (this.blen == oldBlen) {
                        this.addSeparator();
                        this.append(Character.toUpperCase(c));
                        continue;
                    }
                    this.append(Character.toLowerCase(c));
                }
                --this.index;
                if (this.index - oldIndex != 5) {
                    this.index = oldIndex;
                    this.blen = oldBlen;
                } else {
                    ++oldBlen;
                }
                return oldBlen;
            }
            return this.blen;
        }

        private void skipScript() {
            if (!this.atTerminator()) {
                int oldIndex = this.index++;
                this.skipUntilTerminatorOrIDSeparator();
                if (this.index - oldIndex != 5) {
                    this.index = oldIndex;
                }
            }
        }

        private int parseCountry() {
            if (!this.atTerminator()) {
                char c;
                ++this.index;
                int oldBlen = this.blen;
                while (!this.isTerminatorOrIDSeparator(c = this.next())) {
                    if (oldBlen == this.blen) {
                        this.hadCountry = true;
                        this.addSeparator();
                        ++oldBlen;
                    }
                    this.append(Character.toUpperCase(c));
                }
                --this.index;
                if (this.blen - oldBlen == 3) {
                    ULocale.initCountryTables();
                    int offset = ULocale.findIndex(_countries3, this.getString(oldBlen));
                    if (offset >= 0) {
                        this.set(oldBlen, _countries[offset]);
                    } else {
                        offset = ULocale.findIndex(_obsoleteCountries3, this.getString(oldBlen));
                        if (offset >= 0) {
                            this.set(oldBlen, _obsoleteCountries[offset]);
                        }
                    }
                }
                return oldBlen;
            }
            return this.blen;
        }

        private void skipCountry() {
            if (!this.atTerminator()) {
                ++this.index;
                this.skipUntilTerminatorOrIDSeparator();
            }
        }

        private int parseVariant() {
            char c;
            int oldBlen = this.blen;
            boolean start = true;
            boolean needSeparator = true;
            boolean skipping = false;
            while ((c = this.next()) != '\uffff') {
                if (c == '.') {
                    start = false;
                    skipping = true;
                    continue;
                }
                if (c == '@') {
                    if (this.haveKeywordAssign()) break;
                    skipping = false;
                    start = false;
                    needSeparator = true;
                    continue;
                }
                if (start) {
                    start = false;
                    continue;
                }
                if (skipping) continue;
                if (needSeparator) {
                    boolean incOldBlen = this.blen == oldBlen;
                    needSeparator = false;
                    if (incOldBlen && !this.hadCountry) {
                        this.addSeparator();
                        ++oldBlen;
                    }
                    this.addSeparator();
                    if (incOldBlen) {
                        ++oldBlen;
                    }
                }
                if ((c = Character.toUpperCase(c)) == '-' || c == ',') {
                    c = '_';
                }
                this.append(c);
            }
            --this.index;
            return oldBlen;
        }

        public String getLanguage() {
            this.reset();
            return this.getString(this.parseLanguage());
        }

        public String getScript() {
            this.reset();
            this.skipLanguage();
            return this.getString(this.parseScript());
        }

        public String getCountry() {
            this.reset();
            this.skipLanguage();
            this.skipScript();
            return this.getString(this.parseCountry());
        }

        public String getVariant() {
            this.reset();
            this.skipLanguage();
            this.skipScript();
            this.skipCountry();
            return this.getString(this.parseVariant());
        }

        public String[] getLanguageScriptCountryVariant() {
            this.reset();
            return new String[]{this.getString(this.parseLanguage()), this.getString(this.parseScript()), this.getString(this.parseCountry()), this.getString(this.parseVariant())};
        }

        public void setBaseName(String baseName) {
            this.baseName = baseName;
        }

        public void parseBaseName() {
            if (this.baseName != null) {
                this.set(0, this.baseName);
            } else {
                this.reset();
                this.parseLanguage();
                this.parseScript();
                this.parseCountry();
                this.parseVariant();
                if (this.blen > 1 && this.buffer[this.blen - 1] == '_') {
                    --this.blen;
                }
            }
        }

        public String getBaseName() {
            if (this.baseName != null) {
                return this.baseName;
            }
            this.parseBaseName();
            return this.getString(0);
        }

        public String getName() {
            this.parseBaseName();
            this.parseKeywords();
            return this.getString(0);
        }

        private boolean setToKeywordStart() {
            int i = this.index;
            while (i < this.id.length) {
                if (this.id[i] == '@') {
                    if (this.canonicalize) {
                        int j = ++i;
                        while (j < this.id.length) {
                            if (this.id[j] == '=') {
                                this.index = i;
                                return true;
                            }
                            ++j;
                        }
                        break;
                    }
                    if (++i >= this.id.length) break;
                    this.index = i;
                    return true;
                }
                ++i;
            }
            return false;
        }

        private static boolean isDoneOrKeywordAssign(char c) {
            return c == '\uffff' || c == '=';
        }

        private static boolean isDoneOrItemSeparator(char c) {
            return c == '\uffff' || c == ';';
        }

        private String getKeyword() {
            int start = this.index;
            while (!IDParser.isDoneOrKeywordAssign(this.next())) {
            }
            --this.index;
            return new String(this.id, start, this.index - start).trim().toLowerCase();
        }

        private String getValue() {
            int start = this.index;
            while (!IDParser.isDoneOrItemSeparator(this.next())) {
            }
            --this.index;
            return new String(this.id, start, this.index - start).trim();
        }

        private Comparator getKeyComparator() {
            Comparator comp = new Comparator(this){
                final /* synthetic */ IDParser this$1;
                {
                    this.this$1 = iDParser;
                }

                public int compare(Object lhs, Object rhs) {
                    return ((String)lhs).compareTo((String)rhs);
                }
            };
            return comp;
        }

        private Map getKeywordMap() {
            block6: {
                TreeMap<String, String> m;
                block7: {
                    String key;
                    if (this.keywords != null) break block6;
                    m = null;
                    if (!this.setToKeywordStart()) break block7;
                    while ((key = this.getKeyword()).length() != 0) {
                        block9: {
                            String value;
                            block11: {
                                block10: {
                                    block8: {
                                        char c = this.next();
                                        if (c == '=') break block8;
                                        if (c == '\uffff') {
                                            break;
                                        }
                                        break block9;
                                    }
                                    value = this.getValue();
                                    if (value.length() == 0) break block9;
                                    if (m != null) break block10;
                                    m = new TreeMap<String, String>(this.getKeyComparator());
                                    break block11;
                                }
                                if (m.containsKey(key)) break block9;
                            }
                            m.put(key, value);
                        }
                        if (this.next() == ';') continue;
                    }
                }
                this.keywords = m != null ? m : Collections.EMPTY_MAP;
            }
            return this.keywords;
        }

        private int parseKeywords() {
            int oldBlen = this.blen;
            Map m = this.getKeywordMap();
            if (!m.isEmpty()) {
                Iterator iter = m.entrySet().iterator();
                boolean first = true;
                while (iter.hasNext()) {
                    this.append(first ? (char)'@' : ';');
                    first = false;
                    Map.Entry e = iter.next();
                    this.append((String)e.getKey());
                    this.append('=');
                    this.append((String)e.getValue());
                }
                if (this.blen != oldBlen) {
                    ++oldBlen;
                }
            }
            return oldBlen;
        }

        public Iterator getKeywords() {
            Map m = this.getKeywordMap();
            return m.isEmpty() ? null : m.keySet().iterator();
        }

        public String getKeywordValue(String keywordName) {
            Map m = this.getKeywordMap();
            return m.isEmpty() ? null : (String)m.get(keywordName.trim().toLowerCase());
        }

        public void defaultKeywordValue(String keywordName, String value) {
            this.setKeywordValue(keywordName, value, false);
        }

        public void setKeywordValue(String keywordName, String value) {
            this.setKeywordValue(keywordName, value, true);
        }

        private void setKeywordValue(String keywordName, String value, boolean reset) {
            if (keywordName == null) {
                if (reset) {
                    this.keywords = Collections.EMPTY_MAP;
                }
            } else {
                if ((keywordName = keywordName.trim().toLowerCase()).length() == 0) {
                    throw new IllegalArgumentException("keyword must not be empty");
                }
                if (value != null && (value = value.trim()).length() == 0) {
                    throw new IllegalArgumentException("value must not be empty");
                }
                Map m = this.getKeywordMap();
                if (m.isEmpty()) {
                    if (value != null) {
                        this.keywords = new TreeMap(this.getKeyComparator());
                        this.keywords.put(keywordName, value.trim());
                    }
                } else if (reset || !m.containsKey(keywordName)) {
                    if (value != null) {
                        m.put(keywordName, value);
                    } else {
                        m.remove(keywordName);
                        if (m.isEmpty()) {
                            this.keywords = Collections.EMPTY_MAP;
                        }
                    }
                }
            }
        }
    }

    public static final class Type {
        private int localeType;

        private Type(int type) {
            this.localeType = type;
        }
    }
}

