/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.concierge.plugin;

import java.util.ArrayList;
import java.util.Collections;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import jp.sourceforge.concierge.framework.AbstractDocumentUIPlugin;
import jp.sourceforge.concierge.framework.FrameworkPlugin;
import jp.sourceforge.concierge.framework.Request;
import jp.sourceforge.concierge.mdocument.DomImpl;
import jp.sourceforge.concierge.mdocument.TypeDomImpl;
import jp.sourceforge.concierge.plugin.searcher.data.Configure;
import jp.sourceforge.concierge.widget.SearchComposite;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class SearcherPlugin
extends AbstractDocumentUIPlugin {
    ArrayList<Document> typedocs = null;
    private Document configDoc;
    private static SearcherPlugin plugin;
    static final String BUNDLE_NAME = "jp.sourceforge.concierge.plugin.searcher.messages";
    static final ResourceBundle RESOURCE_BUNDLE;

    static {
        RESOURCE_BUNDLE = ResourceBundle.getBundle(BUNDLE_NAME);
    }

    private ArrayList<Document> getLastModDocuments(ArrayList<Document> docs) {
        ArrayList<Document> lastdocs = new ArrayList<Document>();
        lastdocs.add(docs.get(0));
        long lastmod = DomImpl.getLastModifiedTime((Document)docs.get(0));
        int i = 1;
        while (i < docs.size()) {
            long lm = DomImpl.getLastModifiedTime((Document)docs.get(i));
            if (lm > lastmod) {
                lastmod = lm;
                lastdocs.clear();
                lastdocs.add(docs.get(i));
            } else if (lm == lastmod) {
                lastdocs.add(docs.get(i));
            }
            ++i;
        }
        return lastdocs;
    }

    public SearcherPlugin() {
        plugin = this;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        Request req = new Request();
        req.collection = "ccgconfig";
        req.command = 4;
        req.options = 0;
        req.data = "/ccgconfig[@name='SFolder2']";
        ArrayList list = FrameworkPlugin.getDocumentsOfQuery((Request)req);
        if (list.size() == 0) {
            this.configDoc = DomImpl.createDocument((String)"ccgconfig");
            Element docnode = DomImpl.getRootElement((Document)this.configDoc);
            DomImpl.setAttribute((Element)docnode, (String)"name", (String)"SFolder2");
            SearcherPlugin.sendDocumentRequest(this.configDoc, "ccgconfig", 1, SearcherPlugin.getDefault().getBundle().getSymbolicName());
        } else {
            this.configDoc = this.getLastModDocuments(list).get(0);
        }
        this.typedocs = FrameworkPlugin.getAllTypeDocuments();
    }

    public void stop(BundleContext context) throws Exception {
        super.stop(context);
        plugin = null;
    }

    public static String getString(String key) {
        try {
            return RESOURCE_BUNDLE.getString(key);
        }
        catch (MissingResourceException missingResourceException) {
            return String.valueOf('!') + key + '!';
        }
    }

    public static SearcherPlugin getDefault() {
        return plugin;
    }

    public static Document getTypeDocument(String type) {
        assert (SearcherPlugin.plugin.typedocs != null);
        int i = 0;
        while (i < SearcherPlugin.plugin.typedocs.size()) {
            Document d = SearcherPlugin.plugin.typedocs.get(i);
            if (TypeDomImpl.getTypeName((Document)d).equals(type)) {
                return d;
            }
            ++i;
        }
        return null;
    }

    public static ArrayList<String> getAllTypeNames() {
        assert (SearcherPlugin.plugin.typedocs != null);
        ArrayList<String> names = new ArrayList<String>(SearcherPlugin.plugin.typedocs.size());
        int i = 0;
        while (i < SearcherPlugin.plugin.typedocs.size()) {
            Document d = SearcherPlugin.plugin.typedocs.get(i);
            names.add(TypeDomImpl.getTypeName((Document)d));
            ++i;
        }
        Collections.sort(names);
        return names;
    }

    public static ArrayList<Element> getConfigList() {
        return DomImpl.getElements((Element)DomImpl.getRootElement((Document)SearcherPlugin.plugin.configDoc), (String)"Info");
    }

    public static void sendDocumentRequest(Document doc, String col, int type, Object sender) {
        ArrayList<Request> reqs = new ArrayList<Request>();
        Request req = new Request();
        req.collection = col;
        req.command = type;
        req.data = doc;
        reqs.add(req);
        if (sender == null) {
            sender = plugin.getBundle().getSymbolicName();
        }
        FrameworkPlugin.updateDocuments(reqs, (Object)sender);
    }

    public static Element createInfo(String name, Configure.InfoType type) {
        Element info = DomImpl.createElement((Document)SearcherPlugin.plugin.configDoc, (String)"Info", (String)"");
        Configure.setDefaultElement(info, type);
        Configure.setName(info, name);
        return info;
    }

    public static void addInfo(Element info, Object sender) {
        DomImpl.getRootElement((Document)SearcherPlugin.plugin.configDoc).appendChild(info);
        SearcherPlugin.sendDocumentRequest(SearcherPlugin.plugin.configDoc, "ccgconfig", 3, sender);
    }

    public static void removeInfo(Element config, Object sender) {
        Element top = DomImpl.getRootElement((Document)SearcherPlugin.plugin.configDoc);
        top.removeChild(config);
        SearcherPlugin.sendDocumentRequest(SearcherPlugin.plugin.configDoc, "ccgconfig", 3, sender);
    }

    public static SearchComposite getSearchComposite(Composite parent, int style, boolean expandable) {
        return new SearchComposite(parent, style, expandable);
    }

    public static ArrayList<Document> search(String xpath) {
        Request r = new Request(4, (Object)xpath, "data");
        return FrameworkPlugin.getDocumentsOfQuery((Request)r);
    }

    public static ArrayList<Document> searchFileContents(String words) {
        return FrameworkPlugin.getDocumentsOfQuery((String)words);
    }

    public static void updateDocument(Object sender) {
        SearcherPlugin.sendDocumentRequest(SearcherPlugin.plugin.configDoc, "ccgconfig", 3, sender);
    }

    public static ImageDescriptor getImageDescriptor(String path) {
        return AbstractUIPlugin.imageDescriptorFromPlugin((String)"jp.sourceforge.concierge.plugin.searcher", (String)path);
    }
}

