/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.concierge.editor;

import java.io.File;
import java.util.Hashtable;
import jp.sourceforge.concierge.editor.EditorEvent;
import jp.sourceforge.concierge.editor.IConciergeDialogArea;
import jp.sourceforge.concierge.editor.IEditorEventListener;
import jp.sourceforge.concierge.mdocument.DataDomImpl;
import jp.sourceforge.concierge.plugin.DataExtractorPlugin;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.w3c.dom.Document;

public class CommonDialogArea
implements IConciergeDialogArea {
    private static final int TEXTWIDTHHINT = 100;
    private Hashtable<String, Control> ttable = new Hashtable();
    private Document document;
    private IEditorEventListener elistener;
    private Group group1 = null;

    private boolean isEmpty(String str) {
        return str == null || str.length() == 0;
    }

    private void setFileInformation(Document doc, boolean override) {
        String filepath;
        String mdate;
        String cdate;
        String creator;
        String author;
        String file = DataDomImpl.getFilePath(doc);
        if (this.isEmpty(file)) {
            return;
        }
        String title = DataDomImpl.getTitle(doc);
        if ((this.isEmpty(title) || override) && (title = DataExtractorPlugin.getFileProperty((String)file, (String)"title")) != null) {
            ((Text)this.ttable.get("title")).setText(title);
        }
        if ((this.isEmpty(author = DataDomImpl.getAuthor(doc)) || override) && (author = DataExtractorPlugin.getFileProperty((String)file, (String)"author")) != null) {
            ((Text)this.ttable.get("author")).setText(author);
        }
        if ((this.isEmpty(creator = DataDomImpl.getCreator(doc)) || override) && (creator = DataExtractorPlugin.getFileProperty((String)file, (String)"creator")) != null) {
            ((Text)this.ttable.get("creator")).setText(creator);
        }
        if ((this.isEmpty(cdate = DataDomImpl.getCreateDate(doc)) || override) && (cdate = DataExtractorPlugin.getFileProperty((String)file, (String)"creationdate")) != null) {
            ((Text)this.ttable.get("creationdate")).setText(cdate);
        }
        if ((this.isEmpty(mdate = DataDomImpl.getLastModDate(doc)) || override) && (mdate = DataExtractorPlugin.getFileProperty((String)file, (String)"lastmoddate")) != null) {
            ((Text)this.ttable.get("lastmoddate")).setText(mdate);
        }
        if (!this.isEmpty(filepath = DataDomImpl.getFilePath(doc))) {
            ((Text)this.ttable.get("filepath")).setText(filepath);
        }
    }

    private void setLabelAndText(Composite parent, String lt, boolean tmulti) {
        Label l = new Label(parent, 0);
        l.setText(lt);
        l.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        int mlt = tmulti ? 2 : 4;
        Text t = new Text(parent, mlt | 0x800);
        int vpara = tmulti ? 4 : 0x1000000;
        GridData tgd = new GridData(4, vpara, true, true);
        tgd.widthHint = 100;
        t.setLayoutData((Object)tgd);
        this.ttable.put(lt, (Control)t);
        t.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (CommonDialogArea.this.elistener != null) {
                    CommonDialogArea.this.elistener.run(new EditorEvent(1, e.widget, CommonDialogArea.this.document));
                }
            }
        });
    }

    private void setLabelAndLabel(Composite parent, String lt) {
        Label l = new Label(parent, 0);
        l.setText(lt);
        l.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        Text vl = new Text(parent, 2048);
        GridData tgd = new GridData(4, 0x1000000, true, true);
        tgd.widthHint = 100;
        vl.setLayoutData((Object)tgd);
        vl.setEditable(false);
        this.ttable.put(lt, (Control)vl);
    }

    private void setLabelAndPathText(Composite parent, String lt, boolean enabled) {
        Label l = new Label(parent, 0);
        l.setText(lt);
        l.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        Composite comp = new Composite(parent, 0);
        comp.setLayoutData((Object)new GridData(4, 0x1000000, true, true));
        FormLayout fl = new FormLayout();
        fl.marginWidth = 0;
        fl.marginHeight = 0;
        fl.spacing = 0;
        comp.setLayout((Layout)fl);
        Button b = new Button(comp, 0);
        b.setEnabled(enabled);
        FormData bfd = new FormData();
        bfd.right = new FormAttachment(100, 0);
        b.setLayoutData((Object)bfd);
        b.setText("Change");
        b.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Text t = (Text)CommonDialogArea.this.ttable.get("filepath");
                FileDialog fd = new FileDialog(t.getShell(), 4096);
                fd.setFileName(t.getText());
                String path = fd.open();
                if (path == null) {
                    return;
                }
                t.setText(path);
                DataDomImpl.setFilePath(CommonDialogArea.this.document, path);
                if (MessageDialog.openConfirm((Shell)CommonDialogArea.this.group1.getShell(), (String)"Override", (String)"Also override file information?")) {
                    CommonDialogArea.this.setFileInformation(CommonDialogArea.this.document, true);
                }
            }
        });
        Text pt = new Text(comp, 2048);
        pt.setEnabled(enabled);
        FormData tfd = new FormData();
        tfd.left = new FormAttachment(0, 0);
        tfd.right = new FormAttachment((Control)b, 0);
        pt.setLayoutData((Object)tfd);
        pt.setEditable(false);
        this.ttable.put(lt, (Control)pt);
        pt.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (CommonDialogArea.this.elistener != null) {
                    CommonDialogArea.this.elistener.run(new EditorEvent(1, e.widget, CommonDialogArea.this.document));
                }
            }
        });
    }

    @Override
    public Control createDialogArea(Composite parent) {
        this.ttable.clear();
        parent.setLayout((Layout)new GridLayout(1, false));
        this.group1 = new Group(parent, 16);
        this.group1.setLayout((Layout)new GridLayout(2, false));
        this.group1.setLayoutData((Object)new GridData(4, 128, true, true));
        this.group1.setText("Common");
        this.setLabelAndText((Composite)this.group1, "title", false);
        this.setLabelAndText((Composite)this.group1, "author", false);
        this.setLabelAndText((Composite)this.group1, "creator", false);
        this.setLabelAndLabel((Composite)this.group1, "creationdate");
        this.setLabelAndLabel((Composite)this.group1, "lastmoddate");
        File f = new File(DataDomImpl.getFilePath(this.document));
        if (f.isDirectory()) {
            this.setLabelAndPathText((Composite)this.group1, "filepath", false);
        } else {
            this.setLabelAndPathText((Composite)this.group1, "filepath", true);
        }
        this.refresh();
        this.setFileInformation(this.document, false);
        return parent;
    }

    @Override
    public void refresh() {
        if (this.document == null) {
            return;
        }
        ((Text)this.ttable.get("title")).setText(DataDomImpl.getTitle(this.document));
        ((Text)this.ttable.get("author")).setText(DataDomImpl.getAuthor(this.document));
        ((Text)this.ttable.get("creator")).setText(DataDomImpl.getCreator(this.document));
        ((Text)this.ttable.get("creationdate")).setText(DataDomImpl.getCreateDate(this.document));
        ((Text)this.ttable.get("lastmoddate")).setText(DataDomImpl.getLastModDate(this.document));
        ((Text)this.ttable.get("filepath")).setText(DataDomImpl.getFilePath(this.document));
    }

    @Override
    public void setDocument(Document doc) {
        this.document = doc;
    }

    @Override
    public void setDocumentChangeListener(IEditorEventListener listener) {
        this.elistener = listener;
    }

    @Override
    public Document saveDocument() {
        if (this.document == null) {
            return null;
        }
        DataDomImpl.setTitle(this.document, ((Text)this.ttable.get("title")).getText());
        DataDomImpl.setAuthor(this.document, ((Text)this.ttable.get("author")).getText());
        DataDomImpl.setCreator(this.document, ((Text)this.ttable.get("creator")).getText());
        DataDomImpl.setFilePath(this.document, ((Text)this.ttable.get("filepath")).getText());
        return this.document;
    }

    @Override
    public String getType() {
        return "Unclassified";
    }

    @Override
    public void setEnabled(boolean enabled) {
        Color lc = null;
        lc = enabled ? this.group1.getDisplay().getSystemColor(2) : this.group1.getDisplay().getSystemColor(15);
        Control[] ctrls = this.group1.getChildren();
        int i = 0;
        while (i < ctrls.length) {
            if (ctrls[i] instanceof Label) {
                ctrls[i].setForeground(lc);
            }
            ctrls[i].setEnabled(enabled);
            ++i;
        }
        this.group1.setEnabled(enabled);
    }

    @Override
    public boolean isEnabled() {
        return this.group1.isEnabled();
    }

    @Override
    public void fillout() {
        this.setFileInformation(this.document, true);
    }

    @Override
    public void dispose() {
    }

    @Override
    public boolean isDisposed() {
        return this.group1.isDisposed();
    }

    public String getCurrentFilePath() {
        return ((Text)this.ttable.get("filepath")).getText();
    }
}

