/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.concierge.plugin.tabulator.indexer;

import java.util.ArrayList;
import java.util.Hashtable;
import jp.sourceforge.concierge.framework.FrameworkPlugin;
import jp.sourceforge.concierge.mdocument.DataDomImpl;
import jp.sourceforge.concierge.mdocument.TypeDomImpl;
import jp.sourceforge.concierge.parser.ITypeParser;
import jp.sourceforge.concierge.plugin.tabulator.InternalTabulator;
import jp.sourceforge.concierge.plugin.tabulator.indexer.ClassifyMethod;
import jp.sourceforge.concierge.plugin.tabulator.indexer.ItemList;
import jp.sourceforge.concierge.plugin.tabulator.indexer.SelectionAction;
import jp.sourceforge.concierge.util.GraphicUtil;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IMemento;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class InternalIndexer
extends Composite {
    private Composite topcomposite = this;
    private SashForm sf0;
    private SashForm sf1;
    private SashForm sf2;
    private ItemList typelist;
    private ItemList itemlist;
    private ItemList abclist;
    private ItemList valuelist;
    private InternalTabulator tabulator;
    private ArrayList<Document> documents;

    private String getParserByElementName(String type, String ename) {
        Document tdoc = FrameworkPlugin.getTypeDocument((String)type);
        Element e = TypeDomImpl.getElement((Document)tdoc, (String)ename);
        return TypeDomImpl.getParser((Element)e);
    }

    private void setDocumentsToTabulator(ArrayList<Document> docs, Document typedoc) {
        ArrayList<Document> d = new ArrayList<Document>();
        int i = 0;
        while (i < docs.size()) {
            Document doc = docs.get(i);
            if (!d.contains(doc)) {
                d.add(doc);
            }
            ++i;
        }
        this.tabulator.setDocuments(d, typedoc);
    }

    public InternalIndexer(Composite parent, int style, IMemento memento) {
        super(parent, style);
        GraphicUtil.setBackground((Control)this.topcomposite, (int)1);
        GridLayout gl = new GridLayout(1, true);
        gl.marginWidth = 0;
        gl.marginHeight = 0;
        gl.verticalSpacing = 0;
        gl.horizontalSpacing = 0;
        this.topcomposite.setLayout((Layout)gl);
        this.sf0 = new SashForm(this.topcomposite, 0);
        this.sf0.SASH_WIDTH = 2;
        this.sf0.setLayoutData((Object)new GridData(1808));
        GraphicUtil.setBackground((Control)this.sf0, (int)1);
        this.typelist = new ItemList(new Composite((Composite)this.sf0, 2048), true);
        this.sf1 = new SashForm((Composite)this.sf0, 0);
        this.sf1.SASH_WIDTH = 2;
        GraphicUtil.setBackground((Control)this.sf1, (int)1);
        this.typelist.setClassifyMethod(new ClassifyMethod(){

            @Override
            public Hashtable<String, ArrayList<Document>> classify(ArrayList<Document> docs) {
                Hashtable<String, ArrayList<Document>> ht = new Hashtable<String, ArrayList<Document>>();
                ht.put("[ALL]", docs);
                int i = 0;
                while (i < docs.size()) {
                    Document ddoc = docs.get(i);
                    ArrayList types = DataDomImpl.getAllTypesAsArray((Document)ddoc);
                    int j = 0;
                    while (j < types.size()) {
                        String type = (String)types.get(j);
                        ArrayList<Document> dl = ht.get(type);
                        if (dl != null) {
                            dl.add(ddoc);
                        } else {
                            dl = new ArrayList();
                            dl.add(ddoc);
                            ht.put(type, dl);
                        }
                        ++j;
                    }
                    ++i;
                }
                return ht;
            }
        });
        this.typelist.setAction(new SelectionAction(){

            @Override
            public void run(String selection, ArrayList<Document> seldocs) {
                if (selection.equals("[ALL]")) {
                    selection = "Unclassified";
                }
                Document tdoc = FrameworkPlugin.getTypeDocument((String)selection);
                InternalIndexer.this.valuelist.clear();
                InternalIndexer.this.abclist.clear();
                InternalIndexer.this.itemlist.setDocuments(seldocs);
                InternalIndexer.this.setDocumentsToTabulator(seldocs, tdoc);
            }
        });
        this.itemlist = new ItemList(new Composite((Composite)this.sf1, 2048), false);
        this.sf2 = new SashForm((Composite)this.sf1, 0);
        this.sf2.SASH_WIDTH = 2;
        GraphicUtil.setBackground((Control)this.sf2, (int)1);
        this.itemlist.setClassifyMethod(new ClassifyMethod(){

            @Override
            public Hashtable<String, ArrayList<Document>> classify(ArrayList<Document> docs) {
                String type = InternalIndexer.this.typelist.getSelection();
                if (type.equals("[ALL]")) {
                    type = "Unclassified";
                }
                Document tdoc = FrameworkPlugin.getTypeDocument((String)type);
                ArrayList elems = TypeDomImpl.getAllElements((Document)tdoc);
                Hashtable<String, ArrayList<Document>> ht = new Hashtable<String, ArrayList<Document>>();
                int i = 0;
                while (i < elems.size()) {
                    Element e = (Element)elems.get(i);
                    if (TypeDomImpl.getIndex((Element)e)) {
                        String s = TypeDomImpl.getElementName((Element)e);
                        ht.put(s, docs);
                    }
                    ++i;
                }
                return ht;
            }
        });
        this.itemlist.setAction(new SelectionAction(){

            @Override
            public void run(String selection, ArrayList<Document> seldocs) {
                String type = InternalIndexer.this.typelist.getSelection();
                if (type.equals("[ALL]")) {
                    type = "Unclassified";
                }
                Document tdoc = FrameworkPlugin.getTypeDocument((String)type);
                InternalIndexer.this.valuelist.clear();
                InternalIndexer.this.abclist.setDocuments(seldocs);
                InternalIndexer.this.setDocumentsToTabulator(seldocs, tdoc);
            }
        });
        this.abclist = new ItemList(new Composite((Composite)this.sf2, 2048), true);
        this.abclist.setClassifyMethod(new ClassifyMethod(){

            @Override
            public Hashtable<String, ArrayList<Document>> classify(ArrayList<Document> docs) {
                String type = InternalIndexer.this.typelist.getSelection();
                if (type.equals("[ALL]")) {
                    type = "Unclassified";
                }
                String item = InternalIndexer.this.itemlist.getSelection();
                String pname = InternalIndexer.this.getParserByElementName(type, item);
                ITypeParser ip = FrameworkPlugin.getParser((String)pname);
                Hashtable<String, ArrayList<Document>> ht = new Hashtable<String, ArrayList<Document>>();
                int i = 0;
                while (i < docs.size()) {
                    Document doc = docs.get(i);
                    Element dtop = DataDomImpl.getDataOfType((Document)doc, (String)type);
                    Element delem = DataDomImpl.getElement((Element)dtop, (String)item);
                    ArrayList list = ip.getIndexABC(delem);
                    if (list != null) {
                        int j = 0;
                        while (j < list.size()) {
                            String initial = (String)list.get(j);
                            if (initial.trim().length() != 0) {
                                ArrayList<Document> dl = ht.get(initial);
                                if (dl == null) {
                                    dl = new ArrayList();
                                    ht.put(initial, dl);
                                }
                                dl.add(doc);
                            }
                            ++j;
                        }
                    }
                    ++i;
                }
                return ht;
            }
        });
        this.abclist.setAction(new SelectionAction(){

            @Override
            public void run(String selection, ArrayList<Document> seldocs) {
                String type = InternalIndexer.this.typelist.getSelection();
                if (type.equals("[ALL]")) {
                    type = "Unclassified";
                }
                Document tdoc = FrameworkPlugin.getTypeDocument((String)type);
                InternalIndexer.this.valuelist.setDocuments(seldocs);
                InternalIndexer.this.setDocumentsToTabulator(seldocs, tdoc);
            }
        });
        this.valuelist = new ItemList(new Composite((Composite)this.sf2, 2048), true);
        this.valuelist.setClassifyMethod(new ClassifyMethod(){

            @Override
            public Hashtable<String, ArrayList<Document>> classify(ArrayList<Document> docs) {
                String type = InternalIndexer.this.typelist.getSelection();
                String item = InternalIndexer.this.itemlist.getSelection();
                String abc = InternalIndexer.this.abclist.getSelection();
                if (type.equals("[ALL]")) {
                    type = "Unclassified";
                }
                String pname = InternalIndexer.this.getParserByElementName(type, item);
                ITypeParser ip = FrameworkPlugin.getParser((String)pname);
                Hashtable<String, ArrayList<Document>> ht = new Hashtable<String, ArrayList<Document>>();
                int i = 0;
                while (i < docs.size()) {
                    Document doc = docs.get(i);
                    Element dtop = DataDomImpl.getDataOfType((Document)doc, (String)type);
                    Element delem = DataDomImpl.getElement((Element)dtop, (String)item);
                    ArrayList list = ip.getIndexValues(delem, abc);
                    if (list != null) {
                        int j = 0;
                        while (j < list.size()) {
                            String iname = (String)list.get(j);
                            if (iname.trim().length() != 0) {
                                ArrayList<Document> dl = ht.get(iname);
                                if (dl == null) {
                                    dl = new ArrayList();
                                    ht.put(iname, dl);
                                }
                                dl.add(doc);
                            }
                            ++j;
                        }
                    }
                    ++i;
                }
                return ht;
            }
        });
        this.valuelist.setAction(new SelectionAction(){

            @Override
            public void run(String selection, ArrayList<Document> seldocs) {
                String type = InternalIndexer.this.typelist.getSelection();
                if (type.equals("[ALL]")) {
                    type = "Unclassified";
                }
                Document tdoc = FrameworkPlugin.getTypeDocument((String)type);
                InternalIndexer.this.setDocumentsToTabulator(seldocs, tdoc);
            }
        });
        try {
            Integer sf0rat = memento.getInteger("SF0RATIO");
            int sf0r = sf0rat != null ? sf0rat : 25;
            Integer sf1rat = memento.getInteger("SF1RATIO");
            int sf1r = sf1rat != null ? sf1rat : 33;
            Integer sf2rat = memento.getInteger("SF2RATIO");
            int sf2r = sf2rat != null ? sf2rat : 50;
            this.sf0.setWeights(new int[]{sf0r, 100 - sf0r});
            this.sf1.setWeights(new int[]{sf1r, 100 - sf1r});
            this.sf2.setWeights(new int[]{sf2r, 100 - sf2r});
        }
        catch (Exception exception) {
            this.sf0.setWeights(new int[]{25, 75});
            this.sf1.setWeights(new int[]{33, 67});
            this.sf2.setWeights(new int[]{50, 50});
        }
    }

    public void setDocuments(ArrayList<Document> docs, boolean noreset) {
        String stype = this.typelist.getSelection();
        String itype = this.itemlist.getSelection();
        String atype = this.abclist.getSelection();
        String vtype = this.valuelist.getSelection();
        this.typelist.clear();
        this.itemlist.clear();
        this.abclist.clear();
        this.valuelist.clear();
        this.documents = docs;
        this.typelist.setDocuments(this.documents);
        this.setTabulatorAll();
        if (noreset) {
            boolean res = false;
            if (stype != null) {
                res = this.typelist.setSelection(stype);
            }
            if (itype != null && res) {
                res = this.itemlist.setSelection(itype);
            }
            if (atype != null && res) {
                res = this.abclist.setSelection(atype);
            }
            if (vtype != null && res) {
                this.valuelist.setSelection(vtype);
            }
        }
    }

    public void addDocuments(ArrayList<Document> docs, boolean noreset) {
        String stype = this.typelist.getSelection();
        String itype = this.itemlist.getSelection();
        String atype = this.abclist.getSelection();
        String vtype = this.valuelist.getSelection();
        this.typelist.clear();
        this.itemlist.clear();
        this.abclist.clear();
        this.valuelist.clear();
        if (this.documents != null) {
            this.documents.addAll(docs);
        } else {
            this.documents = docs;
        }
        this.typelist.setDocuments(this.documents);
        this.setTabulatorAll();
        if (noreset) {
            boolean res = false;
            if (stype != null) {
                res = this.typelist.setSelection(stype);
            }
            if (itype != null && res) {
                res = this.itemlist.setSelection(itype);
            }
            if (atype != null && res) {
                res = this.abclist.setSelection(atype);
            }
            if (vtype != null && res) {
                this.valuelist.setSelection(vtype);
            }
        }
    }

    public void setTabulator(InternalTabulator tbl) {
        this.tabulator = tbl;
    }

    public void setTabulatorAll() {
        this.valuelist.deselect();
        this.abclist.deselect();
        this.itemlist.deselect();
        this.typelist.deselect();
        this.tabulator.setDocuments(this.documents, null);
    }

    public void saveState(IMemento memento) {
        int[] sf0ratio = this.sf0.getWeights();
        int[] sf1ratio = this.sf1.getWeights();
        int[] sf2ratio = this.sf2.getWeights();
        memento.putInteger("SF0RATIO", sf0ratio[0] * 100 / (sf0ratio[0] + sf0ratio[1]));
        memento.putInteger("SF1RATIO", sf1ratio[0] * 100 / (sf1ratio[0] + sf1ratio[1]));
        memento.putInteger("SF2RATIO", sf2ratio[0] * 100 / (sf2ratio[0] + sf2ratio[1]));
    }
}

