/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.concierge.plugin.ipapers.download;

import java.io.BufferedReader;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jp.sourceforge.concierge.framework.FrameworkPlugin;
import jp.sourceforge.concierge.plugin.IPapersPlugin;
import jp.sourceforge.concierge.plugin.ipapers.download.BioMedCentral;
import jp.sourceforge.concierge.plugin.ipapers.download.BlackwellSynergy;
import jp.sourceforge.concierge.plugin.ipapers.download.Highwire;
import jp.sourceforge.concierge.plugin.ipapers.download.Interscience;
import jp.sourceforge.concierge.plugin.ipapers.download.JournalOfVision;
import jp.sourceforge.concierge.plugin.ipapers.download.JournalPDFSite;
import jp.sourceforge.concierge.plugin.ipapers.download.MitPressJournals;
import jp.sourceforge.concierge.plugin.ipapers.download.Nature;
import jp.sourceforge.concierge.plugin.ipapers.download.Oxford;
import jp.sourceforge.concierge.plugin.ipapers.download.PDFDownloadException;
import jp.sourceforge.concierge.plugin.ipapers.download.PubMedCentral;
import jp.sourceforge.concierge.plugin.ipapers.download.Science;
import jp.sourceforge.concierge.plugin.ipapers.download.ScienceDirect;
import jp.sourceforge.concierge.plugin.ipapers.download.Springer;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.MultiThreadedHttpConnectionManager;
import org.apache.commons.httpclient.methods.GetMethod;

public class downloadPDF {
    private HttpClient client;
    private String url;
    private String targetHostName;

    public downloadPDF(String u) {
        this.url = u;
        this.client = new HttpClient((HttpConnectionManager)new MultiThreadedHttpConnectionManager());
        String proxyHost = FrameworkPlugin.getDefault().GetHttpProxyHost();
        if (proxyHost != null && proxyHost.length() != 0) {
            int proxyPort = Integer.valueOf(FrameworkPlugin.getDefault().GetHttpProxyPort());
            this.client.getHostConfiguration().setProxy(proxyHost, proxyPort);
        }
    }

    public String targetHost() {
        return this.targetHostName;
    }

    private void ncbiLink(GetMethod method) {
        String t = this.searchJournalSiteLink(method);
        if (t != null) {
            downloadPDF dl = new downloadPDF(t);
            method.releaseConnection();
            method = new GetMethod(t);
            int iGetResultCode = 0;
            try {
                iGetResultCode = this.client.executeMethod((HttpMethod)method);
            }
            catch (HttpException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            if (IPapersPlugin.log.isDebugEnabled()) {
                IPapersPlugin.log.debug((Object)("result code:" + iGetResultCode));
            }
            this.targetHostName = dl.targetHost();
        }
        if (IPapersPlugin.log.isDebugEnabled()) {
            IPapersPlugin.log.debug((Object)("new host:" + this.targetHostName));
        }
    }

    private JournalPDFSite selectJorunalSite(String hostname) throws PDFDownloadException {
        InetAddress host = null;
        try {
            host = InetAddress.getByName(hostname);
        }
        catch (UnknownHostException e) {
            throw new PDFDownloadException(e.getMessage());
        }
        byte[] IPv4address = host.getAddress();
        if (this.targetHostName.indexOf("sciencedirect.com") >= 0) {
            return new ScienceDirect(hostname);
        }
        if (this.targetHostName.indexOf("journalofvision.org") >= 0) {
            return new JournalOfVision(hostname);
        }
        if (this.targetHostName.indexOf("www.pubmedcentral.gov") >= 0) {
            return new PubMedCentral(hostname);
        }
        if (this.targetHostName.indexOf("www.springerlink.com") >= 0) {
            return new Springer(hostname);
        }
        if (this.targetHostName.indexOf("interscience.wiley.com") >= 0) {
            return new Interscience(hostname);
        }
        if (this.targetHostName.indexOf("nature.com") >= 0) {
            return new Nature(hostname);
        }
        if (this.targetHostName.indexOf("sciencemag.org") >= 0) {
            return new Science(hostname);
        }
        if (this.targetHostName.indexOf("oxfordjournals.org") >= 0) {
            return new Oxford(hostname);
        }
        if (this.targetHostName.indexOf("biomedcentral.com") >= 0) {
            return new BioMedCentral(hostname);
        }
        if (this.targetHostName.indexOf("mitpressjournals.org") >= 0) {
            return new MitPressJournals(hostname);
        }
        if (this.targetHostName.indexOf("blackwell-synergy.com") >= 0) {
            return new BlackwellSynergy(hostname);
        }
        if ((IPv4address[0] & 0xFFFFFFFF) == -85 && (IPv4address[1] & 0xFFFFFFFC) == 64) {
            return new Highwire(hostname);
        }
        throw new PDFDownloadException("This journal site is not impremented yet");
    }

    public String PDFLocation() throws PDFDownloadException {
        GetMethod method = new GetMethod(this.url);
        method.setFollowRedirects(true);
        try {
            this.client.executeMethod((HttpMethod)method);
            this.targetHostName = this.getRequestHeader(method, "Host");
            if (this.targetHostName.indexOf("ncbi.nlm.nih.gov") > 0) {
                this.ncbiLink(method);
            }
            JournalPDFSite journalPDFSite = this.selectJorunalSite(this.targetHostName);
            InputStream is = method.getResponseBodyAsStream();
            String string = journalPDFSite.PDFlinkOfFile(is);
            return string;
        }
        catch (IOException e) {
            throw new PDFDownloadException(e.getMessage());
        }
        catch (PDFDownloadException e) {
            throw e;
        }
        finally {
            method.releaseConnection();
        }
    }

    public String getResponseHeader(GetMethod method, String key) {
        Header header = method.getResponseHeader(key);
        if (header == null) {
            return null;
        }
        return header.getValue();
    }

    public String getRequestHeader(GetMethod method, String key) {
        Header header = method.getRequestHeader(key);
        if (header == null) {
            return null;
        }
        return header.getValue();
    }

    public void fetchPDF(String uri, String PDFfilepath) throws PDFDownloadException {
        GetMethod method = new GetMethod(uri);
        method.setFollowRedirects(true);
        try {
            try {
                this.client.executeMethod((HttpMethod)method);
                String contentType = this.getResponseHeader(method, "Content-Type");
                if (contentType.compareToIgnoreCase("application/pdf") != 0) {
                    throw new PDFDownloadException("Content-Type is not pdf" + contentType);
                }
                InputStream is = method.getResponseBodyAsStream();
                FileOutputStream fos = new FileOutputStream(PDFfilepath);
                this.copy(is, fos);
            }
            catch (IOException ex) {
                throw new PDFDownloadException("error: " + ex.getMessage());
            }
        }
        finally {
            method.releaseConnection();
        }
    }

    public void copy(InputStream in, OutputStream out) throws IOException {
        try {
            int buf;
            while ((buf = in.read()) != -1) {
                out.write(buf);
            }
        }
        finally {
            IOException ioe = null;
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException e) {
                    ioe = e;
                }
            }
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    ioe = e;
                }
            }
            if (ioe != null) {
                throw ioe;
            }
        }
    }

    public String searchJournalSiteLink(GetMethod method) {
        Pattern pattern = Pattern.compile("&url=http://\\S+");
        String targetUrl = null;
        try {
            InputStream is = method.getResponseBodyAsStream();
            InputStreamReader in = new InputStreamReader(is, "ISO-8859-1");
            BufferedReader br = new BufferedReader(in);
            String line = null;
            while ((line = br.readLine()) != null) {
                Matcher matcher = pattern.matcher(line);
                if (!matcher.find(0)) continue;
                targetUrl = line.substring(matcher.start() + 5, matcher.end() - 1);
                break;
            }
            br.close();
            in.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return targetUrl;
    }
}

