/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.concierge.widget;

import java.util.Timer;
import java.util.TimerTask;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Shell;

public class Drawer
extends Dialog {
    private Shell parent;
    private int currenthratio = 0;
    private int drawerwidth = 0;
    private boolean opened = false;
    private ControlAdapter ctrlAdapter = null;
    private DisposeListener dispAdapter = null;
    private static final int MOVERATIO = 10;

    protected void show() {
        Timer tm = new Timer(true);
        TimerTask tt = new TimerTask(){

            public void run() {
                if (Drawer.this.dialogArea.isDisposed()) {
                    tm.cancel();
                    return;
                }
                Drawer.this.getContents().getDisplay().syncExec(new Runnable(){

                    public void run() {
                        if (Drawer.this.currenthratio == 0) {
                            Drawer.this.parent.setActive();
                        }
                        Drawer drawer = Drawer.this;
                        drawer.currenthratio = drawer.currenthratio + 10;
                        Drawer.this.resize(Drawer.this.currenthratio);
                        if (Drawer.this.currenthratio == 100) {
                            Drawer.this.getShell().setFocus();
                            tm.cancel();
                            Drawer.this.opened = true;
                            Drawer.this.parent.addControlListener((ControlListener)Drawer.this.ctrlAdapter);
                            Drawer.this.parent.addDisposeListener(Drawer.this.dispAdapter);
                        }
                    }
                });
            }
        };
        tm.schedule(tt, 0L, 6L);
    }

    protected void hide() {
        Timer tm = new Timer(true);
        TimerTask tt = new TimerTask(){

            public void run() {
                if (Drawer.this.dialogArea.isDisposed()) {
                    tm.cancel();
                    return;
                }
                Drawer.this.getContents().getDisplay().syncExec(new Runnable(){

                    public void run() {
                        if (Drawer.this.currenthratio == 100) {
                            Drawer.this.parent.setActive();
                        }
                        Drawer drawer = Drawer.this;
                        drawer.currenthratio = drawer.currenthratio - 10;
                        Drawer.this.resize(Drawer.this.currenthratio);
                        if (Drawer.this.currenthratio < 0) {
                            Drawer.this.opened = false;
                            Drawer.super.close();
                            tm.cancel();
                        }
                    }
                });
            }
        };
        this.parent.setActive();
        tm.schedule(tt, 0L, 6L);
    }

    protected void resize(int hratio) {
        Rectangle p = this.parent.getBounds();
        Shell sh = this.getShell();
        sh.setBounds(p.x + p.width - this.drawerwidth * (100 - hratio) / 100, p.y + 10, hratio <= 0 ? 0 : this.drawerwidth, p.height - 30);
    }

    public Drawer(Shell parent, int width) {
        super(new Shell(parent.getParent().getShell(), 8));
        this.setShellStyle(8);
        this.setBlockOnOpen(false);
        this.parent = parent;
        this.drawerwidth = width;
    }

    protected void initializeBounds() {
        this.currenthratio = 0;
        this.parent.setActive();
        Rectangle p = this.parent.getBounds();
        if (p.width <= this.drawerwidth) {
            this.drawerwidth = p.width - 5;
        }
        this.resize(this.currenthratio);
        this.ctrlAdapter = new ControlAdapter(){

            public void controlMoved(ControlEvent e) {
                if (!Drawer.this.opened) {
                    return;
                }
                Drawer.this.currenthratio = 100;
                Drawer.this.resize(Drawer.this.currenthratio);
            }

            public void controlResized(ControlEvent e) {
                this.controlMoved(e);
            }
        };
        this.dispAdapter = new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (!Drawer.this.opened) {
                    return;
                }
                Drawer.this.opened = false;
                Drawer.super.close();
            }
        };
        this.show();
    }

    public int open() {
        if (this.opened) {
            return -1;
        }
        return super.open();
    }

    public boolean close() {
        if (!this.opened) {
            return true;
        }
        this.parent.removeControlListener((ControlListener)this.ctrlAdapter);
        this.parent.removeDisposeListener(this.dispAdapter);
        this.hide();
        return true;
    }

    public boolean isOpened() {
        return this.opened;
    }
}

