/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.concierge.framework;

import java.io.File;
import java.util.ArrayList;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathFactory;
import jp.sourceforge.concierge.contentassist.WordList;
import jp.sourceforge.concierge.database.DatabaseManager;
import jp.sourceforge.concierge.database.IDatabaseAdapter;
import jp.sourceforge.concierge.database.IDatabasePlugin;
import jp.sourceforge.concierge.database.cache.ContentCache;
import jp.sourceforge.concierge.event.CCGUpdateEvent;
import jp.sourceforge.concierge.event.CCGUpdateType;
import jp.sourceforge.concierge.event.ICCGUpdateListener;
import jp.sourceforge.concierge.framework.AbstractDocumentUIPlugin;
import jp.sourceforge.concierge.framework.CCG;
import jp.sourceforge.concierge.framework.DatabaseConfigDialog;
import jp.sourceforge.concierge.framework.PluginManager;
import jp.sourceforge.concierge.framework.Request;
import jp.sourceforge.concierge.mdocument.DataDomImpl;
import jp.sourceforge.concierge.mdocument.DataSchemaConverter;
import jp.sourceforge.concierge.mdocument.DomImpl;
import jp.sourceforge.concierge.mdocument.TypeManager;
import jp.sourceforge.concierge.parser.ITypeParser;
import jp.sourceforge.concierge.parser.ParserManager;
import jp.sourceforge.concierge.util.CCGFileUtils;
import jp.sourceforge.concierge.util.GraphicUtil;
import jp.sourceforge.concierge.util.XPathString;
import org.apache.commons.io.FilenameUtils;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.update.core.SiteManager;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.w3c.dom.Document;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FrameworkPlugin
extends AbstractDocumentUIPlugin {
    public static final String TYPECOLLECTIONNAME = "type";
    public static final String DATACOLLECTIONNAME = "data";
    public static final String CONFCOLLECTIONNAME = "ccgconfig";
    private static FrameworkPlugin plugin;
    BundleContext bundlecontext;
    private ContentCache tcmanager;
    private DatabaseManager databases;
    private IDatabasePlugin currentdb;
    private long lastupdtime = 0L;
    static final String BUNDLE_NAME = "jp.sourceforge.concierge.framework.messages";
    static final ResourceBundle RESOURCE_BUNDLE;

    static {
        RESOURCE_BUNDLE = ResourceBundle.getBundle(BUNDLE_NAME);
    }

    private void createDBLabel(String dbpath) {
        try {
            File dblabel = new File(String.valueOf(dbpath) + File.separator + ".db.v2.0");
            if (dblabel.exists()) {
                return;
            }
            dblabel.createNewFile();
        }
        catch (Throwable throwable) {}
    }

    private boolean isDBLabelExists(String dbpath) {
        File dblabel = new File(String.valueOf(dbpath) + File.separator + ".db.v2.0");
        return dblabel.exists();
    }

    private void configureDatabase() {
        Display disp;
        Shell shell;
        DatabaseConfigDialog dcd;
        ArrayList<String> dbnames = this.databases.getAllDatabases();
        if (dbnames.size() == 0) {
            System.err.println("No database found. Abort!!");
            System.exit(0);
        }
        if ((dcd = new DatabaseConfigDialog(shell = new Shell(disp = PlatformUI.createDisplay()), dbnames, CCG.isConciergeRCP())).open() == 1) {
            shell.dispose();
            System.err.println("No database specified. Abort!!");
            System.exit(0);
        }
        String dbname = dcd.getDatabaseName();
        String dbpath = dcd.getDatabaseDirectory();
        shell.dispose();
        if (dbname == null || dbpath == null) {
            System.err.println("No database specified. Abort!!");
            System.exit(0);
        }
        this.getPreferenceStore().setValue("CCGDatabaseName", dbname);
        this.getPreferenceStore().setValue("Database Directory", dbpath);
    }

    public FrameworkPlugin() {
        plugin = this;
        this.databases = new DatabaseManager();
        this.currentdb = null;
    }

    public void start(BundleContext context) throws Exception {
        Bundle[] bundles;
        block13: {
            super.start(context);
            this.bundlecontext = context;
            bundles = context.getBundles();
            try {
                this.databases.initialize(bundles);
            }
            catch (Exception e) {
                if (e == null) break block13;
                System.err.println(e.getMessage());
            }
        }
        String dbname = this.getPreferenceStore().getString("CCGDatabaseName");
        boolean newdb = false;
        if (dbname.length() == 0) {
            this.configureDatabase();
            dbname = this.getPreferenceStore().getString("CCGDatabaseName");
            this.currentdb = this.databases.getDatabasePlugin(dbname);
            newdb = true;
        } else {
            this.currentdb = this.databases.getDatabasePlugin(dbname);
            String dbhome = this.currentdb.getLocalDatabaseDirectory(this.getPreferenceStore().getString("Database Directory"));
            File dbf = new File(dbhome);
            if (!dbf.exists()) {
                this.configureDatabase();
                newdb = true;
            }
        }
        ArrayList<String> props = this.currentdb.getProperties();
        int i = 0;
        while (i < props.size()) {
            String p = this.getPreferenceStore().getString(props.get(i));
            if (p.length() > 0) {
                this.currentdb.setProperty(props.get(i), p);
            } else {
                this.getPreferenceStore().setValue(props.get(i), this.currentdb.getProperty(props.get(i)));
            }
            ++i;
        }
        if (this.currentdb.getInstance(TYPECOLLECTIONNAME) == null || this.currentdb.getInstance(DATACOLLECTIONNAME) == null) {
            PluginManager.stopPlugins(bundles);
            System.err.println("Quit concierge");
            System.exit(0);
        }
        this.currentdb.getInstance(DATACOLLECTIONNAME).addIndex("filepath", "mdata@filepath");
        this.currentdb.getInstance(DATACOLLECTIONNAME).addIndex("did", "mdata@id");
        this.currentdb.getInstance(CONFCOLLECTIONNAME).addIndex("cid", "ccgconfig@id");
        this.currentdb.getInstance(DATACOLLECTIONNAME).addIndex("doctypelist", "data@name");
        this.currentdb.getInstance(DATACOLLECTIONNAME).addListener(new ICCGUpdateListener(){

            public void updated(CCGUpdateEvent ev) {
                if (!ev.success.booleanValue()) {
                    return;
                }
                if (!ev.collection.equals(FrameworkPlugin.DATACOLLECTIONNAME)) {
                    return;
                }
                if (ev.type != CCGUpdateType.DEL_DOCUMENT) {
                    return;
                }
                int i = 0;
                while (i < ev.documents.size()) {
                    FrameworkPlugin.removeThumbnailImage(DomImpl.getID(ev.documents.get(i)));
                    ++i;
                }
            }
        });
        this.initializePreferences();
        File tcachedir = new File(this.getTextCacheDir());
        if (!tcachedir.exists()) {
            tcachedir.mkdir();
        }
        this.tcmanager = new ContentCache(tcachedir.getAbsolutePath());
        FrameworkPlugin.getDefault().getPreferenceStore().setValue("CCGDatabaseName", this.currentdb.getDatabaseName());
        ArrayList<String> properties = this.currentdb.getProperties();
        int i2 = 0;
        while (i2 < properties.size()) {
            String p = properties.get(i2);
            FrameworkPlugin.getDefault().getPreferenceStore().setValue(p, this.currentdb.getProperty(p));
            ++i2;
        }
        TypeManager.initializeTypeXML();
        String dbhome = this.currentdb.getLocalDatabaseDirectory();
        if (newdb) {
            this.createDBLabel(dbhome);
        }
        if (!this.isDBLabelExists(dbhome)) {
            DataSchemaConverter.convertDataToMData(dbhome);
            this.createDBLabel(dbhome);
        }
        TypeManager.updateDatabase();
        plugin.savePluginPreferences();
        WordList.load();
    }

    public void stop(BundleContext context) throws Exception {
        super.stop(context);
        plugin = null;
    }

    public static FrameworkPlugin getDefault() {
        return plugin;
    }

    public static Document getDocumentByID(String collection, long id) {
        String xpath = "/child::*[@id='" + String.valueOf(id) + "']";
        ArrayList<Document> docs = FrameworkPlugin.plugin.currentdb.getInstance(collection).query(xpath);
        return docs == null || docs.size() == 0 ? null : docs.get(0);
    }

    public static Document getDocumentByFilePath(String path) {
        String xpath = "/mdata[" + XPathString.getAttributeEqualsPredicate("filepath", path) + "]";
        ArrayList<Document> docs = FrameworkPlugin.plugin.currentdb.getInstance(DATACOLLECTIONNAME).query(xpath);
        if (docs == null || docs.size() == 0) {
            return null;
        }
        return docs.get(0);
    }

    public static boolean isInstalledPlugin(String pluginid) {
        return Platform.getBundle((String)pluginid) != null;
    }

    public static String[] getAllParserTypes() {
        return ParserManager.getAllParserTypes();
    }

    public static ITypeParser getParser(String parser) {
        return ParserManager.getInstance(parser);
    }

    public static boolean containsParser(String parser) {
        return ParserManager.contains(parser);
    }

    public static IDatabasePlugin getDatabasePlugin(String dbname) {
        return FrameworkPlugin.plugin.databases.getDatabasePlugin(dbname);
    }

    public static ArrayList<String> getAllDatabases() {
        return FrameworkPlugin.plugin.databases.getAllDatabases();
    }

    public static ImageDescriptor getImageDescriptor(String path) {
        return AbstractUIPlugin.imageDescriptorFromPlugin((String)"jp.sourceforge.concierge.framework", (String)path);
    }

    public static ArrayList<Document> getAllTypeDocuments() {
        Request r = new Request(4, "/type", TYPECOLLECTIONNAME);
        return FrameworkPlugin.getDocumentsOfQuery(r);
    }

    public static Document getTypeDocument(String type) {
        Request r = new Request(4, "/type[@name='" + type + "']", TYPECOLLECTIONNAME);
        ArrayList<Document> docs = FrameworkPlugin.getDocumentsOfQuery(r);
        if (docs == null) {
            return null;
        }
        return docs.get(0);
    }

    public static ArrayList<Document> getDocumentsOfQuery(Request req) {
        ArrayList<Document> alldocs = FrameworkPlugin.plugin.currentdb.getInstance(req.collection).query((String)req.data);
        return alldocs;
    }

    public static ArrayList<Document> getDocumentsOfQuery(ArrayList<Document> docs, String xpath) {
        try {
            ArrayList<Document> rdocs = new ArrayList<Document>();
            XPathFactory factory = XPathFactory.newInstance();
            XPath xp = factory.newXPath();
            XPathExpression expr = xp.compile(xpath);
            int i = 0;
            while (i < docs.size()) {
                Document doc = docs.get(i);
                if (((Boolean)expr.evaluate(doc, XPathConstants.BOOLEAN)).booleanValue()) {
                    rdocs.add(doc);
                }
                ++i;
            }
            return rdocs;
        }
        catch (Exception exception) {
            return docs;
        }
    }

    public static ArrayList<Document> getDocumentsOfQuery(String words) {
        ArrayList<Document> docs = new ArrayList<Document>();
        ArrayList<String> files = FrameworkPlugin.plugin.tcmanager.search(words);
        if (files == null) {
            return docs;
        }
        int i = 0;
        while (i < files.size()) {
            String idstr = FilenameUtils.getBaseName((String)files.get(i));
            Document doc = FrameworkPlugin.getDocumentByID(DATACOLLECTIONNAME, Long.parseLong(idstr));
            if (doc != null) {
                docs.add(doc);
            }
            ++i;
        }
        return docs;
    }

    private String getDatabaseDir(String path) {
        File f;
        String dbdir = this.currentdb.getLocalDatabaseDirectory();
        if (dbdir == null) {
            dbdir = System.getProperty("user.home");
        }
        if (!(f = new File(dbdir = String.valueOf(dbdir) + File.separator + path)).exists()) {
            f.mkdir();
        }
        return dbdir;
    }

    private String getTextCacheDir() {
        return this.getDatabaseDir(".textcache");
    }

    private String getSystemFileDir() {
        return this.getDatabaseDir(".import");
    }

    private void adddocument(IDatabaseAdapter adapter, ArrayList<Document> docs, boolean syncmode, Object sender) {
        if (!adapter.append(docs, syncmode, sender)) {
            return;
        }
        this.lastupdtime = System.currentTimeMillis();
        if (adapter.getCollectionName().compareTo(DATACOLLECTIONNAME) != 0) {
            return;
        }
        try {
            int i = 0;
            while (i < docs.size()) {
                String path = DataDomImpl.getFilePath(docs.get(i));
                if (path != null && path.length() != 0) {
                    this.tcmanager.add(path, DomImpl.getID(docs.get(i)));
                }
                ++i;
            }
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
        }
    }

    private void deldocument(IDatabaseAdapter adapter, ArrayList<Document> docs, boolean syncmode, Object sender) {
        if (!adapter.delete(docs, syncmode, sender)) {
            return;
        }
        if (adapter.getCollectionName().compareTo(DATACOLLECTIONNAME) == 0) {
            String importdir = String.valueOf(this.currentdb.getLocalDatabaseDirectory()) + File.separator + ".concierge";
            int i = 0;
            while (i < docs.size()) {
                CCGFileUtils.deleteFile(importdir, DomImpl.getID(docs.get(i)));
                this.tcmanager.delete(DomImpl.getID(docs.get(i)));
                ++i;
            }
        }
        this.lastupdtime = System.currentTimeMillis();
    }

    private void upddocument(IDatabaseAdapter adapter, ArrayList<Document> docs, boolean syncmode, Object sender) {
        int i = 0;
        while (i < docs.size()) {
            DomImpl.setLastModifiedTime(docs.get(i), System.currentTimeMillis());
            ++i;
        }
        if (!adapter.update(docs, syncmode, sender)) {
            return;
        }
        try {
            i = 0;
            while (i < docs.size()) {
                String path = DataDomImpl.getFilePath(docs.get(i));
                if (path != null && path.length() != 0) {
                    long id = DomImpl.getID(docs.get(i));
                    this.tcmanager.delete(id);
                    this.tcmanager.add(path, id);
                }
                ++i;
            }
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
        }
        this.lastupdtime = System.currentTimeMillis();
    }

    public static boolean updateDocuments(ArrayList<Request> requests, boolean syncmode, Object sender) {
        int i = 0;
        while (i < requests.size()) {
            Request req = requests.get(i);
            IDatabaseAdapter dba = FrameworkPlugin.plugin.currentdb.getInstance(req.collection);
            ArrayList<Document> docs = new ArrayList<Document>();
            if (req.data instanceof Document) {
                docs.add((Document)req.data);
            } else if (req.data instanceof ArrayList) {
                docs.addAll((ArrayList)req.data);
            }
            switch (req.command) {
                case 1: {
                    plugin.adddocument(dba, docs, syncmode, sender);
                    break;
                }
                case 3: {
                    plugin.upddocument(dba, docs, syncmode, sender);
                    break;
                }
                case 2: {
                    plugin.deldocument(dba, docs, syncmode, sender);
                }
            }
            ++i;
        }
        return true;
    }

    public static boolean updateDocuments(ArrayList<Request> requests, Object sender) {
        return FrameworkPlugin.updateDocuments(requests, false, sender);
    }

    public static boolean updateDocuments(Request request, Object sender) {
        ArrayList<Request> reqs = new ArrayList<Request>();
        reqs.add(request);
        return FrameworkPlugin.updateDocuments(reqs, false, sender);
    }

    public static boolean updateDocuments(Request request, boolean syncmode, Object sender) {
        ArrayList<Request> reqs = new ArrayList<Request>();
        reqs.add(request);
        return FrameworkPlugin.updateDocuments(reqs, syncmode, sender);
    }

    public static boolean databaseUpdatedSince(long t) {
        return FrameworkPlugin.plugin.lastupdtime > t;
    }

    public static void addDatabaseListener(String collection, ICCGUpdateListener listener) {
        FrameworkPlugin.plugin.currentdb.getInstance(collection).addListener(listener);
    }

    public static void importSystemFile(String originalfile, String newfile) {
        CCGFileUtils.importFile(originalfile, plugin.getSystemFileDir(), newfile);
    }

    public static String findSystemFile(String file) {
        return CCGFileUtils.findFile(plugin.getSystemFileDir(), file);
    }

    public static void importUserFile(String originalfile, long id) {
        String oldfile = FrameworkPlugin.getPathFromID(id);
        if (oldfile != null) {
            File of = new File(oldfile);
            of.delete();
        }
        String importdir = plugin.getDatabaseDir(".concierge");
        String importname = String.valueOf(String.valueOf(id)) + "." + FilenameUtils.getExtension((String)originalfile);
        CCGFileUtils.importFile(originalfile, importdir, importname);
    }

    public static void setThumbnailImage(Image img, long id) {
        FrameworkPlugin.setThumbnailImage(img, id, 0);
    }

    public static void setThumbnailImage(Image img, long id, int type) {
        try {
            File f;
            String thumbnail = CCGFileUtils.findFile(plugin.getDatabaseDir(".thumbnail"), String.valueOf(id));
            if (thumbnail != null && (f = new File(thumbnail)).exists()) {
                f.delete();
            }
            String ext = "bmp";
            switch (type) {
                case 0: {
                    ext = "bmp";
                    break;
                }
                case 2: {
                    ext = "gif";
                    break;
                }
                case 4: {
                    ext = "jpg";
                    break;
                }
                case 5: {
                    ext = "png";
                    break;
                }
                case 6: {
                    ext = "tif";
                }
            }
            thumbnail = String.valueOf(plugin.getDatabaseDir(".thumbnail")) + File.separator + String.valueOf(id) + "." + ext;
            GraphicUtil.saveImage(img, thumbnail, type);
        }
        catch (Throwable t) {
            System.err.println(t.getMessage());
        }
    }

    public static void setThumbnailImage(String src, long id) {
        try {
            File f;
            String thumbnail = CCGFileUtils.findFile(plugin.getDatabaseDir(".thumbnail"), String.valueOf(id));
            if (thumbnail != null && (f = new File(thumbnail)).exists()) {
                f.delete();
            }
            String ext = FilenameUtils.getExtension((String)src);
            CCGFileUtils.importFile(src, plugin.getDatabaseDir(".thumbnail"), String.valueOf(String.valueOf(id)) + "." + ext);
        }
        catch (Throwable t) {
            System.err.println(t.getMessage());
        }
    }

    public static Image getThumbnailImage(long id) {
        String thumbnail;
        block3: {
            try {
                thumbnail = CCGFileUtils.findFile(plugin.getDatabaseDir(".thumbnail"), String.valueOf(String.valueOf(id)) + ".*");
                if (thumbnail != null) break block3;
                return null;
            }
            catch (Throwable t) {
                System.err.println(t.getMessage());
                return null;
            }
        }
        return GraphicUtil.loadImage(plugin.getWorkbench().getDisplay(), thumbnail);
    }

    public static void removeThumbnailImage(long id) {
        try {
            String thumbnail = CCGFileUtils.findFile(plugin.getDatabaseDir(".thumbnail"), String.valueOf(String.valueOf(id)) + ".*");
            if (thumbnail == null) {
                return;
            }
            File f = new File(thumbnail);
            f.delete();
            return;
        }
        catch (Throwable t) {
            System.err.println(t.getMessage());
            return;
        }
    }

    public static String getThumbnailFileDirectory() {
        try {
            return plugin.getDatabaseDir(".thumbnail");
        }
        catch (Throwable t) {
            System.err.println(t.getMessage());
            return null;
        }
    }

    public static String getPathFromID(long id) {
        String finddir = plugin.getDatabaseDir(".concierge");
        return CCGFileUtils.getPathFromID(finddir, id);
    }

    public static ArrayList<Document> getDocumentsByOriginalPath(String path) {
        Request req = new Request();
        req.collection = DATACOLLECTIONNAME;
        req.command = 4;
        req.data = "/mdata[@filepath='" + path + "']";
        req.options = 0;
        return FrameworkPlugin.getDocumentsOfQuery(req);
    }

    public static boolean isDocumentedByOriginalPath(String path) {
        return FrameworkPlugin.getDocumentsByOriginalPath(path).size() > 0;
    }

    public static String getLocalDatabaseDirectory() {
        if (FrameworkPlugin.plugin.currentdb == null) {
            return null;
        }
        return FrameworkPlugin.plugin.currentdb.getLocalDatabaseDirectory();
    }

    private void initializePreferences() {
        this.initHttpProxy();
    }

    private void initHttpProxy() {
        System.out.println("System Http Proxy Host = " + System.getProperty("http.proxyHost") + ", Port = " + System.getProperty("http.proxyPort") + ", Proxy = " + System.getProperty("http.proxySet"));
        String proxyHost = FrameworkPlugin.getDefault().GetHttpProxyHost();
        String proxyPort = FrameworkPlugin.getDefault().GetHttpProxyPort();
        boolean proxySet = FrameworkPlugin.getDefault().IsHttpProxyEnable();
        System.out.println("Preference Http Proxy Host = " + proxyHost + ", Port = " + proxyPort + ", Proxy = " + proxySet);
        if (proxySet) {
            System.setProperty("http.proxySet", "true");
        } else {
            System.setProperty("http.proxySet", "false");
        }
        if (proxyHost != null && proxyHost.length() > 0) {
            System.setProperty("http.proxyHost", proxyHost);
        }
        if (proxyPort != null && proxyPort.length() > 0) {
            System.setProperty("http.proxyPort", proxyPort);
        }
    }

    public String GetHttpProxyHost() {
        if (this.IsHttpProxyEnable()) {
            String proxyHost = SiteManager.getHttpProxyServer();
            return proxyHost;
        }
        return "";
    }

    public String GetHttpProxyPort() {
        if (this.IsHttpProxyEnable()) {
            String proxyPort = SiteManager.getHttpProxyPort();
            return proxyPort;
        }
        return "";
    }

    public boolean IsHttpProxyEnable() {
        return SiteManager.isHttpProxyEnable();
    }

    public static String getString(String key) {
        try {
            return RESOURCE_BUNDLE.getString(key);
        }
        catch (MissingResourceException missingResourceException) {
            return String.valueOf('!') + key + '!';
        }
    }
}

