/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.concierge.plugin.labnote;

import jp.sourceforge.concierge.plugin.LabNotePlugin;
import jp.sourceforge.concierge.plugin.labnote.CalendarTitleListener;
import jp.sourceforge.concierge.util.CalendarUtil;
import jp.sourceforge.concierge.util.GraphicUtil;
import jp.sourceforge.concierge.util.SystemUtil;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.ImageHyperlink;

public class CalendarTitle {
    private Label lyearmonth;
    private Font labelfont;
    private Composite rootcomp;
    CalendarTitleListener listener = null;
    int currentyear;
    int currentmonth;

    protected void finalize() throws Throwable {
        if (this.labelfont != null) {
            this.labelfont.dispose();
        }
    }

    public CalendarTitle(Composite parent, int year, int month) {
        int sz = SystemUtil.GetOSType() == 1 ? 12 : 8;
        this.labelfont = new Font((Device)parent.getDisplay(), "Helvetica", sz, 0);
        parent.setLayout((Layout)new GridLayout(7, true));
        this.rootcomp = new Composite(parent, 0);
        FormLayout fl = new FormLayout();
        fl.marginWidth = 0;
        fl.marginHeight = 0;
        this.rootcomp.setLayout((Layout)fl);
        GridData gdhc = new GridData(1808);
        gdhc.horizontalSpan = 7;
        this.rootcomp.setLayoutData((Object)gdhc);
        GraphicUtil.setBackground((Control)this.rootcomp, (int)1);
        this.lyearmonth = new Label(this.rootcomp, 0x1000000);
        FormData fd = new FormData();
        fd.left = new FormAttachment(50, -50);
        this.lyearmonth.setLayoutData((Object)fd);
        this.lyearmonth.setFont(this.labelfont);
        GraphicUtil.setBackground((Control)this.lyearmonth, (int)1);
        ImageHyperlink lb = new ImageHyperlink(this.rootcomp, 0x800000);
        FormData lbfd = new FormData();
        lbfd.right = new FormAttachment((Control)this.lyearmonth, -10);
        lb.setLayoutData((Object)lbfd);
        GraphicUtil.setBackground((Control)lb, (int)1);
        lb.setImage(LabNotePlugin.getImageDescriptor("icons/left.png").createImage());
        lb.addHyperlinkListener(new IHyperlinkListener(){

            public void linkEntered(HyperlinkEvent e) {
            }

            public void linkExited(HyperlinkEvent e) {
            }

            public void linkActivated(HyperlinkEvent e) {
                --CalendarTitle.this.currentmonth;
                if (CalendarTitle.this.currentmonth == 0) {
                    CalendarTitle.this.currentmonth = 12;
                    --CalendarTitle.this.currentyear;
                }
                CalendarTitle.this.setYearMonth(CalendarTitle.this.currentyear, CalendarTitle.this.currentmonth);
                if (CalendarTitle.this.listener != null) {
                    CalendarTitle.this.listener.calendarChanged(CalendarTitle.this.currentyear, CalendarTitle.this.currentmonth);
                }
            }
        });
        ImageHyperlink rb = new ImageHyperlink(this.rootcomp, 0x800000);
        FormData rbfd = new FormData();
        rbfd.left = new FormAttachment((Control)this.lyearmonth, 10);
        rb.setLayoutData((Object)rbfd);
        GraphicUtil.setBackground((Control)rb, (int)1);
        rb.setImage(LabNotePlugin.getImageDescriptor("icons/right.png").createImage());
        rb.addHyperlinkListener(new IHyperlinkListener(){

            public void linkEntered(HyperlinkEvent e) {
            }

            public void linkExited(HyperlinkEvent e) {
            }

            public void linkActivated(HyperlinkEvent e) {
                ++CalendarTitle.this.currentmonth;
                if (CalendarTitle.this.currentmonth == 13) {
                    CalendarTitle.this.currentmonth = 1;
                    ++CalendarTitle.this.currentyear;
                }
                CalendarTitle.this.setYearMonth(CalendarTitle.this.currentyear, CalendarTitle.this.currentmonth);
                if (CalendarTitle.this.listener != null) {
                    CalendarTitle.this.listener.calendarChanged(CalendarTitle.this.currentyear, CalendarTitle.this.currentmonth);
                }
            }
        });
        this.currentyear = year;
        this.currentmonth = month;
        this.lyearmonth.setText(CalendarUtil.getDateString((int)year, (int)month));
        this.lyearmonth.pack();
        int i = 0;
        while (i < 7) {
            Label wl = new Label(parent, 0x1000000);
            GridData wlgd = new GridData(0x1000710);
            wlgd.minimumHeight = 15;
            wlgd.minimumWidth = 40;
            wlgd.grabExcessHorizontalSpace = true;
            wlgd.horizontalAlignment = 4;
            wlgd.verticalAlignment = 0x1000000;
            wl.setLayoutData((Object)wlgd);
            wl.setText(CalendarUtil.getWeekString((int)i));
            wl.setFont(this.labelfont);
            GraphicUtil.setBackground((Control)wl, (int)1);
            ++i;
        }
    }

    public void setYearMonth(int year, int month) {
        this.currentyear = year;
        this.currentmonth = month;
        this.lyearmonth.setText(CalendarUtil.getDateString((int)year, (int)month));
        this.lyearmonth.pack();
    }

    public int getCurrentYear() {
        return this.currentyear;
    }

    public int getCurrentMonth() {
        return this.currentmonth;
    }

    public void setListener(CalendarTitleListener listener) {
        this.listener = listener;
    }

    public void addMouseMoveListener(MouseMoveListener listener) {
        assert (this.rootcomp != null && !this.rootcomp.isDisposed());
        this.rootcomp.addMouseMoveListener(listener);
    }
}

