/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.concierge.plugin.labnote;

import java.util.ArrayList;
import jp.sourceforge.concierge.editor.EditorManager;
import jp.sourceforge.concierge.mdocument.DomImpl;
import jp.sourceforge.concierge.plugin.LabNotePlugin;
import jp.sourceforge.concierge.plugin.labnote.Category;
import jp.sourceforge.concierge.plugin.labnote.CategoryViewer;
import jp.sourceforge.concierge.plugin.labnote.LabNoteDocumentImpl;
import jp.sourceforge.concierge.plugin.labnote.LabNoteToolTip;
import jp.sourceforge.concierge.util.GraphicUtil;
import jp.sourceforge.concierge.util.SystemUtil;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.w3c.dom.Document;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CalendarItem {
    private static final boolean showHoliday = false;
    private Composite droot;
    private Label tlabel;
    private Label dlabel;
    private Font labelfont;
    private NoteItem itemselect = null;
    private LabNoteToolTip tooltip;
    private int year;
    private int month;
    private int day;
    private boolean holiday = false;
    private boolean enabled = false;
    private String nameofday = null;
    private ArrayList<MouseListener> listeners = new ArrayList();
    private ArrayList<MouseMoveListener> mlisteners = new ArrayList();
    private ArrayList<NoteItem> items = new ArrayList();
    private Color SELECTCOLOR = new Color(null, 236, 243, 250);

    private NoteItem findItem(Document doc) {
        int i = 0;
        while (i < this.items.size()) {
            NoteItem it = this.items.get(i);
            if (DomImpl.equalsByID((Document)it.document, (Document)doc)) {
                return it;
            }
            ++i;
        }
        return null;
    }

    private void rearrange() {
        ArrayList<Composite> ctrls = new ArrayList<Composite>();
        int i = 0;
        while (i < this.items.size()) {
            NoteItem it = this.items.get(i);
            if (it.root.getVisible()) {
                ctrls.add(it.root);
            }
            ++i;
        }
        Control pc = null;
        int i2 = 0;
        while (i2 < ctrls.size()) {
            Control c = (Control)ctrls.get(i2);
            if (pc == null) {
                c.moveAbove(null);
            } else {
                c.moveBelow(pc);
            }
            pc = c;
            ++i2;
        }
        this.droot.layout();
    }

    public CalendarItem(Composite parent, int year, int month, int day) {
        GridLayout gl = new GridLayout(2, false);
        gl.marginHeight = 1;
        gl.marginWidth = 1;
        gl.verticalSpacing = 0;
        gl.horizontalSpacing = 0;
        parent.setLayout((Layout)gl);
        int sz = SystemUtil.GetOSType() == 1 ? 11 : 9;
        this.labelfont = new Font(null, "Arial", sz, 0);
        this.tlabel = new Label(parent, 16384);
        this.tlabel.setLayoutData((Object)new GridData(768));
        GraphicUtil.setBackground((Control)this.tlabel, (int)1);
        this.tlabel.setFont(this.labelfont);
        this.tlabel.setText(" ");
        this.tlabel.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent e) {
                if (e.button != 1) {
                    return;
                }
                CalendarItem.this.itemselect = null;
                int i = 0;
                while (i < CalendarItem.this.listeners.size()) {
                    MouseListener ml = (MouseListener)CalendarItem.this.listeners.get(i);
                    e.data = CalendarItem.this;
                    ml.mouseDoubleClick(e);
                    ++i;
                }
            }

            public void mouseDown(MouseEvent e) {
                if (e.button != 1) {
                    return;
                }
                CalendarItem.this.itemselect = null;
                int i = 0;
                while (i < CalendarItem.this.listeners.size()) {
                    MouseListener ml = (MouseListener)CalendarItem.this.listeners.get(i);
                    e.data = CalendarItem.this;
                    ml.mouseDown(e);
                    ++i;
                }
            }
        });
        this.tlabel.addMouseMoveListener(new MouseMoveListener(){

            public void mouseMove(MouseEvent e) {
                int i = 0;
                while (i < CalendarItem.this.mlisteners.size()) {
                    MouseMoveListener ml = (MouseMoveListener)CalendarItem.this.mlisteners.get(i);
                    e.data = CalendarItem.this;
                    ml.mouseMove(e);
                    ++i;
                }
            }
        });
        GraphicUtil.setForeground((Control)this.tlabel, (int)(this.holiday ? 3 : 2));
        this.dlabel = new Label(parent, 131072);
        this.dlabel.setLayoutData((Object)new GridData(768));
        GraphicUtil.setBackground((Control)this.dlabel, (int)1);
        this.dlabel.setFont(this.labelfont);
        this.dlabel.setText(String.valueOf(day));
        this.dlabel.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                CalendarItem.this.labelfont.dispose();
            }
        });
        this.dlabel.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent e) {
                if (e.button != 1) {
                    return;
                }
                CalendarItem.this.itemselect = null;
                int i = 0;
                while (i < CalendarItem.this.listeners.size()) {
                    MouseListener ml = (MouseListener)CalendarItem.this.listeners.get(i);
                    e.data = CalendarItem.this;
                    ml.mouseDoubleClick(e);
                    ++i;
                }
            }

            public void mouseDown(MouseEvent e) {
                if (e.button != 1) {
                    return;
                }
                CalendarItem.this.itemselect = null;
                int i = 0;
                while (i < CalendarItem.this.listeners.size()) {
                    MouseListener ml = (MouseListener)CalendarItem.this.listeners.get(i);
                    e.data = CalendarItem.this;
                    ml.mouseDown(e);
                    ++i;
                }
            }
        });
        this.dlabel.addMouseMoveListener(new MouseMoveListener(){

            public void mouseMove(MouseEvent e) {
                int i = 0;
                while (i < CalendarItem.this.mlisteners.size()) {
                    MouseMoveListener ml = (MouseMoveListener)CalendarItem.this.mlisteners.get(i);
                    e.data = CalendarItem.this;
                    ml.mouseMove(e);
                    ++i;
                }
            }
        });
        this.droot = new Composite(parent, 0);
        RowLayout rl = new RowLayout();
        this.droot.setLayout((Layout)rl);
        GridData drgd = new GridData(1808);
        drgd.horizontalSpan = 2;
        this.droot.setLayoutData((Object)drgd);
        this.droot.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent e) {
                if (e.button != 1) {
                    return;
                }
                CalendarItem.this.itemselect = null;
                CalendarItem.this.tooltip.hide();
                int i = 0;
                while (i < CalendarItem.this.listeners.size()) {
                    MouseListener ml = (MouseListener)CalendarItem.this.listeners.get(i);
                    e.data = CalendarItem.this;
                    ml.mouseDoubleClick(e);
                    ++i;
                }
            }

            public void mouseDown(MouseEvent e) {
                if (e.button != 1) {
                    return;
                }
                CalendarItem.this.itemselect = null;
                int i = 0;
                while (i < CalendarItem.this.listeners.size()) {
                    MouseListener ml = (MouseListener)CalendarItem.this.listeners.get(i);
                    e.data = CalendarItem.this;
                    ml.mouseDown(e);
                    ++i;
                }
            }
        });
        this.droot.addMouseTrackListener(new MouseTrackListener(){

            public void mouseEnter(MouseEvent e) {
            }

            public void mouseExit(MouseEvent e) {
                CalendarItem.this.tooltip.hide();
            }

            public void mouseHover(MouseEvent e) {
            }
        });
        this.droot.addMouseMoveListener(new MouseMoveListener(){

            public void mouseMove(MouseEvent e) {
                int i = 0;
                while (i < CalendarItem.this.mlisteners.size()) {
                    MouseMoveListener ml = (MouseMoveListener)CalendarItem.this.mlisteners.get(i);
                    e.data = CalendarItem.this;
                    ml.mouseMove(e);
                    ++i;
                }
            }
        });
        this.droot.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                CalendarItem.this.droot.layout();
            }
        });
        this.year = year;
        this.month = month;
        this.day = day;
        this.enabled = true;
        this.tooltip = new LabNoteToolTip((Control)this.droot, 0, true);
    }

    protected void finalize() throws Throwable {
        this.SELECTCOLOR.dispose();
        super.finalize();
    }

    public void setEnabled(boolean en) {
        this.droot.setEnabled(true);
        int i = 0;
        while (i < this.items.size()) {
            this.items.get(i).setEnabled(true);
            ++i;
        }
        GraphicUtil.setForeground((Control)this.dlabel, (int)(en ? (this.holiday ? 3 : 2) : 15));
        GraphicUtil.setForeground((Control)this.tlabel, (int)(en ? (this.holiday ? 3 : 2) : 15));
        this.enabled = en;
    }

    public void setDate(int year, int month, int day) {
        this.year = year;
        this.month = month;
        this.day = day;
        this.dlabel.setText(String.valueOf(day));
        this.droot.layout();
    }

    public int getYear() {
        return this.year;
    }

    public int getMonth() {
        return this.month;
    }

    public int getDay() {
        return this.day;
    }

    public void setBackground(Color color) {
        this.dlabel.setBackground(color);
        this.tlabel.setBackground(color);
        this.droot.setBackground(color);
        this.droot.getParent().setBackground(color);
        int i = 0;
        while (i < this.items.size()) {
            this.items.get(i).setBackground(color);
            ++i;
        }
    }

    public void select() {
        this.setBackground(this.SELECTCOLOR);
    }

    public void deselect() {
        this.setBackground(this.droot.getDisplay().getSystemColor(1));
    }

    public void createItem(Document doc, Category curcat) {
        NoteItem it = new NoteItem(this.droot, doc, curcat);
        this.droot.layout();
        this.items.add(it);
    }

    public void setDocuments(ArrayList<Document> docs) {
        this.clearAll();
        if (docs == null) {
            return;
        }
        int i = 0;
        while (i < docs.size()) {
            NoteItem it = new NoteItem(this.droot, docs.get(i), null);
            this.items.add(it);
            ++i;
        }
        this.droot.layout();
    }

    public void showTooltip(boolean show) {
    }

    public void clearAll() {
        int i = 0;
        while (i < this.items.size()) {
            NoteItem it = this.items.get(i);
            it.dispose();
            ++i;
        }
        this.items.clear();
    }

    public void update() {
        int i = 0;
        while (i < this.items.size()) {
            NoteItem it = this.items.get(i);
            it.update();
            ++i;
        }
    }

    public void update(ArrayList<Document> newdocs) {
        int i = 0;
        while (i < this.items.size()) {
            NoteItem it = this.items.get(i);
            Document itdoc = it.document;
            Document fdoc = DomImpl.findDocument(newdocs, (Document)itdoc);
            if (fdoc != null) {
                it.update(fdoc);
            }
            ++i;
        }
    }

    public void updateAll() {
        ArrayList<Document> docs = LabNotePlugin.getDocuments(this.year, this.month, this.day);
        this.setDocuments(docs);
    }

    public void addMouseListener(MouseListener listener) {
        this.listeners.add(listener);
    }

    public void addMouseMoveListener(MouseMoveListener listener) {
        this.mlisteners.add(listener);
    }

    public void noteVisibleByCategory(String category, boolean visible) {
        int i = 0;
        while (i < this.items.size()) {
            NoteItem it = this.items.get(i);
            String name = LabNoteDocumentImpl.getCategory(it.document);
            if (category.equals(name)) {
                it.root.setVisible(visible);
            }
            ++i;
        }
        this.rearrange();
    }

    public void openNoteItem(Document doc) {
        NoteItem it = this.findItem(doc);
        if (it == null) {
            return;
        }
        it.openEditor();
    }

    public void deleteNoteItem(Document doc) {
        NoteItem it = this.findItem(doc);
        if (it == null) {
            return;
        }
        this.items.remove(it);
        it.dispose();
        this.droot.layout();
    }

    public Document getSelectedNoteDocument() {
        if (this.itemselect == null) {
            return null;
        }
        return this.itemselect.document;
    }

    public Control getSelectedNoteControl() {
        if (this.itemselect == null) {
            return null;
        }
        return this.itemselect.titlectrl;
    }

    public void setHoliday(boolean hol) {
        this.holiday = hol;
        if (this.enabled) {
            GraphicUtil.setForeground((Control)this.dlabel, (int)(hol ? 3 : 2));
            GraphicUtil.setForeground((Control)this.tlabel, (int)(hol ? 3 : 2));
        }
    }

    public void setNameOfDay(String name) {
        this.nameofday = name;
        this.tlabel.pack();
        this.droot.layout();
    }

    public class NoteItem {
        private Composite root;
        private CLabel titlectrl;
        private Document document;
        static final String defaultTitle = "untitled";

        public NoteItem(Composite parent, Document doc, Category curcat) {
            this.root = new Composite(parent, 4);
            this.root.setLayoutData((Object)new RowData(-1, -1));
            GridLayout gl = new GridLayout(1, false);
            gl.marginHeight = 0;
            gl.marginWidth = 0;
            gl.verticalSpacing = 0;
            gl.horizontalSpacing = 0;
            this.root.setLayout((Layout)gl);
            this.root.setBackground(parent.getBackground());
            this.document = doc;
            this.titlectrl = new CLabel(this.root, 0);
            this.titlectrl.setLayoutData((Object)new GridData(768));
            this.titlectrl.setFont(CalendarItem.this.labelfont);
            this.titlectrl.setBackground(this.root.getBackground());
            this.titlectrl.addMouseListener((MouseListener)new MouseAdapter(){

                public void mouseDoubleClick(MouseEvent e) {
                    if (e.button != 1) {
                        return;
                    }
                    CalendarItem.this.itemselect = NoteItem.this;
                    CalendarItem.this.tooltip.hide();
                    NoteItem.this.openEditor();
                    CalendarItem.this.droot.setFocus();
                }

                public void mouseDown(MouseEvent e) {
                    CalendarItem.this.itemselect = NoteItem.this;
                    int i = 0;
                    while (i < CalendarItem.this.listeners.size()) {
                        MouseListener ml = (MouseListener)CalendarItem.this.listeners.get(i);
                        e.data = CalendarItem.this;
                        ml.mouseDown(e);
                        ++i;
                    }
                }
            });
            this.titlectrl.addMouseTrackListener(new MouseTrackListener(){

                public void mouseHover(MouseEvent e) {
                    Point p = NoteItem.this.root.getLocation();
                    Point sz = NoteItem.this.root.getSize();
                    CalendarItem.this.tooltip.show(new Point(p.x + sz.x / 2, p.y + sz.y / 2));
                }

                public void mouseEnter(MouseEvent e) {
                    Document doc = NoteItem.this.document;
                    if (doc == null) {
                        CalendarItem.this.tooltip.hide();
                        return;
                    }
                    CalendarItem.this.tooltip.setDocument(doc);
                    Point p = NoteItem.this.root.getLocation();
                    Point sz = NoteItem.this.root.getSize();
                    CalendarItem.this.tooltip.show(new Point(p.x + sz.x / 2, p.y + sz.y / 2));
                }

                public void mouseExit(MouseEvent e) {
                }
            });
            this.update();
        }

        public void setEnabled(boolean en) {
            this.titlectrl.setEnabled(en);
            if (this.document != null && en) {
                this.update();
            } else {
                GraphicUtil.setForeground((Control)this.titlectrl, (int)15);
                this.titlectrl.setImage(CategoryViewer.getUnknownImage());
            }
        }

        public void setBackground(Color color) {
            this.root.setBackground(color);
            this.titlectrl.setBackground(color);
        }

        public void setTitle(String title) {
            LabNoteDocumentImpl.setTitle(this.document, title);
        }

        public String getTitle() {
            return LabNoteDocumentImpl.getTitle(this.document);
        }

        public void openEditor() {
            this.root.layout();
            EditorManager.openEditor((Document)this.document, (boolean)false, (Object)"jp.sourceforge.concierge.plugin.labnote");
        }

        public void update() {
            String c = LabNoteDocumentImpl.getCategory(this.document);
            Category cat = LabNotePlugin.getCategoryManager().getCategoryByName(c);
            if (cat != null) {
                this.titlectrl.setForeground(CategoryViewer.getColor(cat.colorid));
                this.titlectrl.setImage(CategoryViewer.getImage(cat.colorid));
            } else {
                this.titlectrl.setForeground(CategoryViewer.getColor(-1));
                this.titlectrl.setImage(CategoryViewer.getUnknownImage());
            }
        }

        public void update(Document newdoc) {
            this.document = newdoc;
            this.update();
        }

        public void dispose() {
            if (this.root != null) {
                this.root.dispose();
            }
        }
    }
}

