/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.concierge.plugin;

import java.io.File;
import java.io.FileWriter;
import java.io.StringReader;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import jp.sourceforge.concierge.plugin.CCRightsSax;
import jp.sourceforge.concierge.plugin.XooNIpsConnection;
import jp.sourceforge.concierge.plugin.XoonipsLink2Plugin;
import jp.sourceforge.concierge.plugin.licenseAgreementDialog;
import jp.sourceforge.concierge.util.FileLauncher;
import jp.sourceforge.xoonips.XooNIpsException;
import jp.sourceforge.xoonips.XooNIpsFile;
import jp.sourceforge.xoonips.XooNIpsIndex;
import jp.sourceforge.xoonips.XooNIpsItem;
import jp.sourceforge.xoonips.XooNIpsItemType;
import jp.sourceforge.xoonips.XooNIpsSimpleItem;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.LocationEvent;
import org.eclipse.swt.browser.LocationListener;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageLoader;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.xml.sax.InputSource;
import org.xml.sax.helpers.DefaultHandler;

public class XooNIpsItemView {
    private Composite superParent = null;

    public XooNIpsItemView(Composite parent) {
        this.superParent = parent;
    }

    public void show(XooNIpsConnection xoonipsConnection, XooNIpsItem xnpItem, LocationListener relatedtoBrowserLocationListener, LocationListener indexBrowserLocationListener) {
        this.disposeControls(this.superParent);
        CTabFolder tabFolder = new CTabFolder(this.superParent, 2048);
        tabFolder.setLayoutData((Object)new GridData(1808));
        this.createTabItemWithXooNIpsItem(tabFolder, xoonipsConnection, xnpItem, relatedtoBrowserLocationListener, indexBrowserLocationListener);
        tabFolder.setSelection(0);
        this.superParent.layout();
    }

    public void hide() {
        this.disposeControls(this.superParent);
        Composite empty = new Composite(this.superParent, 2048);
        empty.setLayoutData((Object)new GridData(1808));
        empty.setBackground(empty.getDisplay().getSystemColor(1));
        this.superParent.layout();
    }

    private void createTabItemWithXooNIpsItem(CTabFolder tabFolder, XooNIpsConnection xoonipsConnection, XooNIpsItem xnpItem, LocationListener relatedtoBrowserLocationListener, LocationListener indexBrowserLocationListener) {
        this.createBasicTab(tabFolder, xnpItem);
        this.createDetailTab(tabFolder, xoonipsConnection, xnpItem);
        this.createFileTab(tabFolder, xoonipsConnection, xnpItem);
        this.createRelatedToTabWithBrowser(tabFolder, "Related To", this.createRelatedToForHTML(xoonipsConnection, xnpItem), relatedtoBrowserLocationListener);
        this.createIndexTabWithBrowser(tabFolder, "Index", this.creatrIndexToForHTML(xoonipsConnection, xnpItem), indexBrowserLocationListener);
    }

    private void createBasicTab(CTabFolder tabFolder, XooNIpsItem xnpItem) {
        StringBuffer basicStrBuf = new StringBuffer();
        this.createTitleForHTML(basicStrBuf, xnpItem);
        basicStrBuf.append("<hr width=\"100%\">");
        this.createBasicForHTML(basicStrBuf, xnpItem);
        this.createTabWithBrowser(tabFolder, "Basic", basicStrBuf);
    }

    private void createDetailTab(CTabFolder tabFolder, XooNIpsConnection xoonipsConnection, XooNIpsItem xnpItem) {
        StringBuffer detailStrBuf = new StringBuffer();
        this.createTitleForHTML(detailStrBuf, xnpItem);
        detailStrBuf.append("<hr width=\"100%\">");
        detailStrBuf.append("<table>");
        StringBuffer previewStrBuf = null;
        String[] fieldNames = xnpItem.getFieldNames();
        int i = 0;
        while (i < fieldNames.length) {
            block75: {
                if (fieldNames[i].startsWith("detail_field.")) {
                    try {
                        if (fieldNames[i].equals("detail_field.rights") || fieldNames[i].equals("detail_field.readme") || fieldNames[i].equals("detail_field.use_cc") || fieldNames[i].equals("detail_field.cc_commercial_use") || fieldNames[i].equals("detail_field.cc_modification") || fieldNames[i].equals("detail_field.attachment_dl_limit") || fieldNames[i].equals("detail_field.attachment_dl_notify")) break block75;
                        if (fieldNames[i].equals("detail_field.url")) {
                            detailStrBuf.append(this.createURLForHTML(xnpItem, fieldNames[i]));
                            break block75;
                        }
                        if (fieldNames[i].equals("detail_field.preview")) {
                            try {
                                int fileCount = xnpItem.getCount(fieldNames[i]);
                                int rows = fileCount / 3;
                                int j = 0;
                                int row = 0;
                                while (row < rows) {
                                    XooNIpsFile xnpFile = xnpItem.getFile(fieldNames[i], j);
                                    if (previewStrBuf == null) {
                                        previewStrBuf = new StringBuffer();
                                        previewStrBuf.append("<br/>");
                                        previewStrBuf.append("<table id=\"style2\" width=\"100%\">");
                                    }
                                    previewStrBuf.append("<tr>");
                                    int col = 0;
                                    while (col < 3) {
                                        File tmpFile = File.createTempFile("XoonipsLink2", null);
                                        File thumbnailFile = xnpFile.getThumbnail(tmpFile.getAbsolutePath());
                                        String caption = xnpFile.getCaption();
                                        if (caption == null) {
                                            caption = "";
                                        }
                                        previewStrBuf.append("<td align=\"center\" valign=\"top\" width=\"33%\">");
                                        previewStrBuf.append("<table border=\"0\">");
                                        previewStrBuf.append("<caption align=\"bottom\">" + caption + "</caption>");
                                        previewStrBuf.append("<tr><td align=\"center\"><img alt=\"Preview\" border=\"0\" src=\"file://" + thumbnailFile.getAbsolutePath() + "\"/></td></tr>");
                                        previewStrBuf.append("</table>");
                                        previewStrBuf.append("</td>");
                                        ++j;
                                        ++col;
                                    }
                                    previewStrBuf.append("</tr>");
                                    ++row;
                                }
                                if (j < fileCount) {
                                    if (previewStrBuf == null) {
                                        previewStrBuf = new StringBuffer();
                                        previewStrBuf.append("<br/>");
                                        previewStrBuf.append("<table id=\"style2\" width=\"100%\">");
                                    }
                                    previewStrBuf.append("<tr>");
                                    while (j < fileCount) {
                                        XooNIpsFile xnpFile = xnpItem.getFile(fieldNames[i], j);
                                        File tmpFile = File.createTempFile("XoonipsLink2", null);
                                        File thumbnailFile = xnpFile.getThumbnail(tmpFile.getAbsolutePath());
                                        String caption = xnpFile.getCaption();
                                        if (caption == null) {
                                            caption = "";
                                        }
                                        previewStrBuf.append("<td align=\"center\" valign=\"top\" width=\"33%\">");
                                        previewStrBuf.append("<table border=\"0\">");
                                        previewStrBuf.append("<caption align=\"bottom\">" + caption + "</caption>");
                                        previewStrBuf.append("<tr><td align=\"center\"><img alt=\"Preview\" border=\"0\" src=\"file://" + thumbnailFile.getAbsolutePath() + "\"/></td></tr>");
                                        previewStrBuf.append("</table>");
                                        previewStrBuf.append("</td>");
                                        ++j;
                                    }
                                    previewStrBuf.append("</tr>");
                                }
                                if (previewStrBuf != null) {
                                    previewStrBuf.append("</table>");
                                }
                                break block75;
                            }
                            catch (XooNIpsException excp) {
                                System.out.println((Object)excp);
                                excp.printStackTrace();
                            }
                            catch (Exception excp) {
                                System.out.println(excp);
                                excp.printStackTrace();
                            }
                            break block75;
                        }
                        if (!xnpItem.getFieldType(fieldNames[i]).equals("FILE")) {
                            if (xnpItem.getItemType().getTypeName().equals("xnpbook")) {
                                if (!fieldNames[i].equals("detail_field.book_id")) {
                                    if (fieldNames[i].equals("detail_field.publisher")) {
                                        detailStrBuf.append(this.createStringTypeAndDateTypeForHTML(xnpItem, fieldNames[i], null));
                                        detailStrBuf.append(this.createStringTypeAndDateTypeForHTML(xnpItem, "creation_year", null));
                                    } else {
                                        detailStrBuf.append(this.createStringTypeAndDateTypeForHTML(xnpItem, fieldNames[i], null));
                                    }
                                }
                            } else if (xnpItem.getItemType().getTypeName().equals("xnpconference")) {
                                if (!fieldNames[i].equals("detail_field.conference_id")) {
                                    detailStrBuf.append(this.createStringTypeAndDateTypeForHTML(xnpItem, fieldNames[i], null));
                                }
                            } else if (xnpItem.getItemType().getTypeName().equals("xnpdata")) {
                                if (!fieldNames[i].equals("detail_field.data_id")) {
                                    if (fieldNames[i].equals("detail_field.data_type")) {
                                        detailStrBuf.append(this.createStringTypeAndDateTypeForHTML(xnpItem, "creation_year", null));
                                        detailStrBuf.append(this.createStringTypeAndDateTypeForHTML(xnpItem, fieldNames[i], null));
                                    } else {
                                        detailStrBuf.append(this.createStringTypeAndDateTypeForHTML(xnpItem, fieldNames[i], null));
                                    }
                                }
                            } else if (xnpItem.getItemType().getTypeName().equals("xnpfiles")) {
                                if (!fieldNames[i].equals("detail_field.files_id")) {
                                    detailStrBuf.append(this.createStringTypeAndDateTypeForHTML(xnpItem, fieldNames[i], null));
                                }
                            } else if (xnpItem.getItemType().getTypeName().equals("xnpmemo")) {
                                if (!fieldNames[i].equals("detail_field.memo_id")) {
                                    detailStrBuf.append(this.createStringTypeAndDateTypeForHTML(xnpItem, fieldNames[i], null));
                                }
                            } else if (xnpItem.getItemType().getTypeName().equals("xnpmodel")) {
                                if (!fieldNames[i].equals("detail_field.model_id")) {
                                    detailStrBuf.append(this.createStringTypeAndDateTypeForHTML(xnpItem, fieldNames[i], null));
                                }
                            } else if (xnpItem.getItemType().getTypeName().equals("xnppaper")) {
                                if (!fieldNames[i].equals("detail_field.paper_id")) {
                                    if (fieldNames[i].equals("detail_field.journal")) {
                                        detailStrBuf.append(this.createStringTypeAndDateTypeForHTML(xnpItem, fieldNames[i], null));
                                        detailStrBuf.append(this.createStringTypeAndDateTypeForHTML(xnpItem, "creation_year", null));
                                    } else {
                                        detailStrBuf.append(this.createStringTypeAndDateTypeForHTML(xnpItem, fieldNames[i], null));
                                    }
                                }
                            } else if (xnpItem.getItemType().getTypeName().equals("xnppresentation")) {
                                if (!fieldNames[i].equals("detail_field.presentation_id")) {
                                    if (fieldNames[i].equals("detail_field.presentation_type")) {
                                        detailStrBuf.append(this.createStringTypeAndDateTypeForHTML(xnpItem, "creation_year", null));
                                        detailStrBuf.append(this.createStringTypeAndDateTypeForHTML(xnpItem, fieldNames[i], null));
                                    } else {
                                        detailStrBuf.append(this.createStringTypeAndDateTypeForHTML(xnpItem, fieldNames[i], null));
                                    }
                                }
                            } else if (xnpItem.getItemType().getTypeName().equals("xnpsimulator")) {
                                if (!fieldNames[i].equals("detail_field.simulator_id")) {
                                    if (fieldNames[i].equals("detail_field.simulator_type")) {
                                        detailStrBuf.append(this.createStringTypeAndDateTypeForHTML(xnpItem, "creation_year", null));
                                        detailStrBuf.append(this.createStringTypeAndDateTypeForHTML(xnpItem, fieldNames[i], null));
                                    } else {
                                        detailStrBuf.append(this.createStringTypeAndDateTypeForHTML(xnpItem, fieldNames[i], null));
                                    }
                                }
                            } else if (xnpItem.getItemType().getTypeName().equals("xnpstimulus")) {
                                if (!fieldNames[i].equals("detail_field.stimulus_id")) {
                                    if (fieldNames[i].equals("detail_field.stimulus_type")) {
                                        detailStrBuf.append(this.createStringTypeAndDateTypeForHTML(xnpItem, "creation_year", null));
                                        detailStrBuf.append(this.createStringTypeAndDateTypeForHTML(xnpItem, fieldNames[i], null));
                                    } else {
                                        detailStrBuf.append(this.createStringTypeAndDateTypeForHTML(xnpItem, fieldNames[i], null));
                                    }
                                }
                            } else if (xnpItem.getItemType().getTypeName().equals("xnptool")) {
                                if (!fieldNames[i].equals("detail_field.tool_id")) {
                                    if (fieldNames[i].equals("detail_field.tool_type")) {
                                        detailStrBuf.append(this.createStringTypeAndDateTypeForHTML(xnpItem, "creation_year", null));
                                        detailStrBuf.append(this.createStringTypeAndDateTypeForHTML(xnpItem, fieldNames[i], null));
                                    } else {
                                        detailStrBuf.append(this.createStringTypeAndDateTypeForHTML(xnpItem, fieldNames[i], null));
                                    }
                                }
                            } else if (xnpItem.getItemType().getTypeName().equals("xnpurl")) {
                                if (!fieldNames[i].equals("detail_field.url_id")) {
                                    detailStrBuf.append(this.createStringTypeAndDateTypeForHTML(xnpItem, fieldNames[i], null));
                                }
                            } else {
                                xnpItem.getItemType().getTypeName().equals("xnpbinder");
                            }
                        }
                    }
                    catch (Exception excp) {
                        System.out.println(excp);
                        excp.printStackTrace();
                    }
                }
            }
            ++i;
        }
        detailStrBuf.append("</table>");
        try {
            String[] values;
            if (xnpItem.getItemType().getTypeName().equals("xnpbinder") && xnpItem.getItemType().isMultiple("detail_field.item_id") && (values = xnpItem.getValues("detail_field.item_id")) != null && values.length > 0) {
                int[] ids = new int[values.length];
                int i2 = 0;
                while (i2 < values.length) {
                    ids[i2] = Integer.valueOf(values[i2]);
                    ++i2;
                }
                detailStrBuf.append("<br/>");
                XooNIpsSimpleItem[] items = xoonipsConnection.getXooNIpsSession().getXooNIpsSimpleItems(ids, ids.length);
                int i3 = 0;
                while (i3 < items.length) {
                    this.createTitleForHTML(detailStrBuf, items[i3]);
                    ++i3;
                }
            }
        }
        catch (Exception exception) {}
        if (previewStrBuf != null) {
            detailStrBuf.append(previewStrBuf);
        }
        this.createTabWithBrowser(tabFolder, "Detail", detailStrBuf);
    }

    private void createFileTab(CTabFolder tabFolder, XooNIpsConnection xoonipsConnection, XooNIpsItem xnpItem) {
        StringBuffer rightsStrBuf = null;
        StringBuffer readmeStrBuf = null;
        StringBuffer filesStrBuf = null;
        String[] fieldNames = xnpItem.getFieldNames();
        int i = 0;
        while (i < fieldNames.length) {
            block36: {
                try {
                    String displayName;
                    if (fieldNames[i].equals("detail_field.rights")) {
                        String value;
                        displayName = xnpItem.getItemType().getDisplayName(fieldNames[i]);
                        String use_cc = xnpItem.getValue("detail_field.use_cc");
                        if (use_cc == null) {
                            use_cc = "";
                        }
                        if ((value = xnpItem.getValue("detail_field.rights")) == null) {
                            value = "";
                        }
                        if (rightsStrBuf == null) {
                            rightsStrBuf = new StringBuffer();
                        }
                        if (use_cc.equals("1")) {
                            rightsStrBuf.append("<table width=\"100%\">");
                            rightsStrBuf.append("<tr>");
                            rightsStrBuf.append("<td valign=\"top\">" + displayName + "</td>");
                            rightsStrBuf.append("</tr>");
                            rightsStrBuf.append("<tr>");
                            rightsStrBuf.append("<td id=\"style2\">" + value + "</td>");
                            rightsStrBuf.append("</tr>");
                            rightsStrBuf.append("</table>");
                            rightsStrBuf.append("<br/>");
                        } else {
                            rightsStrBuf.append("<table width=\"100%\">");
                            rightsStrBuf.append("<tr>");
                            rightsStrBuf.append("<td valign=\"top\">" + displayName + "</td>");
                            rightsStrBuf.append("</tr>");
                            rightsStrBuf.append("<tr>");
                            rightsStrBuf.append("<td id=\"style1\"><pre>" + value + "</pre></td>");
                            rightsStrBuf.append("</tr>");
                            rightsStrBuf.append("</table>");
                            rightsStrBuf.append("<br/>");
                        }
                        break block36;
                    }
                    if (fieldNames[i].equals("detail_field.readme")) {
                        displayName = xnpItem.getItemType().getDisplayName(fieldNames[i]);
                        String value = xnpItem.getValue("detail_field.readme");
                        if (value == null) {
                            value = "";
                        }
                        if (readmeStrBuf == null) {
                            readmeStrBuf = new StringBuffer();
                        }
                        readmeStrBuf.append("<table width=\"100%\">");
                        readmeStrBuf.append("<tr>");
                        readmeStrBuf.append("<td valign=\"top\">" + displayName + "</td>");
                        readmeStrBuf.append("</tr>");
                        readmeStrBuf.append("<tr>");
                        readmeStrBuf.append("<td id=\"style1\"><pre>" + value + "</pre></td>");
                        readmeStrBuf.append("</tr>");
                        readmeStrBuf.append("</table>");
                        readmeStrBuf.append("<br/>");
                        break block36;
                    }
                    if (fieldNames[i].equals("detail_field.preview") || !xnpItem.getFieldType(fieldNames[i]).equals("FILE")) break block36;
                    displayName = xnpItem.getItemType().getDisplayName(fieldNames[i]);
                    try {
                        String downloadLimit;
                        boolean doDownload = false;
                        doDownload = xnpItem.isDefinedField("detail_field.attachment_dl_limit") ? ((downloadLimit = xnpItem.getValue("detail_field.attachment_dl_limit")).equals("0") ? true : !xoonipsConnection.isGuest()) : true;
                        if (doDownload) {
                            int fileCount = xnpItem.getCount(fieldNames[i]);
                            if (fileCount > 0) {
                                if (filesStrBuf == null) {
                                    filesStrBuf = new StringBuffer();
                                    filesStrBuf.append("<table width=\"100%\">");
                                    filesStrBuf.append("<tr>");
                                    filesStrBuf.append("<td valign=\"top\">" + displayName + "</td>");
                                    filesStrBuf.append("</tr>");
                                    filesStrBuf.append("</table>");
                                }
                                int j = 0;
                                while (j < fileCount) {
                                    XooNIpsFile xnpFile = xnpItem.getFile(fieldNames[i], j);
                                    filesStrBuf.append("<table id=\"style3\" width=\"100%\">");
                                    filesStrBuf.append("<tr>");
                                    filesStrBuf.append("<td width=\"50%\">");
                                    filesStrBuf.append("<table width=\"100%\">");
                                    filesStrBuf.append("<tr><td>File Name:</td><td>");
                                    String filename = "";
                                    try {
                                        filename = xnpFile.getFileName();
                                    }
                                    catch (XooNIpsException excp) {
                                        excp.getStackTrace();
                                    }
                                    filesStrBuf.append(filename);
                                    filesStrBuf.append("</td></tr>");
                                    filesStrBuf.append("<tr><td>MIME Type:</td><td>");
                                    String mimetype = "";
                                    try {
                                        mimetype = xnpFile.getMimeType();
                                    }
                                    catch (XooNIpsException excp) {
                                        excp.getStackTrace();
                                    }
                                    filesStrBuf.append(mimetype);
                                    filesStrBuf.append("</td></tr>");
                                    filesStrBuf.append("<tr><td>Size:</td><td>");
                                    int filesize = -1;
                                    try {
                                        filesize = xnpFile.getFileSize();
                                    }
                                    catch (XooNIpsException xooNIpsException) {}
                                    if (filesize >= 0) {
                                        filesStrBuf.append(filesize);
                                        filesStrBuf.append(" bytes");
                                    }
                                    filesStrBuf.append("</td></tr>");
                                    filesStrBuf.append("<tr><td>Last updated:</td><td>");
                                    Calendar cal = null;
                                    try {
                                        cal = xnpFile.getLastUpdateDate();
                                    }
                                    catch (XooNIpsException xooNIpsException) {}
                                    if (cal != null) {
                                        SimpleDateFormat myformat = new SimpleDateFormat("MMM d, yyyy", Locale.US);
                                        Date date = cal.getTime();
                                        String value = myformat.format(date);
                                        filesStrBuf.append(value);
                                    }
                                    filesStrBuf.append("</td></tr>");
                                    filesStrBuf.append("</table>");
                                    filesStrBuf.append("</td>");
                                    filesStrBuf.append("<td width=\"50%\"><a href=\"");
                                    filesStrBuf.append("xoonips://");
                                    filesStrBuf.append(String.valueOf(fieldNames[i]) + "/" + String.valueOf(j));
                                    filesStrBuf.append("\">Download</a></td>");
                                    filesStrBuf.append("</tr>");
                                    filesStrBuf.append("</table>");
                                    ++j;
                                }
                                if (filesStrBuf != null) {
                                    filesStrBuf.append("<br/>");
                                }
                                break block36;
                            }
                            if (filesStrBuf == null) {
                                filesStrBuf = new StringBuffer();
                            }
                            filesStrBuf.append("<table width=\"100%\">");
                            filesStrBuf.append("<tr>");
                            filesStrBuf.append("<td valign=\"top\">" + displayName + "</td>");
                            filesStrBuf.append("</tr>");
                            filesStrBuf.append("<tr>");
                            filesStrBuf.append("<td id=\"style3\"><pre></pre></td>");
                            filesStrBuf.append("</tr>");
                            filesStrBuf.append("</table>");
                            filesStrBuf.append("<br/>");
                            break block36;
                        }
                        if (filesStrBuf == null) {
                            filesStrBuf = new StringBuffer();
                        }
                        filesStrBuf.append("<table width=\"100%\">");
                        filesStrBuf.append("<tr>");
                        filesStrBuf.append("<td valign=\"top\">" + displayName + "</td>");
                        filesStrBuf.append("</tr>");
                        filesStrBuf.append("<tr>");
                        filesStrBuf.append("<td id=\"style3\">Only login-user can download this file</td>");
                        filesStrBuf.append("</tr>");
                        filesStrBuf.append("</table>");
                        filesStrBuf.append("<br/>");
                    }
                    catch (XooNIpsException excp) {
                        System.out.println((Object)excp);
                        excp.printStackTrace();
                    }
                    catch (Exception excp) {
                        System.out.println(excp);
                        excp.printStackTrace();
                    }
                }
                catch (Exception excp) {
                    System.out.println(excp);
                    excp.printStackTrace();
                }
            }
            ++i;
        }
        if (rightsStrBuf == null) {
            rightsStrBuf = new StringBuffer();
        }
        if (readmeStrBuf != null) {
            rightsStrBuf.append(readmeStrBuf);
        }
        if (filesStrBuf != null) {
            rightsStrBuf.append(filesStrBuf);
        }
        if (rightsStrBuf.length() > 0) {
            this.createFileTabWithBrowser(tabFolder, "File", rightsStrBuf, xnpItem);
        }
    }

    private void createTabWithBrowser(CTabFolder tabFolder, String tabTitle, StringBuffer htmlBuffer) {
        CTabItem tabItem = new CTabItem(tabFolder, 0);
        tabItem.setText(tabTitle);
        Composite composite = new Composite((Composite)tabFolder, 0);
        composite.setLayoutData((Object)new GridData(1808));
        GridLayout gl = new GridLayout();
        gl.marginHeight = 0;
        gl.marginWidth = 0;
        composite.setLayout((Layout)gl);
        Browser browser = new Browser(composite, 0);
        tabItem.setControl((Control)composite);
        browser.setLayoutData((Object)new GridData(1808));
        browser.addLocationListener(new LocationListener(){
            private boolean once = true;

            public void changed(LocationEvent event) {
            }

            public void changing(LocationEvent event) {
                event.doit = this.once;
                if (!this.once && event.location.startsWith("http")) {
                    FileLauncher.LaunchBrowser((String)event.location);
                }
                this.once = false;
            }
        });
        this.setBrowserData(browser, htmlBuffer);
    }

    private void createFileTabWithBrowser(CTabFolder tabFolder, String tabTitle, StringBuffer htmlBuffer, XooNIpsItem xnpItem) {
        CTabItem tabItem = new CTabItem(tabFolder, 0);
        tabItem.setText(tabTitle);
        Composite composite = new Composite((Composite)tabFolder, 0);
        composite.setLayoutData((Object)new GridData(1808));
        GridLayout gl = new GridLayout();
        gl.marginHeight = 0;
        gl.marginWidth = 0;
        composite.setLayout((Layout)gl);
        Browser browser = new Browser(composite, 0);
        tabItem.setControl((Control)composite);
        browser.setLayoutData((Object)new GridData(1808));
        browser.setData((Object)xnpItem);
        browser.addLocationListener(new LocationListener(){
            private boolean once = true;

            public void changed(LocationEvent event) {
            }

            public void changing(LocationEvent event) {
                event.doit = this.once;
                if (!this.once) {
                    try {
                        String headStr = "xoonips://";
                        if (event.location.startsWith(headStr)) {
                            String substr = event.location.substring(headStr.length());
                            String[] values = substr.split("/");
                            String fieldName = values[0];
                            int index = Integer.valueOf(values[1]);
                            Browser browser = (Browser)event.getSource();
                            XooNIpsItem xnpItem = (XooNIpsItem)browser.getData();
                            boolean doDownload = false;
                            if (xnpItem.isDefinedField("detail_field.rights")) {
                                licenseAgreementDialog dlg = new licenseAgreementDialog(XooNIpsItemView.this.superParent.getShell(), xnpItem);
                                if (dlg.open() == 0 && dlg.isAccept()) {
                                    doDownload = true;
                                }
                            } else {
                                doDownload = true;
                            }
                            if (doDownload) {
                                XooNIpsFile xnpFile = xnpItem.getFile(fieldName, index);
                                FileDialog dialog = new FileDialog(XooNIpsItemView.this.superParent.getShell(), 8192);
                                dialog.setFilterNames(new String[]{"All Files (*.*)"});
                                dialog.setFilterExtensions(new String[]{"."});
                                dialog.setFileName(xnpFile.getFileName());
                                dialog.setText("Save File");
                                String path = dialog.open();
                                if (path != null) {
                                    File srcFile = xnpFile.getFile(path);
                                    System.out.println(srcFile.getAbsolutePath());
                                }
                            }
                        }
                    }
                    catch (Exception excp) {
                        System.err.println(excp.getMessage());
                        excp.printStackTrace();
                    }
                    catch (Throwable excp) {
                        System.err.println(excp.getMessage());
                        excp.printStackTrace();
                    }
                }
                this.once = false;
            }
        });
        this.setBrowserData(browser, htmlBuffer);
    }

    private void createRelatedToTabWithBrowser(CTabFolder tabFolder, String tabTitle, StringBuffer htmlBuffer, LocationListener relatedtoBrowserLocationListener) {
        if (htmlBuffer == null) {
            return;
        }
        if (htmlBuffer.length() == 0) {
            return;
        }
        CTabItem tabItem = new CTabItem(tabFolder, 0);
        tabItem.setText(tabTitle);
        Composite composite = new Composite((Composite)tabFolder, 0);
        composite.setLayoutData((Object)new GridData(1808));
        GridLayout gl = new GridLayout();
        gl.marginHeight = 0;
        gl.marginWidth = 0;
        composite.setLayout((Layout)gl);
        Browser browser = new Browser(composite, 0);
        tabItem.setControl((Control)composite);
        browser.setLayoutData((Object)new GridData(1808));
        browser.addLocationListener(relatedtoBrowserLocationListener);
        this.setBrowserData(browser, htmlBuffer);
    }

    private void createIndexTabWithBrowser(CTabFolder tabFolder, String tabTitle, StringBuffer htmlBuffer, LocationListener indexBrowserLocationListener) {
        if (htmlBuffer == null) {
            return;
        }
        if (htmlBuffer.length() == 0) {
            return;
        }
        CTabItem tabItem = new CTabItem(tabFolder, 0);
        tabItem.setText(tabTitle);
        Composite composite = new Composite((Composite)tabFolder, 0);
        composite.setLayoutData((Object)new GridData(1808));
        GridLayout gl = new GridLayout();
        gl.marginHeight = 0;
        gl.marginWidth = 0;
        composite.setLayout((Layout)gl);
        Browser browser = new Browser(composite, 0);
        tabItem.setControl((Control)composite);
        browser.setLayoutData((Object)new GridData(1808));
        try {
            browser.addLocationListener(indexBrowserLocationListener);
        }
        catch (Exception excp) {
            excp.getStackTrace();
        }
        this.setBrowserData(browser, htmlBuffer);
    }

    private void setBrowserData(Browser browser, StringBuffer htmlBuffer) {
        try {
            File file = File.createTempFile("xoonipslink", ".html");
            FileWriter fw = new FileWriter(file);
            fw.write("<!DOCTYPE html PUBLIC \"-//W3C//DTD HTML 4.01//EN\" \"http://www.w3.org/TR/html4/strict.dtd\">");
            fw.write("<html>");
            fw.write("<head><meta http-equiv=\"Content-Type\" content=\"text/html; charset=UTF-8\"></head>");
            fw.write(this.createCssForHTML().toString());
            fw.write(htmlBuffer.toString());
            fw.write("</html>");
            fw.close();
            browser.setUrl(file.toURL().toString());
        }
        catch (Exception excp) {
            excp.getStackTrace();
        }
    }

    private StringBuffer createCssForHTML() {
        StringBuffer strBuf = new StringBuffer();
        strBuf.append("<style type=\"text/css\">");
        strBuf.append("#style1{padding: 5px;border: solid 1px #c0c0c0;background: #f0f8ff}");
        strBuf.append("#style2{padding: 5px;border: solid 1px #c0c0c0}");
        strBuf.append("#style3{padding: 5px;border: solid 1px #c0c0c0;background: #dcdcdc}");
        strBuf.append("</style>");
        return strBuf;
    }

    private void createTitleForHTML(StringBuffer strBuf, XooNIpsItem xnpItem) {
        String iconPath = null;
        iconPath = xnpItem.getItemType().getTypeName().equals("xnpbook") ? "icons/icon_book.gif" : (xnpItem.getItemType().getTypeName().equals("xnpconference") ? "icons/icon_conference.gif" : (xnpItem.getItemType().getTypeName().equals("xnpdata") ? "icons/icon_data.gif" : (xnpItem.getItemType().getTypeName().equals("xnpfiles") ? "icons/icon_files.gif" : (xnpItem.getItemType().getTypeName().equals("xnpmemo") ? "icons/icon_memo.gif" : (xnpItem.getItemType().getTypeName().equals("xnpmodel") ? "icons/icon_model.gif" : (xnpItem.getItemType().getTypeName().equals("xnppaper") ? "icons/icon_paper.gif" : (xnpItem.getItemType().getTypeName().equals("xnppresentation") ? "icons/icon_presentation.gif" : (xnpItem.getItemType().getTypeName().equals("xnpsimulator") ? "icons/icon_simulator.gif" : (xnpItem.getItemType().getTypeName().equals("xnpstimulus") ? "icons/icon_stimulus.gif" : (xnpItem.getItemType().getTypeName().equals("xnptool") ? "icons/icon_tool.gif" : (xnpItem.getItemType().getTypeName().equals("xnpurl") ? "icons/icon_url.gif" : (xnpItem.getItemType().getTypeName().equals("xnpbinder") ? "icons/icon_binder.gif" : "icons/icon_files.gif"))))))))))));
        String path = XoonipsLink2Plugin.getDefault().getFilePath(iconPath);
        strBuf.append("<table width=\"100%\"><tr>");
        strBuf.append("<td width=\"50\" align=\"center\"><img alt=\"XooNIps\" border=\"0\" src=\"file://" + path + "\"/></td>");
        String[] titles = xnpItem.getTitles();
        if (titles.length > 0) {
            strBuf.append("<td align=\"left\">" + titles[0] + "</td>");
        } else {
            strBuf.append("<td align=\"left\">None Title</td>");
        }
        strBuf.append("</tr></table>");
    }

    private void createTitleForHTML(StringBuffer strBuf, XooNIpsSimpleItem xnpSimpleItem) {
        String iconPath = null;
        iconPath = xnpSimpleItem.getItemType().getTypeName().equals("xnpbook") ? "icons/icon_book.gif" : (xnpSimpleItem.getItemType().getTypeName().equals("xnpconference") ? "icons/icon_conference.gif" : (xnpSimpleItem.getItemType().getTypeName().equals("xnpdata") ? "icons/icon_data.gif" : (xnpSimpleItem.getItemType().getTypeName().equals("xnpfiles") ? "icons/icon_files.gif" : (xnpSimpleItem.getItemType().getTypeName().equals("xnpmemo") ? "icons/icon_memo.gif" : (xnpSimpleItem.getItemType().getTypeName().equals("xnpmodel") ? "icons/icon_model.gif" : (xnpSimpleItem.getItemType().getTypeName().equals("xnppaper") ? "icons/icon_paper.gif" : (xnpSimpleItem.getItemType().getTypeName().equals("xnppresentation") ? "icons/icon_presentation.gif" : (xnpSimpleItem.getItemType().getTypeName().equals("xnpsimulator") ? "icons/icon_simulator.gif" : (xnpSimpleItem.getItemType().getTypeName().equals("xnpstimulus") ? "icons/icon_stimulus.gif" : (xnpSimpleItem.getItemType().getTypeName().equals("xnptool") ? "icons/icon_tool.gif" : (xnpSimpleItem.getItemType().getTypeName().equals("xnpurl") ? "icons/icon_url.gif" : (xnpSimpleItem.getItemType().getTypeName().equals("xnpbinder") ? "icons/icon_binder.gif" : "icons/icon_files.gif"))))))))))));
        String path = XoonipsLink2Plugin.getDefault().getFilePath(iconPath);
        strBuf.append("<table width=\"100%\"><tr>");
        strBuf.append("<td width=\"50\" align=\"center\"><img alt=\"XooNIps\" border=\"0\" src=\"file://" + path + "\"/></td>");
        String title = xnpSimpleItem.getTitle();
        if (title.length() > 0) {
            String value = String.valueOf(xnpSimpleItem.getItemID());
            strBuf.append("<td align=\"left\">");
            strBuf.append("<a href=\"xoonips://" + value + "\">");
            strBuf.append(title);
            strBuf.append("</a>");
            strBuf.append("</td>");
        } else {
            strBuf.append("<td align=\"left\">None Title</td>");
        }
        strBuf.append("</tr></table>");
    }

    private String createKeyAndValueForHTML(String displayName, String value) {
        StringBuffer strBuf = new StringBuffer();
        strBuf.append("<tr>");
        strBuf.append("<td valign=\"top\" width=\"150\">" + displayName + "</td>");
        strBuf.append("<td>" + value + "</td>");
        strBuf.append("</tr>");
        return strBuf.toString();
    }

    private String createStringTypeAndDateTypeForHTML(XooNIpsItem xnpItem, String fieldName, String sepalator) {
        StringBuffer buf = new StringBuffer();
        XooNIpsItemType xnpItemType = xnpItem.getItemType();
        if (sepalator == null) {
            sepalator = ", ";
        }
        if (sepalator.length() == 0) {
            sepalator = ", ";
        }
        String displayName = "";
        try {
            if (xnpItemType.isDefinedField(fieldName)) {
                if (xnpItemType.getFieldType(fieldName).equals("STRING")) {
                    displayName = xnpItemType.getDisplayName(fieldName);
                    if (xnpItemType.isMultiple(fieldName)) {
                        String[] values = xnpItem.getValues(fieldName);
                        int i = 0;
                        while (i < values.length) {
                            if (i > 0) {
                                buf.append(sepalator);
                            }
                            buf.append(values[i]);
                            ++i;
                        }
                    } else if (fieldName.equalsIgnoreCase("item_id")) {
                        int item_id = xnpItem.getItemID();
                        buf.append(item_id);
                    } else if (fieldName.equalsIgnoreCase("itemtype")) {
                        displayName = "Item Type";
                        buf.append(xnpItemType.getTitle());
                    } else if (fieldName.equalsIgnoreCase("creation_year")) {
                        buf.append(xnpItem.getCreationDate());
                    } else if (!fieldName.equalsIgnoreCase("creation_month") && !fieldName.equalsIgnoreCase("creation_mday")) {
                        if (xnpItemType.hasOptions(fieldName)) {
                            String value = null;
                            if (fieldName.equals("lang")) {
                                value = xnpItem.getLang();
                                if (value == null) {
                                    value = "eng";
                                }
                                if (value.length() == 0) {
                                    value = "eng";
                                }
                            } else {
                                value = xnpItem.getValue(fieldName);
                            }
                            String[] optionNames = xnpItemType.getOptionNames(fieldName);
                            int j = 0;
                            while (j < optionNames.length) {
                                if (optionNames[j].equals(value)) {
                                    String[] optionDisplayNames = xnpItemType.getOptionDisplayNames(fieldName);
                                    buf.append(optionDisplayNames[j]);
                                    break;
                                }
                                ++j;
                            }
                        } else {
                            String[] values = xnpItem.getValues(fieldName);
                            int i = 0;
                            while (i < values.length) {
                                if (i > 0) {
                                    buf.append(sepalator);
                                }
                                buf.append(values[i]);
                                ++i;
                            }
                        }
                    }
                } else if (xnpItemType.getFieldType(fieldName).equals("DATE")) {
                    displayName = xnpItemType.getDisplayName(fieldName);
                    Calendar cal = null;
                    String format = "MMM d, yyyy HH:mm:ss";
                    if (fieldName.equalsIgnoreCase("last_modified_date")) {
                        cal = xnpItem.getLastUpdateDate();
                    } else if (fieldName.equalsIgnoreCase("registration_date")) {
                        cal = xnpItem.getRegistrationDate();
                    } else if (fieldName.equals("detail_field.conference_from")) {
                        cal = xnpItem.getDateValue(fieldName);
                        format = "MMM d, yyyy";
                    } else if (fieldName.equals("detail_field.conference_to")) {
                        cal = xnpItem.getDateValue(fieldName);
                        format = "MMM d, yyyy";
                    } else {
                        cal = xnpItem.getDateValue(fieldName);
                    }
                    if (cal != null) {
                        SimpleDateFormat myformat = new SimpleDateFormat(format, Locale.US);
                        Date date = cal.getTime();
                        String value = myformat.format(date);
                        buf.append(value);
                    } else {
                        String value = xnpItem.getValue(fieldName);
                        buf.append(value);
                    }
                }
            }
            return this.createKeyAndValueForHTML(displayName, buf.toString());
        }
        catch (XooNIpsException excp) {
            System.out.println((Object)excp);
            excp.printStackTrace();
            return "";
        }
    }

    private String createDateTypeForHTML(XooNIpsItem xnpItem, String fieldName, String format) {
        StringBuffer buf = new StringBuffer();
        XooNIpsItemType xnpItemType = xnpItem.getItemType();
        try {
            if (xnpItemType.isDefinedField(fieldName) && xnpItemType.getFieldType(fieldName).equals("DATE")) {
                String displayName = xnpItemType.getDisplayName(fieldName);
                Calendar cal = null;
                cal = fieldName.equalsIgnoreCase("last_modified_date") ? xnpItem.getLastUpdateDate() : (fieldName.equalsIgnoreCase("registration_date") ? xnpItem.getRegistrationDate() : xnpItem.getDateValue(fieldName));
                if (cal != null) {
                    if (format == null) {
                        format = "MMM d, yyyy HH:mm:ss";
                    }
                    if (format.length() == 0) {
                        format = "MMM d, yyyy HH:mm:ss";
                    }
                    SimpleDateFormat myformat = new SimpleDateFormat(format, Locale.US);
                    Date date = cal.getTime();
                    String value = myformat.format(date);
                    buf.append(value);
                } else {
                    String value = xnpItem.getValue(fieldName);
                    buf.append(value);
                }
                return this.createKeyAndValueForHTML(displayName, buf.toString());
            }
        }
        catch (XooNIpsException excp) {
            System.out.println((Object)excp);
            excp.printStackTrace();
        }
        return "";
    }

    private String createURLForHTML(XooNIpsItem xnpItem, String fieldName) {
        StringBuffer buf = new StringBuffer();
        XooNIpsItemType xnpItemType = xnpItem.getItemType();
        try {
            if (xnpItemType.isDefinedField(fieldName) && xnpItemType.getFieldType(fieldName).equals("STRING")) {
                String displayName = xnpItemType.getDisplayName(fieldName);
                String value = xnpItem.getValue(fieldName);
                buf.append("<a href=\"" + value + "\">");
                if (value.length() > 64) {
                    buf.append(String.valueOf(value.substring(0, 64)) + " ...");
                } else {
                    buf.append(value);
                }
                buf.append("</a>");
                return this.createKeyAndValueForHTML(displayName, buf.toString());
            }
        }
        catch (XooNIpsException excp) {
            System.out.println((Object)excp);
            excp.printStackTrace();
        }
        return "";
    }

    private StringBuffer createRelatedToForHTML(XooNIpsConnection xoonipsConnection, XooNIpsItem xnpItem) {
        StringBuffer strBuf = new StringBuffer();
        try {
            int[] ids = xnpItem.getRelatedTos();
            XooNIpsSimpleItem[] items = xoonipsConnection.getXooNIpsSession().getXooNIpsSimpleItems(ids, ids.length);
            int i = 0;
            while (i < items.length) {
                this.createTitleForHTML(strBuf, items[i]);
                ++i;
            }
        }
        catch (Exception exception) {}
        return strBuf;
    }

    private StringBuffer creatrIndexToForHTML(XooNIpsConnection xoonipsConnection, XooNIpsItem xnpItem) {
        StringBuffer strBuf = new StringBuffer();
        try {
            int[] indexes = xnpItem.getIndexes();
            if (indexes.length > 0) {
                strBuf.append("<table width=\"100%\">");
                int i = 0;
                while (i < indexes.length) {
                    String path = this.getIndexKeywordPath(xoonipsConnection, indexes[i]);
                    if (path != null && path.length() > 0) {
                        strBuf.append("<tr>");
                        String value = String.valueOf(indexes[i]);
                        strBuf.append("<td align=\"left\">");
                        strBuf.append("<a href=\"xoonips://" + value + "\">");
                        strBuf.append(path);
                        strBuf.append("</a>");
                        strBuf.append("</td>");
                        strBuf.append("</tr>");
                    }
                    ++i;
                }
                strBuf.append("</table>");
            }
        }
        catch (Exception exception) {}
        return strBuf;
    }

    private String getIndexKeywordPath(XooNIpsConnection xoonipsConnection, int index) {
        StringBuffer strBuf = new StringBuffer();
        try {
            int count = 0;
            while (index != -1) {
                XooNIpsIndex xnpIndex = xoonipsConnection.getXooNIpsSession().getIndex(index);
                strBuf.insert(0, "/ " + xnpIndex.getIndexString() + " ");
                index = xnpIndex.getParentIndex();
                if (32 > count) {
                    ++count;
                    continue;
                }
                break;
            }
        }
        catch (XooNIpsException xooNIpsException) {
        }
        catch (Exception exception) {}
        return strBuf.toString();
    }

    private void createBasicForHTML(StringBuffer strBuf, XooNIpsItem xnpItem) {
        strBuf.append("<table>");
        String[] titles = xnpItem.getTitles();
        if (titles.length > 0) {
            strBuf.append(this.createKeyAndValueForHTML("Title", titles[0]));
        } else {
            strBuf.append(this.createKeyAndValueForHTML("Title", ""));
        }
        strBuf.append(this.createStringTypeAndDateTypeForHTML(xnpItem, "itemtype", null));
        strBuf.append(this.createStringTypeAndDateTypeForHTML(xnpItem, "keywords", null));
        strBuf.append(this.createStringTypeAndDateTypeForHTML(xnpItem, "comment", null));
        strBuf.append(this.createStringTypeAndDateTypeForHTML(xnpItem, "ext_id", null));
        strBuf.append(this.createStringTypeAndDateTypeForHTML(xnpItem, "username", null));
        strBuf.append(this.createDateTypeForHTML(xnpItem, "last_modified_date", null));
        strBuf.append(this.createDateTypeForHTML(xnpItem, "registration_date", null));
        strBuf.append(this.createStringTypeAndDateTypeForHTML(xnpItem, "lang", null));
        strBuf.append(this.createURLForHTML(xnpItem, "url"));
        strBuf.append(this.createStringTypeAndDateTypeForHTML(xnpItem, "item_id", null));
        strBuf.append("</table>");
    }

    private Image createThumbnail(File file, int thumbnailImageSize) {
        try {
            ImageLoader imgldr;
            ImageData[] imgdata;
            if (file != null && file.exists() && (imgdata = (imgldr = new ImageLoader()).load(file.getAbsolutePath())).length > 0) {
                ImageData imagedata = imgdata[0];
                int width = thumbnailImageSize;
                int height = thumbnailImageSize;
                if (imagedata.width > thumbnailImageSize || imagedata.height > thumbnailImageSize) {
                    ImageData newimagedata;
                    float a;
                    if (imagedata.width > imagedata.height) {
                        a = imagedata.width;
                        float b = thumbnailImageSize;
                        float c = imagedata.height;
                        float ans = a / b;
                        height = (int)(c / ans);
                    } else {
                        a = imagedata.height;
                        float b = thumbnailImageSize;
                        float c = imagedata.width;
                        float ans = a / b;
                        width = (int)(c / ans);
                    }
                    imagedata = newimagedata = imagedata.scaledTo(width, height);
                }
                Image newImage = new Image((Device)this.superParent.getDisplay(), imagedata);
                return newImage;
            }
        }
        catch (Exception excp) {
            System.out.println(excp);
            excp.printStackTrace();
        }
        return null;
    }

    private String createRightsString(XooNIpsItem xnpItem) {
        String rights = "";
        try {
            if (xnpItem.isDefinedField("detail_field.use_cc")) {
                String use_cc = xnpItem.getValue("detail_field.use_cc");
                if (use_cc.equals("0")) {
                    rights = xnpItem.getValue("detail_field.rights");
                } else if (use_cc.equals("1")) {
                    try {
                        String value = xnpItem.getValue("detail_field.rights");
                        SAXParserFactory saxParserFactory = SAXParserFactory.newInstance();
                        saxParserFactory.setValidating(true);
                        SAXParser saxParser = saxParserFactory.newSAXParser();
                        StringReader sr = new StringReader(value);
                        InputSource inputSource = new InputSource(sr);
                        CCRightsSax xs = new CCRightsSax();
                        saxParser.parse(inputSource, (DefaultHandler)xs);
                        return xs.getRight();
                    }
                    catch (Exception exception) {
                        String cc_commercial_use = xnpItem.getValue("detail_field.cc_commercial_use");
                        String cc_modification = xnpItem.getValue("detail_field.cc_modification");
                        String rightsHead = "";
                        String rightsLink = "";
                        if (cc_commercial_use.equals("1") && cc_modification.equals("2")) {
                            rightsHead = "This work is licensed under a Creative Commons Attribution 2.5 License.";
                            rightsLink = "http://creativecommons.org/licenses/by/2.5/";
                        } else if (cc_commercial_use.equals("1") && cc_modification.equals("1")) {
                            rightsHead = "This work is licensed under a Creative Commons Attribution-ShareAlike 2.5 License.";
                            rightsLink = "http://creativecommons.org/licenses/by-sa/2.5/";
                        } else if (cc_commercial_use.equals("1") && cc_modification.equals("0")) {
                            rightsHead = "This work is licensed under a Creative Commons Attribution-NoDerivs 2.5 License.";
                            rightsLink = "http://creativecommons.org/licenses/by-nd/2.5/";
                        } else if (cc_commercial_use.equals("0") && cc_modification.equals("2")) {
                            rightsHead = "This work is licensed under a Creative Commons Attribution-NonCommercial 2.5 License.";
                            rightsLink = "http://creativecommons.org/licenses/by-nc/2.5/";
                        } else if (cc_commercial_use.equals("0") && cc_modification.equals("1")) {
                            rightsHead = "This work is licensed under a Creative Commons Attribution-NonCommercial-ShareAlike 2.5 License.";
                            rightsLink = "http://creativecommons.org/licenses/by-nc-sa/2.5/";
                        } else if (cc_commercial_use.equals("0") && cc_modification.equals("0")) {
                            rightsHead = "This work is licensed under a Creative Commons Attribution-NonCommercial-NoDerivs 2.5 License.";
                            rightsLink = "http://creativecommons.org/licenses/by-nc-nd/2.5/";
                        }
                        rights = String.valueOf(rightsHead) + " " + rightsLink;
                    }
                }
            }
        }
        catch (Exception excp) {
            System.err.println(excp.getMessage());
        }
        return rights;
    }

    private void disposeControls(Composite parent) {
        Control[] controls = parent.getChildren();
        int i = 0;
        while (i < controls.length) {
            if (controls[i] instanceof Composite) {
                this.disposeControls((Composite)controls[i]);
            } else if (controls[i] instanceof Label) {
                Label srcObj = (Label)controls[i];
                Image img = srcObj.getImage();
                srcObj.setImage(null);
                if (img != null) {
                    img.dispose();
                }
                img = null;
            }
            controls[i].dispose();
            controls[i] = null;
            ++i;
        }
    }
}

