/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.text;

import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.text.Assert;
import org.eclipse.jface.text.IInformationControl;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.IInformationControlCreatorExtension;
import org.eclipse.jface.text.IInformationControlExtension;
import org.eclipse.jface.text.IInformationControlExtension2;
import org.eclipse.jface.text.IInformationControlExtension3;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;

public abstract class AbstractInformationControlManager {
    private static final Anchor[] ANCHORS = new Anchor[]{new Anchor(), new Anchor(), new Anchor(), new Anchor()};
    public static final Anchor ANCHOR_TOP = ANCHORS[0];
    public static final Anchor ANCHOR_BOTTOM = ANCHORS[1];
    public static final Anchor ANCHOR_LEFT = ANCHORS[2];
    public static final Anchor ANCHOR_RIGHT = ANCHORS[3];
    public static final Anchor ANCHOR_GLOBAL = new Anchor();
    public static final String STORE_LOCATION_X = "location.x";
    public static final String STORE_LOCATION_Y = "location.y";
    public static final String STORE_SIZE_WIDTH = "size.width";
    public static final String STORE_SIZE_HEIGHT = "size.height";
    private Control fSubjectControl;
    private Rectangle fSubjectArea;
    private Object fInformation;
    private boolean fTakesFocusWhenVisible = false;
    protected IInformationControl fInformationControl;
    protected IInformationControlCreator fInformationControlCreator;
    protected IInformationControlCloser fInformationControlCloser;
    protected boolean fDisposed = false;
    private boolean fEnabled = false;
    private Point fSizeConstraints;
    private int fMarginY = 5;
    private int fMarginX = 5;
    private int fWidthConstraint = 60;
    private int fHeightConstraint = 6;
    private boolean fEnforceAsMinimalSize = false;
    private boolean fEnforceAsMaximalSize = false;
    private Anchor fAnchor = ANCHOR_BOTTOM;
    private Anchor[] fFallbackAnchors = ANCHORS;
    private volatile IInformationControlCreator fCustomInformationControlCreator;
    private boolean fIsCustomInformationControl = false;
    private IDialogSettings fDialogSettings;
    private boolean fIsRestoringLocation;
    private boolean fIsRestoringSize;
    private DisposeListener fSubjectControlDisposeListener;

    protected AbstractInformationControlManager(IInformationControlCreator creator) {
        Assert.isNotNull((Object)creator);
        this.fInformationControlCreator = creator;
    }

    protected abstract void computeInformation();

    protected final void setInformation(String information, Rectangle subjectArea) {
        this.fInformation = information;
        this.fSubjectArea = subjectArea;
        this.presentInformation();
    }

    protected final void setInformation(Object information, Rectangle subjectArea) {
        this.fInformation = information;
        this.fSubjectArea = subjectArea;
        this.presentInformation();
    }

    protected void setCloser(IInformationControlCloser closer) {
        this.fInformationControlCloser = closer;
    }

    public void setMargins(int xMargin, int yMargin) {
        this.fMarginX = xMargin;
        this.fMarginY = yMargin;
    }

    public void setSizeConstraints(int widthInChar, int heightInChar, boolean enforceAsMinimalSize, boolean enforceAsMaximalSize) {
        this.fSizeConstraints = null;
        this.fWidthConstraint = widthInChar;
        this.fHeightConstraint = heightInChar;
        this.fEnforceAsMinimalSize = enforceAsMinimalSize;
        this.fEnforceAsMaximalSize = enforceAsMaximalSize;
    }

    public void setRestoreInformationControlBounds(IDialogSettings dialogSettings, boolean restoreLocation, boolean restoreSize) {
        Assert.isTrue((dialogSettings != null && (restoreLocation || restoreSize) ? 1 : 0) != 0);
        this.fDialogSettings = dialogSettings;
        this.fIsRestoringLocation = restoreLocation;
        this.fIsRestoringSize = restoreSize;
    }

    public void setAnchor(Anchor anchor) {
        this.fAnchor = anchor;
    }

    public void setFallbackAnchors(Anchor[] fallbackAnchors) {
        if (fallbackAnchors != null) {
            this.fFallbackAnchors = new Anchor[fallbackAnchors.length];
            System.arraycopy(fallbackAnchors, 0, this.fFallbackAnchors, 0, fallbackAnchors.length);
        } else {
            this.fFallbackAnchors = null;
        }
    }

    protected void setCustomInformationControlCreator(IInformationControlCreator informationControlCreator) {
        IInformationControlCreatorExtension extension;
        if (informationControlCreator != null && this.fCustomInformationControlCreator instanceof IInformationControlCreatorExtension && (extension = (IInformationControlCreatorExtension)((Object)this.fCustomInformationControlCreator)).canReplace(informationControlCreator)) {
            return;
        }
        this.fCustomInformationControlCreator = informationControlCreator;
    }

    public void takesFocusWhenVisible(boolean takesFocus) {
        this.fTakesFocusWhenVisible = takesFocus;
    }

    protected void handleSubjectControlDisposed() {
        this.disposeInformationControl();
    }

    public void install(Control subjectControl) {
        if (this.fSubjectControl != null && !this.fSubjectControl.isDisposed() && this.fSubjectControlDisposeListener != null) {
            this.fSubjectControl.removeDisposeListener(this.fSubjectControlDisposeListener);
        }
        this.fSubjectControl = subjectControl;
        if (this.fSubjectControl != null) {
            this.fSubjectControl.addDisposeListener(this.getSubjectControlDisposeListener());
        }
        if (this.fInformationControlCloser != null) {
            this.fInformationControlCloser.setSubjectControl(subjectControl);
        }
        this.setEnabled(true);
        this.fDisposed = false;
    }

    private DisposeListener getSubjectControlDisposeListener() {
        if (this.fSubjectControlDisposeListener == null) {
            this.fSubjectControlDisposeListener = new DisposeListener(){

                public void widgetDisposed(DisposeEvent e) {
                    AbstractInformationControlManager.this.handleSubjectControlDisposed();
                }
            };
        }
        return this.fSubjectControlDisposeListener;
    }

    protected Control getSubjectControl() {
        return this.fSubjectControl;
    }

    protected Rectangle getSubjectArea() {
        return this.fSubjectArea;
    }

    public void setEnabled(boolean enabled) {
        this.fEnabled = enabled;
    }

    protected boolean isEnabled() {
        return this.fEnabled;
    }

    protected Point computeSizeConstraints(Control subjectControl, IInformationControl informationControl) {
        if (this.fSizeConstraints == null) {
            if (subjectControl == null) {
                return null;
            }
            GC gc = new GC((Drawable)subjectControl);
            gc.setFont(subjectControl.getFont());
            int width = gc.getFontMetrics().getAverageCharWidth();
            int height = gc.getFontMetrics().getHeight();
            gc.dispose();
            this.fSizeConstraints = new Point(this.fWidthConstraint * width, this.fHeightConstraint * height);
        }
        return new Point(this.fSizeConstraints.x, this.fSizeConstraints.y);
    }

    protected Point computeSizeConstraints(Control subjectControl, Rectangle subjectArea, IInformationControl informationControl) {
        return this.computeSizeConstraints(subjectControl, informationControl);
    }

    protected void handleInformationControlDisposed() {
        this.storeInformationControlBounds();
        this.fInformationControl = null;
        if (this.fInformationControlCloser != null) {
            this.fInformationControlCloser.setInformationControl(null);
            this.fInformationControlCloser.stop();
        }
    }

    protected IInformationControl getInformationControl() {
        if (this.fDisposed) {
            return this.fInformationControl;
        }
        IInformationControlCreator creator = null;
        if (this.fCustomInformationControlCreator == null) {
            creator = this.fInformationControlCreator;
            if (this.fIsCustomInformationControl && this.fInformationControl != null) {
                this.fInformationControl.dispose();
                this.fInformationControl = null;
            }
            this.fIsCustomInformationControl = false;
        } else {
            creator = this.fCustomInformationControlCreator;
            if (creator instanceof IInformationControlCreatorExtension) {
                IInformationControlCreatorExtension extension = (IInformationControlCreatorExtension)((Object)creator);
                if (this.fInformationControl != null && extension.canReuse(this.fInformationControl)) {
                    return this.fInformationControl;
                }
            }
            if (this.fInformationControl != null) {
                this.fInformationControl.dispose();
                this.fInformationControl = null;
            }
            this.fIsCustomInformationControl = true;
        }
        if (this.fInformationControl == null) {
            this.fInformationControl = creator.createInformationControl(this.fSubjectControl.getShell());
            this.fInformationControl.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent e) {
                    AbstractInformationControlManager.this.handleInformationControlDisposed();
                }
            });
            if (this.fInformationControlCloser != null) {
                this.fInformationControlCloser.setInformationControl(this.fInformationControl);
            }
        }
        return this.fInformationControl;
    }

    protected Point computeLocation(Rectangle subjectArea, Point controlSize, Anchor anchor) {
        boolean isRTL;
        if (ANCHOR_GLOBAL == anchor) {
            Point subjectControlSize = this.fSubjectControl.getSize();
            Point location = new Point(subjectControlSize.x / 2, subjectControlSize.y / 2);
            location.x -= controlSize.x / 2;
            location.y -= controlSize.y / 2;
            return this.fSubjectControl.toDisplay(location);
        }
        int xShift = 0;
        int yShift = 0;
        if (ANCHOR_BOTTOM == anchor) {
            xShift = this.fMarginX;
            yShift = subjectArea.height + this.fMarginY;
        } else if (ANCHOR_RIGHT == anchor) {
            xShift = this.fMarginX + subjectArea.width;
            yShift = this.fMarginY;
        } else if (ANCHOR_TOP == anchor) {
            xShift = this.fMarginX;
            yShift = -controlSize.y - this.fMarginY;
        } else if (ANCHOR_LEFT == anchor) {
            xShift = -controlSize.x - this.fMarginX;
            yShift = this.fMarginY;
        }
        boolean bl = isRTL = this.fSubjectControl != null && (this.fSubjectControl.getStyle() & 0x4000000) != 0;
        if (isRTL) {
            xShift += controlSize.x;
        }
        return this.fSubjectControl.toDisplay(new Point(subjectArea.x + xShift, subjectArea.y + yShift));
    }

    protected boolean updateLocation(Point location, Point size, Rectangle displayArea, Anchor anchor) {
        int displayLowerRightX = displayArea.x + displayArea.width;
        int displayLowerRightY = displayArea.y + displayArea.height;
        int lowerRightX = location.x + size.x;
        int lowerRightY = location.y + size.y;
        if (ANCHOR_BOTTOM == anchor || ANCHOR_TOP == anchor) {
            if (ANCHOR_BOTTOM == anchor ? lowerRightY > displayLowerRightY : location.y < displayArea.y) {
                return false;
            }
            if (lowerRightX > displayLowerRightX) {
                location.x -= lowerRightX - displayLowerRightX;
            }
            return location.x >= displayArea.x && location.y >= displayArea.y;
        }
        if (ANCHOR_RIGHT == anchor || ANCHOR_LEFT == anchor) {
            if (ANCHOR_RIGHT == anchor ? lowerRightX > displayLowerRightX : location.x < displayArea.x) {
                return false;
            }
            if (lowerRightY > displayLowerRightY) {
                location.y -= lowerRightY - displayLowerRightY;
            }
            return location.x >= displayArea.x && location.y >= displayArea.y;
        }
        if (ANCHOR_GLOBAL == anchor) {
            if (lowerRightX > displayLowerRightX) {
                location.x -= lowerRightX - displayLowerRightX;
            }
            if (lowerRightY > displayLowerRightY) {
                location.y -= lowerRightY - displayLowerRightY;
            }
            return location.x >= displayArea.x && location.y >= displayArea.y;
        }
        return false;
    }

    protected Anchor getNextFallbackAnchor(Anchor anchor) {
        if (anchor == null || this.fFallbackAnchors == null) {
            return null;
        }
        int i = 0;
        while (i < this.fFallbackAnchors.length) {
            if (this.fFallbackAnchors[i] == anchor) {
                return this.fFallbackAnchors[i + 1 == this.fFallbackAnchors.length ? 0 : i + 1];
            }
            ++i;
        }
        return null;
    }

    protected Point computeInformationControlLocation(Rectangle subjectArea, Point controlSize) {
        Point upperLeft;
        Rectangle displayBounds = this.fSubjectControl.getDisplay().getClientArea();
        Anchor testAnchor = this.fAnchor;
        while (!this.updateLocation(upperLeft = this.computeLocation(subjectArea, controlSize, testAnchor), controlSize, displayBounds, testAnchor) && (testAnchor = this.getNextFallbackAnchor(testAnchor)) != this.fAnchor && testAnchor != null) {
        }
        return upperLeft;
    }

    public void showInformation() {
        if (this.fEnabled) {
            this.doShowInformation();
        }
    }

    protected void doShowInformation() {
        this.fSubjectArea = null;
        this.fInformation = null;
        this.computeInformation();
    }

    protected void presentInformation() {
        boolean hasContents = false;
        if (this.fInformation instanceof String) {
            hasContents = ((String)this.fInformation).trim().length() > 0;
        } else {
            boolean bl = hasContents = this.fInformation != null;
        }
        if (this.fSubjectArea != null && hasContents) {
            this.internalShowInformationControl(this.fSubjectArea, this.fInformation);
        } else {
            this.hideInformationControl();
        }
    }

    private void internalShowInformationControl(Rectangle subjectArea, Object information) {
        IInformationControl informationControl = this.getInformationControl();
        if (informationControl != null) {
            IInformationControlExtension extension;
            Point sizeConstraints = this.computeSizeConstraints(this.fSubjectControl, this.fSubjectArea, informationControl);
            informationControl.setSizeConstraints(sizeConstraints.x, sizeConstraints.y);
            if (informationControl instanceof IInformationControlExtension2) {
                ((IInformationControlExtension2)((Object)informationControl)).setInput(information);
            } else {
                informationControl.setInformation(information.toString());
            }
            if (informationControl instanceof IInformationControlExtension && !(extension = (IInformationControlExtension)((Object)informationControl)).hasContents()) {
                return;
            }
            Point size = null;
            Point location = null;
            Rectangle bounds = this.restoreInformationControlBounds();
            if (bounds != null) {
                if (bounds.x > -1 && bounds.y > -1) {
                    location = new Point(bounds.x, bounds.y);
                }
                if (bounds.width > -1 && bounds.height > -1) {
                    size = new Point(bounds.width, bounds.height);
                }
            }
            if (size == null) {
                size = informationControl.computeSizeHint();
            }
            if (this.fEnforceAsMinimalSize) {
                if (size.x < sizeConstraints.x) {
                    size.x = sizeConstraints.x;
                }
                if (size.y < sizeConstraints.y) {
                    size.y = sizeConstraints.y;
                }
            }
            if (this.fEnforceAsMaximalSize) {
                if (size.x > sizeConstraints.x) {
                    size.x = sizeConstraints.x;
                }
                if (size.y > sizeConstraints.y) {
                    size.y = sizeConstraints.y;
                }
            }
            informationControl.setSize(size.x, size.y);
            if (location == null) {
                location = this.computeInformationControlLocation(subjectArea, size);
            }
            informationControl.setLocation(location);
            Rectangle displayBounds = this.fSubjectControl.getDisplay().getClientArea();
            boolean resize = false;
            if (location.x + size.x > displayBounds.x + displayBounds.width) {
                size.x = Math.max(0, displayBounds.x + displayBounds.width - location.x);
                resize = true;
            }
            if (location.y + size.y > displayBounds.y + displayBounds.height) {
                size.y = Math.max(0, displayBounds.y + displayBounds.height - location.y);
                resize = true;
            }
            if (resize) {
                informationControl.setSize(size.x, size.y);
            }
            this.showInformationControl(subjectArea);
        }
    }

    protected void hideInformationControl() {
        if (this.fInformationControl != null) {
            this.storeInformationControlBounds();
            this.fInformationControl.setVisible(false);
            if (this.fInformationControlCloser != null) {
                this.fInformationControlCloser.stop();
            }
        }
    }

    protected void showInformationControl(Rectangle subjectArea) {
        this.fInformationControl.setVisible(true);
        if (this.fTakesFocusWhenVisible) {
            this.fInformationControl.setFocus();
        }
        if (this.fInformationControlCloser != null) {
            this.fInformationControlCloser.start(subjectArea);
        }
    }

    public void disposeInformationControl() {
        if (this.fInformationControl != null) {
            this.fInformationControl.dispose();
            this.handleInformationControlDisposed();
        }
    }

    public void dispose() {
        if (!this.fDisposed) {
            this.fDisposed = true;
            this.setEnabled(false);
            this.disposeInformationControl();
            if (this.fSubjectControl != null && !this.fSubjectControl.isDisposed() && this.fSubjectControlDisposeListener != null) {
                this.fSubjectControl.removeDisposeListener(this.fSubjectControlDisposeListener);
            }
            this.fSubjectControl = null;
            this.fSubjectControlDisposeListener = null;
            this.fIsCustomInformationControl = false;
            this.fCustomInformationControlCreator = null;
            this.fInformationControlCreator = null;
            this.fInformationControlCloser = null;
        }
    }

    protected void storeInformationControlBounds() {
        if (this.fDialogSettings == null || this.fInformationControl == null || !this.fIsRestoringLocation && !this.fIsRestoringSize) {
            return;
        }
        if (!(this.fInformationControl instanceof IInformationControlExtension3)) {
            throw new UnsupportedOperationException();
        }
        boolean controlRestoresSize = ((IInformationControlExtension3)((Object)this.fInformationControl)).restoresSize();
        boolean controlRestoresLocation = ((IInformationControlExtension3)((Object)this.fInformationControl)).restoresLocation();
        Rectangle bounds = ((IInformationControlExtension3)((Object)this.fInformationControl)).getBounds();
        if (bounds == null) {
            return;
        }
        if (this.fIsRestoringSize && controlRestoresSize) {
            this.fDialogSettings.put(STORE_SIZE_WIDTH, bounds.width);
            this.fDialogSettings.put(STORE_SIZE_HEIGHT, bounds.height);
        }
        if (this.fIsRestoringLocation && controlRestoresLocation) {
            this.fDialogSettings.put(STORE_LOCATION_X, bounds.x);
            this.fDialogSettings.put(STORE_LOCATION_Y, bounds.y);
        }
    }

    protected Rectangle restoreInformationControlBounds() {
        if (this.fDialogSettings == null || !this.fIsRestoringLocation && !this.fIsRestoringSize) {
            return null;
        }
        if (!(this.fInformationControl instanceof IInformationControlExtension3)) {
            throw new UnsupportedOperationException();
        }
        boolean controlRestoresSize = ((IInformationControlExtension3)((Object)this.fInformationControl)).restoresSize();
        boolean controlRestoresLocation = ((IInformationControlExtension3)((Object)this.fInformationControl)).restoresLocation();
        Rectangle bounds = new Rectangle(-1, -1, -1, -1);
        if (this.fIsRestoringSize && controlRestoresSize) {
            try {
                bounds.width = this.fDialogSettings.getInt(STORE_SIZE_WIDTH);
                bounds.height = this.fDialogSettings.getInt(STORE_SIZE_HEIGHT);
            }
            catch (NumberFormatException numberFormatException) {
                bounds.width = -1;
                bounds.height = -1;
            }
        }
        if (this.fIsRestoringLocation && controlRestoresLocation) {
            try {
                bounds.x = this.fDialogSettings.getInt(STORE_LOCATION_X);
                bounds.y = this.fDialogSettings.getInt(STORE_LOCATION_Y);
            }
            catch (NumberFormatException numberFormatException) {
                bounds.x = -1;
                bounds.y = -1;
            }
        }
        if (bounds.x == -1 && bounds.y == -1 && bounds.width == -1 && bounds.height == -1) {
            return null;
        }
        Rectangle maxBounds = null;
        if (this.fSubjectControl != null && !this.fSubjectControl.isDisposed()) {
            maxBounds = this.fSubjectControl.getDisplay().getBounds();
        } else {
            Display display = Display.getCurrent();
            if (display == null) {
                display = Display.getDefault();
            }
            if (display != null && !display.isDisposed()) {
                maxBounds = display.getBounds();
            }
        }
        if (bounds.width > -1 && bounds.height > -1) {
            if (maxBounds != null) {
                bounds.width = Math.min(bounds.width, maxBounds.width);
                bounds.height = Math.min(bounds.height, maxBounds.height);
            }
            bounds.width = Math.max(bounds.width, 30);
            bounds.height = Math.max(bounds.height, 30);
        }
        if (bounds.x > -1 && bounds.y > -1 && maxBounds != null) {
            bounds.x = Math.max(bounds.x, maxBounds.x);
            bounds.y = Math.max(bounds.y, maxBounds.y);
            if (bounds.width > -1 && bounds.height > -1) {
                bounds.x = Math.min(bounds.x, maxBounds.width - bounds.width);
                bounds.y = Math.min(bounds.y, maxBounds.height - bounds.height);
            }
        }
        return bounds;
    }

    public static final class Anchor {
        private Anchor() {
        }
    }

    public static interface IInformationControlCloser {
        public void setSubjectControl(Control var1);

        public void setInformationControl(IInformationControl var1);

        public void start(Rectangle var1);

        public void stop();
    }
}

