/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xindice.tools.command;

import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.ext.LexicalHandler;

public class StringSerializer
implements ContentHandler,
LexicalHandler {
    private Map namespaceMap;
    private StringBuffer namespaceDecls;
    private boolean inCDATA;
    private String outputEncoding;
    private StringBuffer outputXml;

    public StringSerializer() {
        this(null);
    }

    public StringSerializer(String outputEncoding) {
        this.outputEncoding = outputEncoding;
        this.outputXml = new StringBuffer(1024);
        this.namespaceMap = new HashMap();
        this.namespaceDecls = new StringBuffer();
        this.inCDATA = false;
    }

    public void startDocument() throws SAXException {
        this.outputXml.append("<?xml version=\"1.0\"");
        if (this.outputEncoding != null) {
            this.outputXml.append(" encoding=\"");
            this.outputXml.append(this.outputEncoding);
            this.outputXml.append('\"');
        }
        this.outputXml.append("?>");
    }

    public void endDocument() throws SAXException {
    }

    public void processingInstruction(String target, String data) {
        this.outputXml.append("<?");
        this.outputXml.append(target);
        this.outputXml.append(' ');
        this.outputXml.append(data);
        this.outputXml.append("?>");
    }

    public void comment(char[] data, int start, int len) {
        this.outputXml.append("<!--");
        this.outputXml.append(data, start, len);
        this.outputXml.append("-->");
    }

    private void xmlIze(StringBuffer sb, char[] data, int start, int len, boolean isAttValue) {
        for (int i = start; i < start + len; ++i) {
            if (data[i] == '<') {
                sb.append("&lt;");
                continue;
            }
            if (data[i] == '&') {
                sb.append("&amp;");
                continue;
            }
            if (data[i] == '\"' && isAttValue) {
                sb.append("&quot;");
                continue;
            }
            sb.append(data[i]);
        }
    }

    private void writeAttribute(StringBuffer sb, String attName, String attValue) {
        sb.append(' ');
        sb.append(attName);
        sb.append("=\"");
        this.xmlIze(sb, attValue.toCharArray(), 0, attValue.length(), true);
        sb.append('\"');
    }

    public void startPrefixMapping(String prefix, String uri) {
        Stack<String> uriStack = (Stack<String>)this.namespaceMap.get(prefix);
        if (uriStack == null) {
            uriStack = new Stack<String>();
            this.namespaceMap.put(prefix, uriStack);
        }
        uriStack.push(uri);
        if (!prefix.equals("")) {
            this.writeAttribute(this.namespaceDecls, "xmlns:" + prefix, uri);
        } else {
            this.writeAttribute(this.namespaceDecls, "xmlns", uri);
        }
    }

    public void endPrefixMapping(String prefix) {
        Stack uriStack = (Stack)this.namespaceMap.get(prefix);
        uriStack.pop();
    }

    public void ignorableWhitespace(char[] data, int start, int len) {
        this.outputXml.append(data, start, len);
    }

    private String getPrefix(String qName) {
        if (qName.indexOf(58) != -1) {
            return qName.substring(0, qName.indexOf(58));
        }
        return "";
    }

    public void startElement(String namespaceUri, String localName, String qName, Attributes att) {
        String prefix = this.getPrefix(qName);
        if (!prefix.equals("") && !prefix.equals("xml") && this.namespaceMap.get(prefix) == null) {
            this.writeAttribute(this.namespaceDecls, "xmlns:" + prefix, namespaceUri);
        }
        this.outputXml.append('<');
        this.outputXml.append(qName);
        this.outputXml.append(this.namespaceDecls);
        this.namespaceDecls = new StringBuffer();
        for (int i = 0; i < att.getLength(); ++i) {
            String attNamespaceUri = att.getURI(i);
            String attQName = att.getQName(i);
            String attValue = att.getValue(i);
            String attPrefix = this.getPrefix(attQName);
            if (!attPrefix.equals("") && !attPrefix.equals("xml") && this.namespaceMap.get(attPrefix) == null) {
                this.writeAttribute(this.outputXml, "xmlns:" + attPrefix, attNamespaceUri);
            }
            this.writeAttribute(this.outputXml, attQName, attValue);
        }
        this.outputXml.append('>');
    }

    public void endElement(String namespaceUri, String localName, String qName) {
        this.outputXml.append("</");
        this.outputXml.append(qName);
        this.outputXml.append('>');
    }

    public void skippedEntity(String entity) {
        if (entity.startsWith("%")) {
            this.outputXml.append(entity);
            this.outputXml.append(';');
        } else {
            this.outputXml.append('&');
            this.outputXml.append(entity);
            this.outputXml.append(';');
        }
    }

    public void characters(char[] data, int start, int len) {
        if (this.inCDATA) {
            this.outputXml.append(data, start, len);
        } else {
            this.xmlIze(this.outputXml, data, start, len, false);
        }
    }

    public void setDocumentLocator(Locator locator) {
    }

    public void startCDATA() {
        this.outputXml.append("<![CDATA[");
        this.inCDATA = true;
    }

    public void endCDATA() throws SAXException {
        this.inCDATA = false;
        this.outputXml.append("]]>");
    }

    public void startEntity(String entity) {
    }

    public void endEntity(String entity) {
    }

    public void startDTD(String docType, String systemID, String publicID) {
    }

    public void endDTD() {
    }

    public String toString() {
        return new String(this.outputXml);
    }
}

