/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xindice.core.filer;

import java.io.File;
import java.io.FileFilter;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.StringTokenizer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xindice.core.DBException;
import org.apache.xindice.core.data.Key;
import org.apache.xindice.core.data.Record;
import org.apache.xindice.core.data.RecordSet;
import org.apache.xindice.core.data.Value;
import org.apache.xindice.core.filer.Filer;
import org.apache.xindice.core.filer.FilerException;
import org.apache.xindice.util.Configuration;
import org.apache.xindice.util.FileCache;
import org.apache.xindice.util.LockManager;
import org.apache.xindice.util.SimpleConfigurable;
import org.apache.xindice.util.XindiceException;

public final class FSFiler
extends SimpleConfigurable
implements Filer {
    private static final Log log = LogFactory.getLog((Class)(class$org$apache$xindice$core$filer$FSFiler == null ? (class$org$apache$xindice$core$filer$FSFiler = FSFiler.class$("org.apache.xindice.core.filer.FSFiler")) : class$org$apache$xindice$core$filer$FSFiler));
    private static final String LOCATION = "location";
    private static final String EXT = "ext";
    private static final String READONLY = "readonly";
    private FileCache cache = new FileCache();
    private LockManager locks = new LockManager(16);
    private Set extensions = null;
    private String location;
    private File dir;
    private boolean opened = false;
    private boolean readOnly = false;
    static /* synthetic */ Class class$org$apache$xindice$core$filer$FSFiler;

    public String getName() {
        return "FSFiler";
    }

    public void setLocation(File root, String location) {
    }

    public void setConfig(Configuration config) throws XindiceException {
        super.setConfig(config);
        this.location = config.getAttribute(LOCATION);
        this.readOnly = config.getBooleanAttribute(READONLY, this.readOnly);
        String exts = config.getAttribute(EXT);
        if (exts != null && exts.trim().length() > 0) {
            this.extensions = new HashSet();
            StringTokenizer st = new StringTokenizer(exts);
            while (st.hasMoreTokens()) {
                this.extensions.add(st.nextToken());
            }
        }
        this.dir = new File(this.location);
        this.opened = false;
    }

    private void checkOpened() throws DBException {
        if (!this.opened) {
            throw new FilerException(247, "Filer is closed");
        }
    }

    private void checkReadOnly() throws DBException {
        if (this.readOnly) {
            throw new FilerException(246, "Filer is read-only");
        }
    }

    public boolean close() {
        this.opened = false;
        return true;
    }

    public boolean open() {
        this.opened = this.dir.exists() && this.dir.isDirectory();
        return this.opened;
    }

    public boolean drop() {
        this.opened = false;
        return true;
    }

    public boolean isOpened() {
        return this.opened;
    }

    public boolean exists() {
        return this.dir.exists();
    }

    public boolean create() {
        if (!this.dir.exists()) {
            return this.dir.mkdirs();
        }
        return true;
    }

    public void flush() {
    }

    public Record readRecord(Key key) throws DBException {
        if (key == null || key.getLength() == 0) {
            return null;
        }
        this.checkOpened();
        String fname = key.toString();
        if (!this.isExtensionValid(fname)) {
            return null;
        }
        File file = new File(this.dir, fname);
        try {
            this.locks.acquireSharedLock(file);
            HashMap<String, Long> meta = new HashMap<String, Long>(2, 1.5f);
            meta.put("modified", new Long(file.lastModified()));
            byte[] valueData = this.cache.getFile(file);
            if (valueData != null) {
                Record record = new Record(key, new Value(valueData), meta);
                return record;
            }
        }
        catch (IOException e) {
            throw new FilerException(572, "Can't read record '" + key + "': " + e.getMessage(), e);
        }
        finally {
            this.locks.releaseSharedLock(file);
        }
        return null;
    }

    public boolean writeRecord(Key key, Value value) throws DBException {
        if (key == null || key.getLength() == 0) {
            throw new FilerException(571, "Invalid key: '" + key + "'");
        }
        if (value == null) {
            throw new FilerException(571, "Invalid null value");
        }
        this.checkOpened();
        this.checkReadOnly();
        String fname = key.toString();
        if (!this.isExtensionValid(fname)) {
            return false;
        }
        File file = new File(this.dir, fname);
        try {
            this.locks.acquireExclusiveLock(file);
            FileOutputStream fos = new FileOutputStream(file);
            value.streamTo(fos);
            fos.close();
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            throw new FilerException(571, "Can't write record '" + key + "': " + e.getMessage(), e);
        }
        finally {
            this.locks.releaseExclusiveLock(file);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean deleteRecord(Key key) throws DBException {
        if (key == null || key.getLength() == 0) {
            return false;
        }
        this.checkOpened();
        this.checkReadOnly();
        String fname = key.toString();
        if (!this.isExtensionValid(fname)) {
            return false;
        }
        File file = new File(this.dir, fname);
        try {
            this.locks.acquireExclusiveLock(file);
            boolean bl = file.delete();
            return bl;
        }
        finally {
            this.locks.releaseExclusiveLock(file);
        }
    }

    public long getRecordCount() throws DBException {
        this.checkOpened();
        File[] files = this.dir.listFiles(new FileFilter(){

            public boolean accept(File file) {
                return file.isFile() && FSFiler.this.isExtensionValid(file.getName());
            }
        });
        return files.length;
    }

    public RecordSet getRecordSet() throws DBException {
        this.checkOpened();
        return new FSRecordSet();
    }

    private boolean isExtensionValid(String fname) {
        if (this.extensions != null) {
            int idx = fname.lastIndexOf(46);
            if (idx == -1) {
                return false;
            }
            String ext = fname.substring(idx + 1);
            if (!this.extensions.contains(ext)) {
                return false;
            }
        }
        return true;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class FSRecordSet
    implements RecordSet {
        public File[] files;
        public int pos = 0;

        public FSRecordSet() {
            this.files = FSFiler.this.dir.listFiles(new FileFilter(this){
                private final /* synthetic */ FSRecordSet this$1;
                {
                    this.this$1 = this$1;
                }

                public boolean accept(File file) {
                    return file.isFile() && FSFiler.access$000(FSRecordSet.access$100(this.this$1), file.getName());
                }
            });
        }

        public synchronized boolean hasMoreRecords() {
            return this.pos < this.files.length;
        }

        public synchronized Record getNextRecord() throws DBException {
            File file = this.files[this.pos++];
            return FSFiler.this.readRecord(new Key(file.getName()));
        }

        public synchronized Value getNextValue() throws DBException {
            return this.getNextRecord().getValue();
        }

        public synchronized Key getNextKey() {
            return new Key(this.files[this.pos++].getName());
        }

        static /* synthetic */ FSFiler access$100(FSRecordSet x0) {
            return x0.FSFiler.this;
        }
    }
}

