package com.jware.util.mail;

import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

/**
 * メールデータ保管クラス。
 *
 * @author $Id: BaseMailData.java,v 1.1 2010/01/13 11:52:46 clmg Exp $
 */
public class BaseMailData implements Serializable{

    private final static String NAME_REPLACER = "$NAME$";
    
	private int persistentId = 0;
	
	private String from = "";
    private List toList = null;
	private List ccList = null;
	private List bccList = null;
	private String unexistAddress = "";

    private String subject = "";
    private String content = "";
    private Date sendDate = null;
	private Date endDate = null;
	private String mailType = "";
	private Date createDate = null;
	private String mailFlag = "";

	private boolean insertTitleFlg=true;
	private String contentTitle="";
	private String preInsertTitle="";
	private String postInsertTitle="";
	
	private Map attachments = new HashMap();
	private Map addressNameMap = new HashMap();
	
	private Map hostStatusMap = null;
	private int status = 0;
	private String processor = null;
	
	public String getContent( String address ){
		
		if( address == null){

			return getContent();

		}else{
        	String name = null;
        	if( getAddressNameMap() != null ){
        		name = (String)getAddressNameMap().get(address);
        	}
            if( name == null || name.trim().length() == 0 ){
                name = address;
            }
			StringBuffer sb = new StringBuffer();

			sb.append((contentTitle!=null?contentTitle:"") + "\n\n");
			sb.append(name + " 様\n\n");
			sb.append(getContent());
			
			int offset = sb.lastIndexOf(NAME_REPLACER);
			while( offset >= 0 ){
			    sb = sb.replace( offset, offset+NAME_REPLACER.length(), name );
			    offset = sb.lastIndexOf(NAME_REPLACER);
			}
			
			return sb.toString();

		}
	}

	public Map getAttachments( String address ){
		
		if( address == null){

			return getAttachments();

		}else{

		    Map tmpMap = new HashMap();
		    
		    Map attachments = getAttachments();
		    Iterator ite = attachments.keySet().iterator();
		    while( ite.hasNext() ){
		        String fileName = (String)ite.next();
		        Object obj = (Object)attachments.get(fileName);
		        if( obj != null ){
		        	String name = null;
		        	if( getAddressNameMap() != null ){
		        		name = (String)getAddressNameMap().get(address);
		        	}
		            if( name == null || name.trim().length() == 0 ){
		                name = address;
		            }
			        StringBuffer sb = new StringBuffer();
					sb.append("\n");
					sb.append( name + " 様\n\n");
					sb.append(obj.toString());
					
					int offset = sb.lastIndexOf(NAME_REPLACER);
					while( offset >= 0 ){
					    sb = sb.replace( offset, offset+NAME_REPLACER.length(), name );
					    offset = sb.lastIndexOf(NAME_REPLACER);
					}
					
		            tmpMap.put( fileName, sb.toString() );
					
		        } else {
		            tmpMap.put( fileName, obj );
		        }
		        
		    }
		    
			return tmpMap;

		}
		
	}
	
	
	
	/**
	 * @param to
	 */
	public void addToList(String to){
		toList.add(to);
	}

	/**
	 * @param to
	 */
	public void addCcList(String cc){
		ccList.add(cc);
	}
    
    /**
     * @return
     */
    public String getContent() {
        return content;
    }


    /**
     * @return
     */
    public String getFrom() {
        return from;
    }

    /**
     * @return
     */
    public String getSubject() {
        return subject;
    }

    /**
     * @param string
     */
    public void setContent(String string) {
        content = string;
    }

    /**
     * @param string
     */
    public void setFrom(String string) {
        from = string;
    }

    /**
     * @param string
     */
    public void setSubject(String string) {
        subject = string;
    }

    /**
     * @return
     */
    public List getToList() {
        return toList;
    }

    /**
     * @param vector
     */
    public void setToList(List list) {
        toList = list;
    }

    /**
     * @return
     */
    public Date getSendDate() {
        return sendDate;
    }

    /**
     * @param date
     */
    public void setSendDate(Date date) {
        sendDate = date;
    }

	/**
	 * @return
	 */
	public List getCcList() {
		return ccList;
	}

	/**
	 * @param string
	 */
	public void setCcList(List list) {
		ccList = list;
	}

	/**
	 * @return
	 */
	public String getUnexistAddress() {
		return unexistAddress;
	}

	/**
	 * @param string
	 */
	public void setUnexistAddress(String string) {
		unexistAddress = string;
	}

	/**
	 * @return
	 */
	public String getMailType() {
		return mailType;
	}

	/**
	 * @param string
	 */
	public void setMailType(String string) {
		mailType = string;
	}

	/**
	 * @return
	 */
	public Date getCreateDate() {
		return createDate;
	}

	/**
	 * @param date
	 */
	public void setCreateDate(Date date) {
		createDate = date;
	}

	/**
	 * @return
	 */
	public String getMailFlag() {
		return mailFlag;
	}

	/**
	 * @param string
	 */
	public void setMailFlag(String string) {
		mailFlag = string;
	}


	/**
	 * @return Returns the addressNameMap.
	 */
	public Map getAddressNameMap() {
		return addressNameMap;
	}
	/**
	 * @param addressNameMap The addressNameMap to set.
	 */
	public void setAddressNameMap(Map addressNameMap) {
		this.addressNameMap = addressNameMap;
	}
	/**
	 * @return Returns the attachments.
	 */
	public Map getAttachments() {
		return attachments;
	}
	/**
	 * @param attachments The attachments to set.
	 */
	public void setAttachments(Map attachments) {
		this.attachments = attachments;
	}
	/**
	 * @return Returns the bccList.
	 */
	public List getBccList() {
		return bccList;
	}
	/**
	 * @param bccList The bccList to set.
	 */
	public void setBccList(List bccList) {
		this.bccList = bccList;
	}
	/**
	 * @return Returns the hostStatusMap.
	 */
	public Map getHostStatusMap() {
		return hostStatusMap;
	}
	/**
	 * @param hostStatusMap The hostStatusMap to set.
	 */
	public void setHostStatusMap(Map hostStatusMap) {
		this.hostStatusMap = hostStatusMap;
	}
	/**
	 * @return Returns the persistentId.
	 */
	public int getPersistentId() {
		return persistentId;
	}
	/**
	 * @param persistentId The persistentId to set.
	 */
	public void setPersistentId(int persistentId) {
		this.persistentId = persistentId;
	}
	/**
	 * @return Returns the status.
	 */
	public int getStatus() {
		return status;
	}
	/**
	 * @param status The status to set.
	 */
	public void setStatus(int status) {
		this.status = status;
	}
	/**
	 * @return Returns the endDate.
	 */
	public Date getEndDate() {
		return endDate;
	}
	/**
	 * @param endDate The endDate to set.
	 */
	public void setEndDate(Date endDate) {
		this.endDate = endDate;
	}
	/**
	 * @return Returns the processor.
	 */
	public String getProcessor() {
		return processor;
	}
	/**
	 * @param processor The processor to set.
	 */
	public void setProcessor(String processor) {
		this.processor = processor;
	}
	/**
	 * @return Returns the contentTitle.
	 */
	public String getContentTitle() {
		return contentTitle;
	}
	/**
	 * @param contentTitle The contentTitle to set.
	 */
	public void setContentTitle(String contentTitle) {
		this.contentTitle = contentTitle;
	}
	/**
	 * @return Returns the insertTitleFlg.
	 */
	public boolean isInsertTitleFlg() {
		return insertTitleFlg;
	}
	/**
	 * @param insertTitleFlg The insertTitleFlg to set.
	 */
	public void setInsertTitleFlg(boolean insertTitleFlg) {
		this.insertTitleFlg = insertTitleFlg;
	}
	/**
	 * @return Returns the postInsertTitle.
	 */
	public String getPostInsertTitle() {
		return postInsertTitle;
	}
	/**
	 * @param postInsertTitle The postInsertTitle to set.
	 */
	public void setPostInsertTitle(String postInsertTitle) {
		this.postInsertTitle = postInsertTitle;
	}
	/**
	 * @return Returns the preInsertTitle.
	 */
	public String getPreInsertTitle() {
		return preInsertTitle;
	}
	/**
	 * @param preInsertTitle The preInsertTitle to set.
	 */
	public void setPreInsertTitle(String preInsertTitle) {
		this.preInsertTitle = preInsertTitle;
	}
	
	/**
	 * @param addAttachments.
	 */
	public void addAttachments( Object key, Object value){
		this.attachments.put( key, value );
	}

	/**
	 * @param getAttachments.
	 */
	public Object getAttachments( Object key ){
		return this.attachments.get( key );
	}
	
}
