package com.jware.util;

/**
 * @author jrmt
 *
 */
public class StringConverter {

	static final String HANKAKU_LATIN = " !\"#$%&'()*+,-./0123456789:;<=>?@ABCDEFGHIJKLMNOPQRSTUVWXYZ[\\]^_`abcdefghijklmnopqrstuvwxyz{|}~";
	static final String ZENKAKU_LATIN = "　！”＃＄％＆’（）＊＋、－．／０１２３４５６７８９：；＜＝＞？＠ＡＢＣＤＥＦＧＨＩＪＫＬＭＮＯＰＱＲＳＴＵＶＷＸＹＺ［￥］＾＿‘ａｂｃｄｅｆｇｈｉｊｋｌｍｎｏｐｑｒｓｔｕｖｗｘｙｚ｛｜｝～";
	
	static final String ZENKAKU_KATAKANA = "アイウエオカキクケコサシスセソタチツテトナニヌネノハヒフヘホマモムメモヤユヨラリルレロワヲンァィゥェォッャュョガギグゲゴザジズゼゾダヂヅデドバビブベボパピプペポ";
	static final String ZENKAKU_GAZADABA = "ガギグゲゴザジズゼゾダヂヅデドバビブベボ";
	static final String ZENKAKU_PAPIPUPEPO = "パピプペポ";
	static final String ZENKAKU_HIRAKANA = "あいうえおかきくけこさしすせそたちつてとなにぬねのはひふへほまもむめもやゆよらりるれろわをんぁぃぅぇぉっゃゅょがぎぐげござじずぜぞだぢづでどばびぶべぼぱぴぷぺぽ";

	static final String HANKAKU_KATAKANA = "ｱｲｳｴｵｶｷｸｹｺｻｼｽｾｿﾀﾁﾂﾃﾄﾅﾆﾇﾈﾉﾊﾋﾌﾍﾎﾏﾐﾑﾒﾓﾔﾕﾖﾗﾘﾙﾚﾛﾜｦﾝｱｲｳｴｵﾂﾔﾕﾖｶｷｸｹｺｻｼｽｾｿﾀﾁﾂﾃﾄﾊﾋﾌﾍﾎﾊﾋﾌﾍﾎ";
	static final String HANKAKU_GAMARK = "ﾞ";
	static final String HANKAKU_PAMARK = "ﾟ";
	static final String HANKAKU_GAZADABA = "ｶｷｸｹｺｻｼｽｾｿﾀﾁﾂﾃﾄﾊﾋﾌﾍﾎ";
	static final String HANKAKU_PAPIPUPEPO = "ﾊﾋﾌﾍﾎ";
	/**
	 * 
	 */
	private StringConverter() {
		super();
	}

	//半角を全角に変換する。
	public static String hankaku2Zenkaku(String str){
		
		if( str == null ){
			return null;
		}

		StringBuffer buffer = new StringBuffer();
		char ch;
		for (int j = 0; j < str.length() ; j++){
			ch = str.charAt(j);
			for( int i = 0; i < HANKAKU_LATIN.length(); i++ ) {
				if (ch == HANKAKU_LATIN.charAt(i)){
					ch = ZENKAKU_LATIN.charAt(i);
					break;
				}
			}
			buffer.append(ch);
		}
		return buffer.toString();
		
	}

	//全角を半角に変換する。
	public static String zenkaku2Hankeku(String str){
		
		if( str == null ){
			return null;
		}

		StringBuffer buffer = new StringBuffer();
		char ch;
		for (int j = 0; j < str.length() ; j++){
			ch = str.charAt(j);
			for( int i = 0; i < ZENKAKU_LATIN.length(); i++ ) {
				if (ch == ZENKAKU_LATIN.charAt(i)){
					ch = HANKAKU_LATIN.charAt(i);
					break;
				}
			}
			buffer.append(ch);
		}
		return buffer.toString();
		
	}

	//全角カタカナを平仮名に変換する。
	public static String katakana2Hiragana(String str){
		
		if( str == null ){
			return null;
		}

		StringBuffer buffer = new StringBuffer();
		char ch;
		for (int j = 0; j < str.length() ; j++){
			ch = str.charAt(j);
			for( int i = 0; i < ZENKAKU_KATAKANA.length(); i++ ) {
				if (ch == ZENKAKU_KATAKANA.charAt(i)){
					ch = ZENKAKU_HIRAKANA.charAt(i);
					break;
				}
			}
			buffer.append(ch);
		}
		return buffer.toString();
		
	}
	
	//全角平仮名をカタカナに変換する。
	public static String hiragana2Katakana(String str){
		
		if( str == null ){
			return null;
		}

		StringBuffer buffer = new StringBuffer();
		char ch;
		for (int j = 0; j < str.length() ; j++){
			ch = str.charAt(j);
			for( int i = 0; i < ZENKAKU_HIRAKANA.length(); i++ ) {
				if (ch == ZENKAKU_HIRAKANA.charAt(i)){
					ch = ZENKAKU_KATAKANA.charAt(i);
					break;
				}
			}
			buffer.append(ch);
		}
		return buffer.toString();
		
	}

	//全角カタカナを半角カタカナに変換する。
	public static String katakana2HankakuKatakana(String str){
		
		if( str == null ){
			return null;
		}

		StringBuffer buffer = new StringBuffer();
		char ch1, ch2;
		for (int j = 0; j < str.length() ; j++){
			ch1 = str.charAt(j);
			ch2 = ch1;
			for( int i = 0; i < ZENKAKU_KATAKANA.length(); i++ ) {
				if (ch1 == ZENKAKU_KATAKANA.charAt(i)){
					ch2 = HANKAKU_KATAKANA.charAt(i);
					break;
				}
			}
			buffer.append(ch2);
			if( ZENKAKU_GAZADABA.indexOf( (int)ch1 ) > 0 ){
				buffer.append(HANKAKU_GAMARK);
			}
			if( ZENKAKU_PAPIPUPEPO.indexOf( (int)ch1 ) > 0 ){
				buffer.append(HANKAKU_PAMARK);
			}
		}
		return buffer.toString();
		
	}
	
	// 半角カタカナを全角カタカナに変換する。
	public static String HankakuKatakana2katakana(String str){
		
		if( str == null ){
			return null;
		}

		StringBuffer buffer = new StringBuffer();
		char ch1, ch2;
		for (int j = 0; j < str.length() ; j++){
			ch1 = str.charAt(j);
			if( j < (str.length()-1) ){
				ch2 = str.charAt(j+1);
			} else {
				ch2 = 0;
			}
			if( ch2 != HANKAKU_GAMARK.charAt(0) && ch2 != HANKAKU_PAMARK.charAt(0) ){
				for( int i = 0; i < HANKAKU_KATAKANA.length(); i++ ) {
					if (ch1 == HANKAKU_KATAKANA.charAt(i)){
						ch1 = ZENKAKU_KATAKANA.charAt(i);
						break;
					}
				}
				buffer.append(ch1);
			} else if ( ch2 == HANKAKU_GAMARK.charAt(0) ){
				char ch3 = 0;
				for( int i = 0; i < HANKAKU_GAZADABA.length(); i++ ) {
					if (ch1 == HANKAKU_GAZADABA.charAt(i)){
						ch3 = ZENKAKU_GAZADABA.charAt(i);
						break;
					}
				}
				if( ch3 == 0 ){
					for( int i = 0; i < HANKAKU_KATAKANA.length(); i++ ) {
						if (ch1 == HANKAKU_KATAKANA.charAt(i)){
							ch1 = ZENKAKU_KATAKANA.charAt(i);
							break;
						}
					}
				} else {
					ch1 = ch3;
				}
				buffer.append(ch1);
				j++;
				
			} else if ( ch2 == HANKAKU_PAMARK.charAt(0) ){
				
				char ch3 = 0;
				for( int i = 0; i < HANKAKU_KATAKANA.length(); i++ ) {
					if (ch1 == HANKAKU_KATAKANA.charAt(i)){
						ch3 = ZENKAKU_KATAKANA.charAt(i);
						break;
					}
				}
				if( ch3 == 0 ){
					for( int i = 0; i < HANKAKU_KATAKANA.length(); i++ ) {
						if (ch1 == HANKAKU_KATAKANA.charAt(i)){
							ch1 = ZENKAKU_KATAKANA.charAt(i);
							break;
						}
					}
				} else {
					ch1 = ch3;
				}
				buffer.append(ch1);
				j++;
				
			}
		}
		return buffer.toString();
		
	}
	

}
