/**
 * 
 */
package com.ampiere.web.struts.search;

import java.util.logging.Level;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.compiere.util.CLogger;
import org.compiere.util.Env;
import org.compiere.util.WebEnv;
import org.compiere.util.WebSessionCtx;

import com.ampiere.util.Constants;


/**
 * @author Shinjirito
 *
 */
public class InfoBPartnerAction extends InfoBaseAction {
	/**	Logger			*/
	protected CLogger	log = CLogger.getCLogger(this.getClass());

	/* (non-Javadoc)
	 * @see com.jware.base.web.struts.jWareBaseAction#doExecute(org.apache.struts.action.ActionMapping, org.apache.struts.action.ActionForm, javax.servlet.http.HttpServletRequest, javax.servlet.http.HttpServletResponse, org.apache.struts.action.ActionErrors, boolean)
	 */
	public ActionForward doExecute(ActionMapping mapping, ActionForm baseForm,
			HttpServletRequest request, HttpServletResponse response,
			ActionErrors errors, boolean mochaFlag) throws Exception {
		super.doExecute(mapping, baseForm, request, response, errors, mochaFlag);

		//201001 
        WebSessionCtx wscTest = WebSessionCtx.get(request); 
        if (wscTest == null) {
            log.log(Level.SEVERE, "Session Time Out.");
            request.setAttribute(Constants.SESSION_TIMEOUT_INFO, "Session Time Out. Please login again.");
            return mapping.findForward(Constants.SESSION_TIMEOUT);
        }
        //--201001		
		
		String doQurey = "0";
		InfoBPartnerForm searchInfoFormBPartner = (InfoBPartnerForm)baseForm;
		HttpSession session = request.getSession();
		// Clear all
		session.setAttribute("searchResultBPartner", null);
		if (searchInfoFormBPartner != null) {
		  	WebSessionCtx wsc = WebSessionCtx.get(request);
			int windowNo = searchInfoFormBPartner.getWindowNo();
			String name = searchInfoFormBPartner.getName();
			if (WebEnv.NBSP_UNICODE.equals(name)) {
				name = "";
			}
			if (name != null && name.length() > 0) {
				doQurey = "1";
			}

//			boolean isSOTrx = (Env.getContext(wsc.ctx, windowNo, "IsSOTrx").equals("N") ? false : true);
//			boolean isSOTrx = (wsc.ctx.getContext(windowNo, "IsSOTrx").equals("N") ? false : true);
			boolean isSOTrx = (wsc.ctx.isSOTrx(windowNo));//clmg 2009/03/11
			searchInfoFormBPartner.statInit(wsc.ctx, isSOTrx, true, true);
			searchInfoFormBPartner.initInfo(name);

			// Set search info form
			session.setAttribute("searchInfoFormBPartner", searchInfoFormBPartner);
		}

		request.setAttribute("doQuery", doQurey);
	    return mapping.findForward("success");
	}
}
