/*
 * Decompiled with CFR 0.152.
 */
package com.jware.base;

import com.jware.util.DateUtils;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Locale;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.validator.GenericValidator;
import org.apache.struts.action.ActionError;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.util.MessageResources;

public class JwareValidator {
    protected Log log = LogFactory.getLog((String)this.getClass().getName());
    private ActionErrors errors = new ActionErrors();
    private MessageResources messageResources = null;
    private Locale locale = null;

    public JwareValidator(MessageResources messageResources) {
        this(messageResources, null);
    }

    public JwareValidator(MessageResources messageResources, Locale locale) {
        this.clear();
        this.messageResources = messageResources;
        this.locale = locale;
    }

    public void clear() {
        this.errors.clear();
    }

    public boolean isError() {
        return this.errors.size() > 0;
    }

    public ActionErrors getErrors() {
        return this.errors;
    }

    public void addError(String field, String errorKey, String value) {
        String msg = this.getMessage(value);
        if (msg != null) {
            this.errors.add(field, new ActionError(errorKey, (Object)msg));
        } else {
            this.errors.add(field, new ActionError(errorKey, (Object)value));
        }
    }

    public void addError(String field, String errorKey, String[] values) {
        Object[] msgs = new String[values.length];
        for (int i2 = 0; i2 < values.length; ++i2) {
            String buff = this.getMessage(values[i2]);
            msgs[i2] = buff != null ? buff : values[i2];
        }
        this.errors.add(field, new ActionError(errorKey, msgs));
    }

    public boolean isSelected(String field, String fieldname, String errMsg, String value) {
        if (StringUtils.isEmpty(value)) {
            this.errors.add(field, new ActionError(errMsg, (Object)this.getMessage(fieldname)));
            return false;
        }
        return true;
    }

    public boolean isChecked(String field, String fieldname, String[] values) {
        return this.isChecked(field, fieldname, "error.code.E000009", values);
    }

    public boolean isChecked(String field, String fieldname, String errMsg, String[] values) {
        if (values == null || values.length == 0) {
            this.errors.add(field, new ActionError(errMsg, (Object)this.getMessage(fieldname)));
            return false;
        }
        int counts = values.length;
        boolean anyChr = false;
        for (int i2 = 0; i2 < counts; ++i2) {
            if (values[i2] == null || values[i2].length() <= 0) continue;
            anyChr = true;
        }
        if (!anyChr) {
            this.errors.add(field, new ActionError(errMsg, (Object)this.getMessage(fieldname)));
            return false;
        }
        return true;
    }

    public boolean isAlpha(String field, String fieldname, String value, boolean required, int max) {
        return this.isAlpha(field, fieldname, value, required, max, false, 0);
    }

    public boolean isAlpha(String field, String fieldname, String value, boolean required, int max, int arrayCount) {
        return this.isAlpha(field, fieldname, value, required, max, false, arrayCount);
    }

    public boolean isAlphaFixedLength(String field, String fieldname, String value, boolean required, int max) {
        return this.isAlpha(field, fieldname, value, required, max, true, 0);
    }

    public boolean isAlphaFixedLength(String field, String fieldname, String value, boolean required, int max, int arrayCount) {
        return this.isAlpha(field, fieldname, value, required, max, true, arrayCount);
    }

    private boolean isAlpha(String field, String fieldname, String value, boolean required, int max, boolean fixedLength, int arrayCount) {
        if (!this.isString(field, fieldname, value, required, max, 0, fixedLength, arrayCount, "")) {
            return false;
        }
        if (!required && StringUtils.isEmpty(value)) {
            return true;
        }
        if (!StringUtils.isAlpha(value)) {
            if (arrayCount > 0) {
                this.errors.add(field, new ActionError("errors.inN.alpha", (Object)String.valueOf(arrayCount), (Object)this.getMessage(fieldname)));
            } else {
                this.errors.add(field, new ActionError("errors.alpha", (Object)this.getMessage(fieldname)));
            }
            return false;
        }
        return true;
    }

    public boolean isTestNumber(String field, String fieldName, String value) {
        if (StringUtils.isAlpha(value)) {
            this.errors.add(field, new ActionError("errors.alpha", (Object)this.getMessage(fieldName)));
            return false;
        }
        return true;
    }

    public boolean isString(String field, String fieldname, String value, boolean required, int max) {
        return this.isString(field, fieldname, value, required, max, 0, false, 0, "errors.minlength");
    }

    public boolean isString(String field, String fieldname, String value, boolean required, int max, int min, String errMsg) {
        return this.isString(field, fieldname, value, required, max, min, false, 0, errMsg);
    }

    public boolean isString(String field, String fieldname, String value, boolean required, int max, int arrayCount) {
        return this.isString(field, fieldname, value, required, max, 0, false, arrayCount, "errors.minlength");
    }

    public boolean isString(String field, String fieldname, String value, boolean required, int max, int min, int arrayCount, String errMsg) {
        return this.isString(field, fieldname, value, required, max, min, false, arrayCount, errMsg);
    }

    public boolean isStringFixedLength(String field, String fieldname, String value, boolean required, int max, int min, String errMsg) {
        return this.isString(field, fieldname, value, required, max, 0, true, 0, "errors.fixedlength");
    }

    public boolean isStringFixedLength(String field, String fieldname, String value, boolean required, int max, int min, int arrayCount, String errMsg) {
        return this.isString(field, fieldname, value, required, max, min, true, arrayCount, "errors.fixedlength");
    }

    private boolean isString(String field, String fieldname, String value, boolean required, int max, int min, boolean fixedLength, int arrayCount, String errMsg) {
        boolean array = false;
        if (arrayCount > 0) {
            array = true;
        }
        if (StringUtils.isEmpty(value)) {
            if (required) {
                if (array) {
                    this.errors.add(field, new ActionError("errors.inN.required", (Object)String.valueOf(arrayCount), (Object)this.getMessage(fieldname)));
                } else {
                    this.errors.add(field, new ActionError("errors.required", (Object)this.getMessage(fieldname)));
                }
                return false;
            }
            return true;
        }
        if (fixedLength && value.getBytes().length != max) {
            if (array) {
                this.errors.add(field, new ActionError("errors.inN.fixedlength", (Object)String.valueOf(arrayCount), (Object)this.getMessage(fieldname), (Object)String.valueOf(max)));
            } else {
                this.errors.add(field, new ActionError("errors.fixedlength", (Object)this.getMessage(fieldname), (Object)String.valueOf(max)));
            }
            return false;
        }
        if (!fixedLength && value.getBytes().length > max) {
            if (array) {
                this.errors.add(field, new ActionError("errors.inN.minlength", (Object)String.valueOf(arrayCount), (Object)this.getMessage(fieldname), (Object)String.valueOf(max)));
            } else {
                this.errors.add(field, new ActionError(errMsg, (Object)this.getMessage(fieldname), (Object)String.valueOf(max), (Object)String.valueOf(min)));
            }
            return false;
        }
        return true;
    }

    public boolean isDate(String field, String fieldName, String errMsg, String date) {
        if (!DateUtils.isDate(date)) {
            this.errors.add(field, new ActionError(errMsg, (Object)this.getMessage(fieldName)));
            return false;
        }
        return true;
    }

    public boolean isDateNull(String field, String fieldName, String errMsg, String date, boolean nullable) {
        if (!DateUtils.isDate(date, nullable)) {
            this.errors.add(field, new ActionError(errMsg, (Object)this.getMessage(fieldName)));
            return false;
        }
        return true;
    }

    public boolean isDateBeforeAfter(String field, String fieldName, String errMsg, String date1, String date2) {
        if (!this.isDate(field, fieldName, errMsg, date1)) {
            return false;
        }
        if (!this.isDate(field, fieldName, errMsg, date2)) {
            return false;
        }
        if (!DateUtils.isDateBeforeAfter(date1, date2)) {
            this.errors.add(field, new ActionError(errMsg, (Object)this.getMessage(fieldName)));
            return false;
        }
        return true;
    }

    public boolean isDateBeforeAfterOnly(String field, String fieldName, String errMsg, String date1, String date2) {
        if (!DateUtils.isDateBeforeAfterNull(date1, date2)) {
            this.errors.add(field, new ActionError(errMsg, (Object)date1, (Object)date2));
            return false;
        }
        return true;
    }

    public boolean isDateBeforeAfterOnly(String field, String fieldName, String date1, String date2) {
        if (!DateUtils.isDateBeforeAfter(date1, date2)) {
            this.errors.add(field, new ActionError(field, (Object)this.getMessage(fieldName), (Object)date1, (Object)date2));
            return false;
        }
        return true;
    }

    public boolean isInt(String fiels, String fieldName, String str, boolean required) {
        if (required) {
            try {
                int i2 = Integer.parseInt(str);
            }
            catch (NumberFormatException e) {
                this.errors.add(fiels, new ActionError("errors.integer", (Object)this.getMessage(fieldName)));
                return false;
            }
        }
        return true;
    }

    public boolean isExist(String field, String fieldName, String data) {
        if (data == null || "".equals(data)) {
            this.errors.add(field, new ActionError(field, (Object)this.getMessage(fieldName)));
            return false;
        }
        return true;
    }

    public boolean isListExist(String field, String fieldName, String[] data) {
        if (data == null || data.length < 1) {
            this.errors.add(field, new ActionError(field, (Object)this.getMessage(fieldName)));
            return false;
        }
        return true;
    }

    public boolean isStringLengthExceed(String field, String fieldName, String data, int length) {
        return this.isStringLengthExceed(field, fieldName, field, data, length);
    }

    public boolean isStringLengthExceed(String field, String fieldName, String errMsg, String data, int length) {
        if (data != null && data.length() <= length) {
            return true;
        }
        this.errors.add(field, new ActionError(errMsg, (Object)this.getMessage(fieldName)));
        return false;
    }

    public boolean isDateNotMatterExistence(String field, String fieldName, String data) {
        if (data == null || "".equals(data)) {
            return true;
        }
        return !this.isDateType(field, fieldName, data);
    }

    public boolean isDateBeforeAfterNotMatterExistence(String field, String fieldName, String before, String after) {
        if (before == null || "".equals(before)) {
            return true;
        }
        if (after == null || "".equals(after)) {
            return true;
        }
        return this.isDateBeforeAfterOnly(field, fieldName, before, after);
    }

    public boolean isDateType(String field, String fieldName, String data) {
        if (data == null || "".equals(data)) {
            return false;
        }
        SimpleDateFormat fmt = new SimpleDateFormat("yyyy-MM-dd");
        try {
            fmt.parse(data);
            return true;
        }
        catch (ParseException e) {
            this.errors.add(field, new ActionError(field, (Object)this.getMessage(fieldName)));
            return false;
        }
    }

    public boolean isInt(String fiels, String fieldName, String errMsg, String str) {
        try {
            int i2 = Integer.parseInt(str);
        }
        catch (NumberFormatException e) {
            this.errors.add(fiels, new ActionError(errMsg, (Object)this.getMessage(fieldName)));
            return false;
        }
        return true;
    }

    public boolean isIntEx(String fiels, String fieldName, String errMsg, String str, boolean required) {
        if (required) {
            try {
                int i2 = Integer.parseInt(str);
            }
            catch (NumberFormatException e) {
                if (this.getMessage(fieldName) == null) {
                    this.errors.add(fiels, new ActionError(errMsg, (Object)fieldName));
                } else {
                    this.errors.add(fiels, new ActionError(errMsg, (Object)this.getMessage(fieldName)));
                }
                return false;
            }
        }
        return true;
    }

    public boolean isEmail(String field, String fieldName, String errMsg, String value) {
        if (!GenericValidator.isEmail((String)value)) {
            this.errors.add(field, new ActionError(errMsg, (Object)this.getMessage(fieldName)));
            return false;
        }
        return true;
    }

    public boolean isZenkakuOnly(String field, String fieldName, String errMsg, String value) {
        boolean zen_flg = true;
        if (value != null) {
            int len = value.length();
            for (int i2 = 0; i2 < len; ++i2) {
                char chr = value.charAt(i2);
                Character.UnicodeBlock ub = Character.UnicodeBlock.of(chr);
                if (ub == Character.UnicodeBlock.BASIC_LATIN) {
                    zen_flg = false;
                }
                if (ub != Character.UnicodeBlock.HALFWIDTH_AND_FULLWIDTH_FORMS || chr < '\uff61' || chr > '\uff9f') continue;
                zen_flg = false;
            }
            if (!zen_flg) {
                this.errors.add(field, new ActionError(errMsg, (Object)this.getMessage(fieldName)));
                return false;
            }
        }
        return true;
    }

    public boolean isZenkakuKanaOnly(String field, String fieldName, String errMsg, String value) {
        int kanaCnt = 0;
        if (value != null) {
            int len = value.length();
            for (int i2 = 0; i2 < len; ++i2) {
                char chr = value.charAt(i2);
                Character.UnicodeBlock ub = Character.UnicodeBlock.of(chr);
                if (ub != Character.UnicodeBlock.KATAKANA) continue;
                ++kanaCnt;
            }
            if (len != kanaCnt) {
                this.errors.add(field, new ActionError(errMsg, (Object)this.getMessage(fieldName)));
                return false;
            }
        }
        return true;
    }

    public boolean isNotIncludingHankakuKana(String field, String fieldName, String errMsg, String value) {
        boolean kana_flg = false;
        if (value != null) {
            int len = value.length();
            for (int i2 = 0; i2 < len; ++i2) {
                char chr = value.charAt(i2);
                Character.UnicodeBlock ub = Character.UnicodeBlock.of(chr);
                if (ub != Character.UnicodeBlock.HALFWIDTH_AND_FULLWIDTH_FORMS || chr < '\uff61' || chr > '\uff9f') continue;
                kana_flg = true;
            }
            if (kana_flg) {
                this.errors.add(field, new ActionError(errMsg, (Object)this.getMessage(fieldName)));
                return false;
            }
        }
        return true;
    }

    public boolean isRequired(String field, String fieldname, String errMsg, String value) {
        if (StringUtils.isEmpty(value)) {
            this.errors.add(field, new ActionError(errMsg, (Object)this.getMessage(fieldname)));
            return false;
        }
        return true;
    }

    public boolean notEqual(String field, String fieldname, String errMsg, String value1, String value2) {
        if (value1 != null && !value1.equals(value2)) {
            this.errors.add(field, new ActionError(errMsg, (Object)this.getMessage(fieldname)));
            return false;
        }
        return true;
    }

    public boolean isRange(String field, String fieldname, String errMsg, String value, int min, int max) {
        if (value != null && (value.getBytes().length > max || value.getBytes().length < min)) {
            this.errors.add(field, new ActionError(errMsg, (Object)this.getMessage(fieldname), (Object)String.valueOf(min), (Object)String.valueOf(max)));
            return false;
        }
        return true;
    }

    protected String getMessage(String fieldname) {
        if (this.locale == null) {
            return this.messageResources.getMessage(fieldname);
        }
        return this.messageResources.getMessage(this.locale, fieldname);
    }

    public boolean isPositive(String fiels, String fieldName, String errMsg, String str, boolean required) {
        if (!required || str != null) {
            try {
                int i2 = Integer.parseInt(str);
                if (i2 < 0) {
                    this.errors.add(fiels, new ActionError(errMsg, (Object)this.getMessage(fieldName)));
                    return false;
                }
            }
            catch (NumberFormatException e) {
                this.errors.add(fiels, new ActionError(errMsg, (Object)this.getMessage(fieldName)));
                return false;
            }
        }
        return true;
    }

    public boolean isGreaterThan(String field, String fieldname, String value1, String value2) {
        long l2;
        long l1;
        if (!StringUtils.isEmpty(value1) && !StringUtils.isEmpty(value2) && (l1 = Long.valueOf(value1).longValue()) > (l2 = Long.valueOf(value2).longValue())) {
            this.errors.add(field, new ActionError("errors.greaterthan", (Object)value2, (Object)value1));
            return false;
        }
        return true;
    }

    public boolean isGreaterThan(String field, String fieldname, String errMsg, String value1, String value2) {
        long l2;
        long l1;
        if (!StringUtils.isEmpty(value1) && !StringUtils.isEmpty(value2) && (l1 = Long.valueOf(value1).longValue()) > (l2 = Long.valueOf(value2).longValue())) {
            this.errors.add(field, new ActionError(errMsg, (Object)this.getMessage(fieldname), (Object)value2, (Object)value1));
            return false;
        }
        return true;
    }

    public boolean matchRegexp(String field, String fieldName, String errMsg, String value, String exp) {
        if (!GenericValidator.matchRegexp((String)value, (String)exp)) {
            this.errors.add(field, new ActionError(errMsg, (Object)this.getMessage(fieldName)));
            return false;
        }
        return true;
    }

    public boolean notMatchRegexp(String field, String fieldName, String errMsg, String value, String exp) {
        if (GenericValidator.matchRegexp((String)value, (String)exp)) {
            this.errors.add(field, new ActionError(errMsg, (Object)this.getMessage(fieldName)));
            return false;
        }
        return true;
    }

    public boolean isNotIncludingZenkaku(String field, String fieldName, String errMsg, String value) {
        boolean noZen_flg = true;
        int len = value.length();
        for (int i2 = 0; i2 < len; ++i2) {
            char chr = value.charAt(i2);
            Character.UnicodeBlock ub = Character.UnicodeBlock.of(chr);
            if (ub == Character.UnicodeBlock.BASIC_LATIN) continue;
            noZen_flg = false;
        }
        if (!noZen_flg) {
            this.errors.add(field, new ActionError(errMsg, (Object)this.getMessage(fieldName)));
        }
        return noZen_flg;
    }

    public boolean notZero(String field, String fieldName, String errMsg, String value) {
        if (Integer.parseInt(value) <= 0) {
            this.errors.add(field, new ActionError(errMsg, (Object)this.getMessage(fieldName)));
            return false;
        }
        return true;
    }
}

