/*
 * Decompiled with CFR 0.152.
 */
package com.jware.apps.scheduler.web.struts.listener;

import com.jware.apps.scheduler.util.JobSchedulerUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.quartz.Scheduler;

public abstract class EditListenersAction
extends Action {
    private static final transient Log logger = LogFactory.getLog(EditListenersAction.class);
    public static final String CVS_INFO = "$Id: EditListenersAction.java,v 1.1 2010/01/13 11:52:18 clmg Exp $";
    public static final String LISTENER_CLASS_PROP = "listenerClass";
    public static final String LISTENER_NAME_PROP = "listenerName";
    public static final String ACTION_KEY = "action";
    public static final String DELETE_ACTION_PROP = "delete";
    public static final String ADD_ACTION_PROP = "add";

    public ActionForward execute(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        Scheduler scheduler = JobSchedulerUtils.getCurrentScheduler(request);
        logger.info((Object)"Enter action!!!!!!!!!!!!!!!!");
        ActionErrors errors = new ActionErrors();
        String action = request.getParameter(ACTION_KEY);
        if (action == null) {
            logger.info((Object)"no action");
        } else if (action.equals(DELETE_ACTION_PROP)) {
            String[] listenersToDelete = request.getParameterValues(LISTENER_NAME_PROP);
            for (int i2 = 0; i2 < listenersToDelete.length; ++i2) {
                String listenerToDelete = listenersToDelete[i2];
                this.removeListener(listenerToDelete, scheduler);
            }
        } else if (action.equals(ADD_ACTION_PROP)) {
            String newListenerClass = request.getParameter(LISTENER_CLASS_PROP);
            this.addListener(newListenerClass, scheduler);
        }
        if (errors != null && errors.size() > 0) {
            this.saveErrors(request, errors);
            return new ActionForward(mapping.getInput());
        }
        ArrayList jobListenerNames = new ArrayList();
        ArrayList jobListenerClasses = new ArrayList();
        this.addAllListenerNamesAndClasses(scheduler, jobListenerNames, jobListenerClasses);
        request.setAttribute("listenerNames", jobListenerNames);
        request.setAttribute("listenerClasses", jobListenerClasses);
        this.setRequest(request);
        return mapping.findForward("success");
    }

    abstract void removeListener(String var1, Scheduler var2) throws ServletException;

    abstract void addListener(String var1, Scheduler var2) throws ServletException;

    abstract void addAllListenerNamesAndClasses(Scheduler var1, List var2, List var3) throws ServletException;

    abstract void setRequest(HttpServletRequest var1);
}

