/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.www;

import java.io.IOException;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.ecs.Element;
import org.apache.ecs.xhtml.a;
import org.apache.ecs.xhtml.br;
import org.apache.ecs.xhtml.form;
import org.apache.ecs.xhtml.input;
import org.apache.ecs.xhtml.label;
import org.apache.ecs.xhtml.p;
import org.apache.ecs.xhtml.table;
import org.apache.ecs.xhtml.td;
import org.apache.ecs.xhtml.textarea;
import org.apache.ecs.xhtml.tr;
import org.compiere.model.MAttachment;
import org.compiere.model.MAttachmentEntry;
import org.compiere.util.CLogger;
import org.compiere.util.Ctx;
import org.compiere.util.FileUpload;
import org.compiere.util.Msg;
import org.compiere.util.WebDoc;
import org.compiere.util.WebEnv;
import org.compiere.util.WebUtil;
import org.compiere.www.WWindowStatus;

public class WAttachment
extends HttpServlet {
    private static CLogger log = CLogger.getCLogger(WAttachment.class);
    public static final String P_Attachment_ID = "AD_Attachment_ID";
    public static final String P_ATTACHMENT_INDEX = "AttachmentIndex";
    public static final String P_TEXTMSG = "TextMsg";

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        if (!WebEnv.initWeb((ServletConfig)config)) {
            throw new ServletException("WAttachment.init");
        }
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        log.info("From " + request.getRemoteHost() + " - " + request.getRemoteAddr());
        HttpSession session = request.getSession(false);
        WWindowStatus ws = WWindowStatus.get(request);
        WebDoc doc = null;
        if (session == null || ws == null) {
            doc = WebDoc.createPopup((String)"No Context");
            doc.addPopupClose();
        } else {
            int attachmentIndex;
            String error = null;
            int AD_Attachment_ID = WebUtil.getParameterAsInt((HttpServletRequest)request, (String)P_Attachment_ID);
            if (AD_Attachment_ID != 0 && (attachmentIndex = WebUtil.getParameterAsInt((HttpServletRequest)request, (String)P_ATTACHMENT_INDEX)) != 0 && (error = this.streamAttachment(AD_Attachment_ID, attachmentIndex, response, ws)) == null) {
                return;
            }
            doc = this.createPage(ws.ctx, ws.curTab.getAD_AttachmentID(), ws.curTab.getAD_Table_ID(), ws.curTab.getRecord_ID(), error);
        }
        WebUtil.createResponse((HttpServletRequest)request, (HttpServletResponse)response, (HttpServlet)this, null, (WebDoc)doc, (boolean)false);
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        log.info("From " + request.getRemoteHost() + " - " + request.getRemoteAddr());
        HttpSession sess = request.getSession(false);
        WWindowStatus ws = WWindowStatus.get(request);
        WebDoc doc = null;
        if (ws == null) {
            doc = WebDoc.create((String)"Help - No Context");
        } else {
            String error = this.processPost(request, response, ws);
            doc = this.createPage(ws.ctx, ws.curTab.getAD_AttachmentID(), ws.curTab.getAD_Table_ID(), ws.curTab.getRecord_ID(), error);
        }
        WebUtil.createResponse((HttpServletRequest)request, (HttpServletResponse)response, (HttpServlet)this, null, (WebDoc)doc, (boolean)false);
    }

    private WebDoc createPage(Ctx ctx, int AD_Attachment_ID, int AD_Table_ID, int Record_ID, String error) {
        WebDoc doc = WebDoc.createPopup((String)Msg.translate((Ctx)ctx, (String)P_Attachment_ID));
        table table2 = doc.getTable();
        if (error != null) {
            table2.addElement((Element)new tr().addElement((Element)new td("popupHeader", "right", "top", false, null)).addElement((Element)new td("popupHeader", "left", "top", false, new p(error, "left").setClass("Cerror"))));
        }
        MAttachment attachment = null;
        attachment = AD_Attachment_ID != 0 ? new MAttachment(ctx, AD_Attachment_ID, null) : new MAttachment(ctx, AD_Table_ID, Record_ID, null);
        tr tr2 = new tr();
        td left = new td("popupCenter", "right", "top", false, (Element)new label(P_TEXTMSG, "T", Msg.translate((Ctx)ctx, (String)P_TEXTMSG)));
        td right = new td("popupCenter", "left", "top", false);
        form textMsg = new form("WAttachment");
        textMsg.addElement((Element)new input("hidden", P_Attachment_ID, AD_Attachment_ID));
        textMsg.addElement((Element)new input("hidden", "AD_Table_ID", AD_Table_ID));
        textMsg.addElement((Element)new input("hidden", "Record_ID", Record_ID));
        textarea msg = new textarea(P_TEXTMSG, 5, 40);
        msg.addElement(attachment.getTextMsg());
        textMsg.addElement((Element)msg);
        textMsg.addElement((Element)new br());
        textMsg.addElement((Element)new input("submit", "submit", "Submit"));
        right.addElement((Element)textMsg);
        p p2 = new p();
        MAttachmentEntry[] entries = attachment.getEntries();
        for (int i2 = 0; i2 < entries.length; ++i2) {
            MAttachmentEntry entry = entries[i2];
            if (i2 > 0) {
                p2.addElement(" - ");
            }
            String url = "WAttachment?AD_Attachment_ID=" + AD_Attachment_ID + "&" + P_ATTACHMENT_INDEX + "=" + entry.getIndex();
            p2.addElement((Element)new a(url, null, "_blank", entry.getName()));
        }
        right.addElement((Element)p2);
        form upload = FileUpload.createForm((String)"WAttachment");
        upload.addElement((Element)new input("hidden", P_Attachment_ID, AD_Attachment_ID));
        upload.addElement((Element)new input("hidden", "AD_Table_ID", AD_Table_ID));
        upload.addElement((Element)new input("hidden", "Record_ID", Record_ID));
        right.addElement((Element)upload);
        tr2.addElement((Element)left);
        tr2.addElement((Element)right);
        table2.addElement((Element)tr2);
        doc.addPopupClose();
        return doc;
    }

    private String streamAttachment(int AD_Attachment_ID, int attachmentIndex, HttpServletResponse response, WWindowStatus ws) {
        log.info("AD_Attachment_ID=" + AD_Attachment_ID + ", AttachmentIndex=" + attachmentIndex);
        MAttachment attachment = new MAttachment(ws.ctx, AD_Attachment_ID, null);
        if (attachment.get_ID() == 0) {
            log.fine("No Attachment AD_Attachment_ID=" + AD_Attachment_ID);
            return "Attachment not found";
        }
        if (ws.curTab.getAD_AttachmentID() != AD_Attachment_ID) {
            log.warning("Tab AD_Attachment_ID=" + ws.curTab.getAD_AttachmentID() + " <> " + AD_Attachment_ID);
            return "Your Attachment not found";
        }
        return WebUtil.streamAttachment((HttpServletResponse)response, (MAttachment)attachment, (int)attachmentIndex);
    }

    private String processPost(HttpServletRequest request, HttpServletResponse response, WWindowStatus ws) {
        int AD_Attachment_ID = 0;
        int AD_Table_ID = 0;
        int Record_ID = 0;
        String textMsg = null;
        FileUpload upload = null;
        if (request.getContentType().equals("application/x-www-form-urlencoded")) {
            AD_Attachment_ID = WebUtil.getParameterAsInt((HttpServletRequest)request, (String)P_Attachment_ID);
            AD_Table_ID = WebUtil.getParameterAsInt((HttpServletRequest)request, (String)"AD_Table_ID");
            Record_ID = WebUtil.getParameterAsInt((HttpServletRequest)request, (String)"Record_ID");
            textMsg = WebUtil.getParameter((HttpServletRequest)request, (String)P_TEXTMSG);
        } else {
            upload = new FileUpload(request);
            String error = upload.getError();
            if (error != null) {
                log.warning("pocessPost - " + error);
                return error;
            }
            AD_Attachment_ID = upload.getParameterAsInt(P_Attachment_ID);
            AD_Table_ID = upload.getParameterAsInt("AD_Table_ID");
            Record_ID = upload.getParameterAsInt("Record_ID");
        }
        log.info("processPost - AD_Attachment_ID=" + AD_Attachment_ID + ", AD_Table_ID=" + AD_Table_ID + ", Record_ID=" + Record_ID + " - Upload=" + upload);
        if (ws.curTab.getAD_AttachmentID() != AD_Attachment_ID) {
            return "Your Attachment not found";
        }
        if (AD_Attachment_ID != 0 && Record_ID == 0) {
            return "Need to save record first";
        }
        MAttachment attachment = null;
        attachment = AD_Attachment_ID == 0 ? new MAttachment(ws.ctx, AD_Table_ID, Record_ID, null) : new MAttachment(ws.ctx, AD_Attachment_ID, null);
        if (textMsg != null) {
            attachment.setTextMsg(textMsg);
        }
        if (upload != null) {
            attachment.addEntry(upload.getFileName(), upload.getData());
        }
        if (!attachment.save()) {
            return "Attachment not saved";
        }
        ws.curTab.loadAttachments();
        return null;
    }
}

