/*
 * Decompiled with CFR 0.152.
 */
package com.jware.util.bean;

public class StrUtil {
    public static final String LINE_SEPARATOR = System.getProperty("line.separator", "\n");
    private static final int MAXSPACES = 2560;
    private static final int MAXZEROS = 2560;
    private static final String INIT_SPACES = "                                        ";
    private static final int INIT_SPACESLEN = 40;
    private static final String INIT_ZEROS = "0000000000000000000000000000000000000000";
    private static final int INIT_ZEROSLEN = 40;
    private static String SPACES = "";
    private static int SPACESLEN = 0;
    private static String ZEROS = "";
    private static int ZEROSLEN = 0;
    private static Object lock = new Object();

    private StrUtil() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getSpaces(int len) {
        if (len > SPACESLEN && SPACESLEN < 2560) {
            Object object = lock;
            synchronized (object) {
                while (len > SPACESLEN && SPACESLEN < 2560) {
                    SPACES = SPACES + INIT_SPACES;
                    SPACESLEN += 40;
                }
            }
        }
        return SPACES.substring(0, len);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getZeros(int len) {
        if (len > ZEROSLEN && ZEROSLEN < 2560) {
            Object object = lock;
            synchronized (object) {
                while (len > ZEROSLEN && ZEROSLEN < 2560) {
                    ZEROS = ZEROS + INIT_ZEROS;
                    ZEROSLEN += 40;
                }
            }
        }
        return ZEROS.substring(0, len);
    }

    public static String nvl(String sIn) {
        return sIn == null ? "" : sIn;
    }

    public static String nvl(String sIn, String sDef) {
        return sIn == null ? sDef : sIn;
    }

    public static String padLeft(String s, int len) {
        return StrUtil.padLeft(s, len, false);
    }

    public static String padLeft(String s, int len, boolean trim) {
        s = StrUtil.nvl(s);
        int slen = s.getBytes().length;
        String ret = null;
        if (slen < len) {
            ret = StrUtil.getSpaces(len - slen) + s;
        } else if (slen > len && trim) {
            ret = "";
            int length = s.length();
            for (int n = 0; n < length && (ret + s.charAt(n)).getBytes().length <= len; ++n) {
                ret = ret + s.charAt(n);
            }
        } else {
            ret = s;
        }
        return ret;
    }

    public static String padRight(String s, int len) {
        return StrUtil.padRight(s, len, false);
    }

    public static String padRight(String s, int len, boolean trim) {
        s = StrUtil.nvl(s);
        int slen = s.getBytes().length;
        String ret = null;
        if (slen < len) {
            ret = s + StrUtil.getSpaces(len - slen);
        } else if (slen > len && trim) {
            ret = "";
            int length = s.length();
            for (int n = 0; n < length && (ret + s.charAt(n)).getBytes().length <= len; ++n) {
                ret = ret + s.charAt(n);
            }
        } else {
            ret = s;
        }
        return ret;
    }

    public static String padZero(String s, int len) {
        s = StrUtil.nvl(s);
        int slen = s.getBytes().length;
        String ret = null;
        ret = slen < len ? StrUtil.getZeros(len - slen) + s : s;
        return ret;
    }

    public static String padZero(int value, int len) {
        String s = "" + value;
        int slen = s.length();
        String ret = null;
        ret = slen < len ? StrUtil.getZeros(len - slen) + s : s;
        return ret;
    }

    public static String replaceStr(String src, String sFnd, String sRep) {
        String sTemp = "";
        int endIndex = 0;
        int beginIndex = 0;
        do {
            if ((endIndex = src.indexOf(sFnd, beginIndex)) >= 0) {
                sTemp = sTemp + src.substring(beginIndex, endIndex) + sRep;
                beginIndex = endIndex + sFnd.length();
                continue;
            }
            if (beginIndex < 0) continue;
            sTemp = sTemp + src.substring(beginIndex);
            break;
        } while (endIndex >= 0);
        return sTemp;
    }

    public static String removeChar(String str, String rc) {
        if (str == null) {
            return null;
        }
        int i2 = str.indexOf(rc);
        while (i2 >= 0) {
            str = str.substring(0, i2) + str.substring(i2 + 1, str.length());
            i2 = str.indexOf(rc);
        }
        return str;
    }

    public static boolean isSpace(char c) {
        return c == ' ' || c == '\t' || c == ' ';
    }

    public static boolean isSpace(String s) {
        if (s == null) {
            return false;
        }
        int length = s.length();
        for (int i2 = 0; i2 < length; ++i2) {
            if (StrUtil.isSpace(s.charAt(i2))) continue;
            return false;
        }
        return true;
    }

    public static boolean isNullString(String str) {
        return str == null || "".equals(str.trim());
    }

    public static String trim(String s) {
        if (s == null) {
            return null;
        }
        int begin = 0;
        int end = 0;
        int length = s.length();
        for (begin = 0; begin < length && StrUtil.isSpace(s.charAt(begin)); ++begin) {
        }
        for (end = length - 1; end >= 0 && StrUtil.isSpace(s.charAt(end)); --end) {
        }
        if (end < begin) {
            return "";
        }
        return s.substring(begin, end + 1);
    }

    public static boolean isDigit(String s) {
        s = StrUtil.trim(s);
        int n = s.length();
        for (int i2 = 0; i2 < n; ++i2) {
            char c = s.charAt(i2);
            if (Character.isDigit(c)) continue;
            return false;
        }
        return true;
    }
}

