/*
 * Decompiled with CFR 0.152.
 */
package com.ampiere.web.struts.form;

import com.ampiere.web.struts.form.ChargeAccountForm;
import java.util.logging.Level;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.compiere.model.MAccount;
import org.compiere.model.MAcctSchema;
import org.compiere.model.MCharge;
import org.compiere.util.CLogger;
import org.compiere.util.Ctx;
import org.compiere.util.DB;
import org.compiere.util.Msg;
import org.compiere.util.WebSessionCtx;

public class ChargeAccountAction
extends Action {
    private CLogger log = CLogger.getCLogger(((Object)((Object)this)).getClass());
    private static final String ACCOUNT_LIST = "accountlist";
    private static final String ACTION_FORM = "ChargeAccountForm";
    private static final String ERROR_FORWARD = "error";

    public final ActionForward execute(ActionMapping mapping, ActionForm form2, HttpServletRequest request, HttpServletResponse response) throws Exception {
        WebSessionCtx wscTest = WebSessionCtx.get((HttpServletRequest)request);
        if (wscTest == null) {
            this.log.log(Level.SEVERE, "Session Time Out.");
            request.setAttribute("sessionTimeoutInfo", (Object)"Session Time Out. Please login again.");
            return mapping.findForward("sessionTimeout");
        }
        this.log.fine("Begin " + ((Object)((Object)this)).getClass().getName() + ";execute");
        WebSessionCtx wsc = WebSessionCtx.get((HttpServletRequest)request);
        if (wsc == null) {
            this.log.log(Level.SEVERE, "Session Time Out.");
            return mapping.findForward(ERROR_FORWARD);
        }
        ActionForward actionForward = mapping.findForward(ACCOUNT_LIST);
        ChargeAccountForm myForm = (ChargeAccountForm)request.getAttribute(ACTION_FORM);
        String column = myForm.getChangedColumn();
        if (column.equals("new")) {
            int elementValueId = this.createElementValue(wsc.ctx, myForm.getKeyValue(), myForm.getKeyName(), "on".equals(myForm.getExpense()));
            if (elementValueId == 0) {
                myForm.setResultInfo(Msg.translate((Ctx)wsc.ctx, (String)"ChargeNotCreated") + ":" + myForm.getKeyName());
            } else {
                int chargeId = this.createCharge(wsc.ctx, myForm.getKeyName(), elementValueId);
                if (chargeId == 0) {
                    myForm.setResultInfo(Msg.translate((Ctx)wsc.ctx, (String)"ChargeNotCreated") + ":" + myForm.getKeyName());
                } else {
                    myForm.setKeyValue("");
                    myForm.setKeyName("");
                    myForm.setExpense("on");
                    myForm.setResultInfo("");
                }
            }
            actionForward = mapping.findForward(ACCOUNT_LIST);
        } else {
            this.createAccount(wsc.ctx, myForm);
            myForm.setKeyList(null);
            actionForward = mapping.findForward(ACCOUNT_LIST);
        }
        request.setAttribute(ACTION_FORM, (Object)myForm);
        this.log.fine("End " + ((Object)((Object)this)).getClass().getName() + ";execute");
        return actionForward;
    }

    private void createAccount(Ctx ctx, ChargeAccountForm form2) {
        StringBuffer listCreated = new StringBuffer();
        StringBuffer listRejected = new StringBuffer();
        String[] accounts = form2.getKeyList();
        int rows = accounts.length;
        for (int i2 = 0; i2 < rows; ++i2) {
            int elementValueId;
            String[] keyname = accounts[i2].split("\\|");
            String name = keyname[1];
            int chargeId = this.createCharge(ctx, name, elementValueId = Integer.valueOf(keyname[0]).intValue());
            if (chargeId == 0) {
                if (listRejected.length() > 0) {
                    listRejected.append(", ");
                }
                listRejected.append(name);
                continue;
            }
            if (listCreated.length() > 0) {
                listCreated.append(", ");
            }
            listCreated.append(name);
        }
        String result = "";
        if (listCreated.length() > 0) {
            result = result + Msg.translate((Ctx)ctx, (String)"ChargeCreated") + " : " + listCreated.toString();
        }
        if (listRejected.length() > 0) {
            result = result + Msg.translate((Ctx)ctx, (String)"ChargeNotCreated") + " : " + listRejected.toString();
        }
        form2.setResultInfo(result);
    }

    private int createElementValue(Ctx ctx, String value, String name, boolean isExpenseType) {
        int elementValueId = DB.getNextID((Ctx)ctx, (String)"C_ElementValue", null);
        int accountElementId = ctx.getContextAsInt(0, "AccountElementId");
        int clientId = ctx.getAD_Client_ID();
        int organizationId = ctx.getAD_Org_ID();
        int userId = ctx.getAD_User_ID();
        StringBuffer sql = new StringBuffer("INSERT INTO C_ElementValue (C_ElementValue_ID, C_Element_ID, AD_Client_ID,AD_Org_ID,IsActive,Created,CreatedBy,Updated,UpdatedBy, Value, Name, Description, AccountType, AccountSign, IsDocControlled, IsSummary, ValidFrom, ValidTo, PostActual, PostBudget, PostEncumbrance, PostStatistical, IsBankAccount, C_BankAccount_ID, IsForeignCurrency, C_Currency_ID) VALUES (");
        sql.append(elementValueId).append(",").append(accountElementId).append(",");
        sql.append(clientId).append(",").append(organizationId);
        sql.append(",'Y',SysDate,").append(userId).append(",SysDate,").append(userId).append(",");
        sql.append("'").append(value).append("','").append(name).append("',NULL,");
        sql.append(isExpenseType ? "'E'" : "'R'").append(", 'N', ");
        sql.append("'N','N',");
        sql.append("TO_DATE('01-JAN-1970'),NULL,");
        sql.append("'Y','Y','Y','Y',");
        sql.append("'N',NULL,'N',NULL)");
        int no = DB.executeUpdate((String)sql.toString(), null);
        if (no != 1) {
            this.log.log(Level.SEVERE, "#" + no + "\n" + sql.toString());
            elementValueId = 0;
        } else {
            this.log.config("C_ElementValue_ID=" + elementValueId + " " + value + "=" + name);
        }
        return elementValueId;
    }

    private int createCharge(Ctx ctx, String name, int elementValueId) {
        MCharge charge = new MCharge(ctx, 0, null);
        charge.setName(name);
        int taxCategoryId = ctx.getContextAsInt(0, "TaxCategoryID");
        charge.setC_TaxCategory_ID(taxCategoryId);
        if (!charge.save()) {
            this.log.log(Level.SEVERE, name + " not created");
            return 0;
        }
        int accountSchemaId = ctx.getContextAsInt("$C_AcctSchema_ID");
        MAcctSchema acctSchema = new MAcctSchema(ctx, accountSchemaId, null);
        if (acctSchema == null || acctSchema.getC_AcctSchema_ID() == 0) {
            return 0;
        }
        MAccount defaultAcct = MAccount.getDefault((MAcctSchema)acctSchema, (boolean)true);
        MAccount acct = MAccount.get((Ctx)ctx, (int)charge.getAD_Client_ID(), (int)charge.getAD_Org_ID(), (int)acctSchema.getC_AcctSchema_ID(), (int)elementValueId, (int)defaultAcct.getC_SubAcct_ID(), (int)defaultAcct.getM_Product_ID(), (int)defaultAcct.getC_BPartner_ID(), (int)defaultAcct.getAD_OrgTrx_ID(), (int)defaultAcct.getC_LocFrom_ID(), (int)defaultAcct.getC_LocTo_ID(), (int)defaultAcct.getC_SalesRegion_ID(), (int)defaultAcct.getC_Project_ID(), (int)defaultAcct.getC_Campaign_ID(), (int)defaultAcct.getC_Activity_ID(), (int)defaultAcct.getUser1_ID(), (int)defaultAcct.getUser2_ID(), (int)defaultAcct.getUserElement1_ID(), (int)defaultAcct.getUserElement2_ID());
        if (acct == null) {
            return 0;
        }
        StringBuffer sql = new StringBuffer("UPDATE C_Charge_Acct ");
        sql.append("SET CH_Expense_Acct=").append(acct.getC_ValidCombination_ID());
        sql.append(", CH_Revenue_Acct=").append(acct.getC_ValidCombination_ID());
        sql.append(" WHERE C_Charge_ID=").append(charge.getC_Charge_ID());
        sql.append(" AND C_AcctSchema_ID=").append(accountSchemaId);
        int no = DB.executeUpdate((String)sql.toString(), null);
        if (no != 1) {
            this.log.log(Level.SEVERE, "Update #" + no + "\n" + sql.toString());
        }
        return charge.getC_Charge_ID();
    }
}

