/*
 * Decompiled with CFR 0.152.
 */
package com.ampiere.search;

import com.ampiere.search.ComponentBean;
import com.ampiere.search.IDColumn;
import com.ampiere.search.Info;
import com.ampiere.search.Info_Column;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Hashtable;
import java.util.logging.Level;
import org.compiere.framework.Lookup;
import org.compiere.model.MLookup;
import org.compiere.model.MLookupFactory;
import org.compiere.util.Ctx;
import org.compiere.util.DB;
import org.compiere.util.Msg;

public class InfoAssignment
extends Info {
    private Info_Column[] s_assignmentLayout = null;
    private static String s_assignmentFROM = "S_ResourceAssignment ra, S_ResourceType rt, S_Resource r, C_UOM uom";
    private static String s_assignmentWHERE = "ra.IsActive='Y' AND ra.S_Resource_ID=r.S_Resource_ID AND r.S_ResourceType_ID=rt.S_ResourceType_ID AND rt.C_UOM_ID=uom.C_UOM_ID";

    public InfoAssignment(int WindowNo, String value, boolean multiSelection, String whereClause, Ctx ctx) {
        super(WindowNo, "ra", "S_ResourceAssigment_ID", multiSelection, whereClause, ctx);
        this.log.info(value);
        this.title = Msg.translate((Ctx)ctx, (String)"InfoAssignment");
        int i = 0;
        this.s_assignmentLayout = new Info_Column[8];
        this.columnAttrList = new ArrayList();
        this.s_assignmentLayout[i++] = new Info_Column(" ", "ra.S_ResourceAssignment_ID", IDColumn.class);
        this.columnAttrList.add(1);
        this.s_assignmentLayout[i++] = new Info_Column(Msg.translate((Ctx)ctx, (String)"S_ResourceType_ID"), "rt.Name", String.class);
        this.columnAttrList.add(1);
        this.s_assignmentLayout[i++] = new Info_Column(Msg.translate((Ctx)ctx, (String)"S_Resource_ID"), "r.Name", String.class);
        this.columnAttrList.add(1);
        this.s_assignmentLayout[i++] = new Info_Column(Msg.translate((Ctx)ctx, (String)"AssignDateFrom"), "ra.AssignDateFrom", Timestamp.class);
        this.columnAttrList.add(1);
        this.s_assignmentLayout[i++] = new Info_Column(Msg.translate((Ctx)ctx, (String)"Qty"), "ra.Qty", Double.class);
        this.columnAttrList.add(0);
        this.s_assignmentLayout[i++] = new Info_Column(Msg.translate((Ctx)ctx, (String)"C_UOM_ID"), "uom.UOMSymbol", String.class);
        this.columnAttrList.add(0);
        this.s_assignmentLayout[i++] = new Info_Column(Msg.translate((Ctx)ctx, (String)"AssignDateTo"), "ra.AssignDateTo", Timestamp.class);
        this.columnAttrList.add(0);
        this.s_assignmentLayout[i++] = new Info_Column(Msg.translate((Ctx)ctx, (String)"IsConfirmed"), "ra.IsConfirmed", Boolean.class);
        this.columnAttrList.add(0);
        this.statInit(ctx);
        this.initInfo();
        this.p_loadedOK = true;
    }

    private void statInit(Ctx ctx) {
        MLookup lookupResType = MLookupFactory.get((Ctx)ctx, (int)this.p_WindowNo, (int)6851, (int)19);
        this.componentList.add(new ComponentBean(Msg.translate((Ctx)ctx, (String)"S_ResourceType_ID"), 1, "", "right", "middle", "", 0));
        this.componentMapping.put("S_ResourceType_ID", new Integer(this.componentList.size()));
        this.componentList.add(new ComponentBean("", 4, this.getTableDirectList((Lookup)lookupResType), "left", "middle", "", 218));
        MLookup lookupRes = MLookupFactory.get((Ctx)ctx, (int)this.p_WindowNo, (int)6826, (int)19);
        this.componentList.add(new ComponentBean(Msg.translate((Ctx)ctx, (String)"S_Resource_ID"), 1, "", "right", "middle", "", 0));
        this.componentMapping.put("S_Resource_ID", new Integer(this.componentList.size()));
        this.componentList.add(new ComponentBean("", 4, this.getTableDirectList((Lookup)lookupRes), "left", "middle", "", 218));
        this.componentList.add(new ComponentBean(0));
        this.componentList.add(new ComponentBean(Msg.translate((Ctx)ctx, (String)"DateFrom"), 1, "", "right", "middle", "", 0));
        this.componentMapping.put("DateFrom", new Integer(this.componentList.size()));
        this.componentList.add(new ComponentBean(Msg.translate((Ctx)ctx, (String)"DateFrom"), 5, "", "left", "middle", "", 198));
        this.componentList.add(new ComponentBean(Msg.translate((Ctx)ctx, (String)"DateTo"), 1, "", "right", "middle", "", 0));
        this.componentMapping.put("DateTo", new Integer(this.componentList.size()));
        this.componentList.add(new ComponentBean(Msg.translate((Ctx)ctx, (String)"DateTo"), 5, "", "left", "middle", "", 198));
    }

    private void initInfo() {
        StringBuffer where = new StringBuffer(s_assignmentWHERE);
        if (this.p_whereClause != null && this.p_whereClause.length() > 0) {
            where.append(" AND ").append(this.p_whereClause);
        }
        this.prepareTable(this.s_assignmentLayout, s_assignmentFROM, where.toString(), "rt.Name,r.Name,ra.AssignDateFrom");
    }

    protected String createQuery(Hashtable valueMapping, SimpleDateFormat dateFormat) {
        String to;
        String from;
        StringBuffer sql = new StringBuffer();
        String s = this.getComponetValue(valueMapping, "S_ResourceType_ID");
        if (s != null) {
            sql.append(" AND rt.S_ResourceType_ID=");
            sql.append(Integer.parseInt(s));
        }
        if ((s = this.getComponetValue(valueMapping, "S_Resource_ID")) != null) {
            sql.append(" AND r.S_Resource_ID=");
            sql.append(Integer.parseInt(s));
        }
        if ((from = this.getComponetValue(valueMapping, "DateFrom")) != null) {
            Timestamp fromT = null;
            try {
                if (from != null) {
                    Date d = dateFormat.parse(from);
                    fromT = new Timestamp(d.getTime());
                }
            }
            catch (Exception e) {
                this.log.log(Level.SEVERE, "InfoAssignment : createQuery : Date convert error ", (Throwable)e);
            }
            if (fromT == null) {
                sql.append(" AND TRUNC(ra.AssignDateFrom)>=");
                sql.append(DB.TO_DATE((Timestamp)fromT, (boolean)false));
            }
        }
        if ((to = this.getComponetValue(valueMapping, "DateFrom")) != null) {
            Timestamp toT = null;
            try {
                if (to != null) {
                    Date d = dateFormat.parse(to);
                    toT = new Timestamp(d.getTime());
                }
            }
            catch (Exception e) {
                this.log.log(Level.SEVERE, "InfoAssignment : createQuery : Date convert error ", (Throwable)e);
            }
            if (toT == null) {
                sql.append(" AND TRUNC(ra.AssignDateTo)<=");
                sql.append(DB.TO_DATE((Timestamp)toT, (boolean)false));
            }
        }
        return sql.toString();
    }

    void setParameters(PreparedStatement pstmt, boolean forCount) throws SQLException {
    }

    protected String getSQLWhere() {
        if (this.p_sqlWhere != null && this.p_sqlWhere.length() > 0) {
            return this.p_sqlWhere;
        }
        return "";
    }
}

