/*
 * Decompiled with CFR 0.152.
 */
package gnu.trove.decorator;

import gnu.trove.TLongByteHashMap;
import gnu.trove.TLongByteIterator;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class TLongByteHashMapDecorator
extends AbstractMap
implements Map,
Cloneable {
    protected TLongByteHashMap _map;

    public TLongByteHashMapDecorator(TLongByteHashMap map) {
        this._map = map;
    }

    public Object clone() {
        try {
            TLongByteHashMapDecorator copy = (TLongByteHashMapDecorator)super.clone();
            copy._map = (TLongByteHashMap)this._map.clone();
            return copy;
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
    }

    public Object put(Object key, Object value) {
        return this.wrapValue(this._map.put(this.unwrapKey(key), this.unwrapValue(value)));
    }

    public boolean equals(Object other) {
        if (this._map.equals(other)) {
            return true;
        }
        if (other instanceof Map) {
            Map that = (Map)other;
            if (that.size() != this._map.size()) {
                return false;
            }
            Iterator it = that.entrySet().iterator();
            int i = that.size();
            while (i-- > 0) {
                Map.Entry e = it.next();
                Object key = e.getKey();
                Object val = e.getValue();
                if (key instanceof Long && val instanceof Byte) {
                    long k = this.unwrapKey(key);
                    byte v = this.unwrapValue(val);
                    if (this._map.containsKey(k) && v == this._map.get(k)) continue;
                    return false;
                }
                return false;
            }
            return true;
        }
        return false;
    }

    public Object get(Object key) {
        long k = this.unwrapKey(key);
        byte v = this._map.get(k);
        if (v == 0) {
            return this._map.containsKey(k) ? this.wrapValue(v) : null;
        }
        return this.wrapValue(v);
    }

    public void clear() {
        this._map.clear();
    }

    public Object remove(Object key) {
        return this.wrapValue(this._map.remove(this.unwrapKey(key)));
    }

    public Set entrySet() {
        return new AbstractSet(){

            public int size() {
                return TLongByteHashMapDecorator.this._map.size();
            }

            public boolean isEmpty() {
                return TLongByteHashMapDecorator.this.isEmpty();
            }

            public boolean contains(Object o) {
                if (o instanceof Map.Entry) {
                    Object k = ((Map.Entry)o).getKey();
                    Object v = ((Map.Entry)o).getValue();
                    return TLongByteHashMapDecorator.this.containsKey(k) && TLongByteHashMapDecorator.this.get(k).equals(v);
                }
                return false;
            }

            public Iterator iterator() {
                return new Iterator(){
                    private final TLongByteIterator it;
                    {
                        this.it = TLongByteHashMapDecorator.this._map.iterator();
                    }

                    public Object next() {
                        this.it.advance();
                        final Long key = TLongByteHashMapDecorator.this.wrapKey(this.it.key());
                        final Byte v = TLongByteHashMapDecorator.this.wrapValue(this.it.value());
                        return new Map.Entry(){
                            private Object val;
                            {
                                this.val = v;
                            }

                            public boolean equals(Object o) {
                                return o instanceof Map.Entry && ((Map.Entry)o).getKey().equals(key) && ((Map.Entry)o).getValue().equals(this.val);
                            }

                            public Object getKey() {
                                return key;
                            }

                            public Object getValue() {
                                return this.val;
                            }

                            public int hashCode() {
                                return key.hashCode() + this.val.hashCode();
                            }

                            public Object setValue(Object value) {
                                this.val = value;
                                return TLongByteHashMapDecorator.this.put(key, value);
                            }
                        };
                    }

                    public boolean hasNext() {
                        return this.it.hasNext();
                    }

                    public void remove() {
                        this.it.remove();
                    }
                };
            }

            public boolean add(Object o) {
                throw new UnsupportedOperationException();
            }

            public boolean remove(Object o) {
                throw new UnsupportedOperationException();
            }

            public boolean addAll(Collection c) {
                throw new UnsupportedOperationException();
            }

            public boolean retainAll(Collection c) {
                throw new UnsupportedOperationException();
            }

            public boolean removeAll(Collection c) {
                throw new UnsupportedOperationException();
            }

            public void clear() {
                TLongByteHashMapDecorator.this.clear();
            }
        };
    }

    public boolean containsValue(Object val) {
        return this._map.containsValue(this.unwrapValue(val));
    }

    public boolean containsKey(Object key) {
        return this._map.containsKey(this.unwrapKey(key));
    }

    public int size() {
        return this._map.size();
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public void putAll(Map map) {
        Iterator it = map.entrySet().iterator();
        int i = map.size();
        while (i-- > 0) {
            Map.Entry e = it.next();
            this.put(e.getKey(), e.getValue());
        }
    }

    protected Long wrapKey(long k) {
        return new Long(k);
    }

    protected long unwrapKey(Object key) {
        return (Long)key;
    }

    protected Byte wrapValue(byte k) {
        return new Byte(k);
    }

    protected byte unwrapValue(Object value) {
        return (Byte)value;
    }
}

